(ns mathdoc.cljs.notes
  (:require [dommy.core :as dommy :refer-macros [sel sel1]]))

(defn fragment [data]
  (aget data "state" "indexf"))

(defn offset-top [sel]
  (->
   (js/jQuery sel)
   (.offset)
   (.-top)))

#_ (offset-top "#section-intractable-problems")

(defn scroll-to-top []
  (->
   (js/jQuery "#speaker-controls")
   (.animate #js {:scrollTop "0"} 500)))

(defn scroll-to [sel]
  (let [offset (offset-top sel)
        offset-scroll (clj->js
                       {:scrollTop (str "+=" offset "px")})]
    (js/console.log "scroll by" offset)
    (->
     (js/jQuery "#speaker-controls")
     (.animate offset-scroll 500))))

(defn maybe-scroll-to [sel]
  (when (dommy/sel1 (dommy/sel1 "#speaker-controls") sel)
    (scroll-to sel)))

(defn run []
  (maybe-scroll-to "#section-intractable-problems"))

(defn handle-message [data]

  (enable-console-print!)

  (let [f (fragment data)]
    (println ::f f)
    #_(when (or (= f -1) (not f))
      (println "scroll back to top")
      (scroll-to-top))
    (maybe-scroll-to (str "[data-f='" (or f -1) "']"))))
