(ns mathdoc.cljs.copynode
  (:require
   [taoensso.timbre :as log]
   [mathdoc.cljs.reveal :as reveal]
   [hickory.core :as h]
   [hickory.render :as hrender]
   [dommy.core :as dommy :refer-macros [sel sel1]]
   [clojure.walk :as walk]
   [integrant.core :as ig]
   [cljs.spec :as s]
   [cljs.core.async :as a])
  (:require-macros
   [cljs.core.async.macros :refer [go go-loop alt!]]
   [cljs.spec :as s]))

(defn sanitized-html
  "inner html of elem with ids and math removed"
  [elem]
  (as-> elem _
       (h/as-hiccup _)
       (nth _ 2)
       (walk/prewalk
        (comp
         (fn [x]
           (if (and
                (vector? x)
                (map? (second x))
                (= "math/tex" (-> x second :type)))
             ""
             x))
         (fn [x]
           (cond-> x
             (map? x) (dissoc :id))))
        _)
       (list _)
       (hrender/hiccup-to-html _)))

#_ (sanitized-html (sel1 "#cheeger-sos"))

(comment
  (->
   (dommy/create-element :div)
   (dommy/set-html! "<strong>test</strong>")
   (sanitized-html)))

#_(sanitized-html "<strong>test</strong>")

(defn get-source [elem]
  (some->> "data-copy"
       (dommy/attr elem)
       (str "#")
       (sel1)))

#_ (get-source (sel1 "[data-copy]"))

(defn copy [from to]
  #_(assert from ::from)
  #_(assert to ::to)
  (dommy/set-html! to (sanitized-html from)))

#_ (copy (get-source (sel1 "[data-copy]")) (sel1 "[data-copy]"))

(defn copy-source [to]
  (when-let [from (get-source to)]
    (copy from to)))

#_ (copy-source (sel1 "[data-copy]"))

(defn remove-copies
  []
  (->> (sel "[data-copy]")
       (map (fn [x]
              (dommy/set-html!
               x
               "")))
       (dorun)))

#_ (remove-copies)

(defn copy-nodes
  []
  (->> (sel "[data-copy]")
       (map copy-source)
       (dorun)))

#_ (copy-nodes)

;;; visual copy

(defn jq-offset
  ([elem off]
   (.offset (js/jQuery elem) off))
  ([elem]
   (.offset (js/jQuery elem))))

(defn position [elem]
  (-> (jq-offset elem)
      (js->clj #_#_:keywordize-keys true)))

#_ (position "#cheeger-sos")

#_ (position (sel1 "#cheeger-sos"))

(defn offset
  "translation vector between two elems"
  [a b]
  #_(.log js/console "offset" a b
        (clj->js (keys (merge-with - (position b) (position a))))
        "top" (get (merge-with - (position b) (position a)) "top"))
  (merge-with - (position b) (position a)))

#_ (offset "#cheeger-sos" (sel1 ".target[data-copy=cheeger-sos]"))

#_ (offset "#cheeger-sos" (sel1 ".intermediate[data-copy=cheeger-sos]"))

(defn move-to-elem-position
  [elem target-elem]
  (jq-offset elem (jq-offset target-elem)))

(defn animate [elem off]
  #_(.log js/console #js {:top (str "+=" (get off "top") "px")})
  (.animate (js/jQuery elem)
            #js {:top (str "+=" (get off "top") "px")
                 :left (str "+=" (get off "left" "px"))}))

#_ (animate ".intermediate" {:top -331}) 

#_ (move-to-elem-position (sel1 ".intermediate") "#cheeger-sos")

#_ (move-to-elem-position (sel1 ".intermediate") (sel ".target"))

(defn animate-id [id]
  #_(print ::animid id)
  (.log js/console "anim id" id)
  (when id
    (let [begin (sel1 (str "[data-anim-id=" id "].anim-begin"))
          mid (sel1 (str "[data-anim-id=" id "].anim-mid"))
          end (sel1 (str "[data-anim-id=" id "].anim-end"))]
      (when (and begin mid end)
        (.log js/console "anim for real id" id)
        (move-to-elem-position mid begin)
        (animate mid (offset begin end))))))

(defn animate-elems [prev cur]
  (when (and prev cur)
    #_(.log js/console "anim elems" prev cur)
    (->> (sel prev ".anim-begin")
         (map #(do #_(print %) (animate-id (aget % "dataset" "animId"))))
         (dorun))))

#_(.-animId (.-dataset (sel1 "#gmm")))

#_ (aget (sel1 "#gmm") "dataset" "animId")

#_ (animate-elems js/document.body js/document.body)

(defn ^:export init []
  (.addEventListener
   js/Reveal
   "slidechanged"
   (fn [ev]
     #_(.log js/console "changed")
     (animate-elems (.-previousSlide ev) (.-currentSlide ev))))

  (.addEventListener
   js/Reveal
   "ready"
   (fn [ev]
     #_(print "ready")
     (copy-nodes))))

;;; probably best with fade transition for the remaining slide

#_ (def source-offset
     (.offset (js/jQuery "#cheeger-sos")))

#_ (.offset (js/jQuery "[data-copy=cheeger-sos]"))

#_ (.offset (js/jQuery "[data-copy=cheeger-sos]") source-offset)


(def config
  {::animate-elems {:slidechanged-tap (ig/ref ::reveal/slidechanged)}
   ::copy-nodes    {:ready (ig/ref ::reveal/ready)}})

(defmethod ig/init-key
  ::animate-elems
  [_ {:keys [slidechanged-tap]}]
  (log/info ::animate-elems)
  (let [ch (a/chan (a/dropping-buffer 10))]
    (s/assert fn? slidechanged-tap)
    (slidechanged-tap ch)
    (go-loop []
      (when-let [ev (a/<! ch)]
        (log/info ::slidechanged)
        (animate-elems (.-previousSlide ev) (.-currentSlide ev))
        (recur)))
    ::animate-elems))

(defmethod ig/resume-key
  ::animate-elems
  [_ _ _ v]
  (log/info ::animate-elems-resume)
  v)

(defmethod ig/init-key
  ::copy-nodes
  [_ {:keys [ready]}]
  (go
    (assert ready)
    (a/<! ready)
    (log/info ::copy-nodes)
    (copy-nodes))
  ::copy-nodes)

(defmethod ig/resume-key
  ::copy-nodes
  [_ _ _ v]
  (log/info ::copy-nodes-resume)
  v)
