(ns mathdoc.core
  (:require [integrant.core :as ig]
            [clojure.spec :as s]
            [taoensso.tufte :as tufte]
            [clojure.spec :as s]
            [duct.core.protocols :as dcp]))

;;; specs

(s/def ::logger
  #(satisfies? dcp/Logger %))
(s/def ::root string?)
(s/def ::port int?)

;;; implementation

(defmethod ig/init-key
  ::port
  [_ port]
  {:pre [(s/assert ::port port)]}
  port)

(defmethod ig/init-key
  ::root
  [_ root]
  {:pre [(s/assert ::root root)]}
  root)

;;; config sources

(s/def ::sources (s/coll-of keyword?))

(defmethod ig/init-key
  ::config-sources
  [_ sources]
  {:pre [(s/assert ::sources sources)]}
  sources)

;; profiling

(defn profile-init-key [k v]
  (tufte/p k (#'ig/init-key k v)))

(defmethod ig/init-key
  ::profile?
  [_ v]
  (s/assert boolean? v))

(defn profile-init
  [{:keys [::profile?] :as config}]
  (ig/build config (keys config) profile-init-key))

