(ns dev
  (:require [clojure.repl :refer :all]
            [clojure.pprint :refer [pprint]]
            [clojure.tools.namespace.repl
             :refer [refresh refresh-all]]
            [clojure.java.io :as io]
            [duct.core :as duct]
            [clojure.spec.test :as stest]
            [integrant.core :as ig]
            [integrant.repl :as igr
             :refer [config system prep init halt go reset]]
            [taoensso.timbre :as log]
            [figwheel-sidecar.system :as fs]
            [clojure.spec :as s]))

(println ::cljs)

(defn read-config []
  ;; for safety instrument all specs
  (stest/instrument (stest/instrumentable-syms))
  (s/check-asserts true)
  (duct/read-config
   (io/resource "mathdoc/core/config.edn")
   (io/resource "mathdoc/server/config.edn")
   (io/resource "mathdoc/cljs/config.edn")
   (io/resource "mathdoc/compiler/config.edn")
   (io/resource "dev.edn")))

(igr/set-prep! (comp duct/prep read-config))

(defn cljs-repl
  "Launch a ClojureScript REPL that is connected to your build and host environment."
  []
  (fs/cljs-repl (:mathdoc.server/figwheel igr/system)))

(comment

  (go)

  igr/config

  (do
    (time ((:mathdoc/process igr/system) ["eth-interview.md"]))
    nil)

  (reset))
