// Compiled by ClojureScript 1.9.494 {}
goog.provide('garden.stylesheet');
goog.require('cljs.core');
goog.require('garden.util');
goog.require('garden.color');
goog.require('garden.types');
/**
 * Create a rule function for the given selector. The `selector`
 *   argument must be valid selector (ie. a keyword, string, or symbol).
 *   Additional arguments may consist of extra selectors or
 *   declarations.
 * 
 *   The returned function accepts any number of arguments which represent
 *   the rule's children.
 * 
 *   Ex.
 *    (let [text-field (rule "[type="text"])]
 *     (text-field {:border ["1px" :solid "black"]}))
 *    ;; => ["[type="text"] {:boder ["1px" :solid "black"]}]
 */
garden.stylesheet.rule = (function garden$stylesheet$rule(var_args){
var args__67415__auto__ = [];
var len__67408__auto___68469 = arguments.length;
var i__67409__auto___68470 = (0);
while(true){
if((i__67409__auto___68470 < len__67408__auto___68469)){
args__67415__auto__.push((arguments[i__67409__auto___68470]));

var G__68471 = (i__67409__auto___68470 + (1));
i__67409__auto___68470 = G__68471;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic = (function (selector,more){
if(!(((selector instanceof cljs.core.Keyword)) || (typeof selector === 'string') || ((selector instanceof cljs.core.Symbol)))){
throw cljs.core.ex_info.call(null,"Selector must be either a keyword, string, or symbol.",cljs.core.PersistentArrayMap.EMPTY);
} else {
return (function() { 
var G__68472__delegate = function (children){
return cljs.core.into.call(null,cljs.core.apply.call(null,cljs.core.vector,selector,more),children);
};
var G__68472 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__68473__i = 0, G__68473__a = new Array(arguments.length -  0);
while (G__68473__i < G__68473__a.length) {G__68473__a[G__68473__i] = arguments[G__68473__i + 0]; ++G__68473__i;}
  children = new cljs.core.IndexedSeq(G__68473__a,0);
} 
return G__68472__delegate.call(this,children);};
G__68472.cljs$lang$maxFixedArity = 0;
G__68472.cljs$lang$applyTo = (function (arglist__68474){
var children = cljs.core.seq(arglist__68474);
return G__68472__delegate(children);
});
G__68472.cljs$core$IFn$_invoke$arity$variadic = G__68472__delegate;
return G__68472;
})()
;
}
});

garden.stylesheet.rule.cljs$lang$maxFixedArity = (1);

garden.stylesheet.rule.cljs$lang$applyTo = (function (seq68467){
var G__68468 = cljs.core.first.call(null,seq68467);
var seq68467__$1 = cljs.core.next.call(null,seq68467);
return garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic(G__68468,seq68467__$1);
});

garden.stylesheet.cssfn = (function garden$stylesheet$cssfn(fn_name){
return (function() { 
var G__68475__delegate = function (args){
return (new garden.types.CSSFunction(fn_name,args,null,null,null));
};
var G__68475 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__68476__i = 0, G__68476__a = new Array(arguments.length -  0);
while (G__68476__i < G__68476__a.length) {G__68476__a[G__68476__i] = arguments[G__68476__i + 0]; ++G__68476__i;}
  args = new cljs.core.IndexedSeq(G__68476__a,0);
} 
return G__68475__delegate.call(this,args);};
G__68475.cljs$lang$maxFixedArity = 0;
G__68475.cljs$lang$applyTo = (function (arglist__68477){
var args = cljs.core.seq(arglist__68477);
return G__68475__delegate(args);
});
G__68475.cljs$core$IFn$_invoke$arity$variadic = G__68475__delegate;
return G__68475;
})()
;
});
garden.stylesheet.at_rule = (function garden$stylesheet$at_rule(identifier,value){
return (new garden.types.CSSAtRule(identifier,value,null,null,null));
});
/**
 * Create a CSS @font-face rule.
 */
garden.stylesheet.at_font_face = (function garden$stylesheet$at_font_face(var_args){
var args__67415__auto__ = [];
var len__67408__auto___68479 = arguments.length;
var i__67409__auto___68480 = (0);
while(true){
if((i__67409__auto___68480 < len__67408__auto___68479)){
args__67415__auto__.push((arguments[i__67409__auto___68480]));

var G__68481 = (i__67409__auto___68480 + (1));
i__67409__auto___68480 = G__68481;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((0) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((0)),(0),null)):null);
return garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic(argseq__67416__auto__);
});

garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic = (function (font_properties){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@font-face",font_properties], null);
});

garden.stylesheet.at_font_face.cljs$lang$maxFixedArity = (0);

garden.stylesheet.at_font_face.cljs$lang$applyTo = (function (seq68478){
return garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq68478));
});

/**
 * Create a CSS @import rule.
 */
garden.stylesheet.at_import = (function garden$stylesheet$at_import(var_args){
var args68482 = [];
var len__67408__auto___68487 = arguments.length;
var i__67409__auto___68488 = (0);
while(true){
if((i__67409__auto___68488 < len__67408__auto___68487)){
args68482.push((arguments[i__67409__auto___68488]));

var G__68489 = (i__67409__auto___68488 + (1));
i__67409__auto___68488 = G__68489;
continue;
} else {
}
break;
}

var G__68486 = args68482.length;
switch (G__68486) {
case 1:
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args68482.slice((1)),(0),null));
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67431__auto__);

}
});

garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$1 = (function (url){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),null], null));
});

garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic = (function (url,media_queries){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),media_queries], null));
});

garden.stylesheet.at_import.cljs$lang$applyTo = (function (seq68483){
var G__68484 = cljs.core.first.call(null,seq68483);
var seq68483__$1 = cljs.core.next.call(null,seq68483);
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic(G__68484,seq68483__$1);
});

garden.stylesheet.at_import.cljs$lang$maxFixedArity = (1);

/**
 * Create a CSS @media rule.
 */
garden.stylesheet.at_media = (function garden$stylesheet$at_media(var_args){
var args__67415__auto__ = [];
var len__67408__auto___68493 = arguments.length;
var i__67409__auto___68494 = (0);
while(true){
if((i__67409__auto___68494 < len__67408__auto___68493)){
args__67415__auto__.push((arguments[i__67409__auto___68494]));

var G__68495 = (i__67409__auto___68494 + (1));
i__67409__auto___68494 = G__68495;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic = (function (media_queries,rules){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"media","media",-1066138403),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),media_queries,new cljs.core.Keyword(null,"rules","rules",1198912366),rules], null));
});

garden.stylesheet.at_media.cljs$lang$maxFixedArity = (1);

garden.stylesheet.at_media.cljs$lang$applyTo = (function (seq68491){
var G__68492 = cljs.core.first.call(null,seq68491);
var seq68491__$1 = cljs.core.next.call(null,seq68491);
return garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic(G__68492,seq68491__$1);
});

/**
 * Create a CSS @keyframes rule.
 */
garden.stylesheet.at_keyframes = (function garden$stylesheet$at_keyframes(var_args){
var args__67415__auto__ = [];
var len__67408__auto___68498 = arguments.length;
var i__67409__auto___68499 = (0);
while(true){
if((i__67409__auto___68499 < len__67408__auto___68498)){
args__67415__auto__.push((arguments[i__67409__auto___68499]));

var G__68500 = (i__67409__auto___68499 + (1));
i__67409__auto___68499 = G__68500;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic = (function (identifier,frames){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"identifier","identifier",-805503498),identifier,new cljs.core.Keyword(null,"frames","frames",1765687497),frames], null));
});

garden.stylesheet.at_keyframes.cljs$lang$maxFixedArity = (1);

garden.stylesheet.at_keyframes.cljs$lang$applyTo = (function (seq68496){
var G__68497 = cljs.core.first.call(null,seq68496);
var seq68496__$1 = cljs.core.next.call(null,seq68496);
return garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic(G__68497,seq68496__$1);
});

/**
 * Create a color from RGB values.
 */
garden.stylesheet.rgb = (function garden$stylesheet$rgb(r,g,b){
return garden.color.rgb.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,g,b], null));
});
/**
 * Create a color from HSL values.
 */
garden.stylesheet.hsl = (function garden$stylesheet$hsl(h,s,l){
return garden.color.hsl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [h,s,l], null));
});

//# sourceMappingURL=stylesheet.js.map