(ns talk.background
  (:require [dommy.core :as dommy :refer-macros [sel sel1]]))

(def slide-index
  {:superman 2})

(defn get-state []
  (let [state (.getState js/Reveal)]
    {:indexf (aget state "indexf")
     :indexh (aget state "indexh")
     :indexv (aget state "indexv")}))

(defn superman []
  (condp = (get-state)
    {:indexf 0
     :indexh (:superman slide-index)
     :indexv 0} (->
                 (dommy/sel1 ".slide-background.present")
                 (dommy/add-class! "slide-background-faded"))
    #_#_{:indexf 2
     :indexh (:superman slide-index)
     :indexv 0} (->
                 (dommy/sel1 ".slide-background.present")
                 (dommy/add-class! "slide-background-more-faded"))
    nil))


(defn init []
  (.addEventListener
   js/Reveal
   "fragmentshown"
   (fn [ev]
     (superman))))
