(ns talk.highdim
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [cljs-http.client :as http]
            [dommy.core :as dommy :refer-macros [sel sel1]]
            [cljs.core.async :as as :refer [<!]]))

(defn log [& xs] (apply js/console.log xs))

(defn get-url [url]
  (http/get url {:channel (as/chan 1 (map :body))}))

#_(get-url "/notebooks/mixture.svg")

(defn seq-htmlcollection [col]
  (for [i (range (.-length col))]
    (.item col i)))

(defn htmldom [html]
  (-> (dommy/create-element :div)
      (dommy/set-html! html)
      (dommy/children)
      (seq-htmlcollection)))

#_ (htmldom "<?xml version=\"1.0\" encoding=\"utf-8\"?><p>test</p><p>test2</p>")

(defn maybe-set-attr! [elem k v]
  (cond-> elem
    v (dommy/set-attr! k v)))

(defn copy-attr! [to-elem from-elem k]
  (maybe-set-attr! to-elem k (dommy/attr from-elem k)))

(defn replacedom [elem html]
  (dommy/replace!
   elem
   (-> (htmldom html)
       first
       (copy-attr! elem :id)
       (copy-attr! elem :data-svg)
       (copy-attr! elem :class)
       (copy-attr! elem :style)
       (copy-attr! elem :data-fragment-index)
       (copy-attr! elem :data-fragment))))

#_ (go
     (replacedom
      (sel1 "#singlegaussian")
      (<! (get-url "/notebooks/singlegaussian.svg"))))

(defn replace-svg [elem]
  (go
    (replacedom elem (<! (get-url (dommy/attr elem "data-svg"))))))

#_ (replace-svg (sel1 "#mixturegaussian"))

(defn replace-all-svg []
  (go
    (loop [xs (sel "[data-svg]")]
      (when-let [x (first xs)]
        (<! (replace-svg x))
        (recur (next xs))))))

#_ (replace-all-svg)

(defn clean-up-svgs []
  (doseq [id ["#singlegaussian" "#mixturegaussian" "#mixturegaussian2"]]
    (log "clean svg" id)
    (if (sel1 id)
      (mapv dommy/remove! (sel (sel1 id) "polygon")))))

#_(clean-up-svgs)

(defn init []
  (log "init-svg")
  (go
    (<! (replace-all-svg))
    (clean-up-svgs)))


#_ (init)

