// Compiled by ClojureScript 1.9.494 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.ratom');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(!((reagent.dom.imported == null))){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__66199__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_69983 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_69983){
return (function (){
var _STAR_always_update_STAR_69984 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(!((callback == null))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_69984;
}});})(_STAR_always_update_STAR_69983))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_69983;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args69985 = [];
var len__67420__auto___69988 = arguments.length;
var i__67421__auto___69989 = (0);
while(true){
if((i__67421__auto___69989 < len__67420__auto___69988)){
args69985.push((arguments[i__67421__auto___69989]));

var G__69990 = (i__67421__auto___69989 + (1));
i__67421__auto___69989 = G__69990;
continue;
} else {
}
break;
}

var G__69987 = args69985.length;
switch (G__69987) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args69985.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__69996_70000 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__69997_70001 = null;
var count__69998_70002 = (0);
var i__69999_70003 = (0);
while(true){
if((i__69999_70003 < count__69998_70002)){
var v_70004 = cljs.core._nth.call(null,chunk__69997_70001,i__69999_70003);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_70004);

var G__70005 = seq__69996_70000;
var G__70006 = chunk__69997_70001;
var G__70007 = count__69998_70002;
var G__70008 = (i__69999_70003 + (1));
seq__69996_70000 = G__70005;
chunk__69997_70001 = G__70006;
count__69998_70002 = G__70007;
i__69999_70003 = G__70008;
continue;
} else {
var temp__6753__auto___70009 = cljs.core.seq.call(null,seq__69996_70000);
if(temp__6753__auto___70009){
var seq__69996_70010__$1 = temp__6753__auto___70009;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__69996_70010__$1)){
var c__67110__auto___70011 = cljs.core.chunk_first.call(null,seq__69996_70010__$1);
var G__70012 = cljs.core.chunk_rest.call(null,seq__69996_70010__$1);
var G__70013 = c__67110__auto___70011;
var G__70014 = cljs.core.count.call(null,c__67110__auto___70011);
var G__70015 = (0);
seq__69996_70000 = G__70012;
chunk__69997_70001 = G__70013;
count__69998_70002 = G__70014;
i__69999_70003 = G__70015;
continue;
} else {
var v_70016 = cljs.core.first.call(null,seq__69996_70010__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_70016);

var G__70017 = cljs.core.next.call(null,seq__69996_70010__$1);
var G__70018 = null;
var G__70019 = (0);
var G__70020 = (0);
seq__69996_70000 = G__70017;
chunk__69997_70001 = G__70018;
count__69998_70002 = G__70019;
i__69999_70003 = G__70020;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map