(ns talk.conclusion
  (:require [cuerdas.core :as str]
            [garden.core :as garden]
            [dommy.core :as dommy :refer-macros [sel sel1]]
            [garden.stylesheet :as gs]
            [mathdoc.cljs.svg :as svg]
            [reagent.core :as r]
            [garden.color :as gc]
            [clojure.walk :as walk]
            [cuerdas.core :as str]
            [mathdoc.cljs.svg :as svg]))

;;; context

(def context
  (let [color {:color/yellow  "#b58900"
               :color/orange  "#cb4b16"
               :color/red     "#dc322f"
               :color/magenta "#d33682"
               :color/violet  "#6c71c4"
               :color/blue    "#268bd2"
               :color/cyan    "#2aa198"
               :color/green   "#859900"
               :color/base03  "#002b36"
               :color/base02  "#073642"
               :color/base01  "#586e75"
               :color/base00  "#657b83"
               :color/base0   "#839496"
               :color/base1   "#93a1a1"
               :color/base2   "#eee8d5"
               :color/base3   "#fdf6e3"}]
    (merge
     color
     {:cycle/radius   "25"
      :font/size      "10px"
      :font/color     (:color/base1 color)
      :font/bigsize   "15px"
      :font/largesize "14px"

      :frag/shieldsos    0
      :frag/tractability    1
      :frag/optimality    2
      :frag/intractability    3
      :frag/practicality    4
      :frag/bigpicture   5
      :frag/applications 6
      :frag/machinelearning 7
      :frag/unconditional 8
      :frag/nplowerbound 9

      :color/lightyellow (gc/as-hex (gc/lighten (:color/yellow color) 8))}
     #_(zipmap
        [:frag/general-alg
         :frag/simplify
         :frag/simple-alg
         :frag/lp
         :frag/physical
         :frag/entropy
         :frag/equations
         :frag/maxentropy
         :frag/exponentialfamily
         :frag/sosapprox
         :frag/quantumsdp
         :frag/quantumrepresent] (repeat 0)))))

;;; refs

(defrecord Ref [key])

(defn ref [k]
  (->Ref k))

(defn ref? [x]
  (instance? Ref x))

(defn expand
  [form]
  (walk/postwalk
   (fn [x]
     (if (ref? x)
       (context (:key x))
       x))
   form))

(def soscircle
  [:g
   {:transform "scale(1.7,1.5)"}
   [:g
    {:transform "translate(-370,-506)"}
    [:circle
     {:cx 370
      :cy 506
      :fill (ref :color/cyan)
      :r 62}]]])

(def star
  [:g
   {:transform "scale(1.7,1.5)"}
   [:g
    {:transform "translate(-370,-506)"}

    [:path
     {:d    "m 372.06421,442.61363 c 23.44918,-0.003 89.09658,-68.18518 102.46463,-54.59181 13.36805,13.59337 -55.46984,77.16061 -47.03294,91.54627 8.4369,14.38566 113.8043,-4.79137 116.74249,15.11774 2.93819,19.90911 -115.55167,37.08858 -121.78173,46.19307 -6.23006,9.10449 69.49722,75.26008 57.95131,88.18678 -11.54591,12.9267 -89.20528,-60.92123 -110.86338,-61.31081 -21.6581,-0.38958 -95.98203,61.46696 -108.34376,50.39244 -12.36173,-11.07452 65.08621,-66.14636 55.43169,-81.46778 -9.65452,-15.32142 -125.62355,-9.09073 -124.30135,-29.39559 1.3222,-20.30487 114.25157,-13.19532 122.7235,-28.50477 8.47194,-15.30945 -76.87073,-81.60533 -62.25258,-98.31622 14.61815,-16.71089 95.81294,62.15322 119.26212,62.15068 z"
      :fill (ref :color/cyan)}]]])

;;; actual code

(defn conclusion
  []
  (expand
   [:svg
    {:viewBox "-380 -250 760 500"
     :style
     {#_#_:background   "rgba(255,255,255,0.1)"
      :transform        "scale(1.15)"
      :margin-top       "10px"
      :transform-origin "top center"
      :position         "absolute"
      :top              "0px"
      :left             "0px"}}
    soscircle
    [:g.fragment.appeargrow
     {:data-fragment-index 0
      :style
      {:transition-duration "2s"}}
     star
     (let [text-attr {:font-size          "20"
                      :alignment-baseline "middle"
                      :text-anchor        "middle"
                      :fill               (ref :color/base02)}]
       [:g
        [:g
         {:transform "translate(-70,-90)"}
         [:text
          text-attr
          "algorithms"]]
        [:g
         {:transform "translate(-150,3)"}
         [:text
          text-attr
          "learning"]]
        [:g
         {:transform "translate(-70,90)"}
         [:text
          text-attr
          "statistics"]]
        [:g
         {:transform "translate(70,90)"}
         [:text
          text-attr
          "physics"]]
        [:g
         {:transform "translate(65,-85)"}
         [:text
          text-attr
          "complexity"]]
        [:g
         {:transform "translate(140,0)"}
         [:text
          text-attr
          "mathematics"]]])]
    [:g
     [:g
      {:transform "scale(0.8)"}
      soscircle]
     [:g
      {:transform "scale(1.3)"}
      [:g
       {:transform "translate(0,-15)"}
       [:text
        {:font-size          "20"
         :alignment-baseline "middle"
         :text-anchor        "middle"
         :fill               (ref :color/base2)}
        "unified theory:"]]
      [:g
       {:transform "translate(0,15)"}
       [:text
        {:font-size          "30"
         :alignment-baseline "middle"
         :text-anchor        "middle"
         :font-weight        "bold"
         :fill               (ref :color/base2)}
        "SOS"]]]]]))

(defn init
  []
  (some->> "conclusion"
           (.getElementById js/document)
           (r/render [conclusion])))
