// Compiled by ClojureScript 1.9.494 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args71525 = [];
var len__67420__auto___71531 = arguments.length;
var i__67421__auto___71532 = (0);
while(true){
if((i__67421__auto___71532 < len__67420__auto___71531)){
args71525.push((arguments[i__67421__auto___71532]));

var G__71533 = (i__67421__auto___71532 + (1));
i__67421__auto___71532 = G__71533;
continue;
} else {
}
break;
}

var G__71527 = args71525.length;
switch (G__71527) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71525.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async71528 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71528 = (function (f,blockable,meta71529){
this.f = f;
this.blockable = blockable;
this.meta71529 = meta71529;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async71528.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71530,meta71529__$1){
var self__ = this;
var _71530__$1 = this;
return (new cljs.core.async.t_cljs$core$async71528(self__.f,self__.blockable,meta71529__$1));
});

cljs.core.async.t_cljs$core$async71528.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71530){
var self__ = this;
var _71530__$1 = this;
return self__.meta71529;
});

cljs.core.async.t_cljs$core$async71528.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async71528.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async71528.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async71528.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async71528.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta71529","meta71529",-349944861,null)], null);
});

cljs.core.async.t_cljs$core$async71528.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71528.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71528";

cljs.core.async.t_cljs$core$async71528.cljs$lang$ctorPrWriter = (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async71528");
});

cljs.core.async.__GT_t_cljs$core$async71528 = (function cljs$core$async$__GT_t_cljs$core$async71528(f__$1,blockable__$1,meta71529){
return (new cljs.core.async.t_cljs$core$async71528(f__$1,blockable__$1,meta71529));
});

}

return (new cljs.core.async.t_cljs$core$async71528(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args71537 = [];
var len__67420__auto___71540 = arguments.length;
var i__67421__auto___71541 = (0);
while(true){
if((i__67421__auto___71541 < len__67420__auto___71540)){
args71537.push((arguments[i__67421__auto___71541]));

var G__71542 = (i__67421__auto___71541 + (1));
i__67421__auto___71541 = G__71542;
continue;
} else {
}
break;
}

var G__71539 = args71537.length;
switch (G__71539) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71537.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args71544 = [];
var len__67420__auto___71547 = arguments.length;
var i__67421__auto___71548 = (0);
while(true){
if((i__67421__auto___71548 < len__67420__auto___71547)){
args71544.push((arguments[i__67421__auto___71548]));

var G__71549 = (i__67421__auto___71548 + (1));
i__67421__auto___71548 = G__71549;
continue;
} else {
}
break;
}

var G__71546 = args71544.length;
switch (G__71546) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71544.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args71551 = [];
var len__67420__auto___71554 = arguments.length;
var i__67421__auto___71555 = (0);
while(true){
if((i__67421__auto___71555 < len__67420__auto___71554)){
args71551.push((arguments[i__67421__auto___71555]));

var G__71556 = (i__67421__auto___71555 + (1));
i__67421__auto___71555 = G__71556;
continue;
} else {
}
break;
}

var G__71553 = args71551.length;
switch (G__71553) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71551.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_71558 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_71558);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_71558,ret){
return (function (){
return fn1.call(null,val_71558);
});})(val_71558,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args71559 = [];
var len__67420__auto___71562 = arguments.length;
var i__67421__auto___71563 = (0);
while(true){
if((i__67421__auto___71563 < len__67420__auto___71562)){
args71559.push((arguments[i__67421__auto___71563]));

var G__71564 = (i__67421__auto___71563 + (1));
i__67421__auto___71563 = G__71564;
continue;
} else {
}
break;
}

var G__71561 = args71559.length;
switch (G__71561) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71559.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__67220__auto___71566 = n;
var x_71567 = (0);
while(true){
if((x_71567 < n__67220__auto___71566)){
(a[x_71567] = (0));

var G__71568 = (x_71567 + (1));
x_71567 = G__71568;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__71569 = (i + (1));
i = G__71569;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async71573 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71573 = (function (flag,meta71574){
this.flag = flag;
this.meta71574 = meta71574;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async71573.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_71575,meta71574__$1){
var self__ = this;
var _71575__$1 = this;
return (new cljs.core.async.t_cljs$core$async71573(self__.flag,meta71574__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async71573.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_71575){
var self__ = this;
var _71575__$1 = this;
return self__.meta71574;
});})(flag))
;

cljs.core.async.t_cljs$core$async71573.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async71573.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async71573.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async71573.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async71573.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta71574","meta71574",-438667611,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async71573.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71573.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71573";

cljs.core.async.t_cljs$core$async71573.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async71573");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async71573 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async71573(flag__$1,meta71574){
return (new cljs.core.async.t_cljs$core$async71573(flag__$1,meta71574));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async71573(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async71579 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71579 = (function (flag,cb,meta71580){
this.flag = flag;
this.cb = cb;
this.meta71580 = meta71580;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async71579.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71581,meta71580__$1){
var self__ = this;
var _71581__$1 = this;
return (new cljs.core.async.t_cljs$core$async71579(self__.flag,self__.cb,meta71580__$1));
});

cljs.core.async.t_cljs$core$async71579.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71581){
var self__ = this;
var _71581__$1 = this;
return self__.meta71580;
});

cljs.core.async.t_cljs$core$async71579.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async71579.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async71579.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async71579.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async71579.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta71580","meta71580",-1015285849,null)], null);
});

cljs.core.async.t_cljs$core$async71579.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71579.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71579";

cljs.core.async.t_cljs$core$async71579.cljs$lang$ctorPrWriter = (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async71579");
});

cljs.core.async.__GT_t_cljs$core$async71579 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async71579(flag__$1,cb__$1,meta71580){
return (new cljs.core.async.t_cljs$core$async71579(flag__$1,cb__$1,meta71580));
});

}

return (new cljs.core.async.t_cljs$core$async71579(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71582_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71582_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71583_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71583_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__66199__auto__ = wport;
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return port;
}
})()], null));
} else {
var G__71584 = (i + (1));
i = G__71584;
continue;
}
} else {
return null;
}
break;
}
})();
var or__66199__auto__ = ret;
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__66187__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__66187__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__66187__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___71590 = arguments.length;
var i__67421__auto___71591 = (0);
while(true){
if((i__67421__auto___71591 < len__67420__auto___71590)){
args__67427__auto__.push((arguments[i__67421__auto___71591]));

var G__71592 = (i__67421__auto___71591 + (1));
i__67421__auto___71591 = G__71592;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__71587){
var map__71588 = p__71587;
var map__71588__$1 = ((((!((map__71588 == null)))?((((map__71588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71588.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71588):map__71588);
var opts = map__71588__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq71585){
var G__71586 = cljs.core.first.call(null,seq71585);
var seq71585__$1 = cljs.core.next.call(null,seq71585);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__71586,seq71585__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args71593 = [];
var len__67420__auto___71643 = arguments.length;
var i__67421__auto___71644 = (0);
while(true){
if((i__67421__auto___71644 < len__67420__auto___71643)){
args71593.push((arguments[i__67421__auto___71644]));

var G__71645 = (i__67421__auto___71644 + (1));
i__67421__auto___71644 = G__71645;
continue;
} else {
}
break;
}

var G__71595 = args71593.length;
switch (G__71595) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71593.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__68765__auto___71647 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___71647){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___71647){
return (function (state_71619){
var state_val_71620 = (state_71619[(1)]);
if((state_val_71620 === (7))){
var inst_71615 = (state_71619[(2)]);
var state_71619__$1 = state_71619;
var statearr_71621_71648 = state_71619__$1;
(statearr_71621_71648[(2)] = inst_71615);

(statearr_71621_71648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (1))){
var state_71619__$1 = state_71619;
var statearr_71622_71649 = state_71619__$1;
(statearr_71622_71649[(2)] = null);

(statearr_71622_71649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (4))){
var inst_71598 = (state_71619[(7)]);
var inst_71598__$1 = (state_71619[(2)]);
var inst_71599 = (inst_71598__$1 == null);
var state_71619__$1 = (function (){var statearr_71623 = state_71619;
(statearr_71623[(7)] = inst_71598__$1);

return statearr_71623;
})();
if(cljs.core.truth_(inst_71599)){
var statearr_71624_71650 = state_71619__$1;
(statearr_71624_71650[(1)] = (5));

} else {
var statearr_71625_71651 = state_71619__$1;
(statearr_71625_71651[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (13))){
var state_71619__$1 = state_71619;
var statearr_71626_71652 = state_71619__$1;
(statearr_71626_71652[(2)] = null);

(statearr_71626_71652[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (6))){
var inst_71598 = (state_71619[(7)]);
var state_71619__$1 = state_71619;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71619__$1,(11),to,inst_71598);
} else {
if((state_val_71620 === (3))){
var inst_71617 = (state_71619[(2)]);
var state_71619__$1 = state_71619;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71619__$1,inst_71617);
} else {
if((state_val_71620 === (12))){
var state_71619__$1 = state_71619;
var statearr_71627_71653 = state_71619__$1;
(statearr_71627_71653[(2)] = null);

(statearr_71627_71653[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (2))){
var state_71619__$1 = state_71619;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71619__$1,(4),from);
} else {
if((state_val_71620 === (11))){
var inst_71608 = (state_71619[(2)]);
var state_71619__$1 = state_71619;
if(cljs.core.truth_(inst_71608)){
var statearr_71628_71654 = state_71619__$1;
(statearr_71628_71654[(1)] = (12));

} else {
var statearr_71629_71655 = state_71619__$1;
(statearr_71629_71655[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (9))){
var state_71619__$1 = state_71619;
var statearr_71630_71656 = state_71619__$1;
(statearr_71630_71656[(2)] = null);

(statearr_71630_71656[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (5))){
var state_71619__$1 = state_71619;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71631_71657 = state_71619__$1;
(statearr_71631_71657[(1)] = (8));

} else {
var statearr_71632_71658 = state_71619__$1;
(statearr_71632_71658[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (14))){
var inst_71613 = (state_71619[(2)]);
var state_71619__$1 = state_71619;
var statearr_71633_71659 = state_71619__$1;
(statearr_71633_71659[(2)] = inst_71613);

(statearr_71633_71659[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (10))){
var inst_71605 = (state_71619[(2)]);
var state_71619__$1 = state_71619;
var statearr_71634_71660 = state_71619__$1;
(statearr_71634_71660[(2)] = inst_71605);

(statearr_71634_71660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71620 === (8))){
var inst_71602 = cljs.core.async.close_BANG_.call(null,to);
var state_71619__$1 = state_71619;
var statearr_71635_71661 = state_71619__$1;
(statearr_71635_71661[(2)] = inst_71602);

(statearr_71635_71661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___71647))
;
return ((function (switch__68742__auto__,c__68765__auto___71647){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_71639 = [null,null,null,null,null,null,null,null];
(statearr_71639[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_71639[(1)] = (1));

return statearr_71639;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_71619){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_71619);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e71640){if((e71640 instanceof Object)){
var ex__68746__auto__ = e71640;
var statearr_71641_71662 = state_71619;
(statearr_71641_71662[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71619);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71640;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71663 = state_71619;
state_71619 = G__71663;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_71619){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_71619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___71647))
})();
var state__68767__auto__ = (function (){var statearr_71642 = f__68766__auto__.call(null);
(statearr_71642[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___71647);

return statearr_71642;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___71647))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__71851){
var vec__71852 = p__71851;
var v = cljs.core.nth.call(null,vec__71852,(0),null);
var p = cljs.core.nth.call(null,vec__71852,(1),null);
var job = vec__71852;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__68765__auto___72038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___72038,res,vec__71852,v,p,job,jobs,results){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___72038,res,vec__71852,v,p,job,jobs,results){
return (function (state_71859){
var state_val_71860 = (state_71859[(1)]);
if((state_val_71860 === (1))){
var state_71859__$1 = state_71859;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71859__$1,(2),res,v);
} else {
if((state_val_71860 === (2))){
var inst_71856 = (state_71859[(2)]);
var inst_71857 = cljs.core.async.close_BANG_.call(null,res);
var state_71859__$1 = (function (){var statearr_71861 = state_71859;
(statearr_71861[(7)] = inst_71856);

return statearr_71861;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71859__$1,inst_71857);
} else {
return null;
}
}
});})(c__68765__auto___72038,res,vec__71852,v,p,job,jobs,results))
;
return ((function (switch__68742__auto__,c__68765__auto___72038,res,vec__71852,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0 = (function (){
var statearr_71865 = [null,null,null,null,null,null,null,null];
(statearr_71865[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__);

(statearr_71865[(1)] = (1));

return statearr_71865;
});
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1 = (function (state_71859){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_71859);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e71866){if((e71866 instanceof Object)){
var ex__68746__auto__ = e71866;
var statearr_71867_72039 = state_71859;
(statearr_71867_72039[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71859);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71866;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72040 = state_71859;
state_71859 = G__72040;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = function(state_71859){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1.call(this,state_71859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___72038,res,vec__71852,v,p,job,jobs,results))
})();
var state__68767__auto__ = (function (){var statearr_71868 = f__68766__auto__.call(null);
(statearr_71868[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___72038);

return statearr_71868;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___72038,res,vec__71852,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__71869){
var vec__71870 = p__71869;
var v = cljs.core.nth.call(null,vec__71870,(0),null);
var p = cljs.core.nth.call(null,vec__71870,(1),null);
var job = vec__71870;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__67220__auto___72041 = n;
var __72042 = (0);
while(true){
if((__72042 < n__67220__auto___72041)){
var G__71873_72043 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__71873_72043) {
case "compute":
var c__68765__auto___72045 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__72042,c__68765__auto___72045,G__71873_72043,n__67220__auto___72041,jobs,results,process,async){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (__72042,c__68765__auto___72045,G__71873_72043,n__67220__auto___72041,jobs,results,process,async){
return (function (state_71886){
var state_val_71887 = (state_71886[(1)]);
if((state_val_71887 === (1))){
var state_71886__$1 = state_71886;
var statearr_71888_72046 = state_71886__$1;
(statearr_71888_72046[(2)] = null);

(statearr_71888_72046[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71887 === (2))){
var state_71886__$1 = state_71886;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71886__$1,(4),jobs);
} else {
if((state_val_71887 === (3))){
var inst_71884 = (state_71886[(2)]);
var state_71886__$1 = state_71886;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71886__$1,inst_71884);
} else {
if((state_val_71887 === (4))){
var inst_71876 = (state_71886[(2)]);
var inst_71877 = process.call(null,inst_71876);
var state_71886__$1 = state_71886;
if(cljs.core.truth_(inst_71877)){
var statearr_71889_72047 = state_71886__$1;
(statearr_71889_72047[(1)] = (5));

} else {
var statearr_71890_72048 = state_71886__$1;
(statearr_71890_72048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71887 === (5))){
var state_71886__$1 = state_71886;
var statearr_71891_72049 = state_71886__$1;
(statearr_71891_72049[(2)] = null);

(statearr_71891_72049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71887 === (6))){
var state_71886__$1 = state_71886;
var statearr_71892_72050 = state_71886__$1;
(statearr_71892_72050[(2)] = null);

(statearr_71892_72050[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71887 === (7))){
var inst_71882 = (state_71886[(2)]);
var state_71886__$1 = state_71886;
var statearr_71893_72051 = state_71886__$1;
(statearr_71893_72051[(2)] = inst_71882);

(statearr_71893_72051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72042,c__68765__auto___72045,G__71873_72043,n__67220__auto___72041,jobs,results,process,async))
;
return ((function (__72042,switch__68742__auto__,c__68765__auto___72045,G__71873_72043,n__67220__auto___72041,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0 = (function (){
var statearr_71897 = [null,null,null,null,null,null,null];
(statearr_71897[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__);

(statearr_71897[(1)] = (1));

return statearr_71897;
});
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1 = (function (state_71886){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_71886);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e71898){if((e71898 instanceof Object)){
var ex__68746__auto__ = e71898;
var statearr_71899_72052 = state_71886;
(statearr_71899_72052[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71886);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71898;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72053 = state_71886;
state_71886 = G__72053;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = function(state_71886){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1.call(this,state_71886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__;
})()
;})(__72042,switch__68742__auto__,c__68765__auto___72045,G__71873_72043,n__67220__auto___72041,jobs,results,process,async))
})();
var state__68767__auto__ = (function (){var statearr_71900 = f__68766__auto__.call(null);
(statearr_71900[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___72045);

return statearr_71900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(__72042,c__68765__auto___72045,G__71873_72043,n__67220__auto___72041,jobs,results,process,async))
);


break;
case "async":
var c__68765__auto___72054 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__72042,c__68765__auto___72054,G__71873_72043,n__67220__auto___72041,jobs,results,process,async){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (__72042,c__68765__auto___72054,G__71873_72043,n__67220__auto___72041,jobs,results,process,async){
return (function (state_71913){
var state_val_71914 = (state_71913[(1)]);
if((state_val_71914 === (1))){
var state_71913__$1 = state_71913;
var statearr_71915_72055 = state_71913__$1;
(statearr_71915_72055[(2)] = null);

(statearr_71915_72055[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71914 === (2))){
var state_71913__$1 = state_71913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71913__$1,(4),jobs);
} else {
if((state_val_71914 === (3))){
var inst_71911 = (state_71913[(2)]);
var state_71913__$1 = state_71913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71913__$1,inst_71911);
} else {
if((state_val_71914 === (4))){
var inst_71903 = (state_71913[(2)]);
var inst_71904 = async.call(null,inst_71903);
var state_71913__$1 = state_71913;
if(cljs.core.truth_(inst_71904)){
var statearr_71916_72056 = state_71913__$1;
(statearr_71916_72056[(1)] = (5));

} else {
var statearr_71917_72057 = state_71913__$1;
(statearr_71917_72057[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71914 === (5))){
var state_71913__$1 = state_71913;
var statearr_71918_72058 = state_71913__$1;
(statearr_71918_72058[(2)] = null);

(statearr_71918_72058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71914 === (6))){
var state_71913__$1 = state_71913;
var statearr_71919_72059 = state_71913__$1;
(statearr_71919_72059[(2)] = null);

(statearr_71919_72059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71914 === (7))){
var inst_71909 = (state_71913[(2)]);
var state_71913__$1 = state_71913;
var statearr_71920_72060 = state_71913__$1;
(statearr_71920_72060[(2)] = inst_71909);

(statearr_71920_72060[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__72042,c__68765__auto___72054,G__71873_72043,n__67220__auto___72041,jobs,results,process,async))
;
return ((function (__72042,switch__68742__auto__,c__68765__auto___72054,G__71873_72043,n__67220__auto___72041,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0 = (function (){
var statearr_71924 = [null,null,null,null,null,null,null];
(statearr_71924[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__);

(statearr_71924[(1)] = (1));

return statearr_71924;
});
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1 = (function (state_71913){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_71913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e71925){if((e71925 instanceof Object)){
var ex__68746__auto__ = e71925;
var statearr_71926_72061 = state_71913;
(statearr_71926_72061[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71913);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71925;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72062 = state_71913;
state_71913 = G__72062;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = function(state_71913){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1.call(this,state_71913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__;
})()
;})(__72042,switch__68742__auto__,c__68765__auto___72054,G__71873_72043,n__67220__auto___72041,jobs,results,process,async))
})();
var state__68767__auto__ = (function (){var statearr_71927 = f__68766__auto__.call(null);
(statearr_71927[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___72054);

return statearr_71927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(__72042,c__68765__auto___72054,G__71873_72043,n__67220__auto___72041,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__72063 = (__72042 + (1));
__72042 = G__72063;
continue;
} else {
}
break;
}

var c__68765__auto___72064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___72064,jobs,results,process,async){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___72064,jobs,results,process,async){
return (function (state_71949){
var state_val_71950 = (state_71949[(1)]);
if((state_val_71950 === (1))){
var state_71949__$1 = state_71949;
var statearr_71951_72065 = state_71949__$1;
(statearr_71951_72065[(2)] = null);

(statearr_71951_72065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71950 === (2))){
var state_71949__$1 = state_71949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71949__$1,(4),from);
} else {
if((state_val_71950 === (3))){
var inst_71947 = (state_71949[(2)]);
var state_71949__$1 = state_71949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71949__$1,inst_71947);
} else {
if((state_val_71950 === (4))){
var inst_71930 = (state_71949[(7)]);
var inst_71930__$1 = (state_71949[(2)]);
var inst_71931 = (inst_71930__$1 == null);
var state_71949__$1 = (function (){var statearr_71952 = state_71949;
(statearr_71952[(7)] = inst_71930__$1);

return statearr_71952;
})();
if(cljs.core.truth_(inst_71931)){
var statearr_71953_72066 = state_71949__$1;
(statearr_71953_72066[(1)] = (5));

} else {
var statearr_71954_72067 = state_71949__$1;
(statearr_71954_72067[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71950 === (5))){
var inst_71933 = cljs.core.async.close_BANG_.call(null,jobs);
var state_71949__$1 = state_71949;
var statearr_71955_72068 = state_71949__$1;
(statearr_71955_72068[(2)] = inst_71933);

(statearr_71955_72068[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71950 === (6))){
var inst_71935 = (state_71949[(8)]);
var inst_71930 = (state_71949[(7)]);
var inst_71935__$1 = cljs.core.async.chan.call(null,(1));
var inst_71936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71937 = [inst_71930,inst_71935__$1];
var inst_71938 = (new cljs.core.PersistentVector(null,2,(5),inst_71936,inst_71937,null));
var state_71949__$1 = (function (){var statearr_71956 = state_71949;
(statearr_71956[(8)] = inst_71935__$1);

return statearr_71956;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71949__$1,(8),jobs,inst_71938);
} else {
if((state_val_71950 === (7))){
var inst_71945 = (state_71949[(2)]);
var state_71949__$1 = state_71949;
var statearr_71957_72069 = state_71949__$1;
(statearr_71957_72069[(2)] = inst_71945);

(statearr_71957_72069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71950 === (8))){
var inst_71935 = (state_71949[(8)]);
var inst_71940 = (state_71949[(2)]);
var state_71949__$1 = (function (){var statearr_71958 = state_71949;
(statearr_71958[(9)] = inst_71940);

return statearr_71958;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71949__$1,(9),results,inst_71935);
} else {
if((state_val_71950 === (9))){
var inst_71942 = (state_71949[(2)]);
var state_71949__$1 = (function (){var statearr_71959 = state_71949;
(statearr_71959[(10)] = inst_71942);

return statearr_71959;
})();
var statearr_71960_72070 = state_71949__$1;
(statearr_71960_72070[(2)] = null);

(statearr_71960_72070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___72064,jobs,results,process,async))
;
return ((function (switch__68742__auto__,c__68765__auto___72064,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0 = (function (){
var statearr_71964 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71964[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__);

(statearr_71964[(1)] = (1));

return statearr_71964;
});
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1 = (function (state_71949){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_71949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e71965){if((e71965 instanceof Object)){
var ex__68746__auto__ = e71965;
var statearr_71966_72071 = state_71949;
(statearr_71966_72071[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71965;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72072 = state_71949;
state_71949 = G__72072;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = function(state_71949){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1.call(this,state_71949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___72064,jobs,results,process,async))
})();
var state__68767__auto__ = (function (){var statearr_71967 = f__68766__auto__.call(null);
(statearr_71967[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___72064);

return statearr_71967;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___72064,jobs,results,process,async))
);


var c__68765__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto__,jobs,results,process,async){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto__,jobs,results,process,async){
return (function (state_72005){
var state_val_72006 = (state_72005[(1)]);
if((state_val_72006 === (7))){
var inst_72001 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72007_72073 = state_72005__$1;
(statearr_72007_72073[(2)] = inst_72001);

(statearr_72007_72073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (20))){
var state_72005__$1 = state_72005;
var statearr_72008_72074 = state_72005__$1;
(statearr_72008_72074[(2)] = null);

(statearr_72008_72074[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (1))){
var state_72005__$1 = state_72005;
var statearr_72009_72075 = state_72005__$1;
(statearr_72009_72075[(2)] = null);

(statearr_72009_72075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (4))){
var inst_71970 = (state_72005[(7)]);
var inst_71970__$1 = (state_72005[(2)]);
var inst_71971 = (inst_71970__$1 == null);
var state_72005__$1 = (function (){var statearr_72010 = state_72005;
(statearr_72010[(7)] = inst_71970__$1);

return statearr_72010;
})();
if(cljs.core.truth_(inst_71971)){
var statearr_72011_72076 = state_72005__$1;
(statearr_72011_72076[(1)] = (5));

} else {
var statearr_72012_72077 = state_72005__$1;
(statearr_72012_72077[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (15))){
var inst_71983 = (state_72005[(8)]);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72005__$1,(18),to,inst_71983);
} else {
if((state_val_72006 === (21))){
var inst_71996 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72013_72078 = state_72005__$1;
(statearr_72013_72078[(2)] = inst_71996);

(statearr_72013_72078[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (13))){
var inst_71998 = (state_72005[(2)]);
var state_72005__$1 = (function (){var statearr_72014 = state_72005;
(statearr_72014[(9)] = inst_71998);

return statearr_72014;
})();
var statearr_72015_72079 = state_72005__$1;
(statearr_72015_72079[(2)] = null);

(statearr_72015_72079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (6))){
var inst_71970 = (state_72005[(7)]);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72005__$1,(11),inst_71970);
} else {
if((state_val_72006 === (17))){
var inst_71991 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
if(cljs.core.truth_(inst_71991)){
var statearr_72016_72080 = state_72005__$1;
(statearr_72016_72080[(1)] = (19));

} else {
var statearr_72017_72081 = state_72005__$1;
(statearr_72017_72081[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (3))){
var inst_72003 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72005__$1,inst_72003);
} else {
if((state_val_72006 === (12))){
var inst_71980 = (state_72005[(10)]);
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72005__$1,(14),inst_71980);
} else {
if((state_val_72006 === (2))){
var state_72005__$1 = state_72005;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72005__$1,(4),results);
} else {
if((state_val_72006 === (19))){
var state_72005__$1 = state_72005;
var statearr_72018_72082 = state_72005__$1;
(statearr_72018_72082[(2)] = null);

(statearr_72018_72082[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (11))){
var inst_71980 = (state_72005[(2)]);
var state_72005__$1 = (function (){var statearr_72019 = state_72005;
(statearr_72019[(10)] = inst_71980);

return statearr_72019;
})();
var statearr_72020_72083 = state_72005__$1;
(statearr_72020_72083[(2)] = null);

(statearr_72020_72083[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (9))){
var state_72005__$1 = state_72005;
var statearr_72021_72084 = state_72005__$1;
(statearr_72021_72084[(2)] = null);

(statearr_72021_72084[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (5))){
var state_72005__$1 = state_72005;
if(cljs.core.truth_(close_QMARK_)){
var statearr_72022_72085 = state_72005__$1;
(statearr_72022_72085[(1)] = (8));

} else {
var statearr_72023_72086 = state_72005__$1;
(statearr_72023_72086[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (14))){
var inst_71983 = (state_72005[(8)]);
var inst_71985 = (state_72005[(11)]);
var inst_71983__$1 = (state_72005[(2)]);
var inst_71984 = (inst_71983__$1 == null);
var inst_71985__$1 = cljs.core.not.call(null,inst_71984);
var state_72005__$1 = (function (){var statearr_72024 = state_72005;
(statearr_72024[(8)] = inst_71983__$1);

(statearr_72024[(11)] = inst_71985__$1);

return statearr_72024;
})();
if(inst_71985__$1){
var statearr_72025_72087 = state_72005__$1;
(statearr_72025_72087[(1)] = (15));

} else {
var statearr_72026_72088 = state_72005__$1;
(statearr_72026_72088[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (16))){
var inst_71985 = (state_72005[(11)]);
var state_72005__$1 = state_72005;
var statearr_72027_72089 = state_72005__$1;
(statearr_72027_72089[(2)] = inst_71985);

(statearr_72027_72089[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (10))){
var inst_71977 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72028_72090 = state_72005__$1;
(statearr_72028_72090[(2)] = inst_71977);

(statearr_72028_72090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (18))){
var inst_71988 = (state_72005[(2)]);
var state_72005__$1 = state_72005;
var statearr_72029_72091 = state_72005__$1;
(statearr_72029_72091[(2)] = inst_71988);

(statearr_72029_72091[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72006 === (8))){
var inst_71974 = cljs.core.async.close_BANG_.call(null,to);
var state_72005__$1 = state_72005;
var statearr_72030_72092 = state_72005__$1;
(statearr_72030_72092[(2)] = inst_71974);

(statearr_72030_72092[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto__,jobs,results,process,async))
;
return ((function (switch__68742__auto__,c__68765__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0 = (function (){
var statearr_72034 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72034[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__);

(statearr_72034[(1)] = (1));

return statearr_72034;
});
var cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1 = (function (state_72005){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_72005);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e72035){if((e72035 instanceof Object)){
var ex__68746__auto__ = e72035;
var statearr_72036_72093 = state_72005;
(statearr_72036_72093[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72005);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72035;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72094 = state_72005;
state_72005 = G__72094;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__ = function(state_72005){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1.call(this,state_72005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__68743__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto__,jobs,results,process,async))
})();
var state__68767__auto__ = (function (){var statearr_72037 = f__68766__auto__.call(null);
(statearr_72037[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto__);

return statearr_72037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto__,jobs,results,process,async))
);

return c__68765__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args72095 = [];
var len__67420__auto___72098 = arguments.length;
var i__67421__auto___72099 = (0);
while(true){
if((i__67421__auto___72099 < len__67420__auto___72098)){
args72095.push((arguments[i__67421__auto___72099]));

var G__72100 = (i__67421__auto___72099 + (1));
i__67421__auto___72099 = G__72100;
continue;
} else {
}
break;
}

var G__72097 = args72095.length;
switch (G__72097) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72095.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args72102 = [];
var len__67420__auto___72105 = arguments.length;
var i__67421__auto___72106 = (0);
while(true){
if((i__67421__auto___72106 < len__67420__auto___72105)){
args72102.push((arguments[i__67421__auto___72106]));

var G__72107 = (i__67421__auto___72106 + (1));
i__67421__auto___72106 = G__72107;
continue;
} else {
}
break;
}

var G__72104 = args72102.length;
switch (G__72104) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72102.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args72109 = [];
var len__67420__auto___72162 = arguments.length;
var i__67421__auto___72163 = (0);
while(true){
if((i__67421__auto___72163 < len__67420__auto___72162)){
args72109.push((arguments[i__67421__auto___72163]));

var G__72164 = (i__67421__auto___72163 + (1));
i__67421__auto___72163 = G__72164;
continue;
} else {
}
break;
}

var G__72111 = args72109.length;
switch (G__72111) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72109.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__68765__auto___72166 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___72166,tc,fc){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___72166,tc,fc){
return (function (state_72137){
var state_val_72138 = (state_72137[(1)]);
if((state_val_72138 === (7))){
var inst_72133 = (state_72137[(2)]);
var state_72137__$1 = state_72137;
var statearr_72139_72167 = state_72137__$1;
(statearr_72139_72167[(2)] = inst_72133);

(statearr_72139_72167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (1))){
var state_72137__$1 = state_72137;
var statearr_72140_72168 = state_72137__$1;
(statearr_72140_72168[(2)] = null);

(statearr_72140_72168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (4))){
var inst_72114 = (state_72137[(7)]);
var inst_72114__$1 = (state_72137[(2)]);
var inst_72115 = (inst_72114__$1 == null);
var state_72137__$1 = (function (){var statearr_72141 = state_72137;
(statearr_72141[(7)] = inst_72114__$1);

return statearr_72141;
})();
if(cljs.core.truth_(inst_72115)){
var statearr_72142_72169 = state_72137__$1;
(statearr_72142_72169[(1)] = (5));

} else {
var statearr_72143_72170 = state_72137__$1;
(statearr_72143_72170[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (13))){
var state_72137__$1 = state_72137;
var statearr_72144_72171 = state_72137__$1;
(statearr_72144_72171[(2)] = null);

(statearr_72144_72171[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (6))){
var inst_72114 = (state_72137[(7)]);
var inst_72120 = p.call(null,inst_72114);
var state_72137__$1 = state_72137;
if(cljs.core.truth_(inst_72120)){
var statearr_72145_72172 = state_72137__$1;
(statearr_72145_72172[(1)] = (9));

} else {
var statearr_72146_72173 = state_72137__$1;
(statearr_72146_72173[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (3))){
var inst_72135 = (state_72137[(2)]);
var state_72137__$1 = state_72137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72137__$1,inst_72135);
} else {
if((state_val_72138 === (12))){
var state_72137__$1 = state_72137;
var statearr_72147_72174 = state_72137__$1;
(statearr_72147_72174[(2)] = null);

(statearr_72147_72174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (2))){
var state_72137__$1 = state_72137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72137__$1,(4),ch);
} else {
if((state_val_72138 === (11))){
var inst_72114 = (state_72137[(7)]);
var inst_72124 = (state_72137[(2)]);
var state_72137__$1 = state_72137;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72137__$1,(8),inst_72124,inst_72114);
} else {
if((state_val_72138 === (9))){
var state_72137__$1 = state_72137;
var statearr_72148_72175 = state_72137__$1;
(statearr_72148_72175[(2)] = tc);

(statearr_72148_72175[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (5))){
var inst_72117 = cljs.core.async.close_BANG_.call(null,tc);
var inst_72118 = cljs.core.async.close_BANG_.call(null,fc);
var state_72137__$1 = (function (){var statearr_72149 = state_72137;
(statearr_72149[(8)] = inst_72117);

return statearr_72149;
})();
var statearr_72150_72176 = state_72137__$1;
(statearr_72150_72176[(2)] = inst_72118);

(statearr_72150_72176[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (14))){
var inst_72131 = (state_72137[(2)]);
var state_72137__$1 = state_72137;
var statearr_72151_72177 = state_72137__$1;
(statearr_72151_72177[(2)] = inst_72131);

(statearr_72151_72177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (10))){
var state_72137__$1 = state_72137;
var statearr_72152_72178 = state_72137__$1;
(statearr_72152_72178[(2)] = fc);

(statearr_72152_72178[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72138 === (8))){
var inst_72126 = (state_72137[(2)]);
var state_72137__$1 = state_72137;
if(cljs.core.truth_(inst_72126)){
var statearr_72153_72179 = state_72137__$1;
(statearr_72153_72179[(1)] = (12));

} else {
var statearr_72154_72180 = state_72137__$1;
(statearr_72154_72180[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___72166,tc,fc))
;
return ((function (switch__68742__auto__,c__68765__auto___72166,tc,fc){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_72158 = [null,null,null,null,null,null,null,null,null];
(statearr_72158[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_72158[(1)] = (1));

return statearr_72158;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_72137){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_72137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e72159){if((e72159 instanceof Object)){
var ex__68746__auto__ = e72159;
var statearr_72160_72181 = state_72137;
(statearr_72160_72181[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72137);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72159;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72182 = state_72137;
state_72137 = G__72182;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_72137){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_72137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___72166,tc,fc))
})();
var state__68767__auto__ = (function (){var statearr_72161 = f__68766__auto__.call(null);
(statearr_72161[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___72166);

return statearr_72161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___72166,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__68765__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto__){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto__){
return (function (state_72246){
var state_val_72247 = (state_72246[(1)]);
if((state_val_72247 === (7))){
var inst_72242 = (state_72246[(2)]);
var state_72246__$1 = state_72246;
var statearr_72248_72269 = state_72246__$1;
(statearr_72248_72269[(2)] = inst_72242);

(statearr_72248_72269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (1))){
var inst_72226 = init;
var state_72246__$1 = (function (){var statearr_72249 = state_72246;
(statearr_72249[(7)] = inst_72226);

return statearr_72249;
})();
var statearr_72250_72270 = state_72246__$1;
(statearr_72250_72270[(2)] = null);

(statearr_72250_72270[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (4))){
var inst_72229 = (state_72246[(8)]);
var inst_72229__$1 = (state_72246[(2)]);
var inst_72230 = (inst_72229__$1 == null);
var state_72246__$1 = (function (){var statearr_72251 = state_72246;
(statearr_72251[(8)] = inst_72229__$1);

return statearr_72251;
})();
if(cljs.core.truth_(inst_72230)){
var statearr_72252_72271 = state_72246__$1;
(statearr_72252_72271[(1)] = (5));

} else {
var statearr_72253_72272 = state_72246__$1;
(statearr_72253_72272[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (6))){
var inst_72233 = (state_72246[(9)]);
var inst_72226 = (state_72246[(7)]);
var inst_72229 = (state_72246[(8)]);
var inst_72233__$1 = f.call(null,inst_72226,inst_72229);
var inst_72234 = cljs.core.reduced_QMARK_.call(null,inst_72233__$1);
var state_72246__$1 = (function (){var statearr_72254 = state_72246;
(statearr_72254[(9)] = inst_72233__$1);

return statearr_72254;
})();
if(inst_72234){
var statearr_72255_72273 = state_72246__$1;
(statearr_72255_72273[(1)] = (8));

} else {
var statearr_72256_72274 = state_72246__$1;
(statearr_72256_72274[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (3))){
var inst_72244 = (state_72246[(2)]);
var state_72246__$1 = state_72246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72246__$1,inst_72244);
} else {
if((state_val_72247 === (2))){
var state_72246__$1 = state_72246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72246__$1,(4),ch);
} else {
if((state_val_72247 === (9))){
var inst_72233 = (state_72246[(9)]);
var inst_72226 = inst_72233;
var state_72246__$1 = (function (){var statearr_72257 = state_72246;
(statearr_72257[(7)] = inst_72226);

return statearr_72257;
})();
var statearr_72258_72275 = state_72246__$1;
(statearr_72258_72275[(2)] = null);

(statearr_72258_72275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (5))){
var inst_72226 = (state_72246[(7)]);
var state_72246__$1 = state_72246;
var statearr_72259_72276 = state_72246__$1;
(statearr_72259_72276[(2)] = inst_72226);

(statearr_72259_72276[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (10))){
var inst_72240 = (state_72246[(2)]);
var state_72246__$1 = state_72246;
var statearr_72260_72277 = state_72246__$1;
(statearr_72260_72277[(2)] = inst_72240);

(statearr_72260_72277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72247 === (8))){
var inst_72233 = (state_72246[(9)]);
var inst_72236 = cljs.core.deref.call(null,inst_72233);
var state_72246__$1 = state_72246;
var statearr_72261_72278 = state_72246__$1;
(statearr_72261_72278[(2)] = inst_72236);

(statearr_72261_72278[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto__))
;
return ((function (switch__68742__auto__,c__68765__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__68743__auto__ = null;
var cljs$core$async$reduce_$_state_machine__68743__auto____0 = (function (){
var statearr_72265 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72265[(0)] = cljs$core$async$reduce_$_state_machine__68743__auto__);

(statearr_72265[(1)] = (1));

return statearr_72265;
});
var cljs$core$async$reduce_$_state_machine__68743__auto____1 = (function (state_72246){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_72246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e72266){if((e72266 instanceof Object)){
var ex__68746__auto__ = e72266;
var statearr_72267_72279 = state_72246;
(statearr_72267_72279[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72246);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72266;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72280 = state_72246;
state_72246 = G__72280;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__68743__auto__ = function(state_72246){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__68743__auto____1.call(this,state_72246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__68743__auto____0;
cljs$core$async$reduce_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__68743__auto____1;
return cljs$core$async$reduce_$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto__))
})();
var state__68767__auto__ = (function (){var statearr_72268 = f__68766__auto__.call(null);
(statearr_72268[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto__);

return statearr_72268;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto__))
);

return c__68765__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__68765__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto__,f__$1){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto__,f__$1){
return (function (state_72300){
var state_val_72301 = (state_72300[(1)]);
if((state_val_72301 === (1))){
var inst_72295 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_72300__$1 = state_72300;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72300__$1,(2),inst_72295);
} else {
if((state_val_72301 === (2))){
var inst_72297 = (state_72300[(2)]);
var inst_72298 = f__$1.call(null,inst_72297);
var state_72300__$1 = state_72300;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72300__$1,inst_72298);
} else {
return null;
}
}
});})(c__68765__auto__,f__$1))
;
return ((function (switch__68742__auto__,c__68765__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__68743__auto__ = null;
var cljs$core$async$transduce_$_state_machine__68743__auto____0 = (function (){
var statearr_72305 = [null,null,null,null,null,null,null];
(statearr_72305[(0)] = cljs$core$async$transduce_$_state_machine__68743__auto__);

(statearr_72305[(1)] = (1));

return statearr_72305;
});
var cljs$core$async$transduce_$_state_machine__68743__auto____1 = (function (state_72300){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_72300);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e72306){if((e72306 instanceof Object)){
var ex__68746__auto__ = e72306;
var statearr_72307_72309 = state_72300;
(statearr_72307_72309[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72300);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72306;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72310 = state_72300;
state_72300 = G__72310;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__68743__auto__ = function(state_72300){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__68743__auto____1.call(this,state_72300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__68743__auto____0;
cljs$core$async$transduce_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__68743__auto____1;
return cljs$core$async$transduce_$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto__,f__$1))
})();
var state__68767__auto__ = (function (){var statearr_72308 = f__68766__auto__.call(null);
(statearr_72308[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto__);

return statearr_72308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto__,f__$1))
);

return c__68765__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args72311 = [];
var len__67420__auto___72363 = arguments.length;
var i__67421__auto___72364 = (0);
while(true){
if((i__67421__auto___72364 < len__67420__auto___72363)){
args72311.push((arguments[i__67421__auto___72364]));

var G__72365 = (i__67421__auto___72364 + (1));
i__67421__auto___72364 = G__72365;
continue;
} else {
}
break;
}

var G__72313 = args72311.length;
switch (G__72313) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72311.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__68765__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto__){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto__){
return (function (state_72338){
var state_val_72339 = (state_72338[(1)]);
if((state_val_72339 === (7))){
var inst_72320 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
var statearr_72340_72367 = state_72338__$1;
(statearr_72340_72367[(2)] = inst_72320);

(statearr_72340_72367[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (1))){
var inst_72314 = cljs.core.seq.call(null,coll);
var inst_72315 = inst_72314;
var state_72338__$1 = (function (){var statearr_72341 = state_72338;
(statearr_72341[(7)] = inst_72315);

return statearr_72341;
})();
var statearr_72342_72368 = state_72338__$1;
(statearr_72342_72368[(2)] = null);

(statearr_72342_72368[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (4))){
var inst_72315 = (state_72338[(7)]);
var inst_72318 = cljs.core.first.call(null,inst_72315);
var state_72338__$1 = state_72338;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72338__$1,(7),ch,inst_72318);
} else {
if((state_val_72339 === (13))){
var inst_72332 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
var statearr_72343_72369 = state_72338__$1;
(statearr_72343_72369[(2)] = inst_72332);

(statearr_72343_72369[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (6))){
var inst_72323 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
if(cljs.core.truth_(inst_72323)){
var statearr_72344_72370 = state_72338__$1;
(statearr_72344_72370[(1)] = (8));

} else {
var statearr_72345_72371 = state_72338__$1;
(statearr_72345_72371[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (3))){
var inst_72336 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72338__$1,inst_72336);
} else {
if((state_val_72339 === (12))){
var state_72338__$1 = state_72338;
var statearr_72346_72372 = state_72338__$1;
(statearr_72346_72372[(2)] = null);

(statearr_72346_72372[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (2))){
var inst_72315 = (state_72338[(7)]);
var state_72338__$1 = state_72338;
if(cljs.core.truth_(inst_72315)){
var statearr_72347_72373 = state_72338__$1;
(statearr_72347_72373[(1)] = (4));

} else {
var statearr_72348_72374 = state_72338__$1;
(statearr_72348_72374[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (11))){
var inst_72329 = cljs.core.async.close_BANG_.call(null,ch);
var state_72338__$1 = state_72338;
var statearr_72349_72375 = state_72338__$1;
(statearr_72349_72375[(2)] = inst_72329);

(statearr_72349_72375[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (9))){
var state_72338__$1 = state_72338;
if(cljs.core.truth_(close_QMARK_)){
var statearr_72350_72376 = state_72338__$1;
(statearr_72350_72376[(1)] = (11));

} else {
var statearr_72351_72377 = state_72338__$1;
(statearr_72351_72377[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (5))){
var inst_72315 = (state_72338[(7)]);
var state_72338__$1 = state_72338;
var statearr_72352_72378 = state_72338__$1;
(statearr_72352_72378[(2)] = inst_72315);

(statearr_72352_72378[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (10))){
var inst_72334 = (state_72338[(2)]);
var state_72338__$1 = state_72338;
var statearr_72353_72379 = state_72338__$1;
(statearr_72353_72379[(2)] = inst_72334);

(statearr_72353_72379[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72339 === (8))){
var inst_72315 = (state_72338[(7)]);
var inst_72325 = cljs.core.next.call(null,inst_72315);
var inst_72315__$1 = inst_72325;
var state_72338__$1 = (function (){var statearr_72354 = state_72338;
(statearr_72354[(7)] = inst_72315__$1);

return statearr_72354;
})();
var statearr_72355_72380 = state_72338__$1;
(statearr_72355_72380[(2)] = null);

(statearr_72355_72380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto__))
;
return ((function (switch__68742__auto__,c__68765__auto__){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_72359 = [null,null,null,null,null,null,null,null];
(statearr_72359[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_72359[(1)] = (1));

return statearr_72359;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_72338){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_72338);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e72360){if((e72360 instanceof Object)){
var ex__68746__auto__ = e72360;
var statearr_72361_72381 = state_72338;
(statearr_72361_72381[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72338);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72360;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72382 = state_72338;
state_72338 = G__72382;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_72338){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_72338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto__))
})();
var state__68767__auto__ = (function (){var statearr_72362 = f__68766__auto__.call(null);
(statearr_72362[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto__);

return statearr_72362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto__))
);

return c__68765__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__66917__auto__ = (((_ == null))?null:_);
var m__66918__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,_);
} else {
var m__66918__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__66918__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m,ch);
} else {
var m__66918__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m);
} else {
var m__66918__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async72608 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72608 = (function (ch,cs,meta72609){
this.ch = ch;
this.cs = cs;
this.meta72609 = meta72609;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_72610,meta72609__$1){
var self__ = this;
var _72610__$1 = this;
return (new cljs.core.async.t_cljs$core$async72608(self__.ch,self__.cs,meta72609__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_72610){
var self__ = this;
var _72610__$1 = this;
return self__.meta72609;
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta72609","meta72609",-856455189,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async72608.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72608.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72608";

cljs.core.async.t_cljs$core$async72608.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async72608");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async72608 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async72608(ch__$1,cs__$1,meta72609){
return (new cljs.core.async.t_cljs$core$async72608(ch__$1,cs__$1,meta72609));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async72608(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__68765__auto___72833 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___72833,cs,m,dchan,dctr,done){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___72833,cs,m,dchan,dctr,done){
return (function (state_72745){
var state_val_72746 = (state_72745[(1)]);
if((state_val_72746 === (7))){
var inst_72741 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72747_72834 = state_72745__$1;
(statearr_72747_72834[(2)] = inst_72741);

(statearr_72747_72834[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (20))){
var inst_72644 = (state_72745[(7)]);
var inst_72656 = cljs.core.first.call(null,inst_72644);
var inst_72657 = cljs.core.nth.call(null,inst_72656,(0),null);
var inst_72658 = cljs.core.nth.call(null,inst_72656,(1),null);
var state_72745__$1 = (function (){var statearr_72748 = state_72745;
(statearr_72748[(8)] = inst_72657);

return statearr_72748;
})();
if(cljs.core.truth_(inst_72658)){
var statearr_72749_72835 = state_72745__$1;
(statearr_72749_72835[(1)] = (22));

} else {
var statearr_72750_72836 = state_72745__$1;
(statearr_72750_72836[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (27))){
var inst_72693 = (state_72745[(9)]);
var inst_72688 = (state_72745[(10)]);
var inst_72686 = (state_72745[(11)]);
var inst_72613 = (state_72745[(12)]);
var inst_72693__$1 = cljs.core._nth.call(null,inst_72686,inst_72688);
var inst_72694 = cljs.core.async.put_BANG_.call(null,inst_72693__$1,inst_72613,done);
var state_72745__$1 = (function (){var statearr_72751 = state_72745;
(statearr_72751[(9)] = inst_72693__$1);

return statearr_72751;
})();
if(cljs.core.truth_(inst_72694)){
var statearr_72752_72837 = state_72745__$1;
(statearr_72752_72837[(1)] = (30));

} else {
var statearr_72753_72838 = state_72745__$1;
(statearr_72753_72838[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (1))){
var state_72745__$1 = state_72745;
var statearr_72754_72839 = state_72745__$1;
(statearr_72754_72839[(2)] = null);

(statearr_72754_72839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (24))){
var inst_72644 = (state_72745[(7)]);
var inst_72663 = (state_72745[(2)]);
var inst_72664 = cljs.core.next.call(null,inst_72644);
var inst_72622 = inst_72664;
var inst_72623 = null;
var inst_72624 = (0);
var inst_72625 = (0);
var state_72745__$1 = (function (){var statearr_72755 = state_72745;
(statearr_72755[(13)] = inst_72663);

(statearr_72755[(14)] = inst_72625);

(statearr_72755[(15)] = inst_72622);

(statearr_72755[(16)] = inst_72624);

(statearr_72755[(17)] = inst_72623);

return statearr_72755;
})();
var statearr_72756_72840 = state_72745__$1;
(statearr_72756_72840[(2)] = null);

(statearr_72756_72840[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (39))){
var state_72745__$1 = state_72745;
var statearr_72760_72841 = state_72745__$1;
(statearr_72760_72841[(2)] = null);

(statearr_72760_72841[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (4))){
var inst_72613 = (state_72745[(12)]);
var inst_72613__$1 = (state_72745[(2)]);
var inst_72614 = (inst_72613__$1 == null);
var state_72745__$1 = (function (){var statearr_72761 = state_72745;
(statearr_72761[(12)] = inst_72613__$1);

return statearr_72761;
})();
if(cljs.core.truth_(inst_72614)){
var statearr_72762_72842 = state_72745__$1;
(statearr_72762_72842[(1)] = (5));

} else {
var statearr_72763_72843 = state_72745__$1;
(statearr_72763_72843[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (15))){
var inst_72625 = (state_72745[(14)]);
var inst_72622 = (state_72745[(15)]);
var inst_72624 = (state_72745[(16)]);
var inst_72623 = (state_72745[(17)]);
var inst_72640 = (state_72745[(2)]);
var inst_72641 = (inst_72625 + (1));
var tmp72757 = inst_72622;
var tmp72758 = inst_72624;
var tmp72759 = inst_72623;
var inst_72622__$1 = tmp72757;
var inst_72623__$1 = tmp72759;
var inst_72624__$1 = tmp72758;
var inst_72625__$1 = inst_72641;
var state_72745__$1 = (function (){var statearr_72764 = state_72745;
(statearr_72764[(14)] = inst_72625__$1);

(statearr_72764[(15)] = inst_72622__$1);

(statearr_72764[(18)] = inst_72640);

(statearr_72764[(16)] = inst_72624__$1);

(statearr_72764[(17)] = inst_72623__$1);

return statearr_72764;
})();
var statearr_72765_72844 = state_72745__$1;
(statearr_72765_72844[(2)] = null);

(statearr_72765_72844[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (21))){
var inst_72667 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72769_72845 = state_72745__$1;
(statearr_72769_72845[(2)] = inst_72667);

(statearr_72769_72845[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (31))){
var inst_72693 = (state_72745[(9)]);
var inst_72697 = done.call(null,null);
var inst_72698 = cljs.core.async.untap_STAR_.call(null,m,inst_72693);
var state_72745__$1 = (function (){var statearr_72770 = state_72745;
(statearr_72770[(19)] = inst_72697);

return statearr_72770;
})();
var statearr_72771_72846 = state_72745__$1;
(statearr_72771_72846[(2)] = inst_72698);

(statearr_72771_72846[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (32))){
var inst_72685 = (state_72745[(20)]);
var inst_72688 = (state_72745[(10)]);
var inst_72687 = (state_72745[(21)]);
var inst_72686 = (state_72745[(11)]);
var inst_72700 = (state_72745[(2)]);
var inst_72701 = (inst_72688 + (1));
var tmp72766 = inst_72685;
var tmp72767 = inst_72687;
var tmp72768 = inst_72686;
var inst_72685__$1 = tmp72766;
var inst_72686__$1 = tmp72768;
var inst_72687__$1 = tmp72767;
var inst_72688__$1 = inst_72701;
var state_72745__$1 = (function (){var statearr_72772 = state_72745;
(statearr_72772[(20)] = inst_72685__$1);

(statearr_72772[(22)] = inst_72700);

(statearr_72772[(10)] = inst_72688__$1);

(statearr_72772[(21)] = inst_72687__$1);

(statearr_72772[(11)] = inst_72686__$1);

return statearr_72772;
})();
var statearr_72773_72847 = state_72745__$1;
(statearr_72773_72847[(2)] = null);

(statearr_72773_72847[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (40))){
var inst_72713 = (state_72745[(23)]);
var inst_72717 = done.call(null,null);
var inst_72718 = cljs.core.async.untap_STAR_.call(null,m,inst_72713);
var state_72745__$1 = (function (){var statearr_72774 = state_72745;
(statearr_72774[(24)] = inst_72717);

return statearr_72774;
})();
var statearr_72775_72848 = state_72745__$1;
(statearr_72775_72848[(2)] = inst_72718);

(statearr_72775_72848[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (33))){
var inst_72704 = (state_72745[(25)]);
var inst_72706 = cljs.core.chunked_seq_QMARK_.call(null,inst_72704);
var state_72745__$1 = state_72745;
if(inst_72706){
var statearr_72776_72849 = state_72745__$1;
(statearr_72776_72849[(1)] = (36));

} else {
var statearr_72777_72850 = state_72745__$1;
(statearr_72777_72850[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (13))){
var inst_72634 = (state_72745[(26)]);
var inst_72637 = cljs.core.async.close_BANG_.call(null,inst_72634);
var state_72745__$1 = state_72745;
var statearr_72778_72851 = state_72745__$1;
(statearr_72778_72851[(2)] = inst_72637);

(statearr_72778_72851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (22))){
var inst_72657 = (state_72745[(8)]);
var inst_72660 = cljs.core.async.close_BANG_.call(null,inst_72657);
var state_72745__$1 = state_72745;
var statearr_72779_72852 = state_72745__$1;
(statearr_72779_72852[(2)] = inst_72660);

(statearr_72779_72852[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (36))){
var inst_72704 = (state_72745[(25)]);
var inst_72708 = cljs.core.chunk_first.call(null,inst_72704);
var inst_72709 = cljs.core.chunk_rest.call(null,inst_72704);
var inst_72710 = cljs.core.count.call(null,inst_72708);
var inst_72685 = inst_72709;
var inst_72686 = inst_72708;
var inst_72687 = inst_72710;
var inst_72688 = (0);
var state_72745__$1 = (function (){var statearr_72780 = state_72745;
(statearr_72780[(20)] = inst_72685);

(statearr_72780[(10)] = inst_72688);

(statearr_72780[(21)] = inst_72687);

(statearr_72780[(11)] = inst_72686);

return statearr_72780;
})();
var statearr_72781_72853 = state_72745__$1;
(statearr_72781_72853[(2)] = null);

(statearr_72781_72853[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (41))){
var inst_72704 = (state_72745[(25)]);
var inst_72720 = (state_72745[(2)]);
var inst_72721 = cljs.core.next.call(null,inst_72704);
var inst_72685 = inst_72721;
var inst_72686 = null;
var inst_72687 = (0);
var inst_72688 = (0);
var state_72745__$1 = (function (){var statearr_72782 = state_72745;
(statearr_72782[(20)] = inst_72685);

(statearr_72782[(10)] = inst_72688);

(statearr_72782[(27)] = inst_72720);

(statearr_72782[(21)] = inst_72687);

(statearr_72782[(11)] = inst_72686);

return statearr_72782;
})();
var statearr_72783_72854 = state_72745__$1;
(statearr_72783_72854[(2)] = null);

(statearr_72783_72854[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (43))){
var state_72745__$1 = state_72745;
var statearr_72784_72855 = state_72745__$1;
(statearr_72784_72855[(2)] = null);

(statearr_72784_72855[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (29))){
var inst_72729 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72785_72856 = state_72745__$1;
(statearr_72785_72856[(2)] = inst_72729);

(statearr_72785_72856[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (44))){
var inst_72738 = (state_72745[(2)]);
var state_72745__$1 = (function (){var statearr_72786 = state_72745;
(statearr_72786[(28)] = inst_72738);

return statearr_72786;
})();
var statearr_72787_72857 = state_72745__$1;
(statearr_72787_72857[(2)] = null);

(statearr_72787_72857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (6))){
var inst_72677 = (state_72745[(29)]);
var inst_72676 = cljs.core.deref.call(null,cs);
var inst_72677__$1 = cljs.core.keys.call(null,inst_72676);
var inst_72678 = cljs.core.count.call(null,inst_72677__$1);
var inst_72679 = cljs.core.reset_BANG_.call(null,dctr,inst_72678);
var inst_72684 = cljs.core.seq.call(null,inst_72677__$1);
var inst_72685 = inst_72684;
var inst_72686 = null;
var inst_72687 = (0);
var inst_72688 = (0);
var state_72745__$1 = (function (){var statearr_72788 = state_72745;
(statearr_72788[(29)] = inst_72677__$1);

(statearr_72788[(20)] = inst_72685);

(statearr_72788[(10)] = inst_72688);

(statearr_72788[(30)] = inst_72679);

(statearr_72788[(21)] = inst_72687);

(statearr_72788[(11)] = inst_72686);

return statearr_72788;
})();
var statearr_72789_72858 = state_72745__$1;
(statearr_72789_72858[(2)] = null);

(statearr_72789_72858[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (28))){
var inst_72685 = (state_72745[(20)]);
var inst_72704 = (state_72745[(25)]);
var inst_72704__$1 = cljs.core.seq.call(null,inst_72685);
var state_72745__$1 = (function (){var statearr_72790 = state_72745;
(statearr_72790[(25)] = inst_72704__$1);

return statearr_72790;
})();
if(inst_72704__$1){
var statearr_72791_72859 = state_72745__$1;
(statearr_72791_72859[(1)] = (33));

} else {
var statearr_72792_72860 = state_72745__$1;
(statearr_72792_72860[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (25))){
var inst_72688 = (state_72745[(10)]);
var inst_72687 = (state_72745[(21)]);
var inst_72690 = (inst_72688 < inst_72687);
var inst_72691 = inst_72690;
var state_72745__$1 = state_72745;
if(cljs.core.truth_(inst_72691)){
var statearr_72793_72861 = state_72745__$1;
(statearr_72793_72861[(1)] = (27));

} else {
var statearr_72794_72862 = state_72745__$1;
(statearr_72794_72862[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (34))){
var state_72745__$1 = state_72745;
var statearr_72795_72863 = state_72745__$1;
(statearr_72795_72863[(2)] = null);

(statearr_72795_72863[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (17))){
var state_72745__$1 = state_72745;
var statearr_72796_72864 = state_72745__$1;
(statearr_72796_72864[(2)] = null);

(statearr_72796_72864[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (3))){
var inst_72743 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72745__$1,inst_72743);
} else {
if((state_val_72746 === (12))){
var inst_72672 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72797_72865 = state_72745__$1;
(statearr_72797_72865[(2)] = inst_72672);

(statearr_72797_72865[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (2))){
var state_72745__$1 = state_72745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72745__$1,(4),ch);
} else {
if((state_val_72746 === (23))){
var state_72745__$1 = state_72745;
var statearr_72798_72866 = state_72745__$1;
(statearr_72798_72866[(2)] = null);

(statearr_72798_72866[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (35))){
var inst_72727 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72799_72867 = state_72745__$1;
(statearr_72799_72867[(2)] = inst_72727);

(statearr_72799_72867[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (19))){
var inst_72644 = (state_72745[(7)]);
var inst_72648 = cljs.core.chunk_first.call(null,inst_72644);
var inst_72649 = cljs.core.chunk_rest.call(null,inst_72644);
var inst_72650 = cljs.core.count.call(null,inst_72648);
var inst_72622 = inst_72649;
var inst_72623 = inst_72648;
var inst_72624 = inst_72650;
var inst_72625 = (0);
var state_72745__$1 = (function (){var statearr_72800 = state_72745;
(statearr_72800[(14)] = inst_72625);

(statearr_72800[(15)] = inst_72622);

(statearr_72800[(16)] = inst_72624);

(statearr_72800[(17)] = inst_72623);

return statearr_72800;
})();
var statearr_72801_72868 = state_72745__$1;
(statearr_72801_72868[(2)] = null);

(statearr_72801_72868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (11))){
var inst_72622 = (state_72745[(15)]);
var inst_72644 = (state_72745[(7)]);
var inst_72644__$1 = cljs.core.seq.call(null,inst_72622);
var state_72745__$1 = (function (){var statearr_72802 = state_72745;
(statearr_72802[(7)] = inst_72644__$1);

return statearr_72802;
})();
if(inst_72644__$1){
var statearr_72803_72869 = state_72745__$1;
(statearr_72803_72869[(1)] = (16));

} else {
var statearr_72804_72870 = state_72745__$1;
(statearr_72804_72870[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (9))){
var inst_72674 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72805_72871 = state_72745__$1;
(statearr_72805_72871[(2)] = inst_72674);

(statearr_72805_72871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (5))){
var inst_72620 = cljs.core.deref.call(null,cs);
var inst_72621 = cljs.core.seq.call(null,inst_72620);
var inst_72622 = inst_72621;
var inst_72623 = null;
var inst_72624 = (0);
var inst_72625 = (0);
var state_72745__$1 = (function (){var statearr_72806 = state_72745;
(statearr_72806[(14)] = inst_72625);

(statearr_72806[(15)] = inst_72622);

(statearr_72806[(16)] = inst_72624);

(statearr_72806[(17)] = inst_72623);

return statearr_72806;
})();
var statearr_72807_72872 = state_72745__$1;
(statearr_72807_72872[(2)] = null);

(statearr_72807_72872[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (14))){
var state_72745__$1 = state_72745;
var statearr_72808_72873 = state_72745__$1;
(statearr_72808_72873[(2)] = null);

(statearr_72808_72873[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (45))){
var inst_72735 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72809_72874 = state_72745__$1;
(statearr_72809_72874[(2)] = inst_72735);

(statearr_72809_72874[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (26))){
var inst_72677 = (state_72745[(29)]);
var inst_72731 = (state_72745[(2)]);
var inst_72732 = cljs.core.seq.call(null,inst_72677);
var state_72745__$1 = (function (){var statearr_72810 = state_72745;
(statearr_72810[(31)] = inst_72731);

return statearr_72810;
})();
if(inst_72732){
var statearr_72811_72875 = state_72745__$1;
(statearr_72811_72875[(1)] = (42));

} else {
var statearr_72812_72876 = state_72745__$1;
(statearr_72812_72876[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (16))){
var inst_72644 = (state_72745[(7)]);
var inst_72646 = cljs.core.chunked_seq_QMARK_.call(null,inst_72644);
var state_72745__$1 = state_72745;
if(inst_72646){
var statearr_72813_72877 = state_72745__$1;
(statearr_72813_72877[(1)] = (19));

} else {
var statearr_72814_72878 = state_72745__$1;
(statearr_72814_72878[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (38))){
var inst_72724 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72815_72879 = state_72745__$1;
(statearr_72815_72879[(2)] = inst_72724);

(statearr_72815_72879[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (30))){
var state_72745__$1 = state_72745;
var statearr_72816_72880 = state_72745__$1;
(statearr_72816_72880[(2)] = null);

(statearr_72816_72880[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (10))){
var inst_72625 = (state_72745[(14)]);
var inst_72623 = (state_72745[(17)]);
var inst_72633 = cljs.core._nth.call(null,inst_72623,inst_72625);
var inst_72634 = cljs.core.nth.call(null,inst_72633,(0),null);
var inst_72635 = cljs.core.nth.call(null,inst_72633,(1),null);
var state_72745__$1 = (function (){var statearr_72817 = state_72745;
(statearr_72817[(26)] = inst_72634);

return statearr_72817;
})();
if(cljs.core.truth_(inst_72635)){
var statearr_72818_72881 = state_72745__$1;
(statearr_72818_72881[(1)] = (13));

} else {
var statearr_72819_72882 = state_72745__$1;
(statearr_72819_72882[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (18))){
var inst_72670 = (state_72745[(2)]);
var state_72745__$1 = state_72745;
var statearr_72820_72883 = state_72745__$1;
(statearr_72820_72883[(2)] = inst_72670);

(statearr_72820_72883[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (42))){
var state_72745__$1 = state_72745;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72745__$1,(45),dchan);
} else {
if((state_val_72746 === (37))){
var inst_72713 = (state_72745[(23)]);
var inst_72704 = (state_72745[(25)]);
var inst_72613 = (state_72745[(12)]);
var inst_72713__$1 = cljs.core.first.call(null,inst_72704);
var inst_72714 = cljs.core.async.put_BANG_.call(null,inst_72713__$1,inst_72613,done);
var state_72745__$1 = (function (){var statearr_72821 = state_72745;
(statearr_72821[(23)] = inst_72713__$1);

return statearr_72821;
})();
if(cljs.core.truth_(inst_72714)){
var statearr_72822_72884 = state_72745__$1;
(statearr_72822_72884[(1)] = (39));

} else {
var statearr_72823_72885 = state_72745__$1;
(statearr_72823_72885[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72746 === (8))){
var inst_72625 = (state_72745[(14)]);
var inst_72624 = (state_72745[(16)]);
var inst_72627 = (inst_72625 < inst_72624);
var inst_72628 = inst_72627;
var state_72745__$1 = state_72745;
if(cljs.core.truth_(inst_72628)){
var statearr_72824_72886 = state_72745__$1;
(statearr_72824_72886[(1)] = (10));

} else {
var statearr_72825_72887 = state_72745__$1;
(statearr_72825_72887[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___72833,cs,m,dchan,dctr,done))
;
return ((function (switch__68742__auto__,c__68765__auto___72833,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__68743__auto__ = null;
var cljs$core$async$mult_$_state_machine__68743__auto____0 = (function (){
var statearr_72829 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72829[(0)] = cljs$core$async$mult_$_state_machine__68743__auto__);

(statearr_72829[(1)] = (1));

return statearr_72829;
});
var cljs$core$async$mult_$_state_machine__68743__auto____1 = (function (state_72745){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_72745);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e72830){if((e72830 instanceof Object)){
var ex__68746__auto__ = e72830;
var statearr_72831_72888 = state_72745;
(statearr_72831_72888[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72745);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72830;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72889 = state_72745;
state_72745 = G__72889;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__68743__auto__ = function(state_72745){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__68743__auto____1.call(this,state_72745);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__68743__auto____0;
cljs$core$async$mult_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__68743__auto____1;
return cljs$core$async$mult_$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___72833,cs,m,dchan,dctr,done))
})();
var state__68767__auto__ = (function (){var statearr_72832 = f__68766__auto__.call(null);
(statearr_72832[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___72833);

return statearr_72832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___72833,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args72890 = [];
var len__67420__auto___72893 = arguments.length;
var i__67421__auto___72894 = (0);
while(true){
if((i__67421__auto___72894 < len__67420__auto___72893)){
args72890.push((arguments[i__67421__auto___72894]));

var G__72895 = (i__67421__auto___72894 + (1));
i__67421__auto___72894 = G__72895;
continue;
} else {
}
break;
}

var G__72892 = args72890.length;
switch (G__72892) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72890.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m,ch);
} else {
var m__66918__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m,ch);
} else {
var m__66918__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m);
} else {
var m__66918__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m,state_map);
} else {
var m__66918__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__66917__auto__ = (((m == null))?null:m);
var m__66918__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,m,mode);
} else {
var m__66918__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__67427__auto__ = [];
var len__67420__auto___72907 = arguments.length;
var i__67421__auto___72908 = (0);
while(true){
if((i__67421__auto___72908 < len__67420__auto___72907)){
args__67427__auto__.push((arguments[i__67421__auto___72908]));

var G__72909 = (i__67421__auto___72908 + (1));
i__67421__auto___72908 = G__72909;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((3) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__67428__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__72901){
var map__72902 = p__72901;
var map__72902__$1 = ((((!((map__72902 == null)))?((((map__72902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72902.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72902):map__72902);
var opts = map__72902__$1;
var statearr_72904_72910 = state;
(statearr_72904_72910[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__72902,map__72902__$1,opts){
return (function (val){
var statearr_72905_72911 = state;
(statearr_72905_72911[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__72902,map__72902__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_72906_72912 = state;
(statearr_72906_72912[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq72897){
var G__72898 = cljs.core.first.call(null,seq72897);
var seq72897__$1 = cljs.core.next.call(null,seq72897);
var G__72899 = cljs.core.first.call(null,seq72897__$1);
var seq72897__$2 = cljs.core.next.call(null,seq72897__$1);
var G__72900 = cljs.core.first.call(null,seq72897__$2);
var seq72897__$3 = cljs.core.next.call(null,seq72897__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__72898,G__72899,G__72900,seq72897__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async73080 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73080 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta73081){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta73081 = meta73081;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_73082,meta73081__$1){
var self__ = this;
var _73082__$1 = this;
return (new cljs.core.async.t_cljs$core$async73080(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta73081__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_73082){
var self__ = this;
var _73082__$1 = this;
return self__.meta73081;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta73081","meta73081",-582087704,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async73080.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73080.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73080";

cljs.core.async.t_cljs$core$async73080.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async73080");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async73080 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async73080(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta73081){
return (new cljs.core.async.t_cljs$core$async73080(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta73081));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async73080(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__68765__auto___73247 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___73247,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___73247,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_73184){
var state_val_73185 = (state_73184[(1)]);
if((state_val_73185 === (7))){
var inst_73099 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73186_73248 = state_73184__$1;
(statearr_73186_73248[(2)] = inst_73099);

(statearr_73186_73248[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (20))){
var inst_73111 = (state_73184[(7)]);
var state_73184__$1 = state_73184;
var statearr_73187_73249 = state_73184__$1;
(statearr_73187_73249[(2)] = inst_73111);

(statearr_73187_73249[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (27))){
var state_73184__$1 = state_73184;
var statearr_73188_73250 = state_73184__$1;
(statearr_73188_73250[(2)] = null);

(statearr_73188_73250[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (1))){
var inst_73086 = (state_73184[(8)]);
var inst_73086__$1 = calc_state.call(null);
var inst_73088 = (inst_73086__$1 == null);
var inst_73089 = cljs.core.not.call(null,inst_73088);
var state_73184__$1 = (function (){var statearr_73189 = state_73184;
(statearr_73189[(8)] = inst_73086__$1);

return statearr_73189;
})();
if(inst_73089){
var statearr_73190_73251 = state_73184__$1;
(statearr_73190_73251[(1)] = (2));

} else {
var statearr_73191_73252 = state_73184__$1;
(statearr_73191_73252[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (24))){
var inst_73158 = (state_73184[(9)]);
var inst_73144 = (state_73184[(10)]);
var inst_73135 = (state_73184[(11)]);
var inst_73158__$1 = inst_73135.call(null,inst_73144);
var state_73184__$1 = (function (){var statearr_73192 = state_73184;
(statearr_73192[(9)] = inst_73158__$1);

return statearr_73192;
})();
if(cljs.core.truth_(inst_73158__$1)){
var statearr_73193_73253 = state_73184__$1;
(statearr_73193_73253[(1)] = (29));

} else {
var statearr_73194_73254 = state_73184__$1;
(statearr_73194_73254[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (4))){
var inst_73102 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73102)){
var statearr_73195_73255 = state_73184__$1;
(statearr_73195_73255[(1)] = (8));

} else {
var statearr_73196_73256 = state_73184__$1;
(statearr_73196_73256[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (15))){
var inst_73129 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73129)){
var statearr_73197_73257 = state_73184__$1;
(statearr_73197_73257[(1)] = (19));

} else {
var statearr_73198_73258 = state_73184__$1;
(statearr_73198_73258[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (21))){
var inst_73134 = (state_73184[(12)]);
var inst_73134__$1 = (state_73184[(2)]);
var inst_73135 = cljs.core.get.call(null,inst_73134__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_73136 = cljs.core.get.call(null,inst_73134__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_73137 = cljs.core.get.call(null,inst_73134__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_73184__$1 = (function (){var statearr_73199 = state_73184;
(statearr_73199[(12)] = inst_73134__$1);

(statearr_73199[(11)] = inst_73135);

(statearr_73199[(13)] = inst_73136);

return statearr_73199;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_73184__$1,(22),inst_73137);
} else {
if((state_val_73185 === (31))){
var inst_73166 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73166)){
var statearr_73200_73259 = state_73184__$1;
(statearr_73200_73259[(1)] = (32));

} else {
var statearr_73201_73260 = state_73184__$1;
(statearr_73201_73260[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (32))){
var inst_73143 = (state_73184[(14)]);
var state_73184__$1 = state_73184;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73184__$1,(35),out,inst_73143);
} else {
if((state_val_73185 === (33))){
var inst_73134 = (state_73184[(12)]);
var inst_73111 = inst_73134;
var state_73184__$1 = (function (){var statearr_73202 = state_73184;
(statearr_73202[(7)] = inst_73111);

return statearr_73202;
})();
var statearr_73203_73261 = state_73184__$1;
(statearr_73203_73261[(2)] = null);

(statearr_73203_73261[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (13))){
var inst_73111 = (state_73184[(7)]);
var inst_73118 = inst_73111.cljs$lang$protocol_mask$partition0$;
var inst_73119 = (inst_73118 & (64));
var inst_73120 = inst_73111.cljs$core$ISeq$;
var inst_73121 = (cljs.core.PROTOCOL_SENTINEL === inst_73120);
var inst_73122 = (inst_73119) || (inst_73121);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73122)){
var statearr_73204_73262 = state_73184__$1;
(statearr_73204_73262[(1)] = (16));

} else {
var statearr_73205_73263 = state_73184__$1;
(statearr_73205_73263[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (22))){
var inst_73144 = (state_73184[(10)]);
var inst_73143 = (state_73184[(14)]);
var inst_73142 = (state_73184[(2)]);
var inst_73143__$1 = cljs.core.nth.call(null,inst_73142,(0),null);
var inst_73144__$1 = cljs.core.nth.call(null,inst_73142,(1),null);
var inst_73145 = (inst_73143__$1 == null);
var inst_73146 = cljs.core._EQ_.call(null,inst_73144__$1,change);
var inst_73147 = (inst_73145) || (inst_73146);
var state_73184__$1 = (function (){var statearr_73206 = state_73184;
(statearr_73206[(10)] = inst_73144__$1);

(statearr_73206[(14)] = inst_73143__$1);

return statearr_73206;
})();
if(cljs.core.truth_(inst_73147)){
var statearr_73207_73264 = state_73184__$1;
(statearr_73207_73264[(1)] = (23));

} else {
var statearr_73208_73265 = state_73184__$1;
(statearr_73208_73265[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (36))){
var inst_73134 = (state_73184[(12)]);
var inst_73111 = inst_73134;
var state_73184__$1 = (function (){var statearr_73209 = state_73184;
(statearr_73209[(7)] = inst_73111);

return statearr_73209;
})();
var statearr_73210_73266 = state_73184__$1;
(statearr_73210_73266[(2)] = null);

(statearr_73210_73266[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (29))){
var inst_73158 = (state_73184[(9)]);
var state_73184__$1 = state_73184;
var statearr_73211_73267 = state_73184__$1;
(statearr_73211_73267[(2)] = inst_73158);

(statearr_73211_73267[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (6))){
var state_73184__$1 = state_73184;
var statearr_73212_73268 = state_73184__$1;
(statearr_73212_73268[(2)] = false);

(statearr_73212_73268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (28))){
var inst_73154 = (state_73184[(2)]);
var inst_73155 = calc_state.call(null);
var inst_73111 = inst_73155;
var state_73184__$1 = (function (){var statearr_73213 = state_73184;
(statearr_73213[(7)] = inst_73111);

(statearr_73213[(15)] = inst_73154);

return statearr_73213;
})();
var statearr_73214_73269 = state_73184__$1;
(statearr_73214_73269[(2)] = null);

(statearr_73214_73269[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (25))){
var inst_73180 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73215_73270 = state_73184__$1;
(statearr_73215_73270[(2)] = inst_73180);

(statearr_73215_73270[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (34))){
var inst_73178 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73216_73271 = state_73184__$1;
(statearr_73216_73271[(2)] = inst_73178);

(statearr_73216_73271[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (17))){
var state_73184__$1 = state_73184;
var statearr_73217_73272 = state_73184__$1;
(statearr_73217_73272[(2)] = false);

(statearr_73217_73272[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (3))){
var state_73184__$1 = state_73184;
var statearr_73218_73273 = state_73184__$1;
(statearr_73218_73273[(2)] = false);

(statearr_73218_73273[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (12))){
var inst_73182 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73184__$1,inst_73182);
} else {
if((state_val_73185 === (2))){
var inst_73086 = (state_73184[(8)]);
var inst_73091 = inst_73086.cljs$lang$protocol_mask$partition0$;
var inst_73092 = (inst_73091 & (64));
var inst_73093 = inst_73086.cljs$core$ISeq$;
var inst_73094 = (cljs.core.PROTOCOL_SENTINEL === inst_73093);
var inst_73095 = (inst_73092) || (inst_73094);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73095)){
var statearr_73219_73274 = state_73184__$1;
(statearr_73219_73274[(1)] = (5));

} else {
var statearr_73220_73275 = state_73184__$1;
(statearr_73220_73275[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (23))){
var inst_73143 = (state_73184[(14)]);
var inst_73149 = (inst_73143 == null);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73149)){
var statearr_73221_73276 = state_73184__$1;
(statearr_73221_73276[(1)] = (26));

} else {
var statearr_73222_73277 = state_73184__$1;
(statearr_73222_73277[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (35))){
var inst_73169 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
if(cljs.core.truth_(inst_73169)){
var statearr_73223_73278 = state_73184__$1;
(statearr_73223_73278[(1)] = (36));

} else {
var statearr_73224_73279 = state_73184__$1;
(statearr_73224_73279[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (19))){
var inst_73111 = (state_73184[(7)]);
var inst_73131 = cljs.core.apply.call(null,cljs.core.hash_map,inst_73111);
var state_73184__$1 = state_73184;
var statearr_73225_73280 = state_73184__$1;
(statearr_73225_73280[(2)] = inst_73131);

(statearr_73225_73280[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (11))){
var inst_73111 = (state_73184[(7)]);
var inst_73115 = (inst_73111 == null);
var inst_73116 = cljs.core.not.call(null,inst_73115);
var state_73184__$1 = state_73184;
if(inst_73116){
var statearr_73226_73281 = state_73184__$1;
(statearr_73226_73281[(1)] = (13));

} else {
var statearr_73227_73282 = state_73184__$1;
(statearr_73227_73282[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (9))){
var inst_73086 = (state_73184[(8)]);
var state_73184__$1 = state_73184;
var statearr_73228_73283 = state_73184__$1;
(statearr_73228_73283[(2)] = inst_73086);

(statearr_73228_73283[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (5))){
var state_73184__$1 = state_73184;
var statearr_73229_73284 = state_73184__$1;
(statearr_73229_73284[(2)] = true);

(statearr_73229_73284[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (14))){
var state_73184__$1 = state_73184;
var statearr_73230_73285 = state_73184__$1;
(statearr_73230_73285[(2)] = false);

(statearr_73230_73285[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (26))){
var inst_73144 = (state_73184[(10)]);
var inst_73151 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_73144);
var state_73184__$1 = state_73184;
var statearr_73231_73286 = state_73184__$1;
(statearr_73231_73286[(2)] = inst_73151);

(statearr_73231_73286[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (16))){
var state_73184__$1 = state_73184;
var statearr_73232_73287 = state_73184__$1;
(statearr_73232_73287[(2)] = true);

(statearr_73232_73287[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (38))){
var inst_73174 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73233_73288 = state_73184__$1;
(statearr_73233_73288[(2)] = inst_73174);

(statearr_73233_73288[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (30))){
var inst_73144 = (state_73184[(10)]);
var inst_73135 = (state_73184[(11)]);
var inst_73136 = (state_73184[(13)]);
var inst_73161 = cljs.core.empty_QMARK_.call(null,inst_73135);
var inst_73162 = inst_73136.call(null,inst_73144);
var inst_73163 = cljs.core.not.call(null,inst_73162);
var inst_73164 = (inst_73161) && (inst_73163);
var state_73184__$1 = state_73184;
var statearr_73234_73289 = state_73184__$1;
(statearr_73234_73289[(2)] = inst_73164);

(statearr_73234_73289[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (10))){
var inst_73086 = (state_73184[(8)]);
var inst_73107 = (state_73184[(2)]);
var inst_73108 = cljs.core.get.call(null,inst_73107,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_73109 = cljs.core.get.call(null,inst_73107,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_73110 = cljs.core.get.call(null,inst_73107,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_73111 = inst_73086;
var state_73184__$1 = (function (){var statearr_73235 = state_73184;
(statearr_73235[(7)] = inst_73111);

(statearr_73235[(16)] = inst_73110);

(statearr_73235[(17)] = inst_73109);

(statearr_73235[(18)] = inst_73108);

return statearr_73235;
})();
var statearr_73236_73290 = state_73184__$1;
(statearr_73236_73290[(2)] = null);

(statearr_73236_73290[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (18))){
var inst_73126 = (state_73184[(2)]);
var state_73184__$1 = state_73184;
var statearr_73237_73291 = state_73184__$1;
(statearr_73237_73291[(2)] = inst_73126);

(statearr_73237_73291[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (37))){
var state_73184__$1 = state_73184;
var statearr_73238_73292 = state_73184__$1;
(statearr_73238_73292[(2)] = null);

(statearr_73238_73292[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73185 === (8))){
var inst_73086 = (state_73184[(8)]);
var inst_73104 = cljs.core.apply.call(null,cljs.core.hash_map,inst_73086);
var state_73184__$1 = state_73184;
var statearr_73239_73293 = state_73184__$1;
(statearr_73239_73293[(2)] = inst_73104);

(statearr_73239_73293[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___73247,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__68742__auto__,c__68765__auto___73247,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__68743__auto__ = null;
var cljs$core$async$mix_$_state_machine__68743__auto____0 = (function (){
var statearr_73243 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73243[(0)] = cljs$core$async$mix_$_state_machine__68743__auto__);

(statearr_73243[(1)] = (1));

return statearr_73243;
});
var cljs$core$async$mix_$_state_machine__68743__auto____1 = (function (state_73184){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e73244){if((e73244 instanceof Object)){
var ex__68746__auto__ = e73244;
var statearr_73245_73294 = state_73184;
(statearr_73245_73294[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73184);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73244;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73295 = state_73184;
state_73184 = G__73295;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__68743__auto__ = function(state_73184){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__68743__auto____1.call(this,state_73184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__68743__auto____0;
cljs$core$async$mix_$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__68743__auto____1;
return cljs$core$async$mix_$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___73247,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__68767__auto__ = (function (){var statearr_73246 = f__68766__auto__.call(null);
(statearr_73246[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___73247);

return statearr_73246;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___73247,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__66917__auto__ = (((p == null))?null:p);
var m__66918__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__66918__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__66917__auto__ = (((p == null))?null:p);
var m__66918__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,p,v,ch);
} else {
var m__66918__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args73296 = [];
var len__67420__auto___73299 = arguments.length;
var i__67421__auto___73300 = (0);
while(true){
if((i__67421__auto___73300 < len__67420__auto___73299)){
args73296.push((arguments[i__67421__auto___73300]));

var G__73301 = (i__67421__auto___73300 + (1));
i__67421__auto___73300 = G__73301;
continue;
} else {
}
break;
}

var G__73298 = args73296.length;
switch (G__73298) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73296.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__66917__auto__ = (((p == null))?null:p);
var m__66918__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,p);
} else {
var m__66918__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__66917__auto__ = (((p == null))?null:p);
var m__66918__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__66917__auto__)]);
if(!((m__66918__auto__ == null))){
return m__66918__auto__.call(null,p,v);
} else {
var m__66918__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__66918__auto____$1 == null))){
return m__66918__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args73304 = [];
var len__67420__auto___73429 = arguments.length;
var i__67421__auto___73430 = (0);
while(true){
if((i__67421__auto___73430 < len__67420__auto___73429)){
args73304.push((arguments[i__67421__auto___73430]));

var G__73431 = (i__67421__auto___73430 + (1));
i__67421__auto___73430 = G__73431;
continue;
} else {
}
break;
}

var G__73306 = args73304.length;
switch (G__73306) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73304.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__66199__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__66199__auto__)){
return or__66199__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__66199__auto__,mults){
return (function (p1__73303_SHARP_){
if(cljs.core.truth_(p1__73303_SHARP_.call(null,topic))){
return p1__73303_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__73303_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__66199__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async73307 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73307 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta73308){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta73308 = meta73308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_73309,meta73308__$1){
var self__ = this;
var _73309__$1 = this;
return (new cljs.core.async.t_cljs$core$async73307(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta73308__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_73309){
var self__ = this;
var _73309__$1 = this;
return self__.meta73308;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta73308","meta73308",1131138728,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async73307.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73307";

cljs.core.async.t_cljs$core$async73307.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async73307");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async73307 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async73307(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta73308){
return (new cljs.core.async.t_cljs$core$async73307(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta73308));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async73307(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__68765__auto___73433 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___73433,mults,ensure_mult,p){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___73433,mults,ensure_mult,p){
return (function (state_73381){
var state_val_73382 = (state_73381[(1)]);
if((state_val_73382 === (7))){
var inst_73377 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
var statearr_73383_73434 = state_73381__$1;
(statearr_73383_73434[(2)] = inst_73377);

(statearr_73383_73434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (20))){
var state_73381__$1 = state_73381;
var statearr_73384_73435 = state_73381__$1;
(statearr_73384_73435[(2)] = null);

(statearr_73384_73435[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (1))){
var state_73381__$1 = state_73381;
var statearr_73385_73436 = state_73381__$1;
(statearr_73385_73436[(2)] = null);

(statearr_73385_73436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (24))){
var inst_73360 = (state_73381[(7)]);
var inst_73369 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_73360);
var state_73381__$1 = state_73381;
var statearr_73386_73437 = state_73381__$1;
(statearr_73386_73437[(2)] = inst_73369);

(statearr_73386_73437[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (4))){
var inst_73312 = (state_73381[(8)]);
var inst_73312__$1 = (state_73381[(2)]);
var inst_73313 = (inst_73312__$1 == null);
var state_73381__$1 = (function (){var statearr_73387 = state_73381;
(statearr_73387[(8)] = inst_73312__$1);

return statearr_73387;
})();
if(cljs.core.truth_(inst_73313)){
var statearr_73388_73438 = state_73381__$1;
(statearr_73388_73438[(1)] = (5));

} else {
var statearr_73389_73439 = state_73381__$1;
(statearr_73389_73439[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (15))){
var inst_73354 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
var statearr_73390_73440 = state_73381__$1;
(statearr_73390_73440[(2)] = inst_73354);

(statearr_73390_73440[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (21))){
var inst_73374 = (state_73381[(2)]);
var state_73381__$1 = (function (){var statearr_73391 = state_73381;
(statearr_73391[(9)] = inst_73374);

return statearr_73391;
})();
var statearr_73392_73441 = state_73381__$1;
(statearr_73392_73441[(2)] = null);

(statearr_73392_73441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (13))){
var inst_73336 = (state_73381[(10)]);
var inst_73338 = cljs.core.chunked_seq_QMARK_.call(null,inst_73336);
var state_73381__$1 = state_73381;
if(inst_73338){
var statearr_73393_73442 = state_73381__$1;
(statearr_73393_73442[(1)] = (16));

} else {
var statearr_73394_73443 = state_73381__$1;
(statearr_73394_73443[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (22))){
var inst_73366 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
if(cljs.core.truth_(inst_73366)){
var statearr_73395_73444 = state_73381__$1;
(statearr_73395_73444[(1)] = (23));

} else {
var statearr_73396_73445 = state_73381__$1;
(statearr_73396_73445[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (6))){
var inst_73312 = (state_73381[(8)]);
var inst_73362 = (state_73381[(11)]);
var inst_73360 = (state_73381[(7)]);
var inst_73360__$1 = topic_fn.call(null,inst_73312);
var inst_73361 = cljs.core.deref.call(null,mults);
var inst_73362__$1 = cljs.core.get.call(null,inst_73361,inst_73360__$1);
var state_73381__$1 = (function (){var statearr_73397 = state_73381;
(statearr_73397[(11)] = inst_73362__$1);

(statearr_73397[(7)] = inst_73360__$1);

return statearr_73397;
})();
if(cljs.core.truth_(inst_73362__$1)){
var statearr_73398_73446 = state_73381__$1;
(statearr_73398_73446[(1)] = (19));

} else {
var statearr_73399_73447 = state_73381__$1;
(statearr_73399_73447[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (25))){
var inst_73371 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
var statearr_73400_73448 = state_73381__$1;
(statearr_73400_73448[(2)] = inst_73371);

(statearr_73400_73448[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (17))){
var inst_73336 = (state_73381[(10)]);
var inst_73345 = cljs.core.first.call(null,inst_73336);
var inst_73346 = cljs.core.async.muxch_STAR_.call(null,inst_73345);
var inst_73347 = cljs.core.async.close_BANG_.call(null,inst_73346);
var inst_73348 = cljs.core.next.call(null,inst_73336);
var inst_73322 = inst_73348;
var inst_73323 = null;
var inst_73324 = (0);
var inst_73325 = (0);
var state_73381__$1 = (function (){var statearr_73401 = state_73381;
(statearr_73401[(12)] = inst_73323);

(statearr_73401[(13)] = inst_73322);

(statearr_73401[(14)] = inst_73325);

(statearr_73401[(15)] = inst_73324);

(statearr_73401[(16)] = inst_73347);

return statearr_73401;
})();
var statearr_73402_73449 = state_73381__$1;
(statearr_73402_73449[(2)] = null);

(statearr_73402_73449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (3))){
var inst_73379 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73381__$1,inst_73379);
} else {
if((state_val_73382 === (12))){
var inst_73356 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
var statearr_73403_73450 = state_73381__$1;
(statearr_73403_73450[(2)] = inst_73356);

(statearr_73403_73450[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (2))){
var state_73381__$1 = state_73381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73381__$1,(4),ch);
} else {
if((state_val_73382 === (23))){
var state_73381__$1 = state_73381;
var statearr_73404_73451 = state_73381__$1;
(statearr_73404_73451[(2)] = null);

(statearr_73404_73451[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (19))){
var inst_73312 = (state_73381[(8)]);
var inst_73362 = (state_73381[(11)]);
var inst_73364 = cljs.core.async.muxch_STAR_.call(null,inst_73362);
var state_73381__$1 = state_73381;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73381__$1,(22),inst_73364,inst_73312);
} else {
if((state_val_73382 === (11))){
var inst_73322 = (state_73381[(13)]);
var inst_73336 = (state_73381[(10)]);
var inst_73336__$1 = cljs.core.seq.call(null,inst_73322);
var state_73381__$1 = (function (){var statearr_73405 = state_73381;
(statearr_73405[(10)] = inst_73336__$1);

return statearr_73405;
})();
if(inst_73336__$1){
var statearr_73406_73452 = state_73381__$1;
(statearr_73406_73452[(1)] = (13));

} else {
var statearr_73407_73453 = state_73381__$1;
(statearr_73407_73453[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (9))){
var inst_73358 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
var statearr_73408_73454 = state_73381__$1;
(statearr_73408_73454[(2)] = inst_73358);

(statearr_73408_73454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (5))){
var inst_73319 = cljs.core.deref.call(null,mults);
var inst_73320 = cljs.core.vals.call(null,inst_73319);
var inst_73321 = cljs.core.seq.call(null,inst_73320);
var inst_73322 = inst_73321;
var inst_73323 = null;
var inst_73324 = (0);
var inst_73325 = (0);
var state_73381__$1 = (function (){var statearr_73409 = state_73381;
(statearr_73409[(12)] = inst_73323);

(statearr_73409[(13)] = inst_73322);

(statearr_73409[(14)] = inst_73325);

(statearr_73409[(15)] = inst_73324);

return statearr_73409;
})();
var statearr_73410_73455 = state_73381__$1;
(statearr_73410_73455[(2)] = null);

(statearr_73410_73455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (14))){
var state_73381__$1 = state_73381;
var statearr_73414_73456 = state_73381__$1;
(statearr_73414_73456[(2)] = null);

(statearr_73414_73456[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (16))){
var inst_73336 = (state_73381[(10)]);
var inst_73340 = cljs.core.chunk_first.call(null,inst_73336);
var inst_73341 = cljs.core.chunk_rest.call(null,inst_73336);
var inst_73342 = cljs.core.count.call(null,inst_73340);
var inst_73322 = inst_73341;
var inst_73323 = inst_73340;
var inst_73324 = inst_73342;
var inst_73325 = (0);
var state_73381__$1 = (function (){var statearr_73415 = state_73381;
(statearr_73415[(12)] = inst_73323);

(statearr_73415[(13)] = inst_73322);

(statearr_73415[(14)] = inst_73325);

(statearr_73415[(15)] = inst_73324);

return statearr_73415;
})();
var statearr_73416_73457 = state_73381__$1;
(statearr_73416_73457[(2)] = null);

(statearr_73416_73457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (10))){
var inst_73323 = (state_73381[(12)]);
var inst_73322 = (state_73381[(13)]);
var inst_73325 = (state_73381[(14)]);
var inst_73324 = (state_73381[(15)]);
var inst_73330 = cljs.core._nth.call(null,inst_73323,inst_73325);
var inst_73331 = cljs.core.async.muxch_STAR_.call(null,inst_73330);
var inst_73332 = cljs.core.async.close_BANG_.call(null,inst_73331);
var inst_73333 = (inst_73325 + (1));
var tmp73411 = inst_73323;
var tmp73412 = inst_73322;
var tmp73413 = inst_73324;
var inst_73322__$1 = tmp73412;
var inst_73323__$1 = tmp73411;
var inst_73324__$1 = tmp73413;
var inst_73325__$1 = inst_73333;
var state_73381__$1 = (function (){var statearr_73417 = state_73381;
(statearr_73417[(12)] = inst_73323__$1);

(statearr_73417[(13)] = inst_73322__$1);

(statearr_73417[(14)] = inst_73325__$1);

(statearr_73417[(15)] = inst_73324__$1);

(statearr_73417[(17)] = inst_73332);

return statearr_73417;
})();
var statearr_73418_73458 = state_73381__$1;
(statearr_73418_73458[(2)] = null);

(statearr_73418_73458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (18))){
var inst_73351 = (state_73381[(2)]);
var state_73381__$1 = state_73381;
var statearr_73419_73459 = state_73381__$1;
(statearr_73419_73459[(2)] = inst_73351);

(statearr_73419_73459[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73382 === (8))){
var inst_73325 = (state_73381[(14)]);
var inst_73324 = (state_73381[(15)]);
var inst_73327 = (inst_73325 < inst_73324);
var inst_73328 = inst_73327;
var state_73381__$1 = state_73381;
if(cljs.core.truth_(inst_73328)){
var statearr_73420_73460 = state_73381__$1;
(statearr_73420_73460[(1)] = (10));

} else {
var statearr_73421_73461 = state_73381__$1;
(statearr_73421_73461[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___73433,mults,ensure_mult,p))
;
return ((function (switch__68742__auto__,c__68765__auto___73433,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_73425 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73425[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_73425[(1)] = (1));

return statearr_73425;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_73381){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e73426){if((e73426 instanceof Object)){
var ex__68746__auto__ = e73426;
var statearr_73427_73462 = state_73381;
(statearr_73427_73462[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73381);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73426;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73463 = state_73381;
state_73381 = G__73463;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_73381){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_73381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___73433,mults,ensure_mult,p))
})();
var state__68767__auto__ = (function (){var statearr_73428 = f__68766__auto__.call(null);
(statearr_73428[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___73433);

return statearr_73428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___73433,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args73464 = [];
var len__67420__auto___73467 = arguments.length;
var i__67421__auto___73468 = (0);
while(true){
if((i__67421__auto___73468 < len__67420__auto___73467)){
args73464.push((arguments[i__67421__auto___73468]));

var G__73469 = (i__67421__auto___73468 + (1));
i__67421__auto___73468 = G__73469;
continue;
} else {
}
break;
}

var G__73466 = args73464.length;
switch (G__73466) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73464.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args73471 = [];
var len__67420__auto___73474 = arguments.length;
var i__67421__auto___73475 = (0);
while(true){
if((i__67421__auto___73475 < len__67420__auto___73474)){
args73471.push((arguments[i__67421__auto___73475]));

var G__73476 = (i__67421__auto___73475 + (1));
i__67421__auto___73475 = G__73476;
continue;
} else {
}
break;
}

var G__73473 = args73471.length;
switch (G__73473) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73471.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args73478 = [];
var len__67420__auto___73549 = arguments.length;
var i__67421__auto___73550 = (0);
while(true){
if((i__67421__auto___73550 < len__67420__auto___73549)){
args73478.push((arguments[i__67421__auto___73550]));

var G__73551 = (i__67421__auto___73550 + (1));
i__67421__auto___73550 = G__73551;
continue;
} else {
}
break;
}

var G__73480 = args73478.length;
switch (G__73480) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73478.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__68765__auto___73553 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___73553,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___73553,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_73519){
var state_val_73520 = (state_73519[(1)]);
if((state_val_73520 === (7))){
var state_73519__$1 = state_73519;
var statearr_73521_73554 = state_73519__$1;
(statearr_73521_73554[(2)] = null);

(statearr_73521_73554[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (1))){
var state_73519__$1 = state_73519;
var statearr_73522_73555 = state_73519__$1;
(statearr_73522_73555[(2)] = null);

(statearr_73522_73555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (4))){
var inst_73483 = (state_73519[(7)]);
var inst_73485 = (inst_73483 < cnt);
var state_73519__$1 = state_73519;
if(cljs.core.truth_(inst_73485)){
var statearr_73523_73556 = state_73519__$1;
(statearr_73523_73556[(1)] = (6));

} else {
var statearr_73524_73557 = state_73519__$1;
(statearr_73524_73557[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (15))){
var inst_73515 = (state_73519[(2)]);
var state_73519__$1 = state_73519;
var statearr_73525_73558 = state_73519__$1;
(statearr_73525_73558[(2)] = inst_73515);

(statearr_73525_73558[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (13))){
var inst_73508 = cljs.core.async.close_BANG_.call(null,out);
var state_73519__$1 = state_73519;
var statearr_73526_73559 = state_73519__$1;
(statearr_73526_73559[(2)] = inst_73508);

(statearr_73526_73559[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (6))){
var state_73519__$1 = state_73519;
var statearr_73527_73560 = state_73519__$1;
(statearr_73527_73560[(2)] = null);

(statearr_73527_73560[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (3))){
var inst_73517 = (state_73519[(2)]);
var state_73519__$1 = state_73519;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73519__$1,inst_73517);
} else {
if((state_val_73520 === (12))){
var inst_73505 = (state_73519[(8)]);
var inst_73505__$1 = (state_73519[(2)]);
var inst_73506 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_73505__$1);
var state_73519__$1 = (function (){var statearr_73528 = state_73519;
(statearr_73528[(8)] = inst_73505__$1);

return statearr_73528;
})();
if(cljs.core.truth_(inst_73506)){
var statearr_73529_73561 = state_73519__$1;
(statearr_73529_73561[(1)] = (13));

} else {
var statearr_73530_73562 = state_73519__$1;
(statearr_73530_73562[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (2))){
var inst_73482 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_73483 = (0);
var state_73519__$1 = (function (){var statearr_73531 = state_73519;
(statearr_73531[(7)] = inst_73483);

(statearr_73531[(9)] = inst_73482);

return statearr_73531;
})();
var statearr_73532_73563 = state_73519__$1;
(statearr_73532_73563[(2)] = null);

(statearr_73532_73563[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (11))){
var inst_73483 = (state_73519[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_73519,(10),Object,null,(9));
var inst_73492 = chs__$1.call(null,inst_73483);
var inst_73493 = done.call(null,inst_73483);
var inst_73494 = cljs.core.async.take_BANG_.call(null,inst_73492,inst_73493);
var state_73519__$1 = state_73519;
var statearr_73533_73564 = state_73519__$1;
(statearr_73533_73564[(2)] = inst_73494);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73519__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (9))){
var inst_73483 = (state_73519[(7)]);
var inst_73496 = (state_73519[(2)]);
var inst_73497 = (inst_73483 + (1));
var inst_73483__$1 = inst_73497;
var state_73519__$1 = (function (){var statearr_73534 = state_73519;
(statearr_73534[(7)] = inst_73483__$1);

(statearr_73534[(10)] = inst_73496);

return statearr_73534;
})();
var statearr_73535_73565 = state_73519__$1;
(statearr_73535_73565[(2)] = null);

(statearr_73535_73565[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (5))){
var inst_73503 = (state_73519[(2)]);
var state_73519__$1 = (function (){var statearr_73536 = state_73519;
(statearr_73536[(11)] = inst_73503);

return statearr_73536;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73519__$1,(12),dchan);
} else {
if((state_val_73520 === (14))){
var inst_73505 = (state_73519[(8)]);
var inst_73510 = cljs.core.apply.call(null,f,inst_73505);
var state_73519__$1 = state_73519;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73519__$1,(16),out,inst_73510);
} else {
if((state_val_73520 === (16))){
var inst_73512 = (state_73519[(2)]);
var state_73519__$1 = (function (){var statearr_73537 = state_73519;
(statearr_73537[(12)] = inst_73512);

return statearr_73537;
})();
var statearr_73538_73566 = state_73519__$1;
(statearr_73538_73566[(2)] = null);

(statearr_73538_73566[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (10))){
var inst_73487 = (state_73519[(2)]);
var inst_73488 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_73519__$1 = (function (){var statearr_73539 = state_73519;
(statearr_73539[(13)] = inst_73487);

return statearr_73539;
})();
var statearr_73540_73567 = state_73519__$1;
(statearr_73540_73567[(2)] = inst_73488);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73519__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73520 === (8))){
var inst_73501 = (state_73519[(2)]);
var state_73519__$1 = state_73519;
var statearr_73541_73568 = state_73519__$1;
(statearr_73541_73568[(2)] = inst_73501);

(statearr_73541_73568[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___73553,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__68742__auto__,c__68765__auto___73553,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_73545 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73545[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_73545[(1)] = (1));

return statearr_73545;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_73519){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73519);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e73546){if((e73546 instanceof Object)){
var ex__68746__auto__ = e73546;
var statearr_73547_73569 = state_73519;
(statearr_73547_73569[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73519);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73546;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73570 = state_73519;
state_73519 = G__73570;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_73519){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_73519);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___73553,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__68767__auto__ = (function (){var statearr_73548 = f__68766__auto__.call(null);
(statearr_73548[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___73553);

return statearr_73548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___73553,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args73572 = [];
var len__67420__auto___73630 = arguments.length;
var i__67421__auto___73631 = (0);
while(true){
if((i__67421__auto___73631 < len__67420__auto___73630)){
args73572.push((arguments[i__67421__auto___73631]));

var G__73632 = (i__67421__auto___73631 + (1));
i__67421__auto___73631 = G__73632;
continue;
} else {
}
break;
}

var G__73574 = args73572.length;
switch (G__73574) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73572.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__68765__auto___73634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___73634,out){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___73634,out){
return (function (state_73606){
var state_val_73607 = (state_73606[(1)]);
if((state_val_73607 === (7))){
var inst_73586 = (state_73606[(7)]);
var inst_73585 = (state_73606[(8)]);
var inst_73585__$1 = (state_73606[(2)]);
var inst_73586__$1 = cljs.core.nth.call(null,inst_73585__$1,(0),null);
var inst_73587 = cljs.core.nth.call(null,inst_73585__$1,(1),null);
var inst_73588 = (inst_73586__$1 == null);
var state_73606__$1 = (function (){var statearr_73608 = state_73606;
(statearr_73608[(9)] = inst_73587);

(statearr_73608[(7)] = inst_73586__$1);

(statearr_73608[(8)] = inst_73585__$1);

return statearr_73608;
})();
if(cljs.core.truth_(inst_73588)){
var statearr_73609_73635 = state_73606__$1;
(statearr_73609_73635[(1)] = (8));

} else {
var statearr_73610_73636 = state_73606__$1;
(statearr_73610_73636[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (1))){
var inst_73575 = cljs.core.vec.call(null,chs);
var inst_73576 = inst_73575;
var state_73606__$1 = (function (){var statearr_73611 = state_73606;
(statearr_73611[(10)] = inst_73576);

return statearr_73611;
})();
var statearr_73612_73637 = state_73606__$1;
(statearr_73612_73637[(2)] = null);

(statearr_73612_73637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (4))){
var inst_73576 = (state_73606[(10)]);
var state_73606__$1 = state_73606;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73606__$1,(7),inst_73576);
} else {
if((state_val_73607 === (6))){
var inst_73602 = (state_73606[(2)]);
var state_73606__$1 = state_73606;
var statearr_73613_73638 = state_73606__$1;
(statearr_73613_73638[(2)] = inst_73602);

(statearr_73613_73638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (3))){
var inst_73604 = (state_73606[(2)]);
var state_73606__$1 = state_73606;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73606__$1,inst_73604);
} else {
if((state_val_73607 === (2))){
var inst_73576 = (state_73606[(10)]);
var inst_73578 = cljs.core.count.call(null,inst_73576);
var inst_73579 = (inst_73578 > (0));
var state_73606__$1 = state_73606;
if(cljs.core.truth_(inst_73579)){
var statearr_73615_73639 = state_73606__$1;
(statearr_73615_73639[(1)] = (4));

} else {
var statearr_73616_73640 = state_73606__$1;
(statearr_73616_73640[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (11))){
var inst_73576 = (state_73606[(10)]);
var inst_73595 = (state_73606[(2)]);
var tmp73614 = inst_73576;
var inst_73576__$1 = tmp73614;
var state_73606__$1 = (function (){var statearr_73617 = state_73606;
(statearr_73617[(11)] = inst_73595);

(statearr_73617[(10)] = inst_73576__$1);

return statearr_73617;
})();
var statearr_73618_73641 = state_73606__$1;
(statearr_73618_73641[(2)] = null);

(statearr_73618_73641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (9))){
var inst_73586 = (state_73606[(7)]);
var state_73606__$1 = state_73606;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73606__$1,(11),out,inst_73586);
} else {
if((state_val_73607 === (5))){
var inst_73600 = cljs.core.async.close_BANG_.call(null,out);
var state_73606__$1 = state_73606;
var statearr_73619_73642 = state_73606__$1;
(statearr_73619_73642[(2)] = inst_73600);

(statearr_73619_73642[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (10))){
var inst_73598 = (state_73606[(2)]);
var state_73606__$1 = state_73606;
var statearr_73620_73643 = state_73606__$1;
(statearr_73620_73643[(2)] = inst_73598);

(statearr_73620_73643[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73607 === (8))){
var inst_73576 = (state_73606[(10)]);
var inst_73587 = (state_73606[(9)]);
var inst_73586 = (state_73606[(7)]);
var inst_73585 = (state_73606[(8)]);
var inst_73590 = (function (){var cs = inst_73576;
var vec__73581 = inst_73585;
var v = inst_73586;
var c = inst_73587;
return ((function (cs,vec__73581,v,c,inst_73576,inst_73587,inst_73586,inst_73585,state_val_73607,c__68765__auto___73634,out){
return (function (p1__73571_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__73571_SHARP_);
});
;})(cs,vec__73581,v,c,inst_73576,inst_73587,inst_73586,inst_73585,state_val_73607,c__68765__auto___73634,out))
})();
var inst_73591 = cljs.core.filterv.call(null,inst_73590,inst_73576);
var inst_73576__$1 = inst_73591;
var state_73606__$1 = (function (){var statearr_73621 = state_73606;
(statearr_73621[(10)] = inst_73576__$1);

return statearr_73621;
})();
var statearr_73622_73644 = state_73606__$1;
(statearr_73622_73644[(2)] = null);

(statearr_73622_73644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___73634,out))
;
return ((function (switch__68742__auto__,c__68765__auto___73634,out){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_73626 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73626[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_73626[(1)] = (1));

return statearr_73626;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_73606){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73606);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e73627){if((e73627 instanceof Object)){
var ex__68746__auto__ = e73627;
var statearr_73628_73645 = state_73606;
(statearr_73628_73645[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73606);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73646 = state_73606;
state_73606 = G__73646;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_73606){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_73606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___73634,out))
})();
var state__68767__auto__ = (function (){var statearr_73629 = f__68766__auto__.call(null);
(statearr_73629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___73634);

return statearr_73629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___73634,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args73647 = [];
var len__67420__auto___73696 = arguments.length;
var i__67421__auto___73697 = (0);
while(true){
if((i__67421__auto___73697 < len__67420__auto___73696)){
args73647.push((arguments[i__67421__auto___73697]));

var G__73698 = (i__67421__auto___73697 + (1));
i__67421__auto___73697 = G__73698;
continue;
} else {
}
break;
}

var G__73649 = args73647.length;
switch (G__73649) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73647.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__68765__auto___73700 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___73700,out){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___73700,out){
return (function (state_73673){
var state_val_73674 = (state_73673[(1)]);
if((state_val_73674 === (7))){
var inst_73655 = (state_73673[(7)]);
var inst_73655__$1 = (state_73673[(2)]);
var inst_73656 = (inst_73655__$1 == null);
var inst_73657 = cljs.core.not.call(null,inst_73656);
var state_73673__$1 = (function (){var statearr_73675 = state_73673;
(statearr_73675[(7)] = inst_73655__$1);

return statearr_73675;
})();
if(inst_73657){
var statearr_73676_73701 = state_73673__$1;
(statearr_73676_73701[(1)] = (8));

} else {
var statearr_73677_73702 = state_73673__$1;
(statearr_73677_73702[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (1))){
var inst_73650 = (0);
var state_73673__$1 = (function (){var statearr_73678 = state_73673;
(statearr_73678[(8)] = inst_73650);

return statearr_73678;
})();
var statearr_73679_73703 = state_73673__$1;
(statearr_73679_73703[(2)] = null);

(statearr_73679_73703[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (4))){
var state_73673__$1 = state_73673;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73673__$1,(7),ch);
} else {
if((state_val_73674 === (6))){
var inst_73668 = (state_73673[(2)]);
var state_73673__$1 = state_73673;
var statearr_73680_73704 = state_73673__$1;
(statearr_73680_73704[(2)] = inst_73668);

(statearr_73680_73704[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (3))){
var inst_73670 = (state_73673[(2)]);
var inst_73671 = cljs.core.async.close_BANG_.call(null,out);
var state_73673__$1 = (function (){var statearr_73681 = state_73673;
(statearr_73681[(9)] = inst_73670);

return statearr_73681;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73673__$1,inst_73671);
} else {
if((state_val_73674 === (2))){
var inst_73650 = (state_73673[(8)]);
var inst_73652 = (inst_73650 < n);
var state_73673__$1 = state_73673;
if(cljs.core.truth_(inst_73652)){
var statearr_73682_73705 = state_73673__$1;
(statearr_73682_73705[(1)] = (4));

} else {
var statearr_73683_73706 = state_73673__$1;
(statearr_73683_73706[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (11))){
var inst_73650 = (state_73673[(8)]);
var inst_73660 = (state_73673[(2)]);
var inst_73661 = (inst_73650 + (1));
var inst_73650__$1 = inst_73661;
var state_73673__$1 = (function (){var statearr_73684 = state_73673;
(statearr_73684[(10)] = inst_73660);

(statearr_73684[(8)] = inst_73650__$1);

return statearr_73684;
})();
var statearr_73685_73707 = state_73673__$1;
(statearr_73685_73707[(2)] = null);

(statearr_73685_73707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (9))){
var state_73673__$1 = state_73673;
var statearr_73686_73708 = state_73673__$1;
(statearr_73686_73708[(2)] = null);

(statearr_73686_73708[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (5))){
var state_73673__$1 = state_73673;
var statearr_73687_73709 = state_73673__$1;
(statearr_73687_73709[(2)] = null);

(statearr_73687_73709[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (10))){
var inst_73665 = (state_73673[(2)]);
var state_73673__$1 = state_73673;
var statearr_73688_73710 = state_73673__$1;
(statearr_73688_73710[(2)] = inst_73665);

(statearr_73688_73710[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73674 === (8))){
var inst_73655 = (state_73673[(7)]);
var state_73673__$1 = state_73673;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73673__$1,(11),out,inst_73655);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___73700,out))
;
return ((function (switch__68742__auto__,c__68765__auto___73700,out){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_73692 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73692[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_73692[(1)] = (1));

return statearr_73692;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_73673){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73673);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e73693){if((e73693 instanceof Object)){
var ex__68746__auto__ = e73693;
var statearr_73694_73711 = state_73673;
(statearr_73694_73711[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73673);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73693;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73712 = state_73673;
state_73673 = G__73712;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_73673){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_73673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___73700,out))
})();
var state__68767__auto__ = (function (){var statearr_73695 = f__68766__auto__.call(null);
(statearr_73695[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___73700);

return statearr_73695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___73700,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async73720 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73720 = (function (f,ch,meta73721){
this.f = f;
this.ch = ch;
this.meta73721 = meta73721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_73722,meta73721__$1){
var self__ = this;
var _73722__$1 = this;
return (new cljs.core.async.t_cljs$core$async73720(self__.f,self__.ch,meta73721__$1));
});

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_73722){
var self__ = this;
var _73722__$1 = this;
return self__.meta73721;
});

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async73723 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73723 = (function (f,ch,meta73721,_,fn1,meta73724){
this.f = f;
this.ch = ch;
this.meta73721 = meta73721;
this._ = _;
this.fn1 = fn1;
this.meta73724 = meta73724;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73723.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_73725,meta73724__$1){
var self__ = this;
var _73725__$1 = this;
return (new cljs.core.async.t_cljs$core$async73723(self__.f,self__.ch,self__.meta73721,self__._,self__.fn1,meta73724__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async73723.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_73725){
var self__ = this;
var _73725__$1 = this;
return self__.meta73724;
});})(___$1))
;

cljs.core.async.t_cljs$core$async73723.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73723.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async73723.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async73723.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__73713_SHARP_){
return f1.call(null,(((p1__73713_SHARP_ == null))?null:self__.f.call(null,p1__73713_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async73723.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73721","meta73721",-381345685,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async73720","cljs.core.async/t_cljs$core$async73720",-1202168011,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta73724","meta73724",-1310286732,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async73723.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73723.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73723";

cljs.core.async.t_cljs$core$async73723.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async73723");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async73723 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async73723(f__$1,ch__$1,meta73721__$1,___$2,fn1__$1,meta73724){
return (new cljs.core.async.t_cljs$core$async73723(f__$1,ch__$1,meta73721__$1,___$2,fn1__$1,meta73724));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async73723(self__.f,self__.ch,self__.meta73721,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__66187__auto__ = ret;
if(cljs.core.truth_(and__66187__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__66187__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73720.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async73720.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73721","meta73721",-381345685,null)], null);
});

cljs.core.async.t_cljs$core$async73720.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73720.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73720";

cljs.core.async.t_cljs$core$async73720.cljs$lang$ctorPrWriter = (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async73720");
});

cljs.core.async.__GT_t_cljs$core$async73720 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async73720(f__$1,ch__$1,meta73721){
return (new cljs.core.async.t_cljs$core$async73720(f__$1,ch__$1,meta73721));
});

}

return (new cljs.core.async.t_cljs$core$async73720(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async73729 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73729 = (function (f,ch,meta73730){
this.f = f;
this.ch = ch;
this.meta73730 = meta73730;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_73731,meta73730__$1){
var self__ = this;
var _73731__$1 = this;
return (new cljs.core.async.t_cljs$core$async73729(self__.f,self__.ch,meta73730__$1));
});

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_73731){
var self__ = this;
var _73731__$1 = this;
return self__.meta73730;
});

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73729.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async73729.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73730","meta73730",2092567155,null)], null);
});

cljs.core.async.t_cljs$core$async73729.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73729.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73729";

cljs.core.async.t_cljs$core$async73729.cljs$lang$ctorPrWriter = (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async73729");
});

cljs.core.async.__GT_t_cljs$core$async73729 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async73729(f__$1,ch__$1,meta73730){
return (new cljs.core.async.t_cljs$core$async73729(f__$1,ch__$1,meta73730));
});

}

return (new cljs.core.async.t_cljs$core$async73729(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async73735 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73735 = (function (p,ch,meta73736){
this.p = p;
this.ch = ch;
this.meta73736 = meta73736;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_73737,meta73736__$1){
var self__ = this;
var _73737__$1 = this;
return (new cljs.core.async.t_cljs$core$async73735(self__.p,self__.ch,meta73736__$1));
});

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_73737){
var self__ = this;
var _73737__$1 = this;
return self__.meta73736;
});

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73735.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async73735.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73736","meta73736",-1486005584,null)], null);
});

cljs.core.async.t_cljs$core$async73735.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73735.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73735";

cljs.core.async.t_cljs$core$async73735.cljs$lang$ctorPrWriter = (function (this__66856__auto__,writer__66857__auto__,opt__66858__auto__){
return cljs.core._write.call(null,writer__66857__auto__,"cljs.core.async/t_cljs$core$async73735");
});

cljs.core.async.__GT_t_cljs$core$async73735 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async73735(p__$1,ch__$1,meta73736){
return (new cljs.core.async.t_cljs$core$async73735(p__$1,ch__$1,meta73736));
});

}

return (new cljs.core.async.t_cljs$core$async73735(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args73738 = [];
var len__67420__auto___73782 = arguments.length;
var i__67421__auto___73783 = (0);
while(true){
if((i__67421__auto___73783 < len__67420__auto___73782)){
args73738.push((arguments[i__67421__auto___73783]));

var G__73784 = (i__67421__auto___73783 + (1));
i__67421__auto___73783 = G__73784;
continue;
} else {
}
break;
}

var G__73740 = args73738.length;
switch (G__73740) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73738.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__68765__auto___73786 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___73786,out){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___73786,out){
return (function (state_73761){
var state_val_73762 = (state_73761[(1)]);
if((state_val_73762 === (7))){
var inst_73757 = (state_73761[(2)]);
var state_73761__$1 = state_73761;
var statearr_73763_73787 = state_73761__$1;
(statearr_73763_73787[(2)] = inst_73757);

(statearr_73763_73787[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (1))){
var state_73761__$1 = state_73761;
var statearr_73764_73788 = state_73761__$1;
(statearr_73764_73788[(2)] = null);

(statearr_73764_73788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (4))){
var inst_73743 = (state_73761[(7)]);
var inst_73743__$1 = (state_73761[(2)]);
var inst_73744 = (inst_73743__$1 == null);
var state_73761__$1 = (function (){var statearr_73765 = state_73761;
(statearr_73765[(7)] = inst_73743__$1);

return statearr_73765;
})();
if(cljs.core.truth_(inst_73744)){
var statearr_73766_73789 = state_73761__$1;
(statearr_73766_73789[(1)] = (5));

} else {
var statearr_73767_73790 = state_73761__$1;
(statearr_73767_73790[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (6))){
var inst_73743 = (state_73761[(7)]);
var inst_73748 = p.call(null,inst_73743);
var state_73761__$1 = state_73761;
if(cljs.core.truth_(inst_73748)){
var statearr_73768_73791 = state_73761__$1;
(statearr_73768_73791[(1)] = (8));

} else {
var statearr_73769_73792 = state_73761__$1;
(statearr_73769_73792[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (3))){
var inst_73759 = (state_73761[(2)]);
var state_73761__$1 = state_73761;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73761__$1,inst_73759);
} else {
if((state_val_73762 === (2))){
var state_73761__$1 = state_73761;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73761__$1,(4),ch);
} else {
if((state_val_73762 === (11))){
var inst_73751 = (state_73761[(2)]);
var state_73761__$1 = state_73761;
var statearr_73770_73793 = state_73761__$1;
(statearr_73770_73793[(2)] = inst_73751);

(statearr_73770_73793[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (9))){
var state_73761__$1 = state_73761;
var statearr_73771_73794 = state_73761__$1;
(statearr_73771_73794[(2)] = null);

(statearr_73771_73794[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (5))){
var inst_73746 = cljs.core.async.close_BANG_.call(null,out);
var state_73761__$1 = state_73761;
var statearr_73772_73795 = state_73761__$1;
(statearr_73772_73795[(2)] = inst_73746);

(statearr_73772_73795[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (10))){
var inst_73754 = (state_73761[(2)]);
var state_73761__$1 = (function (){var statearr_73773 = state_73761;
(statearr_73773[(8)] = inst_73754);

return statearr_73773;
})();
var statearr_73774_73796 = state_73761__$1;
(statearr_73774_73796[(2)] = null);

(statearr_73774_73796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73762 === (8))){
var inst_73743 = (state_73761[(7)]);
var state_73761__$1 = state_73761;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73761__$1,(11),out,inst_73743);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___73786,out))
;
return ((function (switch__68742__auto__,c__68765__auto___73786,out){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_73778 = [null,null,null,null,null,null,null,null,null];
(statearr_73778[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_73778[(1)] = (1));

return statearr_73778;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_73761){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73761);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e73779){if((e73779 instanceof Object)){
var ex__68746__auto__ = e73779;
var statearr_73780_73797 = state_73761;
(statearr_73780_73797[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73761);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73779;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73798 = state_73761;
state_73761 = G__73798;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_73761){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_73761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___73786,out))
})();
var state__68767__auto__ = (function (){var statearr_73781 = f__68766__auto__.call(null);
(statearr_73781[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___73786);

return statearr_73781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___73786,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args73799 = [];
var len__67420__auto___73802 = arguments.length;
var i__67421__auto___73803 = (0);
while(true){
if((i__67421__auto___73803 < len__67420__auto___73802)){
args73799.push((arguments[i__67421__auto___73803]));

var G__73804 = (i__67421__auto___73803 + (1));
i__67421__auto___73803 = G__73804;
continue;
} else {
}
break;
}

var G__73801 = args73799.length;
switch (G__73801) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73799.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__68765__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto__){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto__){
return (function (state_73971){
var state_val_73972 = (state_73971[(1)]);
if((state_val_73972 === (7))){
var inst_73967 = (state_73971[(2)]);
var state_73971__$1 = state_73971;
var statearr_73973_74014 = state_73971__$1;
(statearr_73973_74014[(2)] = inst_73967);

(statearr_73973_74014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (20))){
var inst_73937 = (state_73971[(7)]);
var inst_73948 = (state_73971[(2)]);
var inst_73949 = cljs.core.next.call(null,inst_73937);
var inst_73923 = inst_73949;
var inst_73924 = null;
var inst_73925 = (0);
var inst_73926 = (0);
var state_73971__$1 = (function (){var statearr_73974 = state_73971;
(statearr_73974[(8)] = inst_73924);

(statearr_73974[(9)] = inst_73926);

(statearr_73974[(10)] = inst_73923);

(statearr_73974[(11)] = inst_73925);

(statearr_73974[(12)] = inst_73948);

return statearr_73974;
})();
var statearr_73975_74015 = state_73971__$1;
(statearr_73975_74015[(2)] = null);

(statearr_73975_74015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (1))){
var state_73971__$1 = state_73971;
var statearr_73976_74016 = state_73971__$1;
(statearr_73976_74016[(2)] = null);

(statearr_73976_74016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (4))){
var inst_73912 = (state_73971[(13)]);
var inst_73912__$1 = (state_73971[(2)]);
var inst_73913 = (inst_73912__$1 == null);
var state_73971__$1 = (function (){var statearr_73977 = state_73971;
(statearr_73977[(13)] = inst_73912__$1);

return statearr_73977;
})();
if(cljs.core.truth_(inst_73913)){
var statearr_73978_74017 = state_73971__$1;
(statearr_73978_74017[(1)] = (5));

} else {
var statearr_73979_74018 = state_73971__$1;
(statearr_73979_74018[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (15))){
var state_73971__$1 = state_73971;
var statearr_73983_74019 = state_73971__$1;
(statearr_73983_74019[(2)] = null);

(statearr_73983_74019[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (21))){
var state_73971__$1 = state_73971;
var statearr_73984_74020 = state_73971__$1;
(statearr_73984_74020[(2)] = null);

(statearr_73984_74020[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (13))){
var inst_73924 = (state_73971[(8)]);
var inst_73926 = (state_73971[(9)]);
var inst_73923 = (state_73971[(10)]);
var inst_73925 = (state_73971[(11)]);
var inst_73933 = (state_73971[(2)]);
var inst_73934 = (inst_73926 + (1));
var tmp73980 = inst_73924;
var tmp73981 = inst_73923;
var tmp73982 = inst_73925;
var inst_73923__$1 = tmp73981;
var inst_73924__$1 = tmp73980;
var inst_73925__$1 = tmp73982;
var inst_73926__$1 = inst_73934;
var state_73971__$1 = (function (){var statearr_73985 = state_73971;
(statearr_73985[(8)] = inst_73924__$1);

(statearr_73985[(9)] = inst_73926__$1);

(statearr_73985[(10)] = inst_73923__$1);

(statearr_73985[(14)] = inst_73933);

(statearr_73985[(11)] = inst_73925__$1);

return statearr_73985;
})();
var statearr_73986_74021 = state_73971__$1;
(statearr_73986_74021[(2)] = null);

(statearr_73986_74021[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (22))){
var state_73971__$1 = state_73971;
var statearr_73987_74022 = state_73971__$1;
(statearr_73987_74022[(2)] = null);

(statearr_73987_74022[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (6))){
var inst_73912 = (state_73971[(13)]);
var inst_73921 = f.call(null,inst_73912);
var inst_73922 = cljs.core.seq.call(null,inst_73921);
var inst_73923 = inst_73922;
var inst_73924 = null;
var inst_73925 = (0);
var inst_73926 = (0);
var state_73971__$1 = (function (){var statearr_73988 = state_73971;
(statearr_73988[(8)] = inst_73924);

(statearr_73988[(9)] = inst_73926);

(statearr_73988[(10)] = inst_73923);

(statearr_73988[(11)] = inst_73925);

return statearr_73988;
})();
var statearr_73989_74023 = state_73971__$1;
(statearr_73989_74023[(2)] = null);

(statearr_73989_74023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (17))){
var inst_73937 = (state_73971[(7)]);
var inst_73941 = cljs.core.chunk_first.call(null,inst_73937);
var inst_73942 = cljs.core.chunk_rest.call(null,inst_73937);
var inst_73943 = cljs.core.count.call(null,inst_73941);
var inst_73923 = inst_73942;
var inst_73924 = inst_73941;
var inst_73925 = inst_73943;
var inst_73926 = (0);
var state_73971__$1 = (function (){var statearr_73990 = state_73971;
(statearr_73990[(8)] = inst_73924);

(statearr_73990[(9)] = inst_73926);

(statearr_73990[(10)] = inst_73923);

(statearr_73990[(11)] = inst_73925);

return statearr_73990;
})();
var statearr_73991_74024 = state_73971__$1;
(statearr_73991_74024[(2)] = null);

(statearr_73991_74024[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (3))){
var inst_73969 = (state_73971[(2)]);
var state_73971__$1 = state_73971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73971__$1,inst_73969);
} else {
if((state_val_73972 === (12))){
var inst_73957 = (state_73971[(2)]);
var state_73971__$1 = state_73971;
var statearr_73992_74025 = state_73971__$1;
(statearr_73992_74025[(2)] = inst_73957);

(statearr_73992_74025[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (2))){
var state_73971__$1 = state_73971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73971__$1,(4),in$);
} else {
if((state_val_73972 === (23))){
var inst_73965 = (state_73971[(2)]);
var state_73971__$1 = state_73971;
var statearr_73993_74026 = state_73971__$1;
(statearr_73993_74026[(2)] = inst_73965);

(statearr_73993_74026[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (19))){
var inst_73952 = (state_73971[(2)]);
var state_73971__$1 = state_73971;
var statearr_73994_74027 = state_73971__$1;
(statearr_73994_74027[(2)] = inst_73952);

(statearr_73994_74027[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (11))){
var inst_73937 = (state_73971[(7)]);
var inst_73923 = (state_73971[(10)]);
var inst_73937__$1 = cljs.core.seq.call(null,inst_73923);
var state_73971__$1 = (function (){var statearr_73995 = state_73971;
(statearr_73995[(7)] = inst_73937__$1);

return statearr_73995;
})();
if(inst_73937__$1){
var statearr_73996_74028 = state_73971__$1;
(statearr_73996_74028[(1)] = (14));

} else {
var statearr_73997_74029 = state_73971__$1;
(statearr_73997_74029[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (9))){
var inst_73959 = (state_73971[(2)]);
var inst_73960 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_73971__$1 = (function (){var statearr_73998 = state_73971;
(statearr_73998[(15)] = inst_73959);

return statearr_73998;
})();
if(cljs.core.truth_(inst_73960)){
var statearr_73999_74030 = state_73971__$1;
(statearr_73999_74030[(1)] = (21));

} else {
var statearr_74000_74031 = state_73971__$1;
(statearr_74000_74031[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (5))){
var inst_73915 = cljs.core.async.close_BANG_.call(null,out);
var state_73971__$1 = state_73971;
var statearr_74001_74032 = state_73971__$1;
(statearr_74001_74032[(2)] = inst_73915);

(statearr_74001_74032[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (14))){
var inst_73937 = (state_73971[(7)]);
var inst_73939 = cljs.core.chunked_seq_QMARK_.call(null,inst_73937);
var state_73971__$1 = state_73971;
if(inst_73939){
var statearr_74002_74033 = state_73971__$1;
(statearr_74002_74033[(1)] = (17));

} else {
var statearr_74003_74034 = state_73971__$1;
(statearr_74003_74034[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (16))){
var inst_73955 = (state_73971[(2)]);
var state_73971__$1 = state_73971;
var statearr_74004_74035 = state_73971__$1;
(statearr_74004_74035[(2)] = inst_73955);

(statearr_74004_74035[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73972 === (10))){
var inst_73924 = (state_73971[(8)]);
var inst_73926 = (state_73971[(9)]);
var inst_73931 = cljs.core._nth.call(null,inst_73924,inst_73926);
var state_73971__$1 = state_73971;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73971__$1,(13),out,inst_73931);
} else {
if((state_val_73972 === (18))){
var inst_73937 = (state_73971[(7)]);
var inst_73946 = cljs.core.first.call(null,inst_73937);
var state_73971__$1 = state_73971;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73971__$1,(20),out,inst_73946);
} else {
if((state_val_73972 === (8))){
var inst_73926 = (state_73971[(9)]);
var inst_73925 = (state_73971[(11)]);
var inst_73928 = (inst_73926 < inst_73925);
var inst_73929 = inst_73928;
var state_73971__$1 = state_73971;
if(cljs.core.truth_(inst_73929)){
var statearr_74005_74036 = state_73971__$1;
(statearr_74005_74036[(1)] = (10));

} else {
var statearr_74006_74037 = state_73971__$1;
(statearr_74006_74037[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto__))
;
return ((function (switch__68742__auto__,c__68765__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__68743__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__68743__auto____0 = (function (){
var statearr_74010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74010[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__68743__auto__);

(statearr_74010[(1)] = (1));

return statearr_74010;
});
var cljs$core$async$mapcat_STAR__$_state_machine__68743__auto____1 = (function (state_73971){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_73971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e74011){if((e74011 instanceof Object)){
var ex__68746__auto__ = e74011;
var statearr_74012_74038 = state_73971;
(statearr_74012_74038[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73971);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e74011;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74039 = state_73971;
state_73971 = G__74039;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__68743__auto__ = function(state_73971){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__68743__auto____1.call(this,state_73971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__68743__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__68743__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto__))
})();
var state__68767__auto__ = (function (){var statearr_74013 = f__68766__auto__.call(null);
(statearr_74013[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto__);

return statearr_74013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto__))
);

return c__68765__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args74040 = [];
var len__67420__auto___74043 = arguments.length;
var i__67421__auto___74044 = (0);
while(true){
if((i__67421__auto___74044 < len__67420__auto___74043)){
args74040.push((arguments[i__67421__auto___74044]));

var G__74045 = (i__67421__auto___74044 + (1));
i__67421__auto___74044 = G__74045;
continue;
} else {
}
break;
}

var G__74042 = args74040.length;
switch (G__74042) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74040.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args74047 = [];
var len__67420__auto___74050 = arguments.length;
var i__67421__auto___74051 = (0);
while(true){
if((i__67421__auto___74051 < len__67420__auto___74050)){
args74047.push((arguments[i__67421__auto___74051]));

var G__74052 = (i__67421__auto___74051 + (1));
i__67421__auto___74051 = G__74052;
continue;
} else {
}
break;
}

var G__74049 = args74047.length;
switch (G__74049) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74047.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args74054 = [];
var len__67420__auto___74105 = arguments.length;
var i__67421__auto___74106 = (0);
while(true){
if((i__67421__auto___74106 < len__67420__auto___74105)){
args74054.push((arguments[i__67421__auto___74106]));

var G__74107 = (i__67421__auto___74106 + (1));
i__67421__auto___74106 = G__74107;
continue;
} else {
}
break;
}

var G__74056 = args74054.length;
switch (G__74056) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74054.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__68765__auto___74109 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___74109,out){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___74109,out){
return (function (state_74080){
var state_val_74081 = (state_74080[(1)]);
if((state_val_74081 === (7))){
var inst_74075 = (state_74080[(2)]);
var state_74080__$1 = state_74080;
var statearr_74082_74110 = state_74080__$1;
(statearr_74082_74110[(2)] = inst_74075);

(statearr_74082_74110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (1))){
var inst_74057 = null;
var state_74080__$1 = (function (){var statearr_74083 = state_74080;
(statearr_74083[(7)] = inst_74057);

return statearr_74083;
})();
var statearr_74084_74111 = state_74080__$1;
(statearr_74084_74111[(2)] = null);

(statearr_74084_74111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (4))){
var inst_74060 = (state_74080[(8)]);
var inst_74060__$1 = (state_74080[(2)]);
var inst_74061 = (inst_74060__$1 == null);
var inst_74062 = cljs.core.not.call(null,inst_74061);
var state_74080__$1 = (function (){var statearr_74085 = state_74080;
(statearr_74085[(8)] = inst_74060__$1);

return statearr_74085;
})();
if(inst_74062){
var statearr_74086_74112 = state_74080__$1;
(statearr_74086_74112[(1)] = (5));

} else {
var statearr_74087_74113 = state_74080__$1;
(statearr_74087_74113[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (6))){
var state_74080__$1 = state_74080;
var statearr_74088_74114 = state_74080__$1;
(statearr_74088_74114[(2)] = null);

(statearr_74088_74114[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (3))){
var inst_74077 = (state_74080[(2)]);
var inst_74078 = cljs.core.async.close_BANG_.call(null,out);
var state_74080__$1 = (function (){var statearr_74089 = state_74080;
(statearr_74089[(9)] = inst_74077);

return statearr_74089;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74080__$1,inst_74078);
} else {
if((state_val_74081 === (2))){
var state_74080__$1 = state_74080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74080__$1,(4),ch);
} else {
if((state_val_74081 === (11))){
var inst_74060 = (state_74080[(8)]);
var inst_74069 = (state_74080[(2)]);
var inst_74057 = inst_74060;
var state_74080__$1 = (function (){var statearr_74090 = state_74080;
(statearr_74090[(10)] = inst_74069);

(statearr_74090[(7)] = inst_74057);

return statearr_74090;
})();
var statearr_74091_74115 = state_74080__$1;
(statearr_74091_74115[(2)] = null);

(statearr_74091_74115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (9))){
var inst_74060 = (state_74080[(8)]);
var state_74080__$1 = state_74080;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_74080__$1,(11),out,inst_74060);
} else {
if((state_val_74081 === (5))){
var inst_74060 = (state_74080[(8)]);
var inst_74057 = (state_74080[(7)]);
var inst_74064 = cljs.core._EQ_.call(null,inst_74060,inst_74057);
var state_74080__$1 = state_74080;
if(inst_74064){
var statearr_74093_74116 = state_74080__$1;
(statearr_74093_74116[(1)] = (8));

} else {
var statearr_74094_74117 = state_74080__$1;
(statearr_74094_74117[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (10))){
var inst_74072 = (state_74080[(2)]);
var state_74080__$1 = state_74080;
var statearr_74095_74118 = state_74080__$1;
(statearr_74095_74118[(2)] = inst_74072);

(statearr_74095_74118[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74081 === (8))){
var inst_74057 = (state_74080[(7)]);
var tmp74092 = inst_74057;
var inst_74057__$1 = tmp74092;
var state_74080__$1 = (function (){var statearr_74096 = state_74080;
(statearr_74096[(7)] = inst_74057__$1);

return statearr_74096;
})();
var statearr_74097_74119 = state_74080__$1;
(statearr_74097_74119[(2)] = null);

(statearr_74097_74119[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___74109,out))
;
return ((function (switch__68742__auto__,c__68765__auto___74109,out){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_74101 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_74101[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_74101[(1)] = (1));

return statearr_74101;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_74080){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_74080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e74102){if((e74102 instanceof Object)){
var ex__68746__auto__ = e74102;
var statearr_74103_74120 = state_74080;
(statearr_74103_74120[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_74080);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e74102;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74121 = state_74080;
state_74080 = G__74121;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_74080){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_74080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___74109,out))
})();
var state__68767__auto__ = (function (){var statearr_74104 = f__68766__auto__.call(null);
(statearr_74104[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___74109);

return statearr_74104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___74109,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args74122 = [];
var len__67420__auto___74192 = arguments.length;
var i__67421__auto___74193 = (0);
while(true){
if((i__67421__auto___74193 < len__67420__auto___74192)){
args74122.push((arguments[i__67421__auto___74193]));

var G__74194 = (i__67421__auto___74193 + (1));
i__67421__auto___74193 = G__74194;
continue;
} else {
}
break;
}

var G__74124 = args74122.length;
switch (G__74124) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74122.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__68765__auto___74196 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___74196,out){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___74196,out){
return (function (state_74162){
var state_val_74163 = (state_74162[(1)]);
if((state_val_74163 === (7))){
var inst_74158 = (state_74162[(2)]);
var state_74162__$1 = state_74162;
var statearr_74164_74197 = state_74162__$1;
(statearr_74164_74197[(2)] = inst_74158);

(statearr_74164_74197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (1))){
var inst_74125 = (new Array(n));
var inst_74126 = inst_74125;
var inst_74127 = (0);
var state_74162__$1 = (function (){var statearr_74165 = state_74162;
(statearr_74165[(7)] = inst_74127);

(statearr_74165[(8)] = inst_74126);

return statearr_74165;
})();
var statearr_74166_74198 = state_74162__$1;
(statearr_74166_74198[(2)] = null);

(statearr_74166_74198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (4))){
var inst_74130 = (state_74162[(9)]);
var inst_74130__$1 = (state_74162[(2)]);
var inst_74131 = (inst_74130__$1 == null);
var inst_74132 = cljs.core.not.call(null,inst_74131);
var state_74162__$1 = (function (){var statearr_74167 = state_74162;
(statearr_74167[(9)] = inst_74130__$1);

return statearr_74167;
})();
if(inst_74132){
var statearr_74168_74199 = state_74162__$1;
(statearr_74168_74199[(1)] = (5));

} else {
var statearr_74169_74200 = state_74162__$1;
(statearr_74169_74200[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (15))){
var inst_74152 = (state_74162[(2)]);
var state_74162__$1 = state_74162;
var statearr_74170_74201 = state_74162__$1;
(statearr_74170_74201[(2)] = inst_74152);

(statearr_74170_74201[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (13))){
var state_74162__$1 = state_74162;
var statearr_74171_74202 = state_74162__$1;
(statearr_74171_74202[(2)] = null);

(statearr_74171_74202[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (6))){
var inst_74127 = (state_74162[(7)]);
var inst_74148 = (inst_74127 > (0));
var state_74162__$1 = state_74162;
if(cljs.core.truth_(inst_74148)){
var statearr_74172_74203 = state_74162__$1;
(statearr_74172_74203[(1)] = (12));

} else {
var statearr_74173_74204 = state_74162__$1;
(statearr_74173_74204[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (3))){
var inst_74160 = (state_74162[(2)]);
var state_74162__$1 = state_74162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74162__$1,inst_74160);
} else {
if((state_val_74163 === (12))){
var inst_74126 = (state_74162[(8)]);
var inst_74150 = cljs.core.vec.call(null,inst_74126);
var state_74162__$1 = state_74162;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_74162__$1,(15),out,inst_74150);
} else {
if((state_val_74163 === (2))){
var state_74162__$1 = state_74162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74162__$1,(4),ch);
} else {
if((state_val_74163 === (11))){
var inst_74142 = (state_74162[(2)]);
var inst_74143 = (new Array(n));
var inst_74126 = inst_74143;
var inst_74127 = (0);
var state_74162__$1 = (function (){var statearr_74174 = state_74162;
(statearr_74174[(10)] = inst_74142);

(statearr_74174[(7)] = inst_74127);

(statearr_74174[(8)] = inst_74126);

return statearr_74174;
})();
var statearr_74175_74205 = state_74162__$1;
(statearr_74175_74205[(2)] = null);

(statearr_74175_74205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (9))){
var inst_74126 = (state_74162[(8)]);
var inst_74140 = cljs.core.vec.call(null,inst_74126);
var state_74162__$1 = state_74162;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_74162__$1,(11),out,inst_74140);
} else {
if((state_val_74163 === (5))){
var inst_74127 = (state_74162[(7)]);
var inst_74130 = (state_74162[(9)]);
var inst_74126 = (state_74162[(8)]);
var inst_74135 = (state_74162[(11)]);
var inst_74134 = (inst_74126[inst_74127] = inst_74130);
var inst_74135__$1 = (inst_74127 + (1));
var inst_74136 = (inst_74135__$1 < n);
var state_74162__$1 = (function (){var statearr_74176 = state_74162;
(statearr_74176[(12)] = inst_74134);

(statearr_74176[(11)] = inst_74135__$1);

return statearr_74176;
})();
if(cljs.core.truth_(inst_74136)){
var statearr_74177_74206 = state_74162__$1;
(statearr_74177_74206[(1)] = (8));

} else {
var statearr_74178_74207 = state_74162__$1;
(statearr_74178_74207[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (14))){
var inst_74155 = (state_74162[(2)]);
var inst_74156 = cljs.core.async.close_BANG_.call(null,out);
var state_74162__$1 = (function (){var statearr_74180 = state_74162;
(statearr_74180[(13)] = inst_74155);

return statearr_74180;
})();
var statearr_74181_74208 = state_74162__$1;
(statearr_74181_74208[(2)] = inst_74156);

(statearr_74181_74208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (10))){
var inst_74146 = (state_74162[(2)]);
var state_74162__$1 = state_74162;
var statearr_74182_74209 = state_74162__$1;
(statearr_74182_74209[(2)] = inst_74146);

(statearr_74182_74209[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74163 === (8))){
var inst_74126 = (state_74162[(8)]);
var inst_74135 = (state_74162[(11)]);
var tmp74179 = inst_74126;
var inst_74126__$1 = tmp74179;
var inst_74127 = inst_74135;
var state_74162__$1 = (function (){var statearr_74183 = state_74162;
(statearr_74183[(7)] = inst_74127);

(statearr_74183[(8)] = inst_74126__$1);

return statearr_74183;
})();
var statearr_74184_74210 = state_74162__$1;
(statearr_74184_74210[(2)] = null);

(statearr_74184_74210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___74196,out))
;
return ((function (switch__68742__auto__,c__68765__auto___74196,out){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_74188 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74188[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_74188[(1)] = (1));

return statearr_74188;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_74162){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_74162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e74189){if((e74189 instanceof Object)){
var ex__68746__auto__ = e74189;
var statearr_74190_74211 = state_74162;
(statearr_74190_74211[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_74162);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e74189;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74212 = state_74162;
state_74162 = G__74212;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_74162){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_74162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___74196,out))
})();
var state__68767__auto__ = (function (){var statearr_74191 = f__68766__auto__.call(null);
(statearr_74191[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___74196);

return statearr_74191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___74196,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args74213 = [];
var len__67420__auto___74287 = arguments.length;
var i__67421__auto___74288 = (0);
while(true){
if((i__67421__auto___74288 < len__67420__auto___74287)){
args74213.push((arguments[i__67421__auto___74288]));

var G__74289 = (i__67421__auto___74288 + (1));
i__67421__auto___74288 = G__74289;
continue;
} else {
}
break;
}

var G__74215 = args74213.length;
switch (G__74215) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args74213.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__68765__auto___74291 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__68765__auto___74291,out){
return (function (){
var f__68766__auto__ = (function (){var switch__68742__auto__ = ((function (c__68765__auto___74291,out){
return (function (state_74257){
var state_val_74258 = (state_74257[(1)]);
if((state_val_74258 === (7))){
var inst_74253 = (state_74257[(2)]);
var state_74257__$1 = state_74257;
var statearr_74259_74292 = state_74257__$1;
(statearr_74259_74292[(2)] = inst_74253);

(statearr_74259_74292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (1))){
var inst_74216 = [];
var inst_74217 = inst_74216;
var inst_74218 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_74257__$1 = (function (){var statearr_74260 = state_74257;
(statearr_74260[(7)] = inst_74217);

(statearr_74260[(8)] = inst_74218);

return statearr_74260;
})();
var statearr_74261_74293 = state_74257__$1;
(statearr_74261_74293[(2)] = null);

(statearr_74261_74293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (4))){
var inst_74221 = (state_74257[(9)]);
var inst_74221__$1 = (state_74257[(2)]);
var inst_74222 = (inst_74221__$1 == null);
var inst_74223 = cljs.core.not.call(null,inst_74222);
var state_74257__$1 = (function (){var statearr_74262 = state_74257;
(statearr_74262[(9)] = inst_74221__$1);

return statearr_74262;
})();
if(inst_74223){
var statearr_74263_74294 = state_74257__$1;
(statearr_74263_74294[(1)] = (5));

} else {
var statearr_74264_74295 = state_74257__$1;
(statearr_74264_74295[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (15))){
var inst_74247 = (state_74257[(2)]);
var state_74257__$1 = state_74257;
var statearr_74265_74296 = state_74257__$1;
(statearr_74265_74296[(2)] = inst_74247);

(statearr_74265_74296[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (13))){
var state_74257__$1 = state_74257;
var statearr_74266_74297 = state_74257__$1;
(statearr_74266_74297[(2)] = null);

(statearr_74266_74297[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (6))){
var inst_74217 = (state_74257[(7)]);
var inst_74242 = inst_74217.length;
var inst_74243 = (inst_74242 > (0));
var state_74257__$1 = state_74257;
if(cljs.core.truth_(inst_74243)){
var statearr_74267_74298 = state_74257__$1;
(statearr_74267_74298[(1)] = (12));

} else {
var statearr_74268_74299 = state_74257__$1;
(statearr_74268_74299[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (3))){
var inst_74255 = (state_74257[(2)]);
var state_74257__$1 = state_74257;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_74257__$1,inst_74255);
} else {
if((state_val_74258 === (12))){
var inst_74217 = (state_74257[(7)]);
var inst_74245 = cljs.core.vec.call(null,inst_74217);
var state_74257__$1 = state_74257;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_74257__$1,(15),out,inst_74245);
} else {
if((state_val_74258 === (2))){
var state_74257__$1 = state_74257;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_74257__$1,(4),ch);
} else {
if((state_val_74258 === (11))){
var inst_74225 = (state_74257[(10)]);
var inst_74221 = (state_74257[(9)]);
var inst_74235 = (state_74257[(2)]);
var inst_74236 = [];
var inst_74237 = inst_74236.push(inst_74221);
var inst_74217 = inst_74236;
var inst_74218 = inst_74225;
var state_74257__$1 = (function (){var statearr_74269 = state_74257;
(statearr_74269[(7)] = inst_74217);

(statearr_74269[(11)] = inst_74235);

(statearr_74269[(8)] = inst_74218);

(statearr_74269[(12)] = inst_74237);

return statearr_74269;
})();
var statearr_74270_74300 = state_74257__$1;
(statearr_74270_74300[(2)] = null);

(statearr_74270_74300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (9))){
var inst_74217 = (state_74257[(7)]);
var inst_74233 = cljs.core.vec.call(null,inst_74217);
var state_74257__$1 = state_74257;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_74257__$1,(11),out,inst_74233);
} else {
if((state_val_74258 === (5))){
var inst_74225 = (state_74257[(10)]);
var inst_74221 = (state_74257[(9)]);
var inst_74218 = (state_74257[(8)]);
var inst_74225__$1 = f.call(null,inst_74221);
var inst_74226 = cljs.core._EQ_.call(null,inst_74225__$1,inst_74218);
var inst_74227 = cljs.core.keyword_identical_QMARK_.call(null,inst_74218,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_74228 = (inst_74226) || (inst_74227);
var state_74257__$1 = (function (){var statearr_74271 = state_74257;
(statearr_74271[(10)] = inst_74225__$1);

return statearr_74271;
})();
if(cljs.core.truth_(inst_74228)){
var statearr_74272_74301 = state_74257__$1;
(statearr_74272_74301[(1)] = (8));

} else {
var statearr_74273_74302 = state_74257__$1;
(statearr_74273_74302[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (14))){
var inst_74250 = (state_74257[(2)]);
var inst_74251 = cljs.core.async.close_BANG_.call(null,out);
var state_74257__$1 = (function (){var statearr_74275 = state_74257;
(statearr_74275[(13)] = inst_74250);

return statearr_74275;
})();
var statearr_74276_74303 = state_74257__$1;
(statearr_74276_74303[(2)] = inst_74251);

(statearr_74276_74303[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (10))){
var inst_74240 = (state_74257[(2)]);
var state_74257__$1 = state_74257;
var statearr_74277_74304 = state_74257__$1;
(statearr_74277_74304[(2)] = inst_74240);

(statearr_74277_74304[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_74258 === (8))){
var inst_74225 = (state_74257[(10)]);
var inst_74217 = (state_74257[(7)]);
var inst_74221 = (state_74257[(9)]);
var inst_74230 = inst_74217.push(inst_74221);
var tmp74274 = inst_74217;
var inst_74217__$1 = tmp74274;
var inst_74218 = inst_74225;
var state_74257__$1 = (function (){var statearr_74278 = state_74257;
(statearr_74278[(14)] = inst_74230);

(statearr_74278[(7)] = inst_74217__$1);

(statearr_74278[(8)] = inst_74218);

return statearr_74278;
})();
var statearr_74279_74305 = state_74257__$1;
(statearr_74279_74305[(2)] = null);

(statearr_74279_74305[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__68765__auto___74291,out))
;
return ((function (switch__68742__auto__,c__68765__auto___74291,out){
return (function() {
var cljs$core$async$state_machine__68743__auto__ = null;
var cljs$core$async$state_machine__68743__auto____0 = (function (){
var statearr_74283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74283[(0)] = cljs$core$async$state_machine__68743__auto__);

(statearr_74283[(1)] = (1));

return statearr_74283;
});
var cljs$core$async$state_machine__68743__auto____1 = (function (state_74257){
while(true){
var ret_value__68744__auto__ = (function (){try{while(true){
var result__68745__auto__ = switch__68742__auto__.call(null,state_74257);
if(cljs.core.keyword_identical_QMARK_.call(null,result__68745__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__68745__auto__;
}
break;
}
}catch (e74284){if((e74284 instanceof Object)){
var ex__68746__auto__ = e74284;
var statearr_74285_74306 = state_74257;
(statearr_74285_74306[(5)] = ex__68746__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_74257);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e74284;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__68744__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__74307 = state_74257;
state_74257 = G__74307;
continue;
} else {
return ret_value__68744__auto__;
}
break;
}
});
cljs$core$async$state_machine__68743__auto__ = function(state_74257){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__68743__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__68743__auto____1.call(this,state_74257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__68743__auto____0;
cljs$core$async$state_machine__68743__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__68743__auto____1;
return cljs$core$async$state_machine__68743__auto__;
})()
;})(switch__68742__auto__,c__68765__auto___74291,out))
})();
var state__68767__auto__ = (function (){var statearr_74286 = f__68766__auto__.call(null);
(statearr_74286[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__68765__auto___74291);

return statearr_74286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__68767__auto__);
});})(c__68765__auto___74291,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map