// Compiled by ClojureScript 1.9.494 {}
goog.provide('figwheel.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('goog.userAgent.product');
goog.require('goog.object');
goog.require('cljs.reader');
goog.require('cljs.core.async');
goog.require('figwheel.client.socket');
goog.require('figwheel.client.utils');
goog.require('figwheel.client.heads_up');
goog.require('figwheel.client.file_reloading');
goog.require('clojure.string');
goog.require('cljs.repl');
figwheel.client._figwheel_version_ = "0.5.9";
figwheel.client.figwheel_repl_print = (function figwheel$client$figwheel_repl_print(var_args){
var args89263 = [];
var len__67408__auto___89266 = arguments.length;
var i__67409__auto___89267 = (0);
while(true){
if((i__67409__auto___89267 < len__67408__auto___89266)){
args89263.push((arguments[i__67409__auto___89267]));

var G__89268 = (i__67409__auto___89267 + (1));
i__67409__auto___89267 = G__89268;
continue;
} else {
}
break;
}

var G__89265 = args89263.length;
switch (G__89265) {
case 2:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args89263.length)].join('')));

}
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$2 = (function (stream,args){
figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),"figwheel-repl-print",new cljs.core.Keyword(null,"content","content",15833224),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"stream","stream",1534941648),stream,new cljs.core.Keyword(null,"args","args",1315556576),args], null)], null));

return null;
});

figwheel.client.figwheel_repl_print.cljs$core$IFn$_invoke$arity$1 = (function (args){
return figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);
});

figwheel.client.figwheel_repl_print.cljs$lang$maxFixedArity = 2;

figwheel.client.console_out_print = (function figwheel$client$console_out_print(args){
return console.log.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.console_err_print = (function figwheel$client$console_err_print(args){
return console.error.apply(console,cljs.core.into_array.call(null,args));
});
figwheel.client.repl_out_print_fn = (function figwheel$client$repl_out_print_fn(var_args){
var args__67415__auto__ = [];
var len__67408__auto___89271 = arguments.length;
var i__67409__auto___89272 = (0);
while(true){
if((i__67409__auto___89272 < len__67408__auto___89271)){
args__67415__auto__.push((arguments[i__67409__auto___89272]));

var G__89273 = (i__67409__auto___89272 + (1));
i__67409__auto___89272 = G__89273;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((0) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__67416__auto__);
});

figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_out_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"out","out",-910545517),args);

return null;
});

figwheel.client.repl_out_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_out_print_fn.cljs$lang$applyTo = (function (seq89270){
return figwheel.client.repl_out_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq89270));
});

figwheel.client.repl_err_print_fn = (function figwheel$client$repl_err_print_fn(var_args){
var args__67415__auto__ = [];
var len__67408__auto___89275 = arguments.length;
var i__67409__auto___89276 = (0);
while(true){
if((i__67409__auto___89276 < len__67408__auto___89275)){
args__67415__auto__.push((arguments[i__67409__auto___89276]));

var G__89277 = (i__67409__auto___89276 + (1));
i__67409__auto___89276 = G__89277;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((0) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((0)),(0),null)):null);
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__67416__auto__);
});

figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic = (function (args){
figwheel.client.console_err_print.call(null,args);

figwheel.client.figwheel_repl_print.call(null,new cljs.core.Keyword(null,"err","err",-2089457205),args);

return null;
});

figwheel.client.repl_err_print_fn.cljs$lang$maxFixedArity = (0);

figwheel.client.repl_err_print_fn.cljs$lang$applyTo = (function (seq89274){
return figwheel.client.repl_err_print_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq89274));
});

figwheel.client.enable_repl_print_BANG_ = (function figwheel$client$enable_repl_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core.set_print_fn_BANG_.call(null,figwheel.client.repl_out_print_fn);

cljs.core.set_print_err_fn_BANG_.call(null,figwheel.client.repl_err_print_fn);

return null;
});
figwheel.client.autoload_QMARK_ = (function figwheel$client$autoload_QMARK_(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),true);
});
figwheel.client.toggle_autoload = (function figwheel$client$toggle_autoload(){
var res = figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),cljs.core.not.call(null,figwheel.client.autoload_QMARK_.call(null)));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Toggle autoload deprecated! Use (figwheel.client/set-autoload! false)")].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel autoloading "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.autoload_QMARK_.call(null))?"ON":"OFF"))].join(''));

return res;
});
goog.exportSymbol('figwheel.client.toggle_autoload', figwheel.client.toggle_autoload);
/**
 * Figwheel by default loads code changes as you work. Sometimes you
 *   just want to work on your code without the ramifications of
 *   autoloading and simply load your code piecemeal in the REPL. You can
 *   turn autoloading on and of with this method. 
 * 
 *   (figwheel.client/set-autoload false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_autoload = (function figwheel$client$set_autoload(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-autoload","figwheel-autoload",-2044741728),b);
});
goog.exportSymbol('figwheel.client.set_autoload', figwheel.client.set_autoload);
figwheel.client.repl_pprint = (function figwheel$client$repl_pprint(){
return figwheel.client.utils.persistent_config_get.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),true);
});
goog.exportSymbol('figwheel.client.repl_pprint', figwheel.client.repl_pprint);
/**
 * This method gives you the ability to turn the pretty printing of
 *   the REPL's return value on and off.
 *   
 *   (figwheel.client/set-repl-pprint false)
 * 
 *   NOTE: This is a persistent setting, meaning that it will persist
 *   through browser reloads.
 */
figwheel.client.set_repl_pprint = (function figwheel$client$set_repl_pprint(b){
if((b === true) || (b === false)){
} else {
throw (new Error("Assert failed: (or (true? b) (false? b))"));
}

return figwheel.client.utils.persistent_config_set_BANG_.call(null,new cljs.core.Keyword(null,"figwheel-repl-pprint","figwheel-repl-pprint",1076150873),b);
});
goog.exportSymbol('figwheel.client.set_repl_pprint', figwheel.client.set_repl_pprint);
figwheel.client.repl_result_pr_str = (function figwheel$client$repl_result_pr_str(v){
if(cljs.core.truth_(figwheel.client.repl_pprint.call(null))){
return figwheel.client.utils.pprint_to_string.call(null,v);
} else {
return cljs.core.pr_str.call(null,v);
}
});
goog.exportSymbol('figwheel.client.repl_result_pr_str', figwheel.client.repl_result_pr_str);
figwheel.client.get_essential_messages = (function figwheel$client$get_essential_messages(ed){
if(cljs.core.truth_(ed)){
return cljs.core.cons.call(null,cljs.core.select_keys.call(null,ed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"class","class",-2030961996)], null)),figwheel.client.get_essential_messages.call(null,new cljs.core.Keyword(null,"cause","cause",231901252).cljs$core$IFn$_invoke$arity$1(ed)));
} else {
return null;
}
});
figwheel.client.error_msg_format = (function figwheel$client$error_msg_format(p__89278){
var map__89281 = p__89278;
var map__89281__$1 = ((((!((map__89281 == null)))?((((map__89281.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89281.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89281):map__89281);
var message = cljs.core.get.call(null,map__89281__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var class$ = cljs.core.get.call(null,map__89281__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" : "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join('');
});
figwheel.client.format_messages = cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.map,figwheel.client.error_msg_format),figwheel.client.get_essential_messages);
figwheel.client.focus_msgs = (function figwheel$client$focus_msgs(name_set,msg_hist){
return cljs.core.cons.call(null,cljs.core.first.call(null,msg_hist),cljs.core.filter.call(null,cljs.core.comp.call(null,name_set,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863)),cljs.core.rest.call(null,msg_hist)));
});
figwheel.client.reload_file_QMARK__STAR_ = (function figwheel$client$reload_file_QMARK__STAR_(msg_name,opts){
var or__66187__auto__ = new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return cljs.core.not_EQ_.call(null,msg_name,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356));
}
});
figwheel.client.reload_file_state_QMARK_ = (function figwheel$client$reload_file_state_QMARK_(msg_names,opts){
var and__66175__auto__ = cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563));
if(and__66175__auto__){
return figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts);
} else {
return and__66175__auto__;
}
});
figwheel.client.block_reload_file_state_QMARK_ = (function figwheel$client$block_reload_file_state_QMARK_(msg_names,opts){
return (cljs.core._EQ_.call(null,cljs.core.first.call(null,msg_names),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))) && (cljs.core.not.call(null,figwheel.client.reload_file_QMARK__STAR_.call(null,cljs.core.second.call(null,msg_names),opts)));
});
figwheel.client.warning_append_state_QMARK_ = (function figwheel$client$warning_append_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.warning_state_QMARK_ = (function figwheel$client$warning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),cljs.core.first.call(null,msg_names));
});
figwheel.client.rewarning_state_QMARK_ = (function figwheel$client$rewarning_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356)], null),cljs.core.take.call(null,(3),msg_names));
});
figwheel.client.compile_fail_state_QMARK_ = (function figwheel$client$compile_fail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),cljs.core.first.call(null,msg_names));
});
figwheel.client.compile_refail_state_QMARK_ = (function figwheel$client$compile_refail_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289)], null),cljs.core.take.call(null,(2),msg_names));
});
figwheel.client.css_loaded_state_QMARK_ = (function figwheel$client$css_loaded_state_QMARK_(msg_names){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874),cljs.core.first.call(null,msg_names));
});
figwheel.client.file_reloader_plugin = (function figwheel$client$file_reloader_plugin(opts){
var ch = cljs.core.async.chan.call(null);
var c__70934__auto___89443 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___89443,ch){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___89443,ch){
return (function (state_89412){
var state_val_89413 = (state_89412[(1)]);
if((state_val_89413 === (7))){
var inst_89408 = (state_89412[(2)]);
var state_89412__$1 = state_89412;
var statearr_89414_89444 = state_89412__$1;
(statearr_89414_89444[(2)] = inst_89408);

(statearr_89414_89444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (1))){
var state_89412__$1 = state_89412;
var statearr_89415_89445 = state_89412__$1;
(statearr_89415_89445[(2)] = null);

(statearr_89415_89445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (4))){
var inst_89365 = (state_89412[(7)]);
var inst_89365__$1 = (state_89412[(2)]);
var state_89412__$1 = (function (){var statearr_89416 = state_89412;
(statearr_89416[(7)] = inst_89365__$1);

return statearr_89416;
})();
if(cljs.core.truth_(inst_89365__$1)){
var statearr_89417_89446 = state_89412__$1;
(statearr_89417_89446[(1)] = (5));

} else {
var statearr_89418_89447 = state_89412__$1;
(statearr_89418_89447[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (15))){
var inst_89372 = (state_89412[(8)]);
var inst_89387 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_89372);
var inst_89388 = cljs.core.first.call(null,inst_89387);
var inst_89389 = new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(inst_89388);
var inst_89390 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Not loading code with warnings - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_89389)].join('');
var inst_89391 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),inst_89390);
var state_89412__$1 = state_89412;
var statearr_89419_89448 = state_89412__$1;
(statearr_89419_89448[(2)] = inst_89391);

(statearr_89419_89448[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (13))){
var inst_89396 = (state_89412[(2)]);
var state_89412__$1 = state_89412;
var statearr_89420_89449 = state_89412__$1;
(statearr_89420_89449[(2)] = inst_89396);

(statearr_89420_89449[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (6))){
var state_89412__$1 = state_89412;
var statearr_89421_89450 = state_89412__$1;
(statearr_89421_89450[(2)] = null);

(statearr_89421_89450[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (17))){
var inst_89394 = (state_89412[(2)]);
var state_89412__$1 = state_89412;
var statearr_89422_89451 = state_89412__$1;
(statearr_89422_89451[(2)] = inst_89394);

(statearr_89422_89451[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (3))){
var inst_89410 = (state_89412[(2)]);
var state_89412__$1 = state_89412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89412__$1,inst_89410);
} else {
if((state_val_89413 === (12))){
var inst_89371 = (state_89412[(9)]);
var inst_89385 = figwheel.client.block_reload_file_state_QMARK_.call(null,inst_89371,opts);
var state_89412__$1 = state_89412;
if(cljs.core.truth_(inst_89385)){
var statearr_89423_89452 = state_89412__$1;
(statearr_89423_89452[(1)] = (15));

} else {
var statearr_89424_89453 = state_89412__$1;
(statearr_89424_89453[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (2))){
var state_89412__$1 = state_89412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89412__$1,(4),ch);
} else {
if((state_val_89413 === (11))){
var inst_89372 = (state_89412[(8)]);
var inst_89377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_89378 = figwheel.client.file_reloading.reload_js_files.call(null,opts,inst_89372);
var inst_89379 = cljs.core.async.timeout.call(null,(1000));
var inst_89380 = [inst_89378,inst_89379];
var inst_89381 = (new cljs.core.PersistentVector(null,2,(5),inst_89377,inst_89380,null));
var state_89412__$1 = state_89412;
return cljs.core.async.ioc_alts_BANG_.call(null,state_89412__$1,(14),inst_89381);
} else {
if((state_val_89413 === (9))){
var inst_89372 = (state_89412[(8)]);
var inst_89398 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),"Figwheel: code autoloading is OFF");
var inst_89399 = new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(inst_89372);
var inst_89400 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_89399);
var inst_89401 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Not loading: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_89400)].join('');
var inst_89402 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),inst_89401);
var state_89412__$1 = (function (){var statearr_89425 = state_89412;
(statearr_89425[(10)] = inst_89398);

return statearr_89425;
})();
var statearr_89426_89454 = state_89412__$1;
(statearr_89426_89454[(2)] = inst_89402);

(statearr_89426_89454[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (5))){
var inst_89365 = (state_89412[(7)]);
var inst_89367 = [new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null];
var inst_89368 = (new cljs.core.PersistentArrayMap(null,2,inst_89367,null));
var inst_89369 = (new cljs.core.PersistentHashSet(null,inst_89368,null));
var inst_89370 = figwheel.client.focus_msgs.call(null,inst_89369,inst_89365);
var inst_89371 = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),inst_89370);
var inst_89372 = cljs.core.first.call(null,inst_89370);
var inst_89373 = figwheel.client.autoload_QMARK_.call(null);
var state_89412__$1 = (function (){var statearr_89427 = state_89412;
(statearr_89427[(8)] = inst_89372);

(statearr_89427[(9)] = inst_89371);

return statearr_89427;
})();
if(cljs.core.truth_(inst_89373)){
var statearr_89428_89455 = state_89412__$1;
(statearr_89428_89455[(1)] = (8));

} else {
var statearr_89429_89456 = state_89412__$1;
(statearr_89429_89456[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (14))){
var inst_89383 = (state_89412[(2)]);
var state_89412__$1 = state_89412;
var statearr_89430_89457 = state_89412__$1;
(statearr_89430_89457[(2)] = inst_89383);

(statearr_89430_89457[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (16))){
var state_89412__$1 = state_89412;
var statearr_89431_89458 = state_89412__$1;
(statearr_89431_89458[(2)] = null);

(statearr_89431_89458[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (10))){
var inst_89404 = (state_89412[(2)]);
var state_89412__$1 = (function (){var statearr_89432 = state_89412;
(statearr_89432[(11)] = inst_89404);

return statearr_89432;
})();
var statearr_89433_89459 = state_89412__$1;
(statearr_89433_89459[(2)] = null);

(statearr_89433_89459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89413 === (8))){
var inst_89371 = (state_89412[(9)]);
var inst_89375 = figwheel.client.reload_file_state_QMARK_.call(null,inst_89371,opts);
var state_89412__$1 = state_89412;
if(cljs.core.truth_(inst_89375)){
var statearr_89434_89460 = state_89412__$1;
(statearr_89434_89460[(1)] = (11));

} else {
var statearr_89435_89461 = state_89412__$1;
(statearr_89435_89461[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___89443,ch))
;
return ((function (switch__70820__auto__,c__70934__auto___89443,ch){
return (function() {
var figwheel$client$file_reloader_plugin_$_state_machine__70821__auto__ = null;
var figwheel$client$file_reloader_plugin_$_state_machine__70821__auto____0 = (function (){
var statearr_89439 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_89439[(0)] = figwheel$client$file_reloader_plugin_$_state_machine__70821__auto__);

(statearr_89439[(1)] = (1));

return statearr_89439;
});
var figwheel$client$file_reloader_plugin_$_state_machine__70821__auto____1 = (function (state_89412){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_89412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e89440){if((e89440 instanceof Object)){
var ex__70824__auto__ = e89440;
var statearr_89441_89462 = state_89412;
(statearr_89441_89462[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89412);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89440;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89463 = state_89412;
state_89412 = G__89463;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$file_reloader_plugin_$_state_machine__70821__auto__ = function(state_89412){
switch(arguments.length){
case 0:
return figwheel$client$file_reloader_plugin_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$file_reloader_plugin_$_state_machine__70821__auto____1.call(this,state_89412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloader_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloader_plugin_$_state_machine__70821__auto____0;
figwheel$client$file_reloader_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloader_plugin_$_state_machine__70821__auto____1;
return figwheel$client$file_reloader_plugin_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___89443,ch))
})();
var state__70936__auto__ = (function (){var statearr_89442 = f__70935__auto__.call(null);
(statearr_89442[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___89443);

return statearr_89442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___89443,ch))
);


return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.truncate_stack_trace = (function figwheel$client$truncate_stack_trace(stack_str){
return cljs.core.take_while.call(null,(function (p1__89464_SHARP_){
return cljs.core.not.call(null,cljs.core.re_matches.call(null,/.*eval_javascript_STAR__STAR_.*/,p1__89464_SHARP_));
}),clojure.string.split_lines.call(null,stack_str));
});
figwheel.client.get_ua_product = (function figwheel$client$get_ua_product(){
if(cljs.core.truth_(figwheel.client.utils.node_env_QMARK_.call(null))){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.SAFARI)){
return new cljs.core.Keyword(null,"safari","safari",497115653);
} else {
if(cljs.core.truth_(goog.userAgent.product.CHROME)){
return new cljs.core.Keyword(null,"chrome","chrome",1718738387);
} else {
if(cljs.core.truth_(goog.userAgent.product.FIREFOX)){
return new cljs.core.Keyword(null,"firefox","firefox",1283768880);
} else {
if(cljs.core.truth_(goog.userAgent.product.IE)){
return new cljs.core.Keyword(null,"ie","ie",2038473780);
} else {
return null;
}
}
}
}
}
});
var base_path_89467 = figwheel.client.utils.base_url_path.call(null);
figwheel.client.eval_javascript_STAR__STAR_ = ((function (base_path_89467){
return (function figwheel$client$eval_javascript_STAR__STAR_(code,opts,result_handler){
try{figwheel.client.enable_repl_print_BANG_.call(null);

var result_value = figwheel.client.utils.eval_helper.call(null,code,opts);
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"success","success",1890645906),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),result_value], null));
}catch (e89466){if((e89466 instanceof Error)){
var e = e89466;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),clojure.string.join.call(null,"\n",figwheel.client.truncate_stack_trace.call(null,e.stack)),new cljs.core.Keyword(null,"base-path","base-path",495760020),base_path_89467], null));
} else {
var e = e89466;
return result_handler.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"exception","exception",-335277064),new cljs.core.Keyword(null,"ua-product","ua-product",938384227),figwheel.client.get_ua_product.call(null),new cljs.core.Keyword(null,"value","value",305978217),cljs.core.pr_str.call(null,e),new cljs.core.Keyword(null,"stacktrace","stacktrace",-95588394),"No stacktrace available."], null));

}
}finally {figwheel.client.enable_repl_print_BANG_.call(null);
}});})(base_path_89467))
;
/**
 * The REPL can disconnect and reconnect lets ensure cljs.user exists at least.
 */
figwheel.client.ensure_cljs_user = (function figwheel$client$ensure_cljs_user(){
if(cljs.core.truth_(cljs.user)){
return null;
} else {
return cljs.user = ({});
}
});
figwheel.client.repl_plugin = (function figwheel$client$repl_plugin(p__89468){
var map__89477 = p__89468;
var map__89477__$1 = ((((!((map__89477 == null)))?((((map__89477.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89477.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89477):map__89477);
var opts = map__89477__$1;
var build_id = cljs.core.get.call(null,map__89477__$1,new cljs.core.Keyword(null,"build-id","build-id",1642831089));
return ((function (map__89477,map__89477__$1,opts,build_id){
return (function (p__89479){
var vec__89480 = p__89479;
var seq__89481 = cljs.core.seq.call(null,vec__89480);
var first__89482 = cljs.core.first.call(null,seq__89481);
var seq__89481__$1 = cljs.core.next.call(null,seq__89481);
var map__89483 = first__89482;
var map__89483__$1 = ((((!((map__89483 == null)))?((((map__89483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89483.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89483):map__89483);
var msg = map__89483__$1;
var msg_name = cljs.core.get.call(null,map__89483__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__89481__$1;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"repl-eval","repl-eval",-1784727398),msg_name)){
figwheel.client.ensure_cljs_user.call(null);

return figwheel.client.eval_javascript_STAR__STAR_.call(null,new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(msg),opts,((function (vec__89480,seq__89481,first__89482,seq__89481__$1,map__89483,map__89483__$1,msg,msg_name,_,map__89477,map__89477__$1,opts,build_id){
return (function (res){
return figwheel.client.socket.send_BANG_.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"figwheel-event","figwheel-event",519570592),"callback",new cljs.core.Keyword(null,"callback-name","callback-name",336964714),new cljs.core.Keyword(null,"callback-name","callback-name",336964714).cljs$core$IFn$_invoke$arity$1(msg),new cljs.core.Keyword(null,"content","content",15833224),res], null));
});})(vec__89480,seq__89481,first__89482,seq__89481__$1,map__89483,map__89483__$1,msg,msg_name,_,map__89477,map__89477__$1,opts,build_id))
);
} else {
return null;
}
});
;})(map__89477,map__89477__$1,opts,build_id))
});
figwheel.client.css_reloader_plugin = (function figwheel$client$css_reloader_plugin(opts){
return (function (p__89491){
var vec__89492 = p__89491;
var seq__89493 = cljs.core.seq.call(null,vec__89492);
var first__89494 = cljs.core.first.call(null,seq__89493);
var seq__89493__$1 = cljs.core.next.call(null,seq__89493);
var map__89495 = first__89494;
var map__89495__$1 = ((((!((map__89495 == null)))?((((map__89495.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89495.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89495):map__89495);
var msg = map__89495__$1;
var msg_name = cljs.core.get.call(null,map__89495__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__89493__$1;
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"css-files-changed","css-files-changed",720773874))){
return figwheel.client.file_reloading.reload_css_files.call(null,opts,msg);
} else {
return null;
}
});
});
figwheel.client.compile_fail_warning_plugin = (function figwheel$client$compile_fail_warning_plugin(p__89497){
var map__89509 = p__89497;
var map__89509__$1 = ((((!((map__89509 == null)))?((((map__89509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89509.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89509):map__89509);
var on_compile_warning = cljs.core.get.call(null,map__89509__$1,new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947));
var on_compile_fail = cljs.core.get.call(null,map__89509__$1,new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036));
return ((function (map__89509,map__89509__$1,on_compile_warning,on_compile_fail){
return (function (p__89511){
var vec__89512 = p__89511;
var seq__89513 = cljs.core.seq.call(null,vec__89512);
var first__89514 = cljs.core.first.call(null,seq__89513);
var seq__89513__$1 = cljs.core.next.call(null,seq__89513);
var map__89515 = first__89514;
var map__89515__$1 = ((((!((map__89515 == null)))?((((map__89515.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89515.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89515):map__89515);
var msg = map__89515__$1;
var msg_name = cljs.core.get.call(null,map__89515__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
var _ = seq__89513__$1;
var pred__89517 = cljs.core._EQ_;
var expr__89518 = msg_name;
if(cljs.core.truth_(pred__89517.call(null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),expr__89518))){
return on_compile_warning.call(null,msg);
} else {
if(cljs.core.truth_(pred__89517.call(null,new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),expr__89518))){
return on_compile_fail.call(null,msg);
} else {
return null;
}
}
});
;})(map__89509,map__89509__$1,on_compile_warning,on_compile_fail))
});
figwheel.client.auto_jump_to_error = (function figwheel$client$auto_jump_to_error(opts,error){
if(cljs.core.truth_(new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920).cljs$core$IFn$_invoke$arity$1(opts))){
return figwheel.client.heads_up.auto_notify_source_file_line.call(null,error);
} else {
return null;
}
});
figwheel.client.heads_up_plugin_msg_handler = (function figwheel$client$heads_up_plugin_msg_handler(opts,msg_hist_SINGLEQUOTE_){
var msg_hist = figwheel.client.focus_msgs.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"compile-failed","compile-failed",-477639289),null,new cljs.core.Keyword(null,"compile-warning","compile-warning",43425356),null,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563),null], null), null),msg_hist_SINGLEQUOTE_);
var msg_names = cljs.core.map.call(null,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863),msg_hist);
var msg = cljs.core.first.call(null,msg_hist);
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,msg_hist,msg_names,msg){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,msg_hist,msg_names,msg){
return (function (state_89746){
var state_val_89747 = (state_89746[(1)]);
if((state_val_89747 === (7))){
var inst_89666 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89666)){
var statearr_89748_89798 = state_89746__$1;
(statearr_89748_89798[(1)] = (8));

} else {
var statearr_89749_89799 = state_89746__$1;
(statearr_89749_89799[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (20))){
var inst_89740 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89750_89800 = state_89746__$1;
(statearr_89750_89800[(2)] = inst_89740);

(statearr_89750_89800[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (27))){
var inst_89736 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89751_89801 = state_89746__$1;
(statearr_89751_89801[(2)] = inst_89736);

(statearr_89751_89801[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (1))){
var inst_89659 = figwheel.client.reload_file_state_QMARK_.call(null,msg_names,opts);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89659)){
var statearr_89752_89802 = state_89746__$1;
(statearr_89752_89802[(1)] = (2));

} else {
var statearr_89753_89803 = state_89746__$1;
(statearr_89753_89803[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (24))){
var inst_89738 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89754_89804 = state_89746__$1;
(statearr_89754_89804[(2)] = inst_89738);

(statearr_89754_89804[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (4))){
var inst_89744 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89746__$1,inst_89744);
} else {
if((state_val_89747 === (15))){
var inst_89742 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89755_89805 = state_89746__$1;
(statearr_89755_89805[(2)] = inst_89742);

(statearr_89755_89805[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (21))){
var inst_89695 = (state_89746[(2)]);
var inst_89696 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89697 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89696);
var state_89746__$1 = (function (){var statearr_89756 = state_89746;
(statearr_89756[(7)] = inst_89695);

return statearr_89756;
})();
var statearr_89757_89806 = state_89746__$1;
(statearr_89757_89806[(2)] = inst_89697);

(statearr_89757_89806[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (31))){
var inst_89725 = figwheel.client.css_loaded_state_QMARK_.call(null,msg_names);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89725)){
var statearr_89758_89807 = state_89746__$1;
(statearr_89758_89807[(1)] = (34));

} else {
var statearr_89759_89808 = state_89746__$1;
(statearr_89759_89808[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (32))){
var inst_89734 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89760_89809 = state_89746__$1;
(statearr_89760_89809[(2)] = inst_89734);

(statearr_89760_89809[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (33))){
var inst_89721 = (state_89746[(2)]);
var inst_89722 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89723 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89722);
var state_89746__$1 = (function (){var statearr_89761 = state_89746;
(statearr_89761[(8)] = inst_89721);

return statearr_89761;
})();
var statearr_89762_89810 = state_89746__$1;
(statearr_89762_89810[(2)] = inst_89723);

(statearr_89762_89810[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (13))){
var inst_89680 = figwheel.client.heads_up.clear.call(null);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(16),inst_89680);
} else {
if((state_val_89747 === (22))){
var inst_89701 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89702 = figwheel.client.heads_up.append_warning_message.call(null,inst_89701);
var state_89746__$1 = state_89746;
var statearr_89763_89811 = state_89746__$1;
(statearr_89763_89811[(2)] = inst_89702);

(statearr_89763_89811[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (36))){
var inst_89732 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89764_89812 = state_89746__$1;
(statearr_89764_89812[(2)] = inst_89732);

(statearr_89764_89812[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (29))){
var inst_89712 = (state_89746[(2)]);
var inst_89713 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89714 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89713);
var state_89746__$1 = (function (){var statearr_89765 = state_89746;
(statearr_89765[(9)] = inst_89712);

return statearr_89765;
})();
var statearr_89766_89813 = state_89746__$1;
(statearr_89766_89813[(2)] = inst_89714);

(statearr_89766_89813[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (6))){
var inst_89661 = (state_89746[(10)]);
var state_89746__$1 = state_89746;
var statearr_89767_89814 = state_89746__$1;
(statearr_89767_89814[(2)] = inst_89661);

(statearr_89767_89814[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (28))){
var inst_89708 = (state_89746[(2)]);
var inst_89709 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89710 = figwheel.client.heads_up.display_warning.call(null,inst_89709);
var state_89746__$1 = (function (){var statearr_89768 = state_89746;
(statearr_89768[(11)] = inst_89708);

return statearr_89768;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(29),inst_89710);
} else {
if((state_val_89747 === (25))){
var inst_89706 = figwheel.client.heads_up.clear.call(null);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(28),inst_89706);
} else {
if((state_val_89747 === (34))){
var inst_89727 = figwheel.client.heads_up.flash_loaded.call(null);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(37),inst_89727);
} else {
if((state_val_89747 === (17))){
var inst_89686 = (state_89746[(2)]);
var inst_89687 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89688 = figwheel.client.auto_jump_to_error.call(null,opts,inst_89687);
var state_89746__$1 = (function (){var statearr_89769 = state_89746;
(statearr_89769[(12)] = inst_89686);

return statearr_89769;
})();
var statearr_89770_89815 = state_89746__$1;
(statearr_89770_89815[(2)] = inst_89688);

(statearr_89770_89815[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (3))){
var inst_89678 = figwheel.client.compile_refail_state_QMARK_.call(null,msg_names);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89678)){
var statearr_89771_89816 = state_89746__$1;
(statearr_89771_89816[(1)] = (13));

} else {
var statearr_89772_89817 = state_89746__$1;
(statearr_89772_89817[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (12))){
var inst_89674 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89773_89818 = state_89746__$1;
(statearr_89773_89818[(2)] = inst_89674);

(statearr_89773_89818[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (2))){
var inst_89661 = (state_89746[(10)]);
var inst_89661__$1 = figwheel.client.autoload_QMARK_.call(null);
var state_89746__$1 = (function (){var statearr_89774 = state_89746;
(statearr_89774[(10)] = inst_89661__$1);

return statearr_89774;
})();
if(cljs.core.truth_(inst_89661__$1)){
var statearr_89775_89819 = state_89746__$1;
(statearr_89775_89819[(1)] = (5));

} else {
var statearr_89776_89820 = state_89746__$1;
(statearr_89776_89820[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (23))){
var inst_89704 = figwheel.client.rewarning_state_QMARK_.call(null,msg_names);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89704)){
var statearr_89777_89821 = state_89746__$1;
(statearr_89777_89821[(1)] = (25));

} else {
var statearr_89778_89822 = state_89746__$1;
(statearr_89778_89822[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (35))){
var state_89746__$1 = state_89746;
var statearr_89779_89823 = state_89746__$1;
(statearr_89779_89823[(2)] = null);

(statearr_89779_89823[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (19))){
var inst_89699 = figwheel.client.warning_append_state_QMARK_.call(null,msg_names);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89699)){
var statearr_89780_89824 = state_89746__$1;
(statearr_89780_89824[(1)] = (22));

} else {
var statearr_89781_89825 = state_89746__$1;
(statearr_89781_89825[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (11))){
var inst_89670 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89782_89826 = state_89746__$1;
(statearr_89782_89826[(2)] = inst_89670);

(statearr_89782_89826[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (9))){
var inst_89672 = figwheel.client.heads_up.clear.call(null);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(12),inst_89672);
} else {
if((state_val_89747 === (5))){
var inst_89663 = new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(opts);
var state_89746__$1 = state_89746;
var statearr_89783_89827 = state_89746__$1;
(statearr_89783_89827[(2)] = inst_89663);

(statearr_89783_89827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (14))){
var inst_89690 = figwheel.client.compile_fail_state_QMARK_.call(null,msg_names);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89690)){
var statearr_89784_89828 = state_89746__$1;
(statearr_89784_89828[(1)] = (18));

} else {
var statearr_89785_89829 = state_89746__$1;
(statearr_89785_89829[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (26))){
var inst_89716 = figwheel.client.warning_state_QMARK_.call(null,msg_names);
var state_89746__$1 = state_89746;
if(cljs.core.truth_(inst_89716)){
var statearr_89786_89830 = state_89746__$1;
(statearr_89786_89830[(1)] = (30));

} else {
var statearr_89787_89831 = state_89746__$1;
(statearr_89787_89831[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (16))){
var inst_89682 = (state_89746[(2)]);
var inst_89683 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89684 = figwheel.client.heads_up.display_exception.call(null,inst_89683);
var state_89746__$1 = (function (){var statearr_89788 = state_89746;
(statearr_89788[(13)] = inst_89682);

return statearr_89788;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(17),inst_89684);
} else {
if((state_val_89747 === (30))){
var inst_89718 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89719 = figwheel.client.heads_up.display_warning.call(null,inst_89718);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(33),inst_89719);
} else {
if((state_val_89747 === (10))){
var inst_89676 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89789_89832 = state_89746__$1;
(statearr_89789_89832[(2)] = inst_89676);

(statearr_89789_89832[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (18))){
var inst_89692 = new cljs.core.Keyword(null,"exception-data","exception-data",-512474886).cljs$core$IFn$_invoke$arity$1(msg);
var inst_89693 = figwheel.client.heads_up.display_exception.call(null,inst_89692);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(21),inst_89693);
} else {
if((state_val_89747 === (37))){
var inst_89729 = (state_89746[(2)]);
var state_89746__$1 = state_89746;
var statearr_89790_89833 = state_89746__$1;
(statearr_89790_89833[(2)] = inst_89729);

(statearr_89790_89833[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89747 === (8))){
var inst_89668 = figwheel.client.heads_up.flash_loaded.call(null);
var state_89746__$1 = state_89746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89746__$1,(11),inst_89668);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__,msg_hist,msg_names,msg))
;
return ((function (switch__70820__auto__,c__70934__auto__,msg_hist,msg_names,msg){
return (function() {
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto__ = null;
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto____0 = (function (){
var statearr_89794 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_89794[(0)] = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto__);

(statearr_89794[(1)] = (1));

return statearr_89794;
});
var figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto____1 = (function (state_89746){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_89746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e89795){if((e89795 instanceof Object)){
var ex__70824__auto__ = e89795;
var statearr_89796_89834 = state_89746;
(statearr_89796_89834[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89746);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89795;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89835 = state_89746;
state_89746 = G__89835;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto__ = function(state_89746){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto____1.call(this,state_89746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto____0;
figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto____1;
return figwheel$client$heads_up_plugin_msg_handler_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,msg_hist,msg_names,msg))
})();
var state__70936__auto__ = (function (){var statearr_89797 = f__70935__auto__.call(null);
(statearr_89797[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_89797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,msg_hist,msg_names,msg))
);

return c__70934__auto__;
});
figwheel.client.heads_up_plugin = (function figwheel$client$heads_up_plugin(opts){
var ch = cljs.core.async.chan.call(null);
figwheel.client.heads_up_config_options_STAR__STAR_ = opts;

var c__70934__auto___89898 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___89898,ch){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___89898,ch){
return (function (state_89881){
var state_val_89882 = (state_89881[(1)]);
if((state_val_89882 === (1))){
var state_89881__$1 = state_89881;
var statearr_89883_89899 = state_89881__$1;
(statearr_89883_89899[(2)] = null);

(statearr_89883_89899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89882 === (2))){
var state_89881__$1 = state_89881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89881__$1,(4),ch);
} else {
if((state_val_89882 === (3))){
var inst_89879 = (state_89881[(2)]);
var state_89881__$1 = state_89881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89881__$1,inst_89879);
} else {
if((state_val_89882 === (4))){
var inst_89869 = (state_89881[(7)]);
var inst_89869__$1 = (state_89881[(2)]);
var state_89881__$1 = (function (){var statearr_89884 = state_89881;
(statearr_89884[(7)] = inst_89869__$1);

return statearr_89884;
})();
if(cljs.core.truth_(inst_89869__$1)){
var statearr_89885_89900 = state_89881__$1;
(statearr_89885_89900[(1)] = (5));

} else {
var statearr_89886_89901 = state_89881__$1;
(statearr_89886_89901[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89882 === (5))){
var inst_89869 = (state_89881[(7)]);
var inst_89871 = figwheel.client.heads_up_plugin_msg_handler.call(null,opts,inst_89869);
var state_89881__$1 = state_89881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89881__$1,(8),inst_89871);
} else {
if((state_val_89882 === (6))){
var state_89881__$1 = state_89881;
var statearr_89887_89902 = state_89881__$1;
(statearr_89887_89902[(2)] = null);

(statearr_89887_89902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89882 === (7))){
var inst_89877 = (state_89881[(2)]);
var state_89881__$1 = state_89881;
var statearr_89888_89903 = state_89881__$1;
(statearr_89888_89903[(2)] = inst_89877);

(statearr_89888_89903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_89882 === (8))){
var inst_89873 = (state_89881[(2)]);
var state_89881__$1 = (function (){var statearr_89889 = state_89881;
(statearr_89889[(8)] = inst_89873);

return statearr_89889;
})();
var statearr_89890_89904 = state_89881__$1;
(statearr_89890_89904[(2)] = null);

(statearr_89890_89904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__70934__auto___89898,ch))
;
return ((function (switch__70820__auto__,c__70934__auto___89898,ch){
return (function() {
var figwheel$client$heads_up_plugin_$_state_machine__70821__auto__ = null;
var figwheel$client$heads_up_plugin_$_state_machine__70821__auto____0 = (function (){
var statearr_89894 = [null,null,null,null,null,null,null,null,null];
(statearr_89894[(0)] = figwheel$client$heads_up_plugin_$_state_machine__70821__auto__);

(statearr_89894[(1)] = (1));

return statearr_89894;
});
var figwheel$client$heads_up_plugin_$_state_machine__70821__auto____1 = (function (state_89881){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_89881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e89895){if((e89895 instanceof Object)){
var ex__70824__auto__ = e89895;
var statearr_89896_89905 = state_89881;
(statearr_89896_89905[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89881);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89895;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89906 = state_89881;
state_89881 = G__89906;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$heads_up_plugin_$_state_machine__70821__auto__ = function(state_89881){
switch(arguments.length){
case 0:
return figwheel$client$heads_up_plugin_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$heads_up_plugin_$_state_machine__70821__auto____1.call(this,state_89881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$heads_up_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$heads_up_plugin_$_state_machine__70821__auto____0;
figwheel$client$heads_up_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$heads_up_plugin_$_state_machine__70821__auto____1;
return figwheel$client$heads_up_plugin_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___89898,ch))
})();
var state__70936__auto__ = (function (){var statearr_89897 = f__70935__auto__.call(null);
(statearr_89897[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___89898);

return statearr_89897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___89898,ch))
);


figwheel.client.heads_up.ensure_container.call(null);

return ((function (ch){
return (function (msg_hist){
cljs.core.async.put_BANG_.call(null,ch,msg_hist);

return msg_hist;
});
;})(ch))
});
figwheel.client.enforce_project_plugin = (function figwheel$client$enforce_project_plugin(opts){
return (function (msg_hist){
if(((1) < cljs.core.count.call(null,cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"project-id","project-id",206449307),cljs.core.take.call(null,(5),msg_hist)))))){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different project. Shutting socket down.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_89927){
var state_val_89928 = (state_89927[(1)]);
if((state_val_89928 === (1))){
var inst_89922 = cljs.core.async.timeout.call(null,(3000));
var state_89927__$1 = state_89927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89927__$1,(2),inst_89922);
} else {
if((state_val_89928 === (2))){
var inst_89924 = (state_89927[(2)]);
var inst_89925 = figwheel.client.heads_up.display_system_warning.call(null,"Connection from different project","Shutting connection down!!!!!");
var state_89927__$1 = (function (){var statearr_89929 = state_89927;
(statearr_89929[(7)] = inst_89924);

return statearr_89929;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89927__$1,inst_89925);
} else {
return null;
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var figwheel$client$enforce_project_plugin_$_state_machine__70821__auto__ = null;
var figwheel$client$enforce_project_plugin_$_state_machine__70821__auto____0 = (function (){
var statearr_89933 = [null,null,null,null,null,null,null,null];
(statearr_89933[(0)] = figwheel$client$enforce_project_plugin_$_state_machine__70821__auto__);

(statearr_89933[(1)] = (1));

return statearr_89933;
});
var figwheel$client$enforce_project_plugin_$_state_machine__70821__auto____1 = (function (state_89927){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_89927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e89934){if((e89934 instanceof Object)){
var ex__70824__auto__ = e89934;
var statearr_89935_89937 = state_89927;
(statearr_89935_89937[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89927);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89934;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89938 = state_89927;
state_89927 = G__89938;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$enforce_project_plugin_$_state_machine__70821__auto__ = function(state_89927){
switch(arguments.length){
case 0:
return figwheel$client$enforce_project_plugin_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$enforce_project_plugin_$_state_machine__70821__auto____1.call(this,state_89927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_project_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_project_plugin_$_state_machine__70821__auto____0;
figwheel$client$enforce_project_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_project_plugin_$_state_machine__70821__auto____1;
return figwheel$client$enforce_project_plugin_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_89936 = f__70935__auto__.call(null);
(statearr_89936[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_89936;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.enforce_figwheel_version_plugin = (function figwheel$client$enforce_figwheel_version_plugin(opts){
return (function (msg_hist){
var temp__6753__auto__ = new cljs.core.Keyword(null,"figwheel-version","figwheel-version",1409553832).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,msg_hist));
if(cljs.core.truth_(temp__6753__auto__)){
var figwheel_version = temp__6753__auto__;
if(cljs.core.not_EQ_.call(null,figwheel_version,figwheel.client._figwheel_version_)){
figwheel.client.socket.close_BANG_.call(null);

console.error("Figwheel: message received from different version of Figwheel.");

if(cljs.core.truth_(new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(opts))){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,figwheel_version,temp__6753__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,figwheel_version,temp__6753__auto__){
return (function (state_89961){
var state_val_89962 = (state_89961[(1)]);
if((state_val_89962 === (1))){
var inst_89955 = cljs.core.async.timeout.call(null,(2000));
var state_89961__$1 = state_89961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_89961__$1,(2),inst_89955);
} else {
if((state_val_89962 === (2))){
var inst_89957 = (state_89961[(2)]);
var inst_89958 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Client Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client._figwheel_version_),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong> is not equal to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel Sidecar Version <strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel_version),cljs.core.str.cljs$core$IFn$_invoke$arity$1("</strong>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".  Shutting down Websocket Connection!"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<h4>To fix try:</h4>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<ol><li>Reload this page and make sure you are not getting a cached version of the client.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>You may have to clean (delete compiled assets) and rebuild to make sure that the new client code is being used.</li>"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("<li>Also, make sure you have consistent Figwheel dependencies.</li></ol>")].join('');
var inst_89959 = figwheel.client.heads_up.display_system_warning.call(null,"Figwheel Client and Server have different versions!!",inst_89958);
var state_89961__$1 = (function (){var statearr_89963 = state_89961;
(statearr_89963[(7)] = inst_89957);

return statearr_89963;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_89961__$1,inst_89959);
} else {
return null;
}
}
});})(c__70934__auto__,figwheel_version,temp__6753__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__,figwheel_version,temp__6753__auto__){
return (function() {
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto__ = null;
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto____0 = (function (){
var statearr_89967 = [null,null,null,null,null,null,null,null];
(statearr_89967[(0)] = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto__);

(statearr_89967[(1)] = (1));

return statearr_89967;
});
var figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto____1 = (function (state_89961){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_89961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e89968){if((e89968 instanceof Object)){
var ex__70824__auto__ = e89968;
var statearr_89969_89971 = state_89961;
(statearr_89969_89971[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_89961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e89968;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__89972 = state_89961;
state_89961 = G__89972;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto__ = function(state_89961){
switch(arguments.length){
case 0:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto____0.call(this);
case 1:
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto____1.call(this,state_89961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto____0;
figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto____1;
return figwheel$client$enforce_figwheel_version_plugin_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,figwheel_version,temp__6753__auto__))
})();
var state__70936__auto__ = (function (){var statearr_89970 = f__70935__auto__.call(null);
(statearr_89970[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_89970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,figwheel_version,temp__6753__auto__))
);

return c__70934__auto__;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});
});
figwheel.client.default_on_jsload = cljs.core.identity;
figwheel.client.file_line_column = (function figwheel$client$file_line_column(p__89973){
var map__89977 = p__89973;
var map__89977__$1 = ((((!((map__89977 == null)))?((((map__89977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89977.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89977):map__89977);
var file = cljs.core.get.call(null,map__89977__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var line = cljs.core.get.call(null,map__89977__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column = cljs.core.get.call(null,map__89977__$1,new cljs.core.Keyword(null,"column","column",2078222095));
var G__89979 = "";
var G__89979__$1 = (cljs.core.truth_(file)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__89979),cljs.core.str.cljs$core$IFn$_invoke$arity$1("file "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(file)].join(''):G__89979);
var G__89979__$2 = (cljs.core.truth_(line)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__89979__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" at line "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(line)].join(''):G__89979__$1);
if(cljs.core.truth_((function (){var and__66175__auto__ = line;
if(cljs.core.truth_(and__66175__auto__)){
return column;
} else {
return and__66175__auto__;
}
})())){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__89979__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(", column "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join('');
} else {
return G__89979__$2;
}
});
figwheel.client.default_on_compile_fail = (function figwheel$client$default_on_compile_fail(p__89980){
var map__89987 = p__89980;
var map__89987__$1 = ((((!((map__89987 == null)))?((((map__89987.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__89987.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__89987):map__89987);
var ed = map__89987__$1;
var formatted_exception = cljs.core.get.call(null,map__89987__$1,new cljs.core.Keyword(null,"formatted-exception","formatted-exception",-116489026));
var exception_data = cljs.core.get.call(null,map__89987__$1,new cljs.core.Keyword(null,"exception-data","exception-data",-512474886));
var cause = cljs.core.get.call(null,map__89987__$1,new cljs.core.Keyword(null,"cause","cause",231901252));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: Compile Exception");

var seq__89989_89993 = cljs.core.seq.call(null,figwheel.client.format_messages.call(null,exception_data));
var chunk__89990_89994 = null;
var count__89991_89995 = (0);
var i__89992_89996 = (0);
while(true){
if((i__89992_89996 < count__89991_89995)){
var msg_89997 = cljs.core._nth.call(null,chunk__89990_89994,i__89992_89996);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_89997);

var G__89998 = seq__89989_89993;
var G__89999 = chunk__89990_89994;
var G__90000 = count__89991_89995;
var G__90001 = (i__89992_89996 + (1));
seq__89989_89993 = G__89998;
chunk__89990_89994 = G__89999;
count__89991_89995 = G__90000;
i__89992_89996 = G__90001;
continue;
} else {
var temp__6753__auto___90002 = cljs.core.seq.call(null,seq__89989_89993);
if(temp__6753__auto___90002){
var seq__89989_90003__$1 = temp__6753__auto___90002;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__89989_90003__$1)){
var c__67098__auto___90004 = cljs.core.chunk_first.call(null,seq__89989_90003__$1);
var G__90005 = cljs.core.chunk_rest.call(null,seq__89989_90003__$1);
var G__90006 = c__67098__auto___90004;
var G__90007 = cljs.core.count.call(null,c__67098__auto___90004);
var G__90008 = (0);
seq__89989_89993 = G__90005;
chunk__89990_89994 = G__90006;
count__89991_89995 = G__90007;
i__89992_89996 = G__90008;
continue;
} else {
var msg_90009 = cljs.core.first.call(null,seq__89989_90003__$1);
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),msg_90009);

var G__90010 = cljs.core.next.call(null,seq__89989_90003__$1);
var G__90011 = null;
var G__90012 = (0);
var G__90013 = (0);
seq__89989_89993 = G__90010;
chunk__89990_89994 = G__90011;
count__89991_89995 = G__90012;
i__89992_89996 = G__90013;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cause)){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Error on "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,ed))].join(''));
} else {
}

return ed;
});
figwheel.client.default_on_compile_warning = (function figwheel$client$default_on_compile_warning(p__90014){
var map__90017 = p__90014;
var map__90017__$1 = ((((!((map__90017 == null)))?((((map__90017.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90017.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90017):map__90017);
var w = map__90017__$1;
var message = cljs.core.get.call(null,map__90017__$1,new cljs.core.Keyword(null,"message","message",-406056002));
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"warn","warn",-436710552),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Figwheel: Compile Warning - "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(message)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(figwheel.client.file_line_column.call(null,message))].join(''));

return w;
});
figwheel.client.default_before_load = (function figwheel$client$default_before_load(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: notified of file changes");

return files;
});
figwheel.client.default_on_cssload = (function figwheel$client$default_on_cssload(files){
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded CSS files");

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"info","info",-317069002),cljs.core.pr_str.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),files)));

return files;
});
if(typeof figwheel.client.config_defaults !== 'undefined'){
} else {
figwheel.client.config_defaults = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"on-compile-warning","on-compile-warning",-1195585947),new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430),new cljs.core.Keyword(null,"on-compile-fail","on-compile-fail",728013036),new cljs.core.Keyword(null,"debug","debug",-1608172596),new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202),new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938),new cljs.core.Keyword(null,"auto-jump-to-source-on-error","auto-jump-to-source-on-error",-960314920),new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128),new cljs.core.Keyword(null,"load-warninged-code","load-warninged-code",-2030345223),new cljs.core.Keyword(null,"eval-fn","eval-fn",-1111644294),new cljs.core.Keyword(null,"retry-count","retry-count",1936122875),new cljs.core.Keyword(null,"autoload","autoload",-354122500),new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318)],[new cljs.core.Var(function(){return figwheel.client.default_on_compile_warning;},new cljs.core.Symbol("figwheel.client","default-on-compile-warning","figwheel.client/default-on-compile-warning",584144208,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-warning","default-on-compile-warning",-18911586,null),"resources/mathdoc/figwheel/public/js/compiled/out/figwheel/client.cljs",33,1,357,357,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"message","message",1234475525,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"w","w",1994700528,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_warning)?figwheel.client.default_on_compile_warning.cljs$lang$test:null)])),figwheel.client.default_on_jsload,true,new cljs.core.Var(function(){return figwheel.client.default_on_compile_fail;},new cljs.core.Symbol("figwheel.client","default-on-compile-fail","figwheel.client/default-on-compile-fail",1384826337,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[new cljs.core.Symbol(null,"figwheel.client","figwheel.client",-538710252,null),new cljs.core.Symbol(null,"default-on-compile-fail","default-on-compile-fail",-158814813,null),"resources/mathdoc/figwheel/public/js/compiled/out/figwheel/client.cljs",30,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"formatted-exception","formatted-exception",1524042501,null),new cljs.core.Symbol(null,"exception-data","exception-data",1128056641,null),new cljs.core.Symbol(null,"cause","cause",1872432779,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"ed","ed",2076825751,null)], null)], null)),null,(cljs.core.truth_(figwheel.client.default_on_compile_fail)?figwheel.client.default_on_compile_fail.cljs$lang$test:null)])),false,true,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ws://"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))?location.host:"localhost:3449")),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/figwheel-ws")].join(''),false,figwheel.client.default_before_load,false,false,(100),true,figwheel.client.default_on_cssload]);
}
figwheel.client.handle_deprecated_jsload_callback = (function figwheel$client$handle_deprecated_jsload_callback(config){
if(cljs.core.truth_(new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,config,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369).cljs$core$IFn$_invoke$arity$1(config)),new cljs.core.Keyword(null,"jsload-callback","jsload-callback",-1949628369));
} else {
return config;
}
});
figwheel.client.fill_url_template = (function figwheel$client$fill_url_template(config){
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
return cljs.core.update_in.call(null,config,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"websocket-url","websocket-url",-490444938)], null),(function (x){
return clojure.string.replace.call(null,clojure.string.replace.call(null,x,"[[client-hostname]]",location.hostname),"[[client-port]]",location.port);
}));
} else {
return config;
}
});
figwheel.client.base_plugins = (function figwheel$client$base_plugins(system_options){
var base = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"enforce-project-plugin","enforce-project-plugin",959402899),figwheel.client.enforce_project_plugin,new cljs.core.Keyword(null,"enforce-figwheel-version-plugin","enforce-figwheel-version-plugin",-1916185220),figwheel.client.enforce_figwheel_version_plugin,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),figwheel.client.file_reloader_plugin,new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),figwheel.client.compile_fail_warning_plugin,new cljs.core.Keyword(null,"css-reloader-plugin","css-reloader-plugin",2002032904),figwheel.client.css_reloader_plugin,new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371),figwheel.client.repl_plugin], null);
var base__$1 = ((cljs.core.not.call(null,figwheel.client.utils.html_env_QMARK_.call(null)))?cljs.core.select_keys.call(null,base,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733),new cljs.core.Keyword(null,"comp-fail-warning-plugin","comp-fail-warning-plugin",634311),new cljs.core.Keyword(null,"repl-plugin","repl-plugin",-1138952371)], null)):base);
var base__$2 = ((new cljs.core.Keyword(null,"autoload","autoload",-354122500).cljs$core$IFn$_invoke$arity$1(system_options) === false)?cljs.core.dissoc.call(null,base__$1,new cljs.core.Keyword(null,"file-reloader-plugin","file-reloader-plugin",-1792964733)):base__$1);
if(cljs.core.truth_((function (){var and__66175__auto__ = new cljs.core.Keyword(null,"heads-up-display","heads-up-display",-896577202).cljs$core$IFn$_invoke$arity$1(system_options);
if(cljs.core.truth_(and__66175__auto__)){
return figwheel.client.utils.html_env_QMARK_.call(null);
} else {
return and__66175__auto__;
}
})())){
return cljs.core.assoc.call(null,base__$2,new cljs.core.Keyword(null,"heads-up-display-plugin","heads-up-display-plugin",1745207501),figwheel.client.heads_up_plugin);
} else {
return base__$2;
}
});
figwheel.client.add_message_watch = (function figwheel$client$add_message_watch(key,callback){
return cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,key,(function (_,___$1,___$2,msg_hist){
return callback.call(null,cljs.core.first.call(null,msg_hist));
}));
});
figwheel.client.add_plugins = (function figwheel$client$add_plugins(plugins,system_options){
var seq__90029 = cljs.core.seq.call(null,plugins);
var chunk__90030 = null;
var count__90031 = (0);
var i__90032 = (0);
while(true){
if((i__90032 < count__90031)){
var vec__90033 = cljs.core._nth.call(null,chunk__90030,i__90032);
var k = cljs.core.nth.call(null,vec__90033,(0),null);
var plugin = cljs.core.nth.call(null,vec__90033,(1),null);
if(cljs.core.truth_(plugin)){
var pl_90039 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__90029,chunk__90030,count__90031,i__90032,pl_90039,vec__90033,k,plugin){
return (function (_,___$1,___$2,msg_hist){
return pl_90039.call(null,msg_hist);
});})(seq__90029,chunk__90030,count__90031,i__90032,pl_90039,vec__90033,k,plugin))
);
} else {
}

var G__90040 = seq__90029;
var G__90041 = chunk__90030;
var G__90042 = count__90031;
var G__90043 = (i__90032 + (1));
seq__90029 = G__90040;
chunk__90030 = G__90041;
count__90031 = G__90042;
i__90032 = G__90043;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__90029);
if(temp__6753__auto__){
var seq__90029__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90029__$1)){
var c__67098__auto__ = cljs.core.chunk_first.call(null,seq__90029__$1);
var G__90044 = cljs.core.chunk_rest.call(null,seq__90029__$1);
var G__90045 = c__67098__auto__;
var G__90046 = cljs.core.count.call(null,c__67098__auto__);
var G__90047 = (0);
seq__90029 = G__90044;
chunk__90030 = G__90045;
count__90031 = G__90046;
i__90032 = G__90047;
continue;
} else {
var vec__90036 = cljs.core.first.call(null,seq__90029__$1);
var k = cljs.core.nth.call(null,vec__90036,(0),null);
var plugin = cljs.core.nth.call(null,vec__90036,(1),null);
if(cljs.core.truth_(plugin)){
var pl_90048 = plugin.call(null,system_options);
cljs.core.add_watch.call(null,figwheel.client.socket.message_history_atom,k,((function (seq__90029,chunk__90030,count__90031,i__90032,pl_90048,vec__90036,k,plugin,seq__90029__$1,temp__6753__auto__){
return (function (_,___$1,___$2,msg_hist){
return pl_90048.call(null,msg_hist);
});})(seq__90029,chunk__90030,count__90031,i__90032,pl_90048,vec__90036,k,plugin,seq__90029__$1,temp__6753__auto__))
);
} else {
}

var G__90049 = cljs.core.next.call(null,seq__90029__$1);
var G__90050 = null;
var G__90051 = (0);
var G__90052 = (0);
seq__90029 = G__90049;
chunk__90030 = G__90050;
count__90031 = G__90051;
i__90032 = G__90052;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.start = (function figwheel$client$start(var_args){
var args90053 = [];
var len__67408__auto___90060 = arguments.length;
var i__67409__auto___90061 = (0);
while(true){
if((i__67409__auto___90061 < len__67408__auto___90060)){
args90053.push((arguments[i__67409__auto___90061]));

var G__90062 = (i__67409__auto___90061 + (1));
i__67409__auto___90061 = G__90062;
continue;
} else {
}
break;
}

var G__90055 = args90053.length;
switch (G__90055) {
case 1:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return figwheel.client.start.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args90053.length)].join('')));

}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$1 = (function (opts){
if((goog.dependencies_ == null)){
return null;
} else {
if(typeof figwheel.client.__figwheel_start_once__ !== 'undefined'){
return null;
} else {
return (
figwheel.client.__figwheel_start_once__ = setTimeout((function (){
var plugins_SINGLEQUOTE_ = new cljs.core.Keyword(null,"plugins","plugins",1900073717).cljs$core$IFn$_invoke$arity$1(opts);
var merge_plugins = new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370).cljs$core$IFn$_invoke$arity$1(opts);
var system_options = figwheel.client.fill_url_template.call(null,figwheel.client.handle_deprecated_jsload_callback.call(null,cljs.core.merge.call(null,figwheel.client.config_defaults,cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"plugins","plugins",1900073717),new cljs.core.Keyword(null,"merge-plugins","merge-plugins",-1193912370)))));
var plugins = (cljs.core.truth_(plugins_SINGLEQUOTE_)?plugins_SINGLEQUOTE_:cljs.core.merge.call(null,figwheel.client.base_plugins.call(null,system_options),merge_plugins));
figwheel.client.utils._STAR_print_debug_STAR_ = new cljs.core.Keyword(null,"debug","debug",-1608172596).cljs$core$IFn$_invoke$arity$1(opts);

figwheel.client.enable_repl_print_BANG_.call(null);

figwheel.client.add_plugins.call(null,plugins,system_options);

figwheel.client.file_reloading.patch_goog_base.call(null);

var seq__90056_90064 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"initial-messages","initial-messages",2057377771).cljs$core$IFn$_invoke$arity$1(system_options));
var chunk__90057_90065 = null;
var count__90058_90066 = (0);
var i__90059_90067 = (0);
while(true){
if((i__90059_90067 < count__90058_90066)){
var msg_90068 = cljs.core._nth.call(null,chunk__90057_90065,i__90059_90067);
figwheel.client.socket.handle_incoming_message.call(null,msg_90068);

var G__90069 = seq__90056_90064;
var G__90070 = chunk__90057_90065;
var G__90071 = count__90058_90066;
var G__90072 = (i__90059_90067 + (1));
seq__90056_90064 = G__90069;
chunk__90057_90065 = G__90070;
count__90058_90066 = G__90071;
i__90059_90067 = G__90072;
continue;
} else {
var temp__6753__auto___90073 = cljs.core.seq.call(null,seq__90056_90064);
if(temp__6753__auto___90073){
var seq__90056_90074__$1 = temp__6753__auto___90073;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__90056_90074__$1)){
var c__67098__auto___90075 = cljs.core.chunk_first.call(null,seq__90056_90074__$1);
var G__90076 = cljs.core.chunk_rest.call(null,seq__90056_90074__$1);
var G__90077 = c__67098__auto___90075;
var G__90078 = cljs.core.count.call(null,c__67098__auto___90075);
var G__90079 = (0);
seq__90056_90064 = G__90076;
chunk__90057_90065 = G__90077;
count__90058_90066 = G__90078;
i__90059_90067 = G__90079;
continue;
} else {
var msg_90080 = cljs.core.first.call(null,seq__90056_90074__$1);
figwheel.client.socket.handle_incoming_message.call(null,msg_90080);

var G__90081 = cljs.core.next.call(null,seq__90056_90074__$1);
var G__90082 = null;
var G__90083 = (0);
var G__90084 = (0);
seq__90056_90064 = G__90081;
chunk__90057_90065 = G__90082;
count__90058_90066 = G__90083;
i__90059_90067 = G__90084;
continue;
}
} else {
}
}
break;
}

return figwheel.client.socket.open.call(null,system_options);
})))
;
}
}
});

figwheel.client.start.cljs$core$IFn$_invoke$arity$0 = (function (){
return figwheel.client.start.call(null,cljs.core.PersistentArrayMap.EMPTY);
});

figwheel.client.start.cljs$lang$maxFixedArity = 1;

figwheel.client.watch_and_reload_with_opts = figwheel.client.start;
figwheel.client.watch_and_reload = (function figwheel$client$watch_and_reload(var_args){
var args__67415__auto__ = [];
var len__67408__auto___90089 = arguments.length;
var i__67409__auto___90090 = (0);
while(true){
if((i__67409__auto___90090 < len__67408__auto___90089)){
args__67415__auto__.push((arguments[i__67409__auto___90090]));

var G__90091 = (i__67409__auto___90090 + (1));
i__67409__auto___90090 = G__90091;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((0) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((0)),(0),null)):null);
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(argseq__67416__auto__);
});

figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic = (function (p__90086){
var map__90087 = p__90086;
var map__90087__$1 = ((((!((map__90087 == null)))?((((map__90087.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90087.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90087):map__90087);
var opts = map__90087__$1;
return figwheel.client.start.call(null,opts);
});

figwheel.client.watch_and_reload.cljs$lang$maxFixedArity = (0);

figwheel.client.watch_and_reload.cljs$lang$applyTo = (function (seq90085){
return figwheel.client.watch_and_reload.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq90085));
});

figwheel.client.fetch_data_from_env = (function figwheel$client$fetch_data_from_env(){
try{return cljs.reader.read_string.call(null,goog.object.get(window,"FIGWHEEL_CLIENT_CONFIGURATION"));
}catch (e90093){if((e90093 instanceof Error)){
var e = e90093;
cljs.core._STAR_print_err_fn_STAR_.call(null,"Unable to load FIGWHEEL_CLIENT_CONFIGURATION from the environment");

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"autoload","autoload",-354122500),false], null);
} else {
throw e90093;

}
}});
figwheel.client.console_intro_message = "Figwheel has compiled a temporary helper application to your :output-file.\n\nThe code currently in your configured output file does not\nrepresent the code that you are trying to compile.\n\nThis temporary application is intended to help you continue to get\nfeedback from Figwheel until the build you are working on compiles\ncorrectly.\n\nWhen your ClojureScript source code compiles correctly this helper\napplication will auto-reload and pick up your freshly compiled\nClojureScript program.";
figwheel.client.bad_compile_helper_app = (function figwheel$client$bad_compile_helper_app(){
cljs.core.enable_console_print_BANG_.call(null);

var config = figwheel.client.fetch_data_from_env.call(null);
cljs.core.println.call(null,figwheel.client.console_intro_message);

figwheel.client.heads_up.bad_compile_screen.call(null);

if(cljs.core.truth_(goog.dependencies_)){
} else {
goog.dependencies_ = true;
}

figwheel.client.start.call(null,config);

return figwheel.client.add_message_watch.call(null,new cljs.core.Keyword(null,"listen-for-successful-compile","listen-for-successful-compile",-995277603),((function (config){
return (function (p__90097){
var map__90098 = p__90097;
var map__90098__$1 = ((((!((map__90098 == null)))?((((map__90098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90098.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90098):map__90098);
var msg_name = cljs.core.get.call(null,map__90098__$1,new cljs.core.Keyword(null,"msg-name","msg-name",-353709863));
if(cljs.core._EQ_.call(null,msg_name,new cljs.core.Keyword(null,"files-changed","files-changed",-1418200563))){
return location.href = location.href;
} else {
return null;
}
});})(config))
);
});

//# sourceMappingURL=client.js.map?rel=1489355970299