// Compiled by ClojureScript 1.9.494 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args70993 = [];
var len__67408__auto___70999 = arguments.length;
var i__67409__auto___71000 = (0);
while(true){
if((i__67409__auto___71000 < len__67408__auto___70999)){
args70993.push((arguments[i__67409__auto___71000]));

var G__71001 = (i__67409__auto___71000 + (1));
i__67409__auto___71000 = G__71001;
continue;
} else {
}
break;
}

var G__70995 = args70993.length;
switch (G__70995) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args70993.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async70996 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async70996 = (function (f,blockable,meta70997){
this.f = f;
this.blockable = blockable;
this.meta70997 = meta70997;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async70996.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_70998,meta70997__$1){
var self__ = this;
var _70998__$1 = this;
return (new cljs.core.async.t_cljs$core$async70996(self__.f,self__.blockable,meta70997__$1));
});

cljs.core.async.t_cljs$core$async70996.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_70998){
var self__ = this;
var _70998__$1 = this;
return self__.meta70997;
});

cljs.core.async.t_cljs$core$async70996.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async70996.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async70996.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async70996.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async70996.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta70997","meta70997",-25676650,null)], null);
});

cljs.core.async.t_cljs$core$async70996.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async70996.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async70996";

cljs.core.async.t_cljs$core$async70996.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async70996");
});

cljs.core.async.__GT_t_cljs$core$async70996 = (function cljs$core$async$__GT_t_cljs$core$async70996(f__$1,blockable__$1,meta70997){
return (new cljs.core.async.t_cljs$core$async70996(f__$1,blockable__$1,meta70997));
});

}

return (new cljs.core.async.t_cljs$core$async70996(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args71005 = [];
var len__67408__auto___71008 = arguments.length;
var i__67409__auto___71009 = (0);
while(true){
if((i__67409__auto___71009 < len__67408__auto___71008)){
args71005.push((arguments[i__67409__auto___71009]));

var G__71010 = (i__67409__auto___71009 + (1));
i__67409__auto___71009 = G__71010;
continue;
} else {
}
break;
}

var G__71007 = args71005.length;
switch (G__71007) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71005.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args71012 = [];
var len__67408__auto___71015 = arguments.length;
var i__67409__auto___71016 = (0);
while(true){
if((i__67409__auto___71016 < len__67408__auto___71015)){
args71012.push((arguments[i__67409__auto___71016]));

var G__71017 = (i__67409__auto___71016 + (1));
i__67409__auto___71016 = G__71017;
continue;
} else {
}
break;
}

var G__71014 = args71012.length;
switch (G__71014) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71012.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args71019 = [];
var len__67408__auto___71022 = arguments.length;
var i__67409__auto___71023 = (0);
while(true){
if((i__67409__auto___71023 < len__67408__auto___71022)){
args71019.push((arguments[i__67409__auto___71023]));

var G__71024 = (i__67409__auto___71023 + (1));
i__67409__auto___71023 = G__71024;
continue;
} else {
}
break;
}

var G__71021 = args71019.length;
switch (G__71021) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71019.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_71026 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_71026);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_71026,ret){
return (function (){
return fn1.call(null,val_71026);
});})(val_71026,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args71027 = [];
var len__67408__auto___71030 = arguments.length;
var i__67409__auto___71031 = (0);
while(true){
if((i__67409__auto___71031 < len__67408__auto___71030)){
args71027.push((arguments[i__67409__auto___71031]));

var G__71032 = (i__67409__auto___71031 + (1));
i__67409__auto___71031 = G__71032;
continue;
} else {
}
break;
}

var G__71029 = args71027.length;
switch (G__71029) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71027.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__67208__auto___71034 = n;
var x_71035 = (0);
while(true){
if((x_71035 < n__67208__auto___71034)){
(a[x_71035] = (0));

var G__71036 = (x_71035 + (1));
x_71035 = G__71036;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__71037 = (i + (1));
i = G__71037;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async71041 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71041 = (function (flag,meta71042){
this.flag = flag;
this.meta71042 = meta71042;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async71041.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_71043,meta71042__$1){
var self__ = this;
var _71043__$1 = this;
return (new cljs.core.async.t_cljs$core$async71041(self__.flag,meta71042__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async71041.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_71043){
var self__ = this;
var _71043__$1 = this;
return self__.meta71042;
});})(flag))
;

cljs.core.async.t_cljs$core$async71041.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async71041.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async71041.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async71041.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async71041.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta71042","meta71042",1226364664,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async71041.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71041.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71041";

cljs.core.async.t_cljs$core$async71041.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async71041");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async71041 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async71041(flag__$1,meta71042){
return (new cljs.core.async.t_cljs$core$async71041(flag__$1,meta71042));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async71041(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async71047 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async71047 = (function (flag,cb,meta71048){
this.flag = flag;
this.cb = cb;
this.meta71048 = meta71048;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async71047.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_71049,meta71048__$1){
var self__ = this;
var _71049__$1 = this;
return (new cljs.core.async.t_cljs$core$async71047(self__.flag,self__.cb,meta71048__$1));
});

cljs.core.async.t_cljs$core$async71047.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_71049){
var self__ = this;
var _71049__$1 = this;
return self__.meta71048;
});

cljs.core.async.t_cljs$core$async71047.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async71047.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async71047.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async71047.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async71047.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta71048","meta71048",1950634439,null)], null);
});

cljs.core.async.t_cljs$core$async71047.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async71047.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async71047";

cljs.core.async.t_cljs$core$async71047.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async71047");
});

cljs.core.async.__GT_t_cljs$core$async71047 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async71047(flag__$1,cb__$1,meta71048){
return (new cljs.core.async.t_cljs$core$async71047(flag__$1,cb__$1,meta71048));
});

}

return (new cljs.core.async.t_cljs$core$async71047(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71050_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71050_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__71051_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__71051_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__66187__auto__ = wport;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return port;
}
})()], null));
} else {
var G__71052 = (i + (1));
i = G__71052;
continue;
}
} else {
return null;
}
break;
}
})();
var or__66187__auto__ = ret;
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__66175__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__66175__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__66175__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___71058 = arguments.length;
var i__67409__auto___71059 = (0);
while(true){
if((i__67409__auto___71059 < len__67408__auto___71058)){
args__67415__auto__.push((arguments[i__67409__auto___71059]));

var G__71060 = (i__67409__auto___71059 + (1));
i__67409__auto___71059 = G__71060;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__71055){
var map__71056 = p__71055;
var map__71056__$1 = ((((!((map__71056 == null)))?((((map__71056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__71056.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__71056):map__71056);
var opts = map__71056__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq71053){
var G__71054 = cljs.core.first.call(null,seq71053);
var seq71053__$1 = cljs.core.next.call(null,seq71053);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__71054,seq71053__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args71061 = [];
var len__67408__auto___71111 = arguments.length;
var i__67409__auto___71112 = (0);
while(true){
if((i__67409__auto___71112 < len__67408__auto___71111)){
args71061.push((arguments[i__67409__auto___71112]));

var G__71113 = (i__67409__auto___71112 + (1));
i__67409__auto___71112 = G__71113;
continue;
} else {
}
break;
}

var G__71063 = args71061.length;
switch (G__71063) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71061.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__70934__auto___71115 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___71115){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___71115){
return (function (state_71087){
var state_val_71088 = (state_71087[(1)]);
if((state_val_71088 === (7))){
var inst_71083 = (state_71087[(2)]);
var state_71087__$1 = state_71087;
var statearr_71089_71116 = state_71087__$1;
(statearr_71089_71116[(2)] = inst_71083);

(statearr_71089_71116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (1))){
var state_71087__$1 = state_71087;
var statearr_71090_71117 = state_71087__$1;
(statearr_71090_71117[(2)] = null);

(statearr_71090_71117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (4))){
var inst_71066 = (state_71087[(7)]);
var inst_71066__$1 = (state_71087[(2)]);
var inst_71067 = (inst_71066__$1 == null);
var state_71087__$1 = (function (){var statearr_71091 = state_71087;
(statearr_71091[(7)] = inst_71066__$1);

return statearr_71091;
})();
if(cljs.core.truth_(inst_71067)){
var statearr_71092_71118 = state_71087__$1;
(statearr_71092_71118[(1)] = (5));

} else {
var statearr_71093_71119 = state_71087__$1;
(statearr_71093_71119[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (13))){
var state_71087__$1 = state_71087;
var statearr_71094_71120 = state_71087__$1;
(statearr_71094_71120[(2)] = null);

(statearr_71094_71120[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (6))){
var inst_71066 = (state_71087[(7)]);
var state_71087__$1 = state_71087;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71087__$1,(11),to,inst_71066);
} else {
if((state_val_71088 === (3))){
var inst_71085 = (state_71087[(2)]);
var state_71087__$1 = state_71087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71087__$1,inst_71085);
} else {
if((state_val_71088 === (12))){
var state_71087__$1 = state_71087;
var statearr_71095_71121 = state_71087__$1;
(statearr_71095_71121[(2)] = null);

(statearr_71095_71121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (2))){
var state_71087__$1 = state_71087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71087__$1,(4),from);
} else {
if((state_val_71088 === (11))){
var inst_71076 = (state_71087[(2)]);
var state_71087__$1 = state_71087;
if(cljs.core.truth_(inst_71076)){
var statearr_71096_71122 = state_71087__$1;
(statearr_71096_71122[(1)] = (12));

} else {
var statearr_71097_71123 = state_71087__$1;
(statearr_71097_71123[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (9))){
var state_71087__$1 = state_71087;
var statearr_71098_71124 = state_71087__$1;
(statearr_71098_71124[(2)] = null);

(statearr_71098_71124[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (5))){
var state_71087__$1 = state_71087;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71099_71125 = state_71087__$1;
(statearr_71099_71125[(1)] = (8));

} else {
var statearr_71100_71126 = state_71087__$1;
(statearr_71100_71126[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (14))){
var inst_71081 = (state_71087[(2)]);
var state_71087__$1 = state_71087;
var statearr_71101_71127 = state_71087__$1;
(statearr_71101_71127[(2)] = inst_71081);

(statearr_71101_71127[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (10))){
var inst_71073 = (state_71087[(2)]);
var state_71087__$1 = state_71087;
var statearr_71102_71128 = state_71087__$1;
(statearr_71102_71128[(2)] = inst_71073);

(statearr_71102_71128[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71088 === (8))){
var inst_71070 = cljs.core.async.close_BANG_.call(null,to);
var state_71087__$1 = state_71087;
var statearr_71103_71129 = state_71087__$1;
(statearr_71103_71129[(2)] = inst_71070);

(statearr_71103_71129[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___71115))
;
return ((function (switch__70820__auto__,c__70934__auto___71115){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_71107 = [null,null,null,null,null,null,null,null];
(statearr_71107[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_71107[(1)] = (1));

return statearr_71107;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_71087){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71108){if((e71108 instanceof Object)){
var ex__70824__auto__ = e71108;
var statearr_71109_71130 = state_71087;
(statearr_71109_71130[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71087);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71108;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71131 = state_71087;
state_71087 = G__71131;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_71087){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_71087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___71115))
})();
var state__70936__auto__ = (function (){var statearr_71110 = f__70935__auto__.call(null);
(statearr_71110[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___71115);

return statearr_71110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___71115))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__71319){
var vec__71320 = p__71319;
var v = cljs.core.nth.call(null,vec__71320,(0),null);
var p = cljs.core.nth.call(null,vec__71320,(1),null);
var job = vec__71320;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__70934__auto___71506 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___71506,res,vec__71320,v,p,job,jobs,results){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___71506,res,vec__71320,v,p,job,jobs,results){
return (function (state_71327){
var state_val_71328 = (state_71327[(1)]);
if((state_val_71328 === (1))){
var state_71327__$1 = state_71327;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71327__$1,(2),res,v);
} else {
if((state_val_71328 === (2))){
var inst_71324 = (state_71327[(2)]);
var inst_71325 = cljs.core.async.close_BANG_.call(null,res);
var state_71327__$1 = (function (){var statearr_71329 = state_71327;
(statearr_71329[(7)] = inst_71324);

return statearr_71329;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71327__$1,inst_71325);
} else {
return null;
}
}
});})(c__70934__auto___71506,res,vec__71320,v,p,job,jobs,results))
;
return ((function (switch__70820__auto__,c__70934__auto___71506,res,vec__71320,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_71333 = [null,null,null,null,null,null,null,null];
(statearr_71333[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_71333[(1)] = (1));

return statearr_71333;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_71327){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71327);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71334){if((e71334 instanceof Object)){
var ex__70824__auto__ = e71334;
var statearr_71335_71507 = state_71327;
(statearr_71335_71507[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71327);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71334;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71508 = state_71327;
state_71327 = G__71508;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_71327){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_71327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___71506,res,vec__71320,v,p,job,jobs,results))
})();
var state__70936__auto__ = (function (){var statearr_71336 = f__70935__auto__.call(null);
(statearr_71336[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___71506);

return statearr_71336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___71506,res,vec__71320,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__71337){
var vec__71338 = p__71337;
var v = cljs.core.nth.call(null,vec__71338,(0),null);
var p = cljs.core.nth.call(null,vec__71338,(1),null);
var job = vec__71338;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__67208__auto___71509 = n;
var __71510 = (0);
while(true){
if((__71510 < n__67208__auto___71509)){
var G__71341_71511 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__71341_71511) {
case "compute":
var c__70934__auto___71513 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__71510,c__70934__auto___71513,G__71341_71511,n__67208__auto___71509,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (__71510,c__70934__auto___71513,G__71341_71511,n__67208__auto___71509,jobs,results,process,async){
return (function (state_71354){
var state_val_71355 = (state_71354[(1)]);
if((state_val_71355 === (1))){
var state_71354__$1 = state_71354;
var statearr_71356_71514 = state_71354__$1;
(statearr_71356_71514[(2)] = null);

(statearr_71356_71514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71355 === (2))){
var state_71354__$1 = state_71354;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71354__$1,(4),jobs);
} else {
if((state_val_71355 === (3))){
var inst_71352 = (state_71354[(2)]);
var state_71354__$1 = state_71354;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71354__$1,inst_71352);
} else {
if((state_val_71355 === (4))){
var inst_71344 = (state_71354[(2)]);
var inst_71345 = process.call(null,inst_71344);
var state_71354__$1 = state_71354;
if(cljs.core.truth_(inst_71345)){
var statearr_71357_71515 = state_71354__$1;
(statearr_71357_71515[(1)] = (5));

} else {
var statearr_71358_71516 = state_71354__$1;
(statearr_71358_71516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71355 === (5))){
var state_71354__$1 = state_71354;
var statearr_71359_71517 = state_71354__$1;
(statearr_71359_71517[(2)] = null);

(statearr_71359_71517[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71355 === (6))){
var state_71354__$1 = state_71354;
var statearr_71360_71518 = state_71354__$1;
(statearr_71360_71518[(2)] = null);

(statearr_71360_71518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71355 === (7))){
var inst_71350 = (state_71354[(2)]);
var state_71354__$1 = state_71354;
var statearr_71361_71519 = state_71354__$1;
(statearr_71361_71519[(2)] = inst_71350);

(statearr_71361_71519[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__71510,c__70934__auto___71513,G__71341_71511,n__67208__auto___71509,jobs,results,process,async))
;
return ((function (__71510,switch__70820__auto__,c__70934__auto___71513,G__71341_71511,n__67208__auto___71509,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_71365 = [null,null,null,null,null,null,null];
(statearr_71365[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_71365[(1)] = (1));

return statearr_71365;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_71354){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71354);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71366){if((e71366 instanceof Object)){
var ex__70824__auto__ = e71366;
var statearr_71367_71520 = state_71354;
(statearr_71367_71520[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71354);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71366;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71521 = state_71354;
state_71354 = G__71521;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_71354){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_71354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(__71510,switch__70820__auto__,c__70934__auto___71513,G__71341_71511,n__67208__auto___71509,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_71368 = f__70935__auto__.call(null);
(statearr_71368[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___71513);

return statearr_71368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(__71510,c__70934__auto___71513,G__71341_71511,n__67208__auto___71509,jobs,results,process,async))
);


break;
case "async":
var c__70934__auto___71522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__71510,c__70934__auto___71522,G__71341_71511,n__67208__auto___71509,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (__71510,c__70934__auto___71522,G__71341_71511,n__67208__auto___71509,jobs,results,process,async){
return (function (state_71381){
var state_val_71382 = (state_71381[(1)]);
if((state_val_71382 === (1))){
var state_71381__$1 = state_71381;
var statearr_71383_71523 = state_71381__$1;
(statearr_71383_71523[(2)] = null);

(statearr_71383_71523[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71382 === (2))){
var state_71381__$1 = state_71381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71381__$1,(4),jobs);
} else {
if((state_val_71382 === (3))){
var inst_71379 = (state_71381[(2)]);
var state_71381__$1 = state_71381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71381__$1,inst_71379);
} else {
if((state_val_71382 === (4))){
var inst_71371 = (state_71381[(2)]);
var inst_71372 = async.call(null,inst_71371);
var state_71381__$1 = state_71381;
if(cljs.core.truth_(inst_71372)){
var statearr_71384_71524 = state_71381__$1;
(statearr_71384_71524[(1)] = (5));

} else {
var statearr_71385_71525 = state_71381__$1;
(statearr_71385_71525[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71382 === (5))){
var state_71381__$1 = state_71381;
var statearr_71386_71526 = state_71381__$1;
(statearr_71386_71526[(2)] = null);

(statearr_71386_71526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71382 === (6))){
var state_71381__$1 = state_71381;
var statearr_71387_71527 = state_71381__$1;
(statearr_71387_71527[(2)] = null);

(statearr_71387_71527[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71382 === (7))){
var inst_71377 = (state_71381[(2)]);
var state_71381__$1 = state_71381;
var statearr_71388_71528 = state_71381__$1;
(statearr_71388_71528[(2)] = inst_71377);

(statearr_71388_71528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__71510,c__70934__auto___71522,G__71341_71511,n__67208__auto___71509,jobs,results,process,async))
;
return ((function (__71510,switch__70820__auto__,c__70934__auto___71522,G__71341_71511,n__67208__auto___71509,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_71392 = [null,null,null,null,null,null,null];
(statearr_71392[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_71392[(1)] = (1));

return statearr_71392;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_71381){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71393){if((e71393 instanceof Object)){
var ex__70824__auto__ = e71393;
var statearr_71394_71529 = state_71381;
(statearr_71394_71529[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71381);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71393;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71530 = state_71381;
state_71381 = G__71530;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_71381){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_71381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(__71510,switch__70820__auto__,c__70934__auto___71522,G__71341_71511,n__67208__auto___71509,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_71395 = f__70935__auto__.call(null);
(statearr_71395[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___71522);

return statearr_71395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(__71510,c__70934__auto___71522,G__71341_71511,n__67208__auto___71509,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__71531 = (__71510 + (1));
__71510 = G__71531;
continue;
} else {
}
break;
}

var c__70934__auto___71532 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___71532,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___71532,jobs,results,process,async){
return (function (state_71417){
var state_val_71418 = (state_71417[(1)]);
if((state_val_71418 === (1))){
var state_71417__$1 = state_71417;
var statearr_71419_71533 = state_71417__$1;
(statearr_71419_71533[(2)] = null);

(statearr_71419_71533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71418 === (2))){
var state_71417__$1 = state_71417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71417__$1,(4),from);
} else {
if((state_val_71418 === (3))){
var inst_71415 = (state_71417[(2)]);
var state_71417__$1 = state_71417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71417__$1,inst_71415);
} else {
if((state_val_71418 === (4))){
var inst_71398 = (state_71417[(7)]);
var inst_71398__$1 = (state_71417[(2)]);
var inst_71399 = (inst_71398__$1 == null);
var state_71417__$1 = (function (){var statearr_71420 = state_71417;
(statearr_71420[(7)] = inst_71398__$1);

return statearr_71420;
})();
if(cljs.core.truth_(inst_71399)){
var statearr_71421_71534 = state_71417__$1;
(statearr_71421_71534[(1)] = (5));

} else {
var statearr_71422_71535 = state_71417__$1;
(statearr_71422_71535[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71418 === (5))){
var inst_71401 = cljs.core.async.close_BANG_.call(null,jobs);
var state_71417__$1 = state_71417;
var statearr_71423_71536 = state_71417__$1;
(statearr_71423_71536[(2)] = inst_71401);

(statearr_71423_71536[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71418 === (6))){
var inst_71403 = (state_71417[(8)]);
var inst_71398 = (state_71417[(7)]);
var inst_71403__$1 = cljs.core.async.chan.call(null,(1));
var inst_71404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71405 = [inst_71398,inst_71403__$1];
var inst_71406 = (new cljs.core.PersistentVector(null,2,(5),inst_71404,inst_71405,null));
var state_71417__$1 = (function (){var statearr_71424 = state_71417;
(statearr_71424[(8)] = inst_71403__$1);

return statearr_71424;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71417__$1,(8),jobs,inst_71406);
} else {
if((state_val_71418 === (7))){
var inst_71413 = (state_71417[(2)]);
var state_71417__$1 = state_71417;
var statearr_71425_71537 = state_71417__$1;
(statearr_71425_71537[(2)] = inst_71413);

(statearr_71425_71537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71418 === (8))){
var inst_71403 = (state_71417[(8)]);
var inst_71408 = (state_71417[(2)]);
var state_71417__$1 = (function (){var statearr_71426 = state_71417;
(statearr_71426[(9)] = inst_71408);

return statearr_71426;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71417__$1,(9),results,inst_71403);
} else {
if((state_val_71418 === (9))){
var inst_71410 = (state_71417[(2)]);
var state_71417__$1 = (function (){var statearr_71427 = state_71417;
(statearr_71427[(10)] = inst_71410);

return statearr_71427;
})();
var statearr_71428_71538 = state_71417__$1;
(statearr_71428_71538[(2)] = null);

(statearr_71428_71538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___71532,jobs,results,process,async))
;
return ((function (switch__70820__auto__,c__70934__auto___71532,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_71432 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71432[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_71432[(1)] = (1));

return statearr_71432;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_71417){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71433){if((e71433 instanceof Object)){
var ex__70824__auto__ = e71433;
var statearr_71434_71539 = state_71417;
(statearr_71434_71539[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71433;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71540 = state_71417;
state_71417 = G__71540;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_71417){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_71417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___71532,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_71435 = f__70935__auto__.call(null);
(statearr_71435[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___71532);

return statearr_71435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___71532,jobs,results,process,async))
);


var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,jobs,results,process,async){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,jobs,results,process,async){
return (function (state_71473){
var state_val_71474 = (state_71473[(1)]);
if((state_val_71474 === (7))){
var inst_71469 = (state_71473[(2)]);
var state_71473__$1 = state_71473;
var statearr_71475_71541 = state_71473__$1;
(statearr_71475_71541[(2)] = inst_71469);

(statearr_71475_71541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (20))){
var state_71473__$1 = state_71473;
var statearr_71476_71542 = state_71473__$1;
(statearr_71476_71542[(2)] = null);

(statearr_71476_71542[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (1))){
var state_71473__$1 = state_71473;
var statearr_71477_71543 = state_71473__$1;
(statearr_71477_71543[(2)] = null);

(statearr_71477_71543[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (4))){
var inst_71438 = (state_71473[(7)]);
var inst_71438__$1 = (state_71473[(2)]);
var inst_71439 = (inst_71438__$1 == null);
var state_71473__$1 = (function (){var statearr_71478 = state_71473;
(statearr_71478[(7)] = inst_71438__$1);

return statearr_71478;
})();
if(cljs.core.truth_(inst_71439)){
var statearr_71479_71544 = state_71473__$1;
(statearr_71479_71544[(1)] = (5));

} else {
var statearr_71480_71545 = state_71473__$1;
(statearr_71480_71545[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (15))){
var inst_71451 = (state_71473[(8)]);
var state_71473__$1 = state_71473;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71473__$1,(18),to,inst_71451);
} else {
if((state_val_71474 === (21))){
var inst_71464 = (state_71473[(2)]);
var state_71473__$1 = state_71473;
var statearr_71481_71546 = state_71473__$1;
(statearr_71481_71546[(2)] = inst_71464);

(statearr_71481_71546[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (13))){
var inst_71466 = (state_71473[(2)]);
var state_71473__$1 = (function (){var statearr_71482 = state_71473;
(statearr_71482[(9)] = inst_71466);

return statearr_71482;
})();
var statearr_71483_71547 = state_71473__$1;
(statearr_71483_71547[(2)] = null);

(statearr_71483_71547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (6))){
var inst_71438 = (state_71473[(7)]);
var state_71473__$1 = state_71473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71473__$1,(11),inst_71438);
} else {
if((state_val_71474 === (17))){
var inst_71459 = (state_71473[(2)]);
var state_71473__$1 = state_71473;
if(cljs.core.truth_(inst_71459)){
var statearr_71484_71548 = state_71473__$1;
(statearr_71484_71548[(1)] = (19));

} else {
var statearr_71485_71549 = state_71473__$1;
(statearr_71485_71549[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (3))){
var inst_71471 = (state_71473[(2)]);
var state_71473__$1 = state_71473;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71473__$1,inst_71471);
} else {
if((state_val_71474 === (12))){
var inst_71448 = (state_71473[(10)]);
var state_71473__$1 = state_71473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71473__$1,(14),inst_71448);
} else {
if((state_val_71474 === (2))){
var state_71473__$1 = state_71473;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71473__$1,(4),results);
} else {
if((state_val_71474 === (19))){
var state_71473__$1 = state_71473;
var statearr_71486_71550 = state_71473__$1;
(statearr_71486_71550[(2)] = null);

(statearr_71486_71550[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (11))){
var inst_71448 = (state_71473[(2)]);
var state_71473__$1 = (function (){var statearr_71487 = state_71473;
(statearr_71487[(10)] = inst_71448);

return statearr_71487;
})();
var statearr_71488_71551 = state_71473__$1;
(statearr_71488_71551[(2)] = null);

(statearr_71488_71551[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (9))){
var state_71473__$1 = state_71473;
var statearr_71489_71552 = state_71473__$1;
(statearr_71489_71552[(2)] = null);

(statearr_71489_71552[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (5))){
var state_71473__$1 = state_71473;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71490_71553 = state_71473__$1;
(statearr_71490_71553[(1)] = (8));

} else {
var statearr_71491_71554 = state_71473__$1;
(statearr_71491_71554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (14))){
var inst_71451 = (state_71473[(8)]);
var inst_71453 = (state_71473[(11)]);
var inst_71451__$1 = (state_71473[(2)]);
var inst_71452 = (inst_71451__$1 == null);
var inst_71453__$1 = cljs.core.not.call(null,inst_71452);
var state_71473__$1 = (function (){var statearr_71492 = state_71473;
(statearr_71492[(8)] = inst_71451__$1);

(statearr_71492[(11)] = inst_71453__$1);

return statearr_71492;
})();
if(inst_71453__$1){
var statearr_71493_71555 = state_71473__$1;
(statearr_71493_71555[(1)] = (15));

} else {
var statearr_71494_71556 = state_71473__$1;
(statearr_71494_71556[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (16))){
var inst_71453 = (state_71473[(11)]);
var state_71473__$1 = state_71473;
var statearr_71495_71557 = state_71473__$1;
(statearr_71495_71557[(2)] = inst_71453);

(statearr_71495_71557[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (10))){
var inst_71445 = (state_71473[(2)]);
var state_71473__$1 = state_71473;
var statearr_71496_71558 = state_71473__$1;
(statearr_71496_71558[(2)] = inst_71445);

(statearr_71496_71558[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (18))){
var inst_71456 = (state_71473[(2)]);
var state_71473__$1 = state_71473;
var statearr_71497_71559 = state_71473__$1;
(statearr_71497_71559[(2)] = inst_71456);

(statearr_71497_71559[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71474 === (8))){
var inst_71442 = cljs.core.async.close_BANG_.call(null,to);
var state_71473__$1 = state_71473;
var statearr_71498_71560 = state_71473__$1;
(statearr_71498_71560[(2)] = inst_71442);

(statearr_71498_71560[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__,jobs,results,process,async))
;
return ((function (switch__70820__auto__,c__70934__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_71502 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71502[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__);

(statearr_71502[(1)] = (1));

return statearr_71502;
});
var cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1 = (function (state_71473){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71473);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71503){if((e71503 instanceof Object)){
var ex__70824__auto__ = e71503;
var statearr_71504_71561 = state_71473;
(statearr_71504_71561[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71473);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71562 = state_71473;
state_71473 = G__71562;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__ = function(state_71473){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1.call(this,state_71473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,jobs,results,process,async))
})();
var state__70936__auto__ = (function (){var statearr_71505 = f__70935__auto__.call(null);
(statearr_71505[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_71505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,jobs,results,process,async))
);

return c__70934__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args71563 = [];
var len__67408__auto___71566 = arguments.length;
var i__67409__auto___71567 = (0);
while(true){
if((i__67409__auto___71567 < len__67408__auto___71566)){
args71563.push((arguments[i__67409__auto___71567]));

var G__71568 = (i__67409__auto___71567 + (1));
i__67409__auto___71567 = G__71568;
continue;
} else {
}
break;
}

var G__71565 = args71563.length;
switch (G__71565) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71563.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args71570 = [];
var len__67408__auto___71573 = arguments.length;
var i__67409__auto___71574 = (0);
while(true){
if((i__67409__auto___71574 < len__67408__auto___71573)){
args71570.push((arguments[i__67409__auto___71574]));

var G__71575 = (i__67409__auto___71574 + (1));
i__67409__auto___71574 = G__71575;
continue;
} else {
}
break;
}

var G__71572 = args71570.length;
switch (G__71572) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71570.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args71577 = [];
var len__67408__auto___71630 = arguments.length;
var i__67409__auto___71631 = (0);
while(true){
if((i__67409__auto___71631 < len__67408__auto___71630)){
args71577.push((arguments[i__67409__auto___71631]));

var G__71632 = (i__67409__auto___71631 + (1));
i__67409__auto___71631 = G__71632;
continue;
} else {
}
break;
}

var G__71579 = args71577.length;
switch (G__71579) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71577.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__70934__auto___71634 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___71634,tc,fc){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___71634,tc,fc){
return (function (state_71605){
var state_val_71606 = (state_71605[(1)]);
if((state_val_71606 === (7))){
var inst_71601 = (state_71605[(2)]);
var state_71605__$1 = state_71605;
var statearr_71607_71635 = state_71605__$1;
(statearr_71607_71635[(2)] = inst_71601);

(statearr_71607_71635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (1))){
var state_71605__$1 = state_71605;
var statearr_71608_71636 = state_71605__$1;
(statearr_71608_71636[(2)] = null);

(statearr_71608_71636[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (4))){
var inst_71582 = (state_71605[(7)]);
var inst_71582__$1 = (state_71605[(2)]);
var inst_71583 = (inst_71582__$1 == null);
var state_71605__$1 = (function (){var statearr_71609 = state_71605;
(statearr_71609[(7)] = inst_71582__$1);

return statearr_71609;
})();
if(cljs.core.truth_(inst_71583)){
var statearr_71610_71637 = state_71605__$1;
(statearr_71610_71637[(1)] = (5));

} else {
var statearr_71611_71638 = state_71605__$1;
(statearr_71611_71638[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (13))){
var state_71605__$1 = state_71605;
var statearr_71612_71639 = state_71605__$1;
(statearr_71612_71639[(2)] = null);

(statearr_71612_71639[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (6))){
var inst_71582 = (state_71605[(7)]);
var inst_71588 = p.call(null,inst_71582);
var state_71605__$1 = state_71605;
if(cljs.core.truth_(inst_71588)){
var statearr_71613_71640 = state_71605__$1;
(statearr_71613_71640[(1)] = (9));

} else {
var statearr_71614_71641 = state_71605__$1;
(statearr_71614_71641[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (3))){
var inst_71603 = (state_71605[(2)]);
var state_71605__$1 = state_71605;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71605__$1,inst_71603);
} else {
if((state_val_71606 === (12))){
var state_71605__$1 = state_71605;
var statearr_71615_71642 = state_71605__$1;
(statearr_71615_71642[(2)] = null);

(statearr_71615_71642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (2))){
var state_71605__$1 = state_71605;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71605__$1,(4),ch);
} else {
if((state_val_71606 === (11))){
var inst_71582 = (state_71605[(7)]);
var inst_71592 = (state_71605[(2)]);
var state_71605__$1 = state_71605;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71605__$1,(8),inst_71592,inst_71582);
} else {
if((state_val_71606 === (9))){
var state_71605__$1 = state_71605;
var statearr_71616_71643 = state_71605__$1;
(statearr_71616_71643[(2)] = tc);

(statearr_71616_71643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (5))){
var inst_71585 = cljs.core.async.close_BANG_.call(null,tc);
var inst_71586 = cljs.core.async.close_BANG_.call(null,fc);
var state_71605__$1 = (function (){var statearr_71617 = state_71605;
(statearr_71617[(8)] = inst_71585);

return statearr_71617;
})();
var statearr_71618_71644 = state_71605__$1;
(statearr_71618_71644[(2)] = inst_71586);

(statearr_71618_71644[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (14))){
var inst_71599 = (state_71605[(2)]);
var state_71605__$1 = state_71605;
var statearr_71619_71645 = state_71605__$1;
(statearr_71619_71645[(2)] = inst_71599);

(statearr_71619_71645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (10))){
var state_71605__$1 = state_71605;
var statearr_71620_71646 = state_71605__$1;
(statearr_71620_71646[(2)] = fc);

(statearr_71620_71646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71606 === (8))){
var inst_71594 = (state_71605[(2)]);
var state_71605__$1 = state_71605;
if(cljs.core.truth_(inst_71594)){
var statearr_71621_71647 = state_71605__$1;
(statearr_71621_71647[(1)] = (12));

} else {
var statearr_71622_71648 = state_71605__$1;
(statearr_71622_71648[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___71634,tc,fc))
;
return ((function (switch__70820__auto__,c__70934__auto___71634,tc,fc){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_71626 = [null,null,null,null,null,null,null,null,null];
(statearr_71626[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_71626[(1)] = (1));

return statearr_71626;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_71605){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71605);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71627){if((e71627 instanceof Object)){
var ex__70824__auto__ = e71627;
var statearr_71628_71649 = state_71605;
(statearr_71628_71649[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71605);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71627;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71650 = state_71605;
state_71605 = G__71650;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_71605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_71605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___71634,tc,fc))
})();
var state__70936__auto__ = (function (){var statearr_71629 = f__70935__auto__.call(null);
(statearr_71629[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___71634);

return statearr_71629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___71634,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_71714){
var state_val_71715 = (state_71714[(1)]);
if((state_val_71715 === (7))){
var inst_71710 = (state_71714[(2)]);
var state_71714__$1 = state_71714;
var statearr_71716_71737 = state_71714__$1;
(statearr_71716_71737[(2)] = inst_71710);

(statearr_71716_71737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (1))){
var inst_71694 = init;
var state_71714__$1 = (function (){var statearr_71717 = state_71714;
(statearr_71717[(7)] = inst_71694);

return statearr_71717;
})();
var statearr_71718_71738 = state_71714__$1;
(statearr_71718_71738[(2)] = null);

(statearr_71718_71738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (4))){
var inst_71697 = (state_71714[(8)]);
var inst_71697__$1 = (state_71714[(2)]);
var inst_71698 = (inst_71697__$1 == null);
var state_71714__$1 = (function (){var statearr_71719 = state_71714;
(statearr_71719[(8)] = inst_71697__$1);

return statearr_71719;
})();
if(cljs.core.truth_(inst_71698)){
var statearr_71720_71739 = state_71714__$1;
(statearr_71720_71739[(1)] = (5));

} else {
var statearr_71721_71740 = state_71714__$1;
(statearr_71721_71740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (6))){
var inst_71701 = (state_71714[(9)]);
var inst_71697 = (state_71714[(8)]);
var inst_71694 = (state_71714[(7)]);
var inst_71701__$1 = f.call(null,inst_71694,inst_71697);
var inst_71702 = cljs.core.reduced_QMARK_.call(null,inst_71701__$1);
var state_71714__$1 = (function (){var statearr_71722 = state_71714;
(statearr_71722[(9)] = inst_71701__$1);

return statearr_71722;
})();
if(inst_71702){
var statearr_71723_71741 = state_71714__$1;
(statearr_71723_71741[(1)] = (8));

} else {
var statearr_71724_71742 = state_71714__$1;
(statearr_71724_71742[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (3))){
var inst_71712 = (state_71714[(2)]);
var state_71714__$1 = state_71714;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71714__$1,inst_71712);
} else {
if((state_val_71715 === (2))){
var state_71714__$1 = state_71714;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71714__$1,(4),ch);
} else {
if((state_val_71715 === (9))){
var inst_71701 = (state_71714[(9)]);
var inst_71694 = inst_71701;
var state_71714__$1 = (function (){var statearr_71725 = state_71714;
(statearr_71725[(7)] = inst_71694);

return statearr_71725;
})();
var statearr_71726_71743 = state_71714__$1;
(statearr_71726_71743[(2)] = null);

(statearr_71726_71743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (5))){
var inst_71694 = (state_71714[(7)]);
var state_71714__$1 = state_71714;
var statearr_71727_71744 = state_71714__$1;
(statearr_71727_71744[(2)] = inst_71694);

(statearr_71727_71744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (10))){
var inst_71708 = (state_71714[(2)]);
var state_71714__$1 = state_71714;
var statearr_71728_71745 = state_71714__$1;
(statearr_71728_71745[(2)] = inst_71708);

(statearr_71728_71745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71715 === (8))){
var inst_71701 = (state_71714[(9)]);
var inst_71704 = cljs.core.deref.call(null,inst_71701);
var state_71714__$1 = state_71714;
var statearr_71729_71746 = state_71714__$1;
(statearr_71729_71746[(2)] = inst_71704);

(statearr_71729_71746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__70821__auto__ = null;
var cljs$core$async$reduce_$_state_machine__70821__auto____0 = (function (){
var statearr_71733 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71733[(0)] = cljs$core$async$reduce_$_state_machine__70821__auto__);

(statearr_71733[(1)] = (1));

return statearr_71733;
});
var cljs$core$async$reduce_$_state_machine__70821__auto____1 = (function (state_71714){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71714);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71734){if((e71734 instanceof Object)){
var ex__70824__auto__ = e71734;
var statearr_71735_71747 = state_71714;
(statearr_71735_71747[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71714);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71748 = state_71714;
state_71714 = G__71748;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__70821__auto__ = function(state_71714){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__70821__auto____1.call(this,state_71714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__70821__auto____0;
cljs$core$async$reduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__70821__auto____1;
return cljs$core$async$reduce_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_71736 = f__70935__auto__.call(null);
(statearr_71736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_71736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__,f__$1){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__,f__$1){
return (function (state_71768){
var state_val_71769 = (state_71768[(1)]);
if((state_val_71769 === (1))){
var inst_71763 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_71768__$1 = state_71768;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71768__$1,(2),inst_71763);
} else {
if((state_val_71769 === (2))){
var inst_71765 = (state_71768[(2)]);
var inst_71766 = f__$1.call(null,inst_71765);
var state_71768__$1 = state_71768;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71768__$1,inst_71766);
} else {
return null;
}
}
});})(c__70934__auto__,f__$1))
;
return ((function (switch__70820__auto__,c__70934__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__70821__auto__ = null;
var cljs$core$async$transduce_$_state_machine__70821__auto____0 = (function (){
var statearr_71773 = [null,null,null,null,null,null,null];
(statearr_71773[(0)] = cljs$core$async$transduce_$_state_machine__70821__auto__);

(statearr_71773[(1)] = (1));

return statearr_71773;
});
var cljs$core$async$transduce_$_state_machine__70821__auto____1 = (function (state_71768){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71768);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71774){if((e71774 instanceof Object)){
var ex__70824__auto__ = e71774;
var statearr_71775_71777 = state_71768;
(statearr_71775_71777[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71768);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71774;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71778 = state_71768;
state_71768 = G__71778;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__70821__auto__ = function(state_71768){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__70821__auto____1.call(this,state_71768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__70821__auto____0;
cljs$core$async$transduce_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__70821__auto____1;
return cljs$core$async$transduce_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__,f__$1))
})();
var state__70936__auto__ = (function (){var statearr_71776 = f__70935__auto__.call(null);
(statearr_71776[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_71776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__,f__$1))
);

return c__70934__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args71779 = [];
var len__67408__auto___71831 = arguments.length;
var i__67409__auto___71832 = (0);
while(true){
if((i__67409__auto___71832 < len__67408__auto___71831)){
args71779.push((arguments[i__67409__auto___71832]));

var G__71833 = (i__67409__auto___71832 + (1));
i__67409__auto___71832 = G__71833;
continue;
} else {
}
break;
}

var G__71781 = args71779.length;
switch (G__71781) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args71779.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_71806){
var state_val_71807 = (state_71806[(1)]);
if((state_val_71807 === (7))){
var inst_71788 = (state_71806[(2)]);
var state_71806__$1 = state_71806;
var statearr_71808_71835 = state_71806__$1;
(statearr_71808_71835[(2)] = inst_71788);

(statearr_71808_71835[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (1))){
var inst_71782 = cljs.core.seq.call(null,coll);
var inst_71783 = inst_71782;
var state_71806__$1 = (function (){var statearr_71809 = state_71806;
(statearr_71809[(7)] = inst_71783);

return statearr_71809;
})();
var statearr_71810_71836 = state_71806__$1;
(statearr_71810_71836[(2)] = null);

(statearr_71810_71836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (4))){
var inst_71783 = (state_71806[(7)]);
var inst_71786 = cljs.core.first.call(null,inst_71783);
var state_71806__$1 = state_71806;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_71806__$1,(7),ch,inst_71786);
} else {
if((state_val_71807 === (13))){
var inst_71800 = (state_71806[(2)]);
var state_71806__$1 = state_71806;
var statearr_71811_71837 = state_71806__$1;
(statearr_71811_71837[(2)] = inst_71800);

(statearr_71811_71837[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (6))){
var inst_71791 = (state_71806[(2)]);
var state_71806__$1 = state_71806;
if(cljs.core.truth_(inst_71791)){
var statearr_71812_71838 = state_71806__$1;
(statearr_71812_71838[(1)] = (8));

} else {
var statearr_71813_71839 = state_71806__$1;
(statearr_71813_71839[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (3))){
var inst_71804 = (state_71806[(2)]);
var state_71806__$1 = state_71806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71806__$1,inst_71804);
} else {
if((state_val_71807 === (12))){
var state_71806__$1 = state_71806;
var statearr_71814_71840 = state_71806__$1;
(statearr_71814_71840[(2)] = null);

(statearr_71814_71840[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (2))){
var inst_71783 = (state_71806[(7)]);
var state_71806__$1 = state_71806;
if(cljs.core.truth_(inst_71783)){
var statearr_71815_71841 = state_71806__$1;
(statearr_71815_71841[(1)] = (4));

} else {
var statearr_71816_71842 = state_71806__$1;
(statearr_71816_71842[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (11))){
var inst_71797 = cljs.core.async.close_BANG_.call(null,ch);
var state_71806__$1 = state_71806;
var statearr_71817_71843 = state_71806__$1;
(statearr_71817_71843[(2)] = inst_71797);

(statearr_71817_71843[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (9))){
var state_71806__$1 = state_71806;
if(cljs.core.truth_(close_QMARK_)){
var statearr_71818_71844 = state_71806__$1;
(statearr_71818_71844[(1)] = (11));

} else {
var statearr_71819_71845 = state_71806__$1;
(statearr_71819_71845[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (5))){
var inst_71783 = (state_71806[(7)]);
var state_71806__$1 = state_71806;
var statearr_71820_71846 = state_71806__$1;
(statearr_71820_71846[(2)] = inst_71783);

(statearr_71820_71846[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (10))){
var inst_71802 = (state_71806[(2)]);
var state_71806__$1 = state_71806;
var statearr_71821_71847 = state_71806__$1;
(statearr_71821_71847[(2)] = inst_71802);

(statearr_71821_71847[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71807 === (8))){
var inst_71783 = (state_71806[(7)]);
var inst_71793 = cljs.core.next.call(null,inst_71783);
var inst_71783__$1 = inst_71793;
var state_71806__$1 = (function (){var statearr_71822 = state_71806;
(statearr_71822[(7)] = inst_71783__$1);

return statearr_71822;
})();
var statearr_71823_71848 = state_71806__$1;
(statearr_71823_71848[(2)] = null);

(statearr_71823_71848[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_71827 = [null,null,null,null,null,null,null,null];
(statearr_71827[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_71827[(1)] = (1));

return statearr_71827;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_71806){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_71806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e71828){if((e71828 instanceof Object)){
var ex__70824__auto__ = e71828;
var statearr_71829_71849 = state_71806;
(statearr_71829_71849[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_71806);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e71828;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71850 = state_71806;
state_71806 = G__71850;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_71806){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_71806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_71830 = f__70935__auto__.call(null);
(statearr_71830[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_71830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__66905__auto__ = (((_ == null))?null:_);
var m__66906__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,_);
} else {
var m__66906__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__66906__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m);
} else {
var m__66906__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async72076 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72076 = (function (ch,cs,meta72077){
this.ch = ch;
this.cs = cs;
this.meta72077 = meta72077;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_72078,meta72077__$1){
var self__ = this;
var _72078__$1 = this;
return (new cljs.core.async.t_cljs$core$async72076(self__.ch,self__.cs,meta72077__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_72078){
var self__ = this;
var _72078__$1 = this;
return self__.meta72077;
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta72077","meta72077",-609613798,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async72076.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72076.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72076";

cljs.core.async.t_cljs$core$async72076.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async72076");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async72076 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async72076(ch__$1,cs__$1,meta72077){
return (new cljs.core.async.t_cljs$core$async72076(ch__$1,cs__$1,meta72077));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async72076(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__70934__auto___72301 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___72301,cs,m,dchan,dctr,done){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___72301,cs,m,dchan,dctr,done){
return (function (state_72213){
var state_val_72214 = (state_72213[(1)]);
if((state_val_72214 === (7))){
var inst_72209 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72215_72302 = state_72213__$1;
(statearr_72215_72302[(2)] = inst_72209);

(statearr_72215_72302[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (20))){
var inst_72112 = (state_72213[(7)]);
var inst_72124 = cljs.core.first.call(null,inst_72112);
var inst_72125 = cljs.core.nth.call(null,inst_72124,(0),null);
var inst_72126 = cljs.core.nth.call(null,inst_72124,(1),null);
var state_72213__$1 = (function (){var statearr_72216 = state_72213;
(statearr_72216[(8)] = inst_72125);

return statearr_72216;
})();
if(cljs.core.truth_(inst_72126)){
var statearr_72217_72303 = state_72213__$1;
(statearr_72217_72303[(1)] = (22));

} else {
var statearr_72218_72304 = state_72213__$1;
(statearr_72218_72304[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (27))){
var inst_72161 = (state_72213[(9)]);
var inst_72081 = (state_72213[(10)]);
var inst_72154 = (state_72213[(11)]);
var inst_72156 = (state_72213[(12)]);
var inst_72161__$1 = cljs.core._nth.call(null,inst_72154,inst_72156);
var inst_72162 = cljs.core.async.put_BANG_.call(null,inst_72161__$1,inst_72081,done);
var state_72213__$1 = (function (){var statearr_72219 = state_72213;
(statearr_72219[(9)] = inst_72161__$1);

return statearr_72219;
})();
if(cljs.core.truth_(inst_72162)){
var statearr_72220_72305 = state_72213__$1;
(statearr_72220_72305[(1)] = (30));

} else {
var statearr_72221_72306 = state_72213__$1;
(statearr_72221_72306[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (1))){
var state_72213__$1 = state_72213;
var statearr_72222_72307 = state_72213__$1;
(statearr_72222_72307[(2)] = null);

(statearr_72222_72307[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (24))){
var inst_72112 = (state_72213[(7)]);
var inst_72131 = (state_72213[(2)]);
var inst_72132 = cljs.core.next.call(null,inst_72112);
var inst_72090 = inst_72132;
var inst_72091 = null;
var inst_72092 = (0);
var inst_72093 = (0);
var state_72213__$1 = (function (){var statearr_72223 = state_72213;
(statearr_72223[(13)] = inst_72090);

(statearr_72223[(14)] = inst_72092);

(statearr_72223[(15)] = inst_72093);

(statearr_72223[(16)] = inst_72091);

(statearr_72223[(17)] = inst_72131);

return statearr_72223;
})();
var statearr_72224_72308 = state_72213__$1;
(statearr_72224_72308[(2)] = null);

(statearr_72224_72308[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (39))){
var state_72213__$1 = state_72213;
var statearr_72228_72309 = state_72213__$1;
(statearr_72228_72309[(2)] = null);

(statearr_72228_72309[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (4))){
var inst_72081 = (state_72213[(10)]);
var inst_72081__$1 = (state_72213[(2)]);
var inst_72082 = (inst_72081__$1 == null);
var state_72213__$1 = (function (){var statearr_72229 = state_72213;
(statearr_72229[(10)] = inst_72081__$1);

return statearr_72229;
})();
if(cljs.core.truth_(inst_72082)){
var statearr_72230_72310 = state_72213__$1;
(statearr_72230_72310[(1)] = (5));

} else {
var statearr_72231_72311 = state_72213__$1;
(statearr_72231_72311[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (15))){
var inst_72090 = (state_72213[(13)]);
var inst_72092 = (state_72213[(14)]);
var inst_72093 = (state_72213[(15)]);
var inst_72091 = (state_72213[(16)]);
var inst_72108 = (state_72213[(2)]);
var inst_72109 = (inst_72093 + (1));
var tmp72225 = inst_72090;
var tmp72226 = inst_72092;
var tmp72227 = inst_72091;
var inst_72090__$1 = tmp72225;
var inst_72091__$1 = tmp72227;
var inst_72092__$1 = tmp72226;
var inst_72093__$1 = inst_72109;
var state_72213__$1 = (function (){var statearr_72232 = state_72213;
(statearr_72232[(18)] = inst_72108);

(statearr_72232[(13)] = inst_72090__$1);

(statearr_72232[(14)] = inst_72092__$1);

(statearr_72232[(15)] = inst_72093__$1);

(statearr_72232[(16)] = inst_72091__$1);

return statearr_72232;
})();
var statearr_72233_72312 = state_72213__$1;
(statearr_72233_72312[(2)] = null);

(statearr_72233_72312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (21))){
var inst_72135 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72237_72313 = state_72213__$1;
(statearr_72237_72313[(2)] = inst_72135);

(statearr_72237_72313[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (31))){
var inst_72161 = (state_72213[(9)]);
var inst_72165 = done.call(null,null);
var inst_72166 = cljs.core.async.untap_STAR_.call(null,m,inst_72161);
var state_72213__$1 = (function (){var statearr_72238 = state_72213;
(statearr_72238[(19)] = inst_72165);

return statearr_72238;
})();
var statearr_72239_72314 = state_72213__$1;
(statearr_72239_72314[(2)] = inst_72166);

(statearr_72239_72314[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (32))){
var inst_72155 = (state_72213[(20)]);
var inst_72153 = (state_72213[(21)]);
var inst_72154 = (state_72213[(11)]);
var inst_72156 = (state_72213[(12)]);
var inst_72168 = (state_72213[(2)]);
var inst_72169 = (inst_72156 + (1));
var tmp72234 = inst_72155;
var tmp72235 = inst_72153;
var tmp72236 = inst_72154;
var inst_72153__$1 = tmp72235;
var inst_72154__$1 = tmp72236;
var inst_72155__$1 = tmp72234;
var inst_72156__$1 = inst_72169;
var state_72213__$1 = (function (){var statearr_72240 = state_72213;
(statearr_72240[(20)] = inst_72155__$1);

(statearr_72240[(21)] = inst_72153__$1);

(statearr_72240[(22)] = inst_72168);

(statearr_72240[(11)] = inst_72154__$1);

(statearr_72240[(12)] = inst_72156__$1);

return statearr_72240;
})();
var statearr_72241_72315 = state_72213__$1;
(statearr_72241_72315[(2)] = null);

(statearr_72241_72315[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (40))){
var inst_72181 = (state_72213[(23)]);
var inst_72185 = done.call(null,null);
var inst_72186 = cljs.core.async.untap_STAR_.call(null,m,inst_72181);
var state_72213__$1 = (function (){var statearr_72242 = state_72213;
(statearr_72242[(24)] = inst_72185);

return statearr_72242;
})();
var statearr_72243_72316 = state_72213__$1;
(statearr_72243_72316[(2)] = inst_72186);

(statearr_72243_72316[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (33))){
var inst_72172 = (state_72213[(25)]);
var inst_72174 = cljs.core.chunked_seq_QMARK_.call(null,inst_72172);
var state_72213__$1 = state_72213;
if(inst_72174){
var statearr_72244_72317 = state_72213__$1;
(statearr_72244_72317[(1)] = (36));

} else {
var statearr_72245_72318 = state_72213__$1;
(statearr_72245_72318[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (13))){
var inst_72102 = (state_72213[(26)]);
var inst_72105 = cljs.core.async.close_BANG_.call(null,inst_72102);
var state_72213__$1 = state_72213;
var statearr_72246_72319 = state_72213__$1;
(statearr_72246_72319[(2)] = inst_72105);

(statearr_72246_72319[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (22))){
var inst_72125 = (state_72213[(8)]);
var inst_72128 = cljs.core.async.close_BANG_.call(null,inst_72125);
var state_72213__$1 = state_72213;
var statearr_72247_72320 = state_72213__$1;
(statearr_72247_72320[(2)] = inst_72128);

(statearr_72247_72320[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (36))){
var inst_72172 = (state_72213[(25)]);
var inst_72176 = cljs.core.chunk_first.call(null,inst_72172);
var inst_72177 = cljs.core.chunk_rest.call(null,inst_72172);
var inst_72178 = cljs.core.count.call(null,inst_72176);
var inst_72153 = inst_72177;
var inst_72154 = inst_72176;
var inst_72155 = inst_72178;
var inst_72156 = (0);
var state_72213__$1 = (function (){var statearr_72248 = state_72213;
(statearr_72248[(20)] = inst_72155);

(statearr_72248[(21)] = inst_72153);

(statearr_72248[(11)] = inst_72154);

(statearr_72248[(12)] = inst_72156);

return statearr_72248;
})();
var statearr_72249_72321 = state_72213__$1;
(statearr_72249_72321[(2)] = null);

(statearr_72249_72321[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (41))){
var inst_72172 = (state_72213[(25)]);
var inst_72188 = (state_72213[(2)]);
var inst_72189 = cljs.core.next.call(null,inst_72172);
var inst_72153 = inst_72189;
var inst_72154 = null;
var inst_72155 = (0);
var inst_72156 = (0);
var state_72213__$1 = (function (){var statearr_72250 = state_72213;
(statearr_72250[(27)] = inst_72188);

(statearr_72250[(20)] = inst_72155);

(statearr_72250[(21)] = inst_72153);

(statearr_72250[(11)] = inst_72154);

(statearr_72250[(12)] = inst_72156);

return statearr_72250;
})();
var statearr_72251_72322 = state_72213__$1;
(statearr_72251_72322[(2)] = null);

(statearr_72251_72322[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (43))){
var state_72213__$1 = state_72213;
var statearr_72252_72323 = state_72213__$1;
(statearr_72252_72323[(2)] = null);

(statearr_72252_72323[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (29))){
var inst_72197 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72253_72324 = state_72213__$1;
(statearr_72253_72324[(2)] = inst_72197);

(statearr_72253_72324[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (44))){
var inst_72206 = (state_72213[(2)]);
var state_72213__$1 = (function (){var statearr_72254 = state_72213;
(statearr_72254[(28)] = inst_72206);

return statearr_72254;
})();
var statearr_72255_72325 = state_72213__$1;
(statearr_72255_72325[(2)] = null);

(statearr_72255_72325[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (6))){
var inst_72145 = (state_72213[(29)]);
var inst_72144 = cljs.core.deref.call(null,cs);
var inst_72145__$1 = cljs.core.keys.call(null,inst_72144);
var inst_72146 = cljs.core.count.call(null,inst_72145__$1);
var inst_72147 = cljs.core.reset_BANG_.call(null,dctr,inst_72146);
var inst_72152 = cljs.core.seq.call(null,inst_72145__$1);
var inst_72153 = inst_72152;
var inst_72154 = null;
var inst_72155 = (0);
var inst_72156 = (0);
var state_72213__$1 = (function (){var statearr_72256 = state_72213;
(statearr_72256[(20)] = inst_72155);

(statearr_72256[(30)] = inst_72147);

(statearr_72256[(21)] = inst_72153);

(statearr_72256[(29)] = inst_72145__$1);

(statearr_72256[(11)] = inst_72154);

(statearr_72256[(12)] = inst_72156);

return statearr_72256;
})();
var statearr_72257_72326 = state_72213__$1;
(statearr_72257_72326[(2)] = null);

(statearr_72257_72326[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (28))){
var inst_72172 = (state_72213[(25)]);
var inst_72153 = (state_72213[(21)]);
var inst_72172__$1 = cljs.core.seq.call(null,inst_72153);
var state_72213__$1 = (function (){var statearr_72258 = state_72213;
(statearr_72258[(25)] = inst_72172__$1);

return statearr_72258;
})();
if(inst_72172__$1){
var statearr_72259_72327 = state_72213__$1;
(statearr_72259_72327[(1)] = (33));

} else {
var statearr_72260_72328 = state_72213__$1;
(statearr_72260_72328[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (25))){
var inst_72155 = (state_72213[(20)]);
var inst_72156 = (state_72213[(12)]);
var inst_72158 = (inst_72156 < inst_72155);
var inst_72159 = inst_72158;
var state_72213__$1 = state_72213;
if(cljs.core.truth_(inst_72159)){
var statearr_72261_72329 = state_72213__$1;
(statearr_72261_72329[(1)] = (27));

} else {
var statearr_72262_72330 = state_72213__$1;
(statearr_72262_72330[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (34))){
var state_72213__$1 = state_72213;
var statearr_72263_72331 = state_72213__$1;
(statearr_72263_72331[(2)] = null);

(statearr_72263_72331[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (17))){
var state_72213__$1 = state_72213;
var statearr_72264_72332 = state_72213__$1;
(statearr_72264_72332[(2)] = null);

(statearr_72264_72332[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (3))){
var inst_72211 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72213__$1,inst_72211);
} else {
if((state_val_72214 === (12))){
var inst_72140 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72265_72333 = state_72213__$1;
(statearr_72265_72333[(2)] = inst_72140);

(statearr_72265_72333[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (2))){
var state_72213__$1 = state_72213;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72213__$1,(4),ch);
} else {
if((state_val_72214 === (23))){
var state_72213__$1 = state_72213;
var statearr_72266_72334 = state_72213__$1;
(statearr_72266_72334[(2)] = null);

(statearr_72266_72334[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (35))){
var inst_72195 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72267_72335 = state_72213__$1;
(statearr_72267_72335[(2)] = inst_72195);

(statearr_72267_72335[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (19))){
var inst_72112 = (state_72213[(7)]);
var inst_72116 = cljs.core.chunk_first.call(null,inst_72112);
var inst_72117 = cljs.core.chunk_rest.call(null,inst_72112);
var inst_72118 = cljs.core.count.call(null,inst_72116);
var inst_72090 = inst_72117;
var inst_72091 = inst_72116;
var inst_72092 = inst_72118;
var inst_72093 = (0);
var state_72213__$1 = (function (){var statearr_72268 = state_72213;
(statearr_72268[(13)] = inst_72090);

(statearr_72268[(14)] = inst_72092);

(statearr_72268[(15)] = inst_72093);

(statearr_72268[(16)] = inst_72091);

return statearr_72268;
})();
var statearr_72269_72336 = state_72213__$1;
(statearr_72269_72336[(2)] = null);

(statearr_72269_72336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (11))){
var inst_72090 = (state_72213[(13)]);
var inst_72112 = (state_72213[(7)]);
var inst_72112__$1 = cljs.core.seq.call(null,inst_72090);
var state_72213__$1 = (function (){var statearr_72270 = state_72213;
(statearr_72270[(7)] = inst_72112__$1);

return statearr_72270;
})();
if(inst_72112__$1){
var statearr_72271_72337 = state_72213__$1;
(statearr_72271_72337[(1)] = (16));

} else {
var statearr_72272_72338 = state_72213__$1;
(statearr_72272_72338[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (9))){
var inst_72142 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72273_72339 = state_72213__$1;
(statearr_72273_72339[(2)] = inst_72142);

(statearr_72273_72339[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (5))){
var inst_72088 = cljs.core.deref.call(null,cs);
var inst_72089 = cljs.core.seq.call(null,inst_72088);
var inst_72090 = inst_72089;
var inst_72091 = null;
var inst_72092 = (0);
var inst_72093 = (0);
var state_72213__$1 = (function (){var statearr_72274 = state_72213;
(statearr_72274[(13)] = inst_72090);

(statearr_72274[(14)] = inst_72092);

(statearr_72274[(15)] = inst_72093);

(statearr_72274[(16)] = inst_72091);

return statearr_72274;
})();
var statearr_72275_72340 = state_72213__$1;
(statearr_72275_72340[(2)] = null);

(statearr_72275_72340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (14))){
var state_72213__$1 = state_72213;
var statearr_72276_72341 = state_72213__$1;
(statearr_72276_72341[(2)] = null);

(statearr_72276_72341[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (45))){
var inst_72203 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72277_72342 = state_72213__$1;
(statearr_72277_72342[(2)] = inst_72203);

(statearr_72277_72342[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (26))){
var inst_72145 = (state_72213[(29)]);
var inst_72199 = (state_72213[(2)]);
var inst_72200 = cljs.core.seq.call(null,inst_72145);
var state_72213__$1 = (function (){var statearr_72278 = state_72213;
(statearr_72278[(31)] = inst_72199);

return statearr_72278;
})();
if(inst_72200){
var statearr_72279_72343 = state_72213__$1;
(statearr_72279_72343[(1)] = (42));

} else {
var statearr_72280_72344 = state_72213__$1;
(statearr_72280_72344[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (16))){
var inst_72112 = (state_72213[(7)]);
var inst_72114 = cljs.core.chunked_seq_QMARK_.call(null,inst_72112);
var state_72213__$1 = state_72213;
if(inst_72114){
var statearr_72281_72345 = state_72213__$1;
(statearr_72281_72345[(1)] = (19));

} else {
var statearr_72282_72346 = state_72213__$1;
(statearr_72282_72346[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (38))){
var inst_72192 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72283_72347 = state_72213__$1;
(statearr_72283_72347[(2)] = inst_72192);

(statearr_72283_72347[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (30))){
var state_72213__$1 = state_72213;
var statearr_72284_72348 = state_72213__$1;
(statearr_72284_72348[(2)] = null);

(statearr_72284_72348[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (10))){
var inst_72093 = (state_72213[(15)]);
var inst_72091 = (state_72213[(16)]);
var inst_72101 = cljs.core._nth.call(null,inst_72091,inst_72093);
var inst_72102 = cljs.core.nth.call(null,inst_72101,(0),null);
var inst_72103 = cljs.core.nth.call(null,inst_72101,(1),null);
var state_72213__$1 = (function (){var statearr_72285 = state_72213;
(statearr_72285[(26)] = inst_72102);

return statearr_72285;
})();
if(cljs.core.truth_(inst_72103)){
var statearr_72286_72349 = state_72213__$1;
(statearr_72286_72349[(1)] = (13));

} else {
var statearr_72287_72350 = state_72213__$1;
(statearr_72287_72350[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (18))){
var inst_72138 = (state_72213[(2)]);
var state_72213__$1 = state_72213;
var statearr_72288_72351 = state_72213__$1;
(statearr_72288_72351[(2)] = inst_72138);

(statearr_72288_72351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (42))){
var state_72213__$1 = state_72213;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72213__$1,(45),dchan);
} else {
if((state_val_72214 === (37))){
var inst_72172 = (state_72213[(25)]);
var inst_72081 = (state_72213[(10)]);
var inst_72181 = (state_72213[(23)]);
var inst_72181__$1 = cljs.core.first.call(null,inst_72172);
var inst_72182 = cljs.core.async.put_BANG_.call(null,inst_72181__$1,inst_72081,done);
var state_72213__$1 = (function (){var statearr_72289 = state_72213;
(statearr_72289[(23)] = inst_72181__$1);

return statearr_72289;
})();
if(cljs.core.truth_(inst_72182)){
var statearr_72290_72352 = state_72213__$1;
(statearr_72290_72352[(1)] = (39));

} else {
var statearr_72291_72353 = state_72213__$1;
(statearr_72291_72353[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72214 === (8))){
var inst_72092 = (state_72213[(14)]);
var inst_72093 = (state_72213[(15)]);
var inst_72095 = (inst_72093 < inst_72092);
var inst_72096 = inst_72095;
var state_72213__$1 = state_72213;
if(cljs.core.truth_(inst_72096)){
var statearr_72292_72354 = state_72213__$1;
(statearr_72292_72354[(1)] = (10));

} else {
var statearr_72293_72355 = state_72213__$1;
(statearr_72293_72355[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___72301,cs,m,dchan,dctr,done))
;
return ((function (switch__70820__auto__,c__70934__auto___72301,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__70821__auto__ = null;
var cljs$core$async$mult_$_state_machine__70821__auto____0 = (function (){
var statearr_72297 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72297[(0)] = cljs$core$async$mult_$_state_machine__70821__auto__);

(statearr_72297[(1)] = (1));

return statearr_72297;
});
var cljs$core$async$mult_$_state_machine__70821__auto____1 = (function (state_72213){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_72213);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e72298){if((e72298 instanceof Object)){
var ex__70824__auto__ = e72298;
var statearr_72299_72356 = state_72213;
(statearr_72299_72356[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72213);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72298;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72357 = state_72213;
state_72213 = G__72357;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__70821__auto__ = function(state_72213){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__70821__auto____1.call(this,state_72213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__70821__auto____0;
cljs$core$async$mult_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__70821__auto____1;
return cljs$core$async$mult_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___72301,cs,m,dchan,dctr,done))
})();
var state__70936__auto__ = (function (){var statearr_72300 = f__70935__auto__.call(null);
(statearr_72300[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___72301);

return statearr_72300;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___72301,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args72358 = [];
var len__67408__auto___72361 = arguments.length;
var i__67409__auto___72362 = (0);
while(true){
if((i__67409__auto___72362 < len__67408__auto___72361)){
args72358.push((arguments[i__67409__auto___72362]));

var G__72363 = (i__67409__auto___72362 + (1));
i__67409__auto___72362 = G__72363;
continue;
} else {
}
break;
}

var G__72360 = args72358.length;
switch (G__72360) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72358.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m);
} else {
var m__66906__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,state_map);
} else {
var m__66906__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__66905__auto__ = (((m == null))?null:m);
var m__66906__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,m,mode);
} else {
var m__66906__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__67415__auto__ = [];
var len__67408__auto___72375 = arguments.length;
var i__67409__auto___72376 = (0);
while(true){
if((i__67409__auto___72376 < len__67408__auto___72375)){
args__67415__auto__.push((arguments[i__67409__auto___72376]));

var G__72377 = (i__67409__auto___72376 + (1));
i__67409__auto___72376 = G__72377;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((3) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__67416__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__72369){
var map__72370 = p__72369;
var map__72370__$1 = ((((!((map__72370 == null)))?((((map__72370.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__72370.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__72370):map__72370);
var opts = map__72370__$1;
var statearr_72372_72378 = state;
(statearr_72372_72378[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__72370,map__72370__$1,opts){
return (function (val){
var statearr_72373_72379 = state;
(statearr_72373_72379[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__72370,map__72370__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_72374_72380 = state;
(statearr_72374_72380[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq72365){
var G__72366 = cljs.core.first.call(null,seq72365);
var seq72365__$1 = cljs.core.next.call(null,seq72365);
var G__72367 = cljs.core.first.call(null,seq72365__$1);
var seq72365__$2 = cljs.core.next.call(null,seq72365__$1);
var G__72368 = cljs.core.first.call(null,seq72365__$2);
var seq72365__$3 = cljs.core.next.call(null,seq72365__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__72366,G__72367,G__72368,seq72365__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async72548 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72548 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta72549){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta72549 = meta72549;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_72550,meta72549__$1){
var self__ = this;
var _72550__$1 = this;
return (new cljs.core.async.t_cljs$core$async72548(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta72549__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_72550){
var self__ = this;
var _72550__$1 = this;
return self__.meta72549;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta72549","meta72549",-194645209,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async72548.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72548.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72548";

cljs.core.async.t_cljs$core$async72548.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async72548");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async72548 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async72548(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta72549){
return (new cljs.core.async.t_cljs$core$async72548(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta72549));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async72548(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70934__auto___72715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___72715,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___72715,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_72652){
var state_val_72653 = (state_72652[(1)]);
if((state_val_72653 === (7))){
var inst_72567 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
var statearr_72654_72716 = state_72652__$1;
(statearr_72654_72716[(2)] = inst_72567);

(statearr_72654_72716[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (20))){
var inst_72579 = (state_72652[(7)]);
var state_72652__$1 = state_72652;
var statearr_72655_72717 = state_72652__$1;
(statearr_72655_72717[(2)] = inst_72579);

(statearr_72655_72717[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (27))){
var state_72652__$1 = state_72652;
var statearr_72656_72718 = state_72652__$1;
(statearr_72656_72718[(2)] = null);

(statearr_72656_72718[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (1))){
var inst_72554 = (state_72652[(8)]);
var inst_72554__$1 = calc_state.call(null);
var inst_72556 = (inst_72554__$1 == null);
var inst_72557 = cljs.core.not.call(null,inst_72556);
var state_72652__$1 = (function (){var statearr_72657 = state_72652;
(statearr_72657[(8)] = inst_72554__$1);

return statearr_72657;
})();
if(inst_72557){
var statearr_72658_72719 = state_72652__$1;
(statearr_72658_72719[(1)] = (2));

} else {
var statearr_72659_72720 = state_72652__$1;
(statearr_72659_72720[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (24))){
var inst_72612 = (state_72652[(9)]);
var inst_72626 = (state_72652[(10)]);
var inst_72603 = (state_72652[(11)]);
var inst_72626__$1 = inst_72603.call(null,inst_72612);
var state_72652__$1 = (function (){var statearr_72660 = state_72652;
(statearr_72660[(10)] = inst_72626__$1);

return statearr_72660;
})();
if(cljs.core.truth_(inst_72626__$1)){
var statearr_72661_72721 = state_72652__$1;
(statearr_72661_72721[(1)] = (29));

} else {
var statearr_72662_72722 = state_72652__$1;
(statearr_72662_72722[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (4))){
var inst_72570 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72570)){
var statearr_72663_72723 = state_72652__$1;
(statearr_72663_72723[(1)] = (8));

} else {
var statearr_72664_72724 = state_72652__$1;
(statearr_72664_72724[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (15))){
var inst_72597 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72597)){
var statearr_72665_72725 = state_72652__$1;
(statearr_72665_72725[(1)] = (19));

} else {
var statearr_72666_72726 = state_72652__$1;
(statearr_72666_72726[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (21))){
var inst_72602 = (state_72652[(12)]);
var inst_72602__$1 = (state_72652[(2)]);
var inst_72603 = cljs.core.get.call(null,inst_72602__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_72604 = cljs.core.get.call(null,inst_72602__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_72605 = cljs.core.get.call(null,inst_72602__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_72652__$1 = (function (){var statearr_72667 = state_72652;
(statearr_72667[(12)] = inst_72602__$1);

(statearr_72667[(13)] = inst_72604);

(statearr_72667[(11)] = inst_72603);

return statearr_72667;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_72652__$1,(22),inst_72605);
} else {
if((state_val_72653 === (31))){
var inst_72634 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72634)){
var statearr_72668_72727 = state_72652__$1;
(statearr_72668_72727[(1)] = (32));

} else {
var statearr_72669_72728 = state_72652__$1;
(statearr_72669_72728[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (32))){
var inst_72611 = (state_72652[(14)]);
var state_72652__$1 = state_72652;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72652__$1,(35),out,inst_72611);
} else {
if((state_val_72653 === (33))){
var inst_72602 = (state_72652[(12)]);
var inst_72579 = inst_72602;
var state_72652__$1 = (function (){var statearr_72670 = state_72652;
(statearr_72670[(7)] = inst_72579);

return statearr_72670;
})();
var statearr_72671_72729 = state_72652__$1;
(statearr_72671_72729[(2)] = null);

(statearr_72671_72729[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (13))){
var inst_72579 = (state_72652[(7)]);
var inst_72586 = inst_72579.cljs$lang$protocol_mask$partition0$;
var inst_72587 = (inst_72586 & (64));
var inst_72588 = inst_72579.cljs$core$ISeq$;
var inst_72589 = (cljs.core.PROTOCOL_SENTINEL === inst_72588);
var inst_72590 = (inst_72587) || (inst_72589);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72590)){
var statearr_72672_72730 = state_72652__$1;
(statearr_72672_72730[(1)] = (16));

} else {
var statearr_72673_72731 = state_72652__$1;
(statearr_72673_72731[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (22))){
var inst_72612 = (state_72652[(9)]);
var inst_72611 = (state_72652[(14)]);
var inst_72610 = (state_72652[(2)]);
var inst_72611__$1 = cljs.core.nth.call(null,inst_72610,(0),null);
var inst_72612__$1 = cljs.core.nth.call(null,inst_72610,(1),null);
var inst_72613 = (inst_72611__$1 == null);
var inst_72614 = cljs.core._EQ_.call(null,inst_72612__$1,change);
var inst_72615 = (inst_72613) || (inst_72614);
var state_72652__$1 = (function (){var statearr_72674 = state_72652;
(statearr_72674[(9)] = inst_72612__$1);

(statearr_72674[(14)] = inst_72611__$1);

return statearr_72674;
})();
if(cljs.core.truth_(inst_72615)){
var statearr_72675_72732 = state_72652__$1;
(statearr_72675_72732[(1)] = (23));

} else {
var statearr_72676_72733 = state_72652__$1;
(statearr_72676_72733[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (36))){
var inst_72602 = (state_72652[(12)]);
var inst_72579 = inst_72602;
var state_72652__$1 = (function (){var statearr_72677 = state_72652;
(statearr_72677[(7)] = inst_72579);

return statearr_72677;
})();
var statearr_72678_72734 = state_72652__$1;
(statearr_72678_72734[(2)] = null);

(statearr_72678_72734[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (29))){
var inst_72626 = (state_72652[(10)]);
var state_72652__$1 = state_72652;
var statearr_72679_72735 = state_72652__$1;
(statearr_72679_72735[(2)] = inst_72626);

(statearr_72679_72735[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (6))){
var state_72652__$1 = state_72652;
var statearr_72680_72736 = state_72652__$1;
(statearr_72680_72736[(2)] = false);

(statearr_72680_72736[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (28))){
var inst_72622 = (state_72652[(2)]);
var inst_72623 = calc_state.call(null);
var inst_72579 = inst_72623;
var state_72652__$1 = (function (){var statearr_72681 = state_72652;
(statearr_72681[(7)] = inst_72579);

(statearr_72681[(15)] = inst_72622);

return statearr_72681;
})();
var statearr_72682_72737 = state_72652__$1;
(statearr_72682_72737[(2)] = null);

(statearr_72682_72737[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (25))){
var inst_72648 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
var statearr_72683_72738 = state_72652__$1;
(statearr_72683_72738[(2)] = inst_72648);

(statearr_72683_72738[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (34))){
var inst_72646 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
var statearr_72684_72739 = state_72652__$1;
(statearr_72684_72739[(2)] = inst_72646);

(statearr_72684_72739[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (17))){
var state_72652__$1 = state_72652;
var statearr_72685_72740 = state_72652__$1;
(statearr_72685_72740[(2)] = false);

(statearr_72685_72740[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (3))){
var state_72652__$1 = state_72652;
var statearr_72686_72741 = state_72652__$1;
(statearr_72686_72741[(2)] = false);

(statearr_72686_72741[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (12))){
var inst_72650 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72652__$1,inst_72650);
} else {
if((state_val_72653 === (2))){
var inst_72554 = (state_72652[(8)]);
var inst_72559 = inst_72554.cljs$lang$protocol_mask$partition0$;
var inst_72560 = (inst_72559 & (64));
var inst_72561 = inst_72554.cljs$core$ISeq$;
var inst_72562 = (cljs.core.PROTOCOL_SENTINEL === inst_72561);
var inst_72563 = (inst_72560) || (inst_72562);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72563)){
var statearr_72687_72742 = state_72652__$1;
(statearr_72687_72742[(1)] = (5));

} else {
var statearr_72688_72743 = state_72652__$1;
(statearr_72688_72743[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (23))){
var inst_72611 = (state_72652[(14)]);
var inst_72617 = (inst_72611 == null);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72617)){
var statearr_72689_72744 = state_72652__$1;
(statearr_72689_72744[(1)] = (26));

} else {
var statearr_72690_72745 = state_72652__$1;
(statearr_72690_72745[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (35))){
var inst_72637 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
if(cljs.core.truth_(inst_72637)){
var statearr_72691_72746 = state_72652__$1;
(statearr_72691_72746[(1)] = (36));

} else {
var statearr_72692_72747 = state_72652__$1;
(statearr_72692_72747[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (19))){
var inst_72579 = (state_72652[(7)]);
var inst_72599 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72579);
var state_72652__$1 = state_72652;
var statearr_72693_72748 = state_72652__$1;
(statearr_72693_72748[(2)] = inst_72599);

(statearr_72693_72748[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (11))){
var inst_72579 = (state_72652[(7)]);
var inst_72583 = (inst_72579 == null);
var inst_72584 = cljs.core.not.call(null,inst_72583);
var state_72652__$1 = state_72652;
if(inst_72584){
var statearr_72694_72749 = state_72652__$1;
(statearr_72694_72749[(1)] = (13));

} else {
var statearr_72695_72750 = state_72652__$1;
(statearr_72695_72750[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (9))){
var inst_72554 = (state_72652[(8)]);
var state_72652__$1 = state_72652;
var statearr_72696_72751 = state_72652__$1;
(statearr_72696_72751[(2)] = inst_72554);

(statearr_72696_72751[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (5))){
var state_72652__$1 = state_72652;
var statearr_72697_72752 = state_72652__$1;
(statearr_72697_72752[(2)] = true);

(statearr_72697_72752[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (14))){
var state_72652__$1 = state_72652;
var statearr_72698_72753 = state_72652__$1;
(statearr_72698_72753[(2)] = false);

(statearr_72698_72753[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (26))){
var inst_72612 = (state_72652[(9)]);
var inst_72619 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_72612);
var state_72652__$1 = state_72652;
var statearr_72699_72754 = state_72652__$1;
(statearr_72699_72754[(2)] = inst_72619);

(statearr_72699_72754[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (16))){
var state_72652__$1 = state_72652;
var statearr_72700_72755 = state_72652__$1;
(statearr_72700_72755[(2)] = true);

(statearr_72700_72755[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (38))){
var inst_72642 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
var statearr_72701_72756 = state_72652__$1;
(statearr_72701_72756[(2)] = inst_72642);

(statearr_72701_72756[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (30))){
var inst_72612 = (state_72652[(9)]);
var inst_72604 = (state_72652[(13)]);
var inst_72603 = (state_72652[(11)]);
var inst_72629 = cljs.core.empty_QMARK_.call(null,inst_72603);
var inst_72630 = inst_72604.call(null,inst_72612);
var inst_72631 = cljs.core.not.call(null,inst_72630);
var inst_72632 = (inst_72629) && (inst_72631);
var state_72652__$1 = state_72652;
var statearr_72702_72757 = state_72652__$1;
(statearr_72702_72757[(2)] = inst_72632);

(statearr_72702_72757[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (10))){
var inst_72554 = (state_72652[(8)]);
var inst_72575 = (state_72652[(2)]);
var inst_72576 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_72577 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_72578 = cljs.core.get.call(null,inst_72575,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_72579 = inst_72554;
var state_72652__$1 = (function (){var statearr_72703 = state_72652;
(statearr_72703[(7)] = inst_72579);

(statearr_72703[(16)] = inst_72576);

(statearr_72703[(17)] = inst_72578);

(statearr_72703[(18)] = inst_72577);

return statearr_72703;
})();
var statearr_72704_72758 = state_72652__$1;
(statearr_72704_72758[(2)] = null);

(statearr_72704_72758[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (18))){
var inst_72594 = (state_72652[(2)]);
var state_72652__$1 = state_72652;
var statearr_72705_72759 = state_72652__$1;
(statearr_72705_72759[(2)] = inst_72594);

(statearr_72705_72759[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (37))){
var state_72652__$1 = state_72652;
var statearr_72706_72760 = state_72652__$1;
(statearr_72706_72760[(2)] = null);

(statearr_72706_72760[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72653 === (8))){
var inst_72554 = (state_72652[(8)]);
var inst_72572 = cljs.core.apply.call(null,cljs.core.hash_map,inst_72554);
var state_72652__$1 = state_72652;
var statearr_72707_72761 = state_72652__$1;
(statearr_72707_72761[(2)] = inst_72572);

(statearr_72707_72761[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___72715,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__70820__auto__,c__70934__auto___72715,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__70821__auto__ = null;
var cljs$core$async$mix_$_state_machine__70821__auto____0 = (function (){
var statearr_72711 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72711[(0)] = cljs$core$async$mix_$_state_machine__70821__auto__);

(statearr_72711[(1)] = (1));

return statearr_72711;
});
var cljs$core$async$mix_$_state_machine__70821__auto____1 = (function (state_72652){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_72652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e72712){if((e72712 instanceof Object)){
var ex__70824__auto__ = e72712;
var statearr_72713_72762 = state_72652;
(statearr_72713_72762[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72652);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72712;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72763 = state_72652;
state_72652 = G__72763;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__70821__auto__ = function(state_72652){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__70821__auto____1.call(this,state_72652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__70821__auto____0;
cljs$core$async$mix_$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__70821__auto____1;
return cljs$core$async$mix_$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___72715,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__70936__auto__ = (function (){var statearr_72714 = f__70935__auto__.call(null);
(statearr_72714[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___72715);

return statearr_72714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___72715,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__66906__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p,v,ch);
} else {
var m__66906__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args72764 = [];
var len__67408__auto___72767 = arguments.length;
var i__67409__auto___72768 = (0);
while(true){
if((i__67409__auto___72768 < len__67408__auto___72767)){
args72764.push((arguments[i__67409__auto___72768]));

var G__72769 = (i__67409__auto___72768 + (1));
i__67409__auto___72768 = G__72769;
continue;
} else {
}
break;
}

var G__72766 = args72764.length;
switch (G__72766) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72764.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p);
} else {
var m__66906__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__66905__auto__ = (((p == null))?null:p);
var m__66906__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__66905__auto__)]);
if(!((m__66906__auto__ == null))){
return m__66906__auto__.call(null,p,v);
} else {
var m__66906__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__66906__auto____$1 == null))){
return m__66906__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args72772 = [];
var len__67408__auto___72897 = arguments.length;
var i__67409__auto___72898 = (0);
while(true){
if((i__67409__auto___72898 < len__67408__auto___72897)){
args72772.push((arguments[i__67409__auto___72898]));

var G__72899 = (i__67409__auto___72898 + (1));
i__67409__auto___72898 = G__72899;
continue;
} else {
}
break;
}

var G__72774 = args72772.length;
switch (G__72774) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72772.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__66187__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__66187__auto__,mults){
return (function (p1__72771_SHARP_){
if(cljs.core.truth_(p1__72771_SHARP_.call(null,topic))){
return p1__72771_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__72771_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__66187__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async72775 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async72775 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta72776){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta72776 = meta72776;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_72777,meta72776__$1){
var self__ = this;
var _72777__$1 = this;
return (new cljs.core.async.t_cljs$core$async72775(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta72776__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_72777){
var self__ = this;
var _72777__$1 = this;
return self__.meta72776;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta72776","meta72776",1019598814,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async72775.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async72775.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async72775";

cljs.core.async.t_cljs$core$async72775.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async72775");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async72775 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async72775(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta72776){
return (new cljs.core.async.t_cljs$core$async72775(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta72776));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async72775(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__70934__auto___72901 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___72901,mults,ensure_mult,p){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___72901,mults,ensure_mult,p){
return (function (state_72849){
var state_val_72850 = (state_72849[(1)]);
if((state_val_72850 === (7))){
var inst_72845 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72851_72902 = state_72849__$1;
(statearr_72851_72902[(2)] = inst_72845);

(statearr_72851_72902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (20))){
var state_72849__$1 = state_72849;
var statearr_72852_72903 = state_72849__$1;
(statearr_72852_72903[(2)] = null);

(statearr_72852_72903[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (1))){
var state_72849__$1 = state_72849;
var statearr_72853_72904 = state_72849__$1;
(statearr_72853_72904[(2)] = null);

(statearr_72853_72904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (24))){
var inst_72828 = (state_72849[(7)]);
var inst_72837 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_72828);
var state_72849__$1 = state_72849;
var statearr_72854_72905 = state_72849__$1;
(statearr_72854_72905[(2)] = inst_72837);

(statearr_72854_72905[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (4))){
var inst_72780 = (state_72849[(8)]);
var inst_72780__$1 = (state_72849[(2)]);
var inst_72781 = (inst_72780__$1 == null);
var state_72849__$1 = (function (){var statearr_72855 = state_72849;
(statearr_72855[(8)] = inst_72780__$1);

return statearr_72855;
})();
if(cljs.core.truth_(inst_72781)){
var statearr_72856_72906 = state_72849__$1;
(statearr_72856_72906[(1)] = (5));

} else {
var statearr_72857_72907 = state_72849__$1;
(statearr_72857_72907[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (15))){
var inst_72822 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72858_72908 = state_72849__$1;
(statearr_72858_72908[(2)] = inst_72822);

(statearr_72858_72908[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (21))){
var inst_72842 = (state_72849[(2)]);
var state_72849__$1 = (function (){var statearr_72859 = state_72849;
(statearr_72859[(9)] = inst_72842);

return statearr_72859;
})();
var statearr_72860_72909 = state_72849__$1;
(statearr_72860_72909[(2)] = null);

(statearr_72860_72909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (13))){
var inst_72804 = (state_72849[(10)]);
var inst_72806 = cljs.core.chunked_seq_QMARK_.call(null,inst_72804);
var state_72849__$1 = state_72849;
if(inst_72806){
var statearr_72861_72910 = state_72849__$1;
(statearr_72861_72910[(1)] = (16));

} else {
var statearr_72862_72911 = state_72849__$1;
(statearr_72862_72911[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (22))){
var inst_72834 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
if(cljs.core.truth_(inst_72834)){
var statearr_72863_72912 = state_72849__$1;
(statearr_72863_72912[(1)] = (23));

} else {
var statearr_72864_72913 = state_72849__$1;
(statearr_72864_72913[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (6))){
var inst_72828 = (state_72849[(7)]);
var inst_72780 = (state_72849[(8)]);
var inst_72830 = (state_72849[(11)]);
var inst_72828__$1 = topic_fn.call(null,inst_72780);
var inst_72829 = cljs.core.deref.call(null,mults);
var inst_72830__$1 = cljs.core.get.call(null,inst_72829,inst_72828__$1);
var state_72849__$1 = (function (){var statearr_72865 = state_72849;
(statearr_72865[(7)] = inst_72828__$1);

(statearr_72865[(11)] = inst_72830__$1);

return statearr_72865;
})();
if(cljs.core.truth_(inst_72830__$1)){
var statearr_72866_72914 = state_72849__$1;
(statearr_72866_72914[(1)] = (19));

} else {
var statearr_72867_72915 = state_72849__$1;
(statearr_72867_72915[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (25))){
var inst_72839 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72868_72916 = state_72849__$1;
(statearr_72868_72916[(2)] = inst_72839);

(statearr_72868_72916[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (17))){
var inst_72804 = (state_72849[(10)]);
var inst_72813 = cljs.core.first.call(null,inst_72804);
var inst_72814 = cljs.core.async.muxch_STAR_.call(null,inst_72813);
var inst_72815 = cljs.core.async.close_BANG_.call(null,inst_72814);
var inst_72816 = cljs.core.next.call(null,inst_72804);
var inst_72790 = inst_72816;
var inst_72791 = null;
var inst_72792 = (0);
var inst_72793 = (0);
var state_72849__$1 = (function (){var statearr_72869 = state_72849;
(statearr_72869[(12)] = inst_72790);

(statearr_72869[(13)] = inst_72792);

(statearr_72869[(14)] = inst_72815);

(statearr_72869[(15)] = inst_72791);

(statearr_72869[(16)] = inst_72793);

return statearr_72869;
})();
var statearr_72870_72917 = state_72849__$1;
(statearr_72870_72917[(2)] = null);

(statearr_72870_72917[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (3))){
var inst_72847 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72849__$1,inst_72847);
} else {
if((state_val_72850 === (12))){
var inst_72824 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72871_72918 = state_72849__$1;
(statearr_72871_72918[(2)] = inst_72824);

(statearr_72871_72918[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (2))){
var state_72849__$1 = state_72849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72849__$1,(4),ch);
} else {
if((state_val_72850 === (23))){
var state_72849__$1 = state_72849;
var statearr_72872_72919 = state_72849__$1;
(statearr_72872_72919[(2)] = null);

(statearr_72872_72919[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (19))){
var inst_72780 = (state_72849[(8)]);
var inst_72830 = (state_72849[(11)]);
var inst_72832 = cljs.core.async.muxch_STAR_.call(null,inst_72830);
var state_72849__$1 = state_72849;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72849__$1,(22),inst_72832,inst_72780);
} else {
if((state_val_72850 === (11))){
var inst_72790 = (state_72849[(12)]);
var inst_72804 = (state_72849[(10)]);
var inst_72804__$1 = cljs.core.seq.call(null,inst_72790);
var state_72849__$1 = (function (){var statearr_72873 = state_72849;
(statearr_72873[(10)] = inst_72804__$1);

return statearr_72873;
})();
if(inst_72804__$1){
var statearr_72874_72920 = state_72849__$1;
(statearr_72874_72920[(1)] = (13));

} else {
var statearr_72875_72921 = state_72849__$1;
(statearr_72875_72921[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (9))){
var inst_72826 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72876_72922 = state_72849__$1;
(statearr_72876_72922[(2)] = inst_72826);

(statearr_72876_72922[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (5))){
var inst_72787 = cljs.core.deref.call(null,mults);
var inst_72788 = cljs.core.vals.call(null,inst_72787);
var inst_72789 = cljs.core.seq.call(null,inst_72788);
var inst_72790 = inst_72789;
var inst_72791 = null;
var inst_72792 = (0);
var inst_72793 = (0);
var state_72849__$1 = (function (){var statearr_72877 = state_72849;
(statearr_72877[(12)] = inst_72790);

(statearr_72877[(13)] = inst_72792);

(statearr_72877[(15)] = inst_72791);

(statearr_72877[(16)] = inst_72793);

return statearr_72877;
})();
var statearr_72878_72923 = state_72849__$1;
(statearr_72878_72923[(2)] = null);

(statearr_72878_72923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (14))){
var state_72849__$1 = state_72849;
var statearr_72882_72924 = state_72849__$1;
(statearr_72882_72924[(2)] = null);

(statearr_72882_72924[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (16))){
var inst_72804 = (state_72849[(10)]);
var inst_72808 = cljs.core.chunk_first.call(null,inst_72804);
var inst_72809 = cljs.core.chunk_rest.call(null,inst_72804);
var inst_72810 = cljs.core.count.call(null,inst_72808);
var inst_72790 = inst_72809;
var inst_72791 = inst_72808;
var inst_72792 = inst_72810;
var inst_72793 = (0);
var state_72849__$1 = (function (){var statearr_72883 = state_72849;
(statearr_72883[(12)] = inst_72790);

(statearr_72883[(13)] = inst_72792);

(statearr_72883[(15)] = inst_72791);

(statearr_72883[(16)] = inst_72793);

return statearr_72883;
})();
var statearr_72884_72925 = state_72849__$1;
(statearr_72884_72925[(2)] = null);

(statearr_72884_72925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (10))){
var inst_72790 = (state_72849[(12)]);
var inst_72792 = (state_72849[(13)]);
var inst_72791 = (state_72849[(15)]);
var inst_72793 = (state_72849[(16)]);
var inst_72798 = cljs.core._nth.call(null,inst_72791,inst_72793);
var inst_72799 = cljs.core.async.muxch_STAR_.call(null,inst_72798);
var inst_72800 = cljs.core.async.close_BANG_.call(null,inst_72799);
var inst_72801 = (inst_72793 + (1));
var tmp72879 = inst_72790;
var tmp72880 = inst_72792;
var tmp72881 = inst_72791;
var inst_72790__$1 = tmp72879;
var inst_72791__$1 = tmp72881;
var inst_72792__$1 = tmp72880;
var inst_72793__$1 = inst_72801;
var state_72849__$1 = (function (){var statearr_72885 = state_72849;
(statearr_72885[(17)] = inst_72800);

(statearr_72885[(12)] = inst_72790__$1);

(statearr_72885[(13)] = inst_72792__$1);

(statearr_72885[(15)] = inst_72791__$1);

(statearr_72885[(16)] = inst_72793__$1);

return statearr_72885;
})();
var statearr_72886_72926 = state_72849__$1;
(statearr_72886_72926[(2)] = null);

(statearr_72886_72926[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (18))){
var inst_72819 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72887_72927 = state_72849__$1;
(statearr_72887_72927[(2)] = inst_72819);

(statearr_72887_72927[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72850 === (8))){
var inst_72792 = (state_72849[(13)]);
var inst_72793 = (state_72849[(16)]);
var inst_72795 = (inst_72793 < inst_72792);
var inst_72796 = inst_72795;
var state_72849__$1 = state_72849;
if(cljs.core.truth_(inst_72796)){
var statearr_72888_72928 = state_72849__$1;
(statearr_72888_72928[(1)] = (10));

} else {
var statearr_72889_72929 = state_72849__$1;
(statearr_72889_72929[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___72901,mults,ensure_mult,p))
;
return ((function (switch__70820__auto__,c__70934__auto___72901,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_72893 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72893[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_72893[(1)] = (1));

return statearr_72893;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_72849){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_72849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e72894){if((e72894 instanceof Object)){
var ex__70824__auto__ = e72894;
var statearr_72895_72930 = state_72849;
(statearr_72895_72930[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72849);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e72894;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72931 = state_72849;
state_72849 = G__72931;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_72849){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_72849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___72901,mults,ensure_mult,p))
})();
var state__70936__auto__ = (function (){var statearr_72896 = f__70935__auto__.call(null);
(statearr_72896[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___72901);

return statearr_72896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___72901,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args72932 = [];
var len__67408__auto___72935 = arguments.length;
var i__67409__auto___72936 = (0);
while(true){
if((i__67409__auto___72936 < len__67408__auto___72935)){
args72932.push((arguments[i__67409__auto___72936]));

var G__72937 = (i__67409__auto___72936 + (1));
i__67409__auto___72936 = G__72937;
continue;
} else {
}
break;
}

var G__72934 = args72932.length;
switch (G__72934) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72932.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args72939 = [];
var len__67408__auto___72942 = arguments.length;
var i__67409__auto___72943 = (0);
while(true){
if((i__67409__auto___72943 < len__67408__auto___72942)){
args72939.push((arguments[i__67409__auto___72943]));

var G__72944 = (i__67409__auto___72943 + (1));
i__67409__auto___72943 = G__72944;
continue;
} else {
}
break;
}

var G__72941 = args72939.length;
switch (G__72941) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72939.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args72946 = [];
var len__67408__auto___73017 = arguments.length;
var i__67409__auto___73018 = (0);
while(true){
if((i__67409__auto___73018 < len__67408__auto___73017)){
args72946.push((arguments[i__67409__auto___73018]));

var G__73019 = (i__67409__auto___73018 + (1));
i__67409__auto___73018 = G__73019;
continue;
} else {
}
break;
}

var G__72948 = args72946.length;
switch (G__72948) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args72946.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__70934__auto___73021 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_72987){
var state_val_72988 = (state_72987[(1)]);
if((state_val_72988 === (7))){
var state_72987__$1 = state_72987;
var statearr_72989_73022 = state_72987__$1;
(statearr_72989_73022[(2)] = null);

(statearr_72989_73022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (1))){
var state_72987__$1 = state_72987;
var statearr_72990_73023 = state_72987__$1;
(statearr_72990_73023[(2)] = null);

(statearr_72990_73023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (4))){
var inst_72951 = (state_72987[(7)]);
var inst_72953 = (inst_72951 < cnt);
var state_72987__$1 = state_72987;
if(cljs.core.truth_(inst_72953)){
var statearr_72991_73024 = state_72987__$1;
(statearr_72991_73024[(1)] = (6));

} else {
var statearr_72992_73025 = state_72987__$1;
(statearr_72992_73025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (15))){
var inst_72983 = (state_72987[(2)]);
var state_72987__$1 = state_72987;
var statearr_72993_73026 = state_72987__$1;
(statearr_72993_73026[(2)] = inst_72983);

(statearr_72993_73026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (13))){
var inst_72976 = cljs.core.async.close_BANG_.call(null,out);
var state_72987__$1 = state_72987;
var statearr_72994_73027 = state_72987__$1;
(statearr_72994_73027[(2)] = inst_72976);

(statearr_72994_73027[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (6))){
var state_72987__$1 = state_72987;
var statearr_72995_73028 = state_72987__$1;
(statearr_72995_73028[(2)] = null);

(statearr_72995_73028[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (3))){
var inst_72985 = (state_72987[(2)]);
var state_72987__$1 = state_72987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72987__$1,inst_72985);
} else {
if((state_val_72988 === (12))){
var inst_72973 = (state_72987[(8)]);
var inst_72973__$1 = (state_72987[(2)]);
var inst_72974 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_72973__$1);
var state_72987__$1 = (function (){var statearr_72996 = state_72987;
(statearr_72996[(8)] = inst_72973__$1);

return statearr_72996;
})();
if(cljs.core.truth_(inst_72974)){
var statearr_72997_73029 = state_72987__$1;
(statearr_72997_73029[(1)] = (13));

} else {
var statearr_72998_73030 = state_72987__$1;
(statearr_72998_73030[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (2))){
var inst_72950 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_72951 = (0);
var state_72987__$1 = (function (){var statearr_72999 = state_72987;
(statearr_72999[(9)] = inst_72950);

(statearr_72999[(7)] = inst_72951);

return statearr_72999;
})();
var statearr_73000_73031 = state_72987__$1;
(statearr_73000_73031[(2)] = null);

(statearr_73000_73031[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (11))){
var inst_72951 = (state_72987[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_72987,(10),Object,null,(9));
var inst_72960 = chs__$1.call(null,inst_72951);
var inst_72961 = done.call(null,inst_72951);
var inst_72962 = cljs.core.async.take_BANG_.call(null,inst_72960,inst_72961);
var state_72987__$1 = state_72987;
var statearr_73001_73032 = state_72987__$1;
(statearr_73001_73032[(2)] = inst_72962);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72987__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (9))){
var inst_72951 = (state_72987[(7)]);
var inst_72964 = (state_72987[(2)]);
var inst_72965 = (inst_72951 + (1));
var inst_72951__$1 = inst_72965;
var state_72987__$1 = (function (){var statearr_73002 = state_72987;
(statearr_73002[(7)] = inst_72951__$1);

(statearr_73002[(10)] = inst_72964);

return statearr_73002;
})();
var statearr_73003_73033 = state_72987__$1;
(statearr_73003_73033[(2)] = null);

(statearr_73003_73033[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (5))){
var inst_72971 = (state_72987[(2)]);
var state_72987__$1 = (function (){var statearr_73004 = state_72987;
(statearr_73004[(11)] = inst_72971);

return statearr_73004;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72987__$1,(12),dchan);
} else {
if((state_val_72988 === (14))){
var inst_72973 = (state_72987[(8)]);
var inst_72978 = cljs.core.apply.call(null,f,inst_72973);
var state_72987__$1 = state_72987;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_72987__$1,(16),out,inst_72978);
} else {
if((state_val_72988 === (16))){
var inst_72980 = (state_72987[(2)]);
var state_72987__$1 = (function (){var statearr_73005 = state_72987;
(statearr_73005[(12)] = inst_72980);

return statearr_73005;
})();
var statearr_73006_73034 = state_72987__$1;
(statearr_73006_73034[(2)] = null);

(statearr_73006_73034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (10))){
var inst_72955 = (state_72987[(2)]);
var inst_72956 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_72987__$1 = (function (){var statearr_73007 = state_72987;
(statearr_73007[(13)] = inst_72955);

return statearr_73007;
})();
var statearr_73008_73035 = state_72987__$1;
(statearr_73008_73035[(2)] = inst_72956);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72987__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72988 === (8))){
var inst_72969 = (state_72987[(2)]);
var state_72987__$1 = state_72987;
var statearr_73009_73036 = state_72987__$1;
(statearr_73009_73036[(2)] = inst_72969);

(statearr_73009_73036[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73021,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__70820__auto__,c__70934__auto___73021,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73013[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73013[(1)] = (1));

return statearr_73013;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_72987){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_72987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73014){if((e73014 instanceof Object)){
var ex__70824__auto__ = e73014;
var statearr_73015_73037 = state_72987;
(statearr_73015_73037[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_72987);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73014;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73038 = state_72987;
state_72987 = G__73038;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_72987){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_72987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73021,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__70936__auto__ = (function (){var statearr_73016 = f__70935__auto__.call(null);
(statearr_73016[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73021);

return statearr_73016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73021,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args73040 = [];
var len__67408__auto___73098 = arguments.length;
var i__67409__auto___73099 = (0);
while(true){
if((i__67409__auto___73099 < len__67408__auto___73098)){
args73040.push((arguments[i__67409__auto___73099]));

var G__73100 = (i__67409__auto___73099 + (1));
i__67409__auto___73099 = G__73100;
continue;
} else {
}
break;
}

var G__73042 = args73040.length;
switch (G__73042) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73040.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___73102 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73102,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73102,out){
return (function (state_73074){
var state_val_73075 = (state_73074[(1)]);
if((state_val_73075 === (7))){
var inst_73054 = (state_73074[(7)]);
var inst_73053 = (state_73074[(8)]);
var inst_73053__$1 = (state_73074[(2)]);
var inst_73054__$1 = cljs.core.nth.call(null,inst_73053__$1,(0),null);
var inst_73055 = cljs.core.nth.call(null,inst_73053__$1,(1),null);
var inst_73056 = (inst_73054__$1 == null);
var state_73074__$1 = (function (){var statearr_73076 = state_73074;
(statearr_73076[(7)] = inst_73054__$1);

(statearr_73076[(9)] = inst_73055);

(statearr_73076[(8)] = inst_73053__$1);

return statearr_73076;
})();
if(cljs.core.truth_(inst_73056)){
var statearr_73077_73103 = state_73074__$1;
(statearr_73077_73103[(1)] = (8));

} else {
var statearr_73078_73104 = state_73074__$1;
(statearr_73078_73104[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (1))){
var inst_73043 = cljs.core.vec.call(null,chs);
var inst_73044 = inst_73043;
var state_73074__$1 = (function (){var statearr_73079 = state_73074;
(statearr_73079[(10)] = inst_73044);

return statearr_73079;
})();
var statearr_73080_73105 = state_73074__$1;
(statearr_73080_73105[(2)] = null);

(statearr_73080_73105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (4))){
var inst_73044 = (state_73074[(10)]);
var state_73074__$1 = state_73074;
return cljs.core.async.ioc_alts_BANG_.call(null,state_73074__$1,(7),inst_73044);
} else {
if((state_val_73075 === (6))){
var inst_73070 = (state_73074[(2)]);
var state_73074__$1 = state_73074;
var statearr_73081_73106 = state_73074__$1;
(statearr_73081_73106[(2)] = inst_73070);

(statearr_73081_73106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (3))){
var inst_73072 = (state_73074[(2)]);
var state_73074__$1 = state_73074;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73074__$1,inst_73072);
} else {
if((state_val_73075 === (2))){
var inst_73044 = (state_73074[(10)]);
var inst_73046 = cljs.core.count.call(null,inst_73044);
var inst_73047 = (inst_73046 > (0));
var state_73074__$1 = state_73074;
if(cljs.core.truth_(inst_73047)){
var statearr_73083_73107 = state_73074__$1;
(statearr_73083_73107[(1)] = (4));

} else {
var statearr_73084_73108 = state_73074__$1;
(statearr_73084_73108[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (11))){
var inst_73044 = (state_73074[(10)]);
var inst_73063 = (state_73074[(2)]);
var tmp73082 = inst_73044;
var inst_73044__$1 = tmp73082;
var state_73074__$1 = (function (){var statearr_73085 = state_73074;
(statearr_73085[(11)] = inst_73063);

(statearr_73085[(10)] = inst_73044__$1);

return statearr_73085;
})();
var statearr_73086_73109 = state_73074__$1;
(statearr_73086_73109[(2)] = null);

(statearr_73086_73109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (9))){
var inst_73054 = (state_73074[(7)]);
var state_73074__$1 = state_73074;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73074__$1,(11),out,inst_73054);
} else {
if((state_val_73075 === (5))){
var inst_73068 = cljs.core.async.close_BANG_.call(null,out);
var state_73074__$1 = state_73074;
var statearr_73087_73110 = state_73074__$1;
(statearr_73087_73110[(2)] = inst_73068);

(statearr_73087_73110[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (10))){
var inst_73066 = (state_73074[(2)]);
var state_73074__$1 = state_73074;
var statearr_73088_73111 = state_73074__$1;
(statearr_73088_73111[(2)] = inst_73066);

(statearr_73088_73111[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73075 === (8))){
var inst_73054 = (state_73074[(7)]);
var inst_73044 = (state_73074[(10)]);
var inst_73055 = (state_73074[(9)]);
var inst_73053 = (state_73074[(8)]);
var inst_73058 = (function (){var cs = inst_73044;
var vec__73049 = inst_73053;
var v = inst_73054;
var c = inst_73055;
return ((function (cs,vec__73049,v,c,inst_73054,inst_73044,inst_73055,inst_73053,state_val_73075,c__70934__auto___73102,out){
return (function (p1__73039_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__73039_SHARP_);
});
;})(cs,vec__73049,v,c,inst_73054,inst_73044,inst_73055,inst_73053,state_val_73075,c__70934__auto___73102,out))
})();
var inst_73059 = cljs.core.filterv.call(null,inst_73058,inst_73044);
var inst_73044__$1 = inst_73059;
var state_73074__$1 = (function (){var statearr_73089 = state_73074;
(statearr_73089[(10)] = inst_73044__$1);

return statearr_73089;
})();
var statearr_73090_73112 = state_73074__$1;
(statearr_73090_73112[(2)] = null);

(statearr_73090_73112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73102,out))
;
return ((function (switch__70820__auto__,c__70934__auto___73102,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73094 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73094[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73094[(1)] = (1));

return statearr_73094;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_73074){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73074);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73095){if((e73095 instanceof Object)){
var ex__70824__auto__ = e73095;
var statearr_73096_73113 = state_73074;
(statearr_73096_73113[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73074);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73095;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73114 = state_73074;
state_73074 = G__73114;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_73074){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_73074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73102,out))
})();
var state__70936__auto__ = (function (){var statearr_73097 = f__70935__auto__.call(null);
(statearr_73097[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73102);

return statearr_73097;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73102,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args73115 = [];
var len__67408__auto___73164 = arguments.length;
var i__67409__auto___73165 = (0);
while(true){
if((i__67409__auto___73165 < len__67408__auto___73164)){
args73115.push((arguments[i__67409__auto___73165]));

var G__73166 = (i__67409__auto___73165 + (1));
i__67409__auto___73165 = G__73166;
continue;
} else {
}
break;
}

var G__73117 = args73115.length;
switch (G__73117) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73115.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___73168 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73168,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73168,out){
return (function (state_73141){
var state_val_73142 = (state_73141[(1)]);
if((state_val_73142 === (7))){
var inst_73123 = (state_73141[(7)]);
var inst_73123__$1 = (state_73141[(2)]);
var inst_73124 = (inst_73123__$1 == null);
var inst_73125 = cljs.core.not.call(null,inst_73124);
var state_73141__$1 = (function (){var statearr_73143 = state_73141;
(statearr_73143[(7)] = inst_73123__$1);

return statearr_73143;
})();
if(inst_73125){
var statearr_73144_73169 = state_73141__$1;
(statearr_73144_73169[(1)] = (8));

} else {
var statearr_73145_73170 = state_73141__$1;
(statearr_73145_73170[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (1))){
var inst_73118 = (0);
var state_73141__$1 = (function (){var statearr_73146 = state_73141;
(statearr_73146[(8)] = inst_73118);

return statearr_73146;
})();
var statearr_73147_73171 = state_73141__$1;
(statearr_73147_73171[(2)] = null);

(statearr_73147_73171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (4))){
var state_73141__$1 = state_73141;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73141__$1,(7),ch);
} else {
if((state_val_73142 === (6))){
var inst_73136 = (state_73141[(2)]);
var state_73141__$1 = state_73141;
var statearr_73148_73172 = state_73141__$1;
(statearr_73148_73172[(2)] = inst_73136);

(statearr_73148_73172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (3))){
var inst_73138 = (state_73141[(2)]);
var inst_73139 = cljs.core.async.close_BANG_.call(null,out);
var state_73141__$1 = (function (){var statearr_73149 = state_73141;
(statearr_73149[(9)] = inst_73138);

return statearr_73149;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73141__$1,inst_73139);
} else {
if((state_val_73142 === (2))){
var inst_73118 = (state_73141[(8)]);
var inst_73120 = (inst_73118 < n);
var state_73141__$1 = state_73141;
if(cljs.core.truth_(inst_73120)){
var statearr_73150_73173 = state_73141__$1;
(statearr_73150_73173[(1)] = (4));

} else {
var statearr_73151_73174 = state_73141__$1;
(statearr_73151_73174[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (11))){
var inst_73118 = (state_73141[(8)]);
var inst_73128 = (state_73141[(2)]);
var inst_73129 = (inst_73118 + (1));
var inst_73118__$1 = inst_73129;
var state_73141__$1 = (function (){var statearr_73152 = state_73141;
(statearr_73152[(10)] = inst_73128);

(statearr_73152[(8)] = inst_73118__$1);

return statearr_73152;
})();
var statearr_73153_73175 = state_73141__$1;
(statearr_73153_73175[(2)] = null);

(statearr_73153_73175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (9))){
var state_73141__$1 = state_73141;
var statearr_73154_73176 = state_73141__$1;
(statearr_73154_73176[(2)] = null);

(statearr_73154_73176[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (5))){
var state_73141__$1 = state_73141;
var statearr_73155_73177 = state_73141__$1;
(statearr_73155_73177[(2)] = null);

(statearr_73155_73177[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (10))){
var inst_73133 = (state_73141[(2)]);
var state_73141__$1 = state_73141;
var statearr_73156_73178 = state_73141__$1;
(statearr_73156_73178[(2)] = inst_73133);

(statearr_73156_73178[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73142 === (8))){
var inst_73123 = (state_73141[(7)]);
var state_73141__$1 = state_73141;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73141__$1,(11),out,inst_73123);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73168,out))
;
return ((function (switch__70820__auto__,c__70934__auto___73168,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73160 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73160[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73160[(1)] = (1));

return statearr_73160;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_73141){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73141);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73161){if((e73161 instanceof Object)){
var ex__70824__auto__ = e73161;
var statearr_73162_73179 = state_73141;
(statearr_73162_73179[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73141);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73161;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73180 = state_73141;
state_73141 = G__73180;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_73141){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_73141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73168,out))
})();
var state__70936__auto__ = (function (){var statearr_73163 = f__70935__auto__.call(null);
(statearr_73163[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73168);

return statearr_73163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73168,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async73188 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73188 = (function (f,ch,meta73189){
this.f = f;
this.ch = ch;
this.meta73189 = meta73189;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_73190,meta73189__$1){
var self__ = this;
var _73190__$1 = this;
return (new cljs.core.async.t_cljs$core$async73188(self__.f,self__.ch,meta73189__$1));
});

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_73190){
var self__ = this;
var _73190__$1 = this;
return self__.meta73189;
});

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async73191 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73191 = (function (f,ch,meta73189,_,fn1,meta73192){
this.f = f;
this.ch = ch;
this.meta73189 = meta73189;
this._ = _;
this.fn1 = fn1;
this.meta73192 = meta73192;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73191.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_73193,meta73192__$1){
var self__ = this;
var _73193__$1 = this;
return (new cljs.core.async.t_cljs$core$async73191(self__.f,self__.ch,self__.meta73189,self__._,self__.fn1,meta73192__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async73191.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_73193){
var self__ = this;
var _73193__$1 = this;
return self__.meta73192;
});})(___$1))
;

cljs.core.async.t_cljs$core$async73191.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73191.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async73191.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async73191.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__73181_SHARP_){
return f1.call(null,(((p1__73181_SHARP_ == null))?null:self__.f.call(null,p1__73181_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async73191.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73189","meta73189",1410041160,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async73188","cljs.core.async/t_cljs$core$async73188",1761768374,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta73192","meta73192",1969061298,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async73191.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73191.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73191";

cljs.core.async.t_cljs$core$async73191.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async73191");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async73191 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async73191(f__$1,ch__$1,meta73189__$1,___$2,fn1__$1,meta73192){
return (new cljs.core.async.t_cljs$core$async73191(f__$1,ch__$1,meta73189__$1,___$2,fn1__$1,meta73192));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async73191(self__.f,self__.ch,self__.meta73189,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__66175__auto__ = ret;
if(cljs.core.truth_(and__66175__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__66175__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73188.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async73188.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73189","meta73189",1410041160,null)], null);
});

cljs.core.async.t_cljs$core$async73188.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73188.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73188";

cljs.core.async.t_cljs$core$async73188.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async73188");
});

cljs.core.async.__GT_t_cljs$core$async73188 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async73188(f__$1,ch__$1,meta73189){
return (new cljs.core.async.t_cljs$core$async73188(f__$1,ch__$1,meta73189));
});

}

return (new cljs.core.async.t_cljs$core$async73188(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async73197 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73197 = (function (f,ch,meta73198){
this.f = f;
this.ch = ch;
this.meta73198 = meta73198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_73199,meta73198__$1){
var self__ = this;
var _73199__$1 = this;
return (new cljs.core.async.t_cljs$core$async73197(self__.f,self__.ch,meta73198__$1));
});

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_73199){
var self__ = this;
var _73199__$1 = this;
return self__.meta73198;
});

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73197.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async73197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73198","meta73198",853181599,null)], null);
});

cljs.core.async.t_cljs$core$async73197.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73197.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73197";

cljs.core.async.t_cljs$core$async73197.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async73197");
});

cljs.core.async.__GT_t_cljs$core$async73197 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async73197(f__$1,ch__$1,meta73198){
return (new cljs.core.async.t_cljs$core$async73197(f__$1,ch__$1,meta73198));
});

}

return (new cljs.core.async.t_cljs$core$async73197(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async73203 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async73203 = (function (p,ch,meta73204){
this.p = p;
this.ch = ch;
this.meta73204 = meta73204;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_73205,meta73204__$1){
var self__ = this;
var _73205__$1 = this;
return (new cljs.core.async.t_cljs$core$async73203(self__.p,self__.ch,meta73204__$1));
});

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_73205){
var self__ = this;
var _73205__$1 = this;
return self__.meta73204;
});

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async73203.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async73203.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta73204","meta73204",1046743825,null)], null);
});

cljs.core.async.t_cljs$core$async73203.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async73203.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async73203";

cljs.core.async.t_cljs$core$async73203.cljs$lang$ctorPrWriter = (function (this__66844__auto__,writer__66845__auto__,opt__66846__auto__){
return cljs.core._write.call(null,writer__66845__auto__,"cljs.core.async/t_cljs$core$async73203");
});

cljs.core.async.__GT_t_cljs$core$async73203 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async73203(p__$1,ch__$1,meta73204){
return (new cljs.core.async.t_cljs$core$async73203(p__$1,ch__$1,meta73204));
});

}

return (new cljs.core.async.t_cljs$core$async73203(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args73206 = [];
var len__67408__auto___73250 = arguments.length;
var i__67409__auto___73251 = (0);
while(true){
if((i__67409__auto___73251 < len__67408__auto___73250)){
args73206.push((arguments[i__67409__auto___73251]));

var G__73252 = (i__67409__auto___73251 + (1));
i__67409__auto___73251 = G__73252;
continue;
} else {
}
break;
}

var G__73208 = args73206.length;
switch (G__73208) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73206.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___73254 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73254,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73254,out){
return (function (state_73229){
var state_val_73230 = (state_73229[(1)]);
if((state_val_73230 === (7))){
var inst_73225 = (state_73229[(2)]);
var state_73229__$1 = state_73229;
var statearr_73231_73255 = state_73229__$1;
(statearr_73231_73255[(2)] = inst_73225);

(statearr_73231_73255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (1))){
var state_73229__$1 = state_73229;
var statearr_73232_73256 = state_73229__$1;
(statearr_73232_73256[(2)] = null);

(statearr_73232_73256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (4))){
var inst_73211 = (state_73229[(7)]);
var inst_73211__$1 = (state_73229[(2)]);
var inst_73212 = (inst_73211__$1 == null);
var state_73229__$1 = (function (){var statearr_73233 = state_73229;
(statearr_73233[(7)] = inst_73211__$1);

return statearr_73233;
})();
if(cljs.core.truth_(inst_73212)){
var statearr_73234_73257 = state_73229__$1;
(statearr_73234_73257[(1)] = (5));

} else {
var statearr_73235_73258 = state_73229__$1;
(statearr_73235_73258[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (6))){
var inst_73211 = (state_73229[(7)]);
var inst_73216 = p.call(null,inst_73211);
var state_73229__$1 = state_73229;
if(cljs.core.truth_(inst_73216)){
var statearr_73236_73259 = state_73229__$1;
(statearr_73236_73259[(1)] = (8));

} else {
var statearr_73237_73260 = state_73229__$1;
(statearr_73237_73260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (3))){
var inst_73227 = (state_73229[(2)]);
var state_73229__$1 = state_73229;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73229__$1,inst_73227);
} else {
if((state_val_73230 === (2))){
var state_73229__$1 = state_73229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73229__$1,(4),ch);
} else {
if((state_val_73230 === (11))){
var inst_73219 = (state_73229[(2)]);
var state_73229__$1 = state_73229;
var statearr_73238_73261 = state_73229__$1;
(statearr_73238_73261[(2)] = inst_73219);

(statearr_73238_73261[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (9))){
var state_73229__$1 = state_73229;
var statearr_73239_73262 = state_73229__$1;
(statearr_73239_73262[(2)] = null);

(statearr_73239_73262[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (5))){
var inst_73214 = cljs.core.async.close_BANG_.call(null,out);
var state_73229__$1 = state_73229;
var statearr_73240_73263 = state_73229__$1;
(statearr_73240_73263[(2)] = inst_73214);

(statearr_73240_73263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (10))){
var inst_73222 = (state_73229[(2)]);
var state_73229__$1 = (function (){var statearr_73241 = state_73229;
(statearr_73241[(8)] = inst_73222);

return statearr_73241;
})();
var statearr_73242_73264 = state_73229__$1;
(statearr_73242_73264[(2)] = null);

(statearr_73242_73264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73230 === (8))){
var inst_73211 = (state_73229[(7)]);
var state_73229__$1 = state_73229;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73229__$1,(11),out,inst_73211);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73254,out))
;
return ((function (switch__70820__auto__,c__70934__auto___73254,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73246 = [null,null,null,null,null,null,null,null,null];
(statearr_73246[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73246[(1)] = (1));

return statearr_73246;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_73229){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73247){if((e73247 instanceof Object)){
var ex__70824__auto__ = e73247;
var statearr_73248_73265 = state_73229;
(statearr_73248_73265[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73247;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73266 = state_73229;
state_73229 = G__73266;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_73229){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_73229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73254,out))
})();
var state__70936__auto__ = (function (){var statearr_73249 = f__70935__auto__.call(null);
(statearr_73249[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73254);

return statearr_73249;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73254,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args73267 = [];
var len__67408__auto___73270 = arguments.length;
var i__67409__auto___73271 = (0);
while(true){
if((i__67409__auto___73271 < len__67408__auto___73270)){
args73267.push((arguments[i__67409__auto___73271]));

var G__73272 = (i__67409__auto___73271 + (1));
i__67409__auto___73271 = G__73272;
continue;
} else {
}
break;
}

var G__73269 = args73267.length;
switch (G__73269) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73267.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__70934__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto__){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto__){
return (function (state_73439){
var state_val_73440 = (state_73439[(1)]);
if((state_val_73440 === (7))){
var inst_73435 = (state_73439[(2)]);
var state_73439__$1 = state_73439;
var statearr_73441_73482 = state_73439__$1;
(statearr_73441_73482[(2)] = inst_73435);

(statearr_73441_73482[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (20))){
var inst_73405 = (state_73439[(7)]);
var inst_73416 = (state_73439[(2)]);
var inst_73417 = cljs.core.next.call(null,inst_73405);
var inst_73391 = inst_73417;
var inst_73392 = null;
var inst_73393 = (0);
var inst_73394 = (0);
var state_73439__$1 = (function (){var statearr_73442 = state_73439;
(statearr_73442[(8)] = inst_73416);

(statearr_73442[(9)] = inst_73393);

(statearr_73442[(10)] = inst_73391);

(statearr_73442[(11)] = inst_73394);

(statearr_73442[(12)] = inst_73392);

return statearr_73442;
})();
var statearr_73443_73483 = state_73439__$1;
(statearr_73443_73483[(2)] = null);

(statearr_73443_73483[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (1))){
var state_73439__$1 = state_73439;
var statearr_73444_73484 = state_73439__$1;
(statearr_73444_73484[(2)] = null);

(statearr_73444_73484[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (4))){
var inst_73380 = (state_73439[(13)]);
var inst_73380__$1 = (state_73439[(2)]);
var inst_73381 = (inst_73380__$1 == null);
var state_73439__$1 = (function (){var statearr_73445 = state_73439;
(statearr_73445[(13)] = inst_73380__$1);

return statearr_73445;
})();
if(cljs.core.truth_(inst_73381)){
var statearr_73446_73485 = state_73439__$1;
(statearr_73446_73485[(1)] = (5));

} else {
var statearr_73447_73486 = state_73439__$1;
(statearr_73447_73486[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (15))){
var state_73439__$1 = state_73439;
var statearr_73451_73487 = state_73439__$1;
(statearr_73451_73487[(2)] = null);

(statearr_73451_73487[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (21))){
var state_73439__$1 = state_73439;
var statearr_73452_73488 = state_73439__$1;
(statearr_73452_73488[(2)] = null);

(statearr_73452_73488[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (13))){
var inst_73393 = (state_73439[(9)]);
var inst_73391 = (state_73439[(10)]);
var inst_73394 = (state_73439[(11)]);
var inst_73392 = (state_73439[(12)]);
var inst_73401 = (state_73439[(2)]);
var inst_73402 = (inst_73394 + (1));
var tmp73448 = inst_73393;
var tmp73449 = inst_73391;
var tmp73450 = inst_73392;
var inst_73391__$1 = tmp73449;
var inst_73392__$1 = tmp73450;
var inst_73393__$1 = tmp73448;
var inst_73394__$1 = inst_73402;
var state_73439__$1 = (function (){var statearr_73453 = state_73439;
(statearr_73453[(9)] = inst_73393__$1);

(statearr_73453[(10)] = inst_73391__$1);

(statearr_73453[(11)] = inst_73394__$1);

(statearr_73453[(14)] = inst_73401);

(statearr_73453[(12)] = inst_73392__$1);

return statearr_73453;
})();
var statearr_73454_73489 = state_73439__$1;
(statearr_73454_73489[(2)] = null);

(statearr_73454_73489[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (22))){
var state_73439__$1 = state_73439;
var statearr_73455_73490 = state_73439__$1;
(statearr_73455_73490[(2)] = null);

(statearr_73455_73490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (6))){
var inst_73380 = (state_73439[(13)]);
var inst_73389 = f.call(null,inst_73380);
var inst_73390 = cljs.core.seq.call(null,inst_73389);
var inst_73391 = inst_73390;
var inst_73392 = null;
var inst_73393 = (0);
var inst_73394 = (0);
var state_73439__$1 = (function (){var statearr_73456 = state_73439;
(statearr_73456[(9)] = inst_73393);

(statearr_73456[(10)] = inst_73391);

(statearr_73456[(11)] = inst_73394);

(statearr_73456[(12)] = inst_73392);

return statearr_73456;
})();
var statearr_73457_73491 = state_73439__$1;
(statearr_73457_73491[(2)] = null);

(statearr_73457_73491[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (17))){
var inst_73405 = (state_73439[(7)]);
var inst_73409 = cljs.core.chunk_first.call(null,inst_73405);
var inst_73410 = cljs.core.chunk_rest.call(null,inst_73405);
var inst_73411 = cljs.core.count.call(null,inst_73409);
var inst_73391 = inst_73410;
var inst_73392 = inst_73409;
var inst_73393 = inst_73411;
var inst_73394 = (0);
var state_73439__$1 = (function (){var statearr_73458 = state_73439;
(statearr_73458[(9)] = inst_73393);

(statearr_73458[(10)] = inst_73391);

(statearr_73458[(11)] = inst_73394);

(statearr_73458[(12)] = inst_73392);

return statearr_73458;
})();
var statearr_73459_73492 = state_73439__$1;
(statearr_73459_73492[(2)] = null);

(statearr_73459_73492[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (3))){
var inst_73437 = (state_73439[(2)]);
var state_73439__$1 = state_73439;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73439__$1,inst_73437);
} else {
if((state_val_73440 === (12))){
var inst_73425 = (state_73439[(2)]);
var state_73439__$1 = state_73439;
var statearr_73460_73493 = state_73439__$1;
(statearr_73460_73493[(2)] = inst_73425);

(statearr_73460_73493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (2))){
var state_73439__$1 = state_73439;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73439__$1,(4),in$);
} else {
if((state_val_73440 === (23))){
var inst_73433 = (state_73439[(2)]);
var state_73439__$1 = state_73439;
var statearr_73461_73494 = state_73439__$1;
(statearr_73461_73494[(2)] = inst_73433);

(statearr_73461_73494[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (19))){
var inst_73420 = (state_73439[(2)]);
var state_73439__$1 = state_73439;
var statearr_73462_73495 = state_73439__$1;
(statearr_73462_73495[(2)] = inst_73420);

(statearr_73462_73495[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (11))){
var inst_73391 = (state_73439[(10)]);
var inst_73405 = (state_73439[(7)]);
var inst_73405__$1 = cljs.core.seq.call(null,inst_73391);
var state_73439__$1 = (function (){var statearr_73463 = state_73439;
(statearr_73463[(7)] = inst_73405__$1);

return statearr_73463;
})();
if(inst_73405__$1){
var statearr_73464_73496 = state_73439__$1;
(statearr_73464_73496[(1)] = (14));

} else {
var statearr_73465_73497 = state_73439__$1;
(statearr_73465_73497[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (9))){
var inst_73427 = (state_73439[(2)]);
var inst_73428 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_73439__$1 = (function (){var statearr_73466 = state_73439;
(statearr_73466[(15)] = inst_73427);

return statearr_73466;
})();
if(cljs.core.truth_(inst_73428)){
var statearr_73467_73498 = state_73439__$1;
(statearr_73467_73498[(1)] = (21));

} else {
var statearr_73468_73499 = state_73439__$1;
(statearr_73468_73499[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (5))){
var inst_73383 = cljs.core.async.close_BANG_.call(null,out);
var state_73439__$1 = state_73439;
var statearr_73469_73500 = state_73439__$1;
(statearr_73469_73500[(2)] = inst_73383);

(statearr_73469_73500[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (14))){
var inst_73405 = (state_73439[(7)]);
var inst_73407 = cljs.core.chunked_seq_QMARK_.call(null,inst_73405);
var state_73439__$1 = state_73439;
if(inst_73407){
var statearr_73470_73501 = state_73439__$1;
(statearr_73470_73501[(1)] = (17));

} else {
var statearr_73471_73502 = state_73439__$1;
(statearr_73471_73502[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (16))){
var inst_73423 = (state_73439[(2)]);
var state_73439__$1 = state_73439;
var statearr_73472_73503 = state_73439__$1;
(statearr_73472_73503[(2)] = inst_73423);

(statearr_73472_73503[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73440 === (10))){
var inst_73394 = (state_73439[(11)]);
var inst_73392 = (state_73439[(12)]);
var inst_73399 = cljs.core._nth.call(null,inst_73392,inst_73394);
var state_73439__$1 = state_73439;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73439__$1,(13),out,inst_73399);
} else {
if((state_val_73440 === (18))){
var inst_73405 = (state_73439[(7)]);
var inst_73414 = cljs.core.first.call(null,inst_73405);
var state_73439__$1 = state_73439;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73439__$1,(20),out,inst_73414);
} else {
if((state_val_73440 === (8))){
var inst_73393 = (state_73439[(9)]);
var inst_73394 = (state_73439[(11)]);
var inst_73396 = (inst_73394 < inst_73393);
var inst_73397 = inst_73396;
var state_73439__$1 = state_73439;
if(cljs.core.truth_(inst_73397)){
var statearr_73473_73504 = state_73439__$1;
(statearr_73473_73504[(1)] = (10));

} else {
var statearr_73474_73505 = state_73439__$1;
(statearr_73474_73505[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto__))
;
return ((function (switch__70820__auto__,c__70934__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____0 = (function (){
var statearr_73478 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73478[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__);

(statearr_73478[(1)] = (1));

return statearr_73478;
});
var cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____1 = (function (state_73439){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73439);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73479){if((e73479 instanceof Object)){
var ex__70824__auto__ = e73479;
var statearr_73480_73506 = state_73439;
(statearr_73480_73506[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73439);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73479;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73507 = state_73439;
state_73439 = G__73507;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__ = function(state_73439){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____1.call(this,state_73439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__70821__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto__))
})();
var state__70936__auto__ = (function (){var statearr_73481 = f__70935__auto__.call(null);
(statearr_73481[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto__);

return statearr_73481;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto__))
);

return c__70934__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args73508 = [];
var len__67408__auto___73511 = arguments.length;
var i__67409__auto___73512 = (0);
while(true){
if((i__67409__auto___73512 < len__67408__auto___73511)){
args73508.push((arguments[i__67409__auto___73512]));

var G__73513 = (i__67409__auto___73512 + (1));
i__67409__auto___73512 = G__73513;
continue;
} else {
}
break;
}

var G__73510 = args73508.length;
switch (G__73510) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73508.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args73515 = [];
var len__67408__auto___73518 = arguments.length;
var i__67409__auto___73519 = (0);
while(true){
if((i__67409__auto___73519 < len__67408__auto___73518)){
args73515.push((arguments[i__67409__auto___73519]));

var G__73520 = (i__67409__auto___73519 + (1));
i__67409__auto___73519 = G__73520;
continue;
} else {
}
break;
}

var G__73517 = args73515.length;
switch (G__73517) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73515.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args73522 = [];
var len__67408__auto___73573 = arguments.length;
var i__67409__auto___73574 = (0);
while(true){
if((i__67409__auto___73574 < len__67408__auto___73573)){
args73522.push((arguments[i__67409__auto___73574]));

var G__73575 = (i__67409__auto___73574 + (1));
i__67409__auto___73574 = G__73575;
continue;
} else {
}
break;
}

var G__73524 = args73522.length;
switch (G__73524) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73522.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___73577 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73577,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73577,out){
return (function (state_73548){
var state_val_73549 = (state_73548[(1)]);
if((state_val_73549 === (7))){
var inst_73543 = (state_73548[(2)]);
var state_73548__$1 = state_73548;
var statearr_73550_73578 = state_73548__$1;
(statearr_73550_73578[(2)] = inst_73543);

(statearr_73550_73578[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (1))){
var inst_73525 = null;
var state_73548__$1 = (function (){var statearr_73551 = state_73548;
(statearr_73551[(7)] = inst_73525);

return statearr_73551;
})();
var statearr_73552_73579 = state_73548__$1;
(statearr_73552_73579[(2)] = null);

(statearr_73552_73579[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (4))){
var inst_73528 = (state_73548[(8)]);
var inst_73528__$1 = (state_73548[(2)]);
var inst_73529 = (inst_73528__$1 == null);
var inst_73530 = cljs.core.not.call(null,inst_73529);
var state_73548__$1 = (function (){var statearr_73553 = state_73548;
(statearr_73553[(8)] = inst_73528__$1);

return statearr_73553;
})();
if(inst_73530){
var statearr_73554_73580 = state_73548__$1;
(statearr_73554_73580[(1)] = (5));

} else {
var statearr_73555_73581 = state_73548__$1;
(statearr_73555_73581[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (6))){
var state_73548__$1 = state_73548;
var statearr_73556_73582 = state_73548__$1;
(statearr_73556_73582[(2)] = null);

(statearr_73556_73582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (3))){
var inst_73545 = (state_73548[(2)]);
var inst_73546 = cljs.core.async.close_BANG_.call(null,out);
var state_73548__$1 = (function (){var statearr_73557 = state_73548;
(statearr_73557[(9)] = inst_73545);

return statearr_73557;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73548__$1,inst_73546);
} else {
if((state_val_73549 === (2))){
var state_73548__$1 = state_73548;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73548__$1,(4),ch);
} else {
if((state_val_73549 === (11))){
var inst_73528 = (state_73548[(8)]);
var inst_73537 = (state_73548[(2)]);
var inst_73525 = inst_73528;
var state_73548__$1 = (function (){var statearr_73558 = state_73548;
(statearr_73558[(10)] = inst_73537);

(statearr_73558[(7)] = inst_73525);

return statearr_73558;
})();
var statearr_73559_73583 = state_73548__$1;
(statearr_73559_73583[(2)] = null);

(statearr_73559_73583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (9))){
var inst_73528 = (state_73548[(8)]);
var state_73548__$1 = state_73548;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73548__$1,(11),out,inst_73528);
} else {
if((state_val_73549 === (5))){
var inst_73528 = (state_73548[(8)]);
var inst_73525 = (state_73548[(7)]);
var inst_73532 = cljs.core._EQ_.call(null,inst_73528,inst_73525);
var state_73548__$1 = state_73548;
if(inst_73532){
var statearr_73561_73584 = state_73548__$1;
(statearr_73561_73584[(1)] = (8));

} else {
var statearr_73562_73585 = state_73548__$1;
(statearr_73562_73585[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (10))){
var inst_73540 = (state_73548[(2)]);
var state_73548__$1 = state_73548;
var statearr_73563_73586 = state_73548__$1;
(statearr_73563_73586[(2)] = inst_73540);

(statearr_73563_73586[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73549 === (8))){
var inst_73525 = (state_73548[(7)]);
var tmp73560 = inst_73525;
var inst_73525__$1 = tmp73560;
var state_73548__$1 = (function (){var statearr_73564 = state_73548;
(statearr_73564[(7)] = inst_73525__$1);

return statearr_73564;
})();
var statearr_73565_73587 = state_73548__$1;
(statearr_73565_73587[(2)] = null);

(statearr_73565_73587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73577,out))
;
return ((function (switch__70820__auto__,c__70934__auto___73577,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73569 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_73569[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73569[(1)] = (1));

return statearr_73569;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_73548){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73548);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73570){if((e73570 instanceof Object)){
var ex__70824__auto__ = e73570;
var statearr_73571_73588 = state_73548;
(statearr_73571_73588[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73548);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73570;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73589 = state_73548;
state_73548 = G__73589;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_73548){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_73548);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73577,out))
})();
var state__70936__auto__ = (function (){var statearr_73572 = f__70935__auto__.call(null);
(statearr_73572[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73577);

return statearr_73572;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73577,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args73590 = [];
var len__67408__auto___73660 = arguments.length;
var i__67409__auto___73661 = (0);
while(true){
if((i__67409__auto___73661 < len__67408__auto___73660)){
args73590.push((arguments[i__67409__auto___73661]));

var G__73662 = (i__67409__auto___73661 + (1));
i__67409__auto___73661 = G__73662;
continue;
} else {
}
break;
}

var G__73592 = args73590.length;
switch (G__73592) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73590.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___73664 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73664,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73664,out){
return (function (state_73630){
var state_val_73631 = (state_73630[(1)]);
if((state_val_73631 === (7))){
var inst_73626 = (state_73630[(2)]);
var state_73630__$1 = state_73630;
var statearr_73632_73665 = state_73630__$1;
(statearr_73632_73665[(2)] = inst_73626);

(statearr_73632_73665[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (1))){
var inst_73593 = (new Array(n));
var inst_73594 = inst_73593;
var inst_73595 = (0);
var state_73630__$1 = (function (){var statearr_73633 = state_73630;
(statearr_73633[(7)] = inst_73595);

(statearr_73633[(8)] = inst_73594);

return statearr_73633;
})();
var statearr_73634_73666 = state_73630__$1;
(statearr_73634_73666[(2)] = null);

(statearr_73634_73666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (4))){
var inst_73598 = (state_73630[(9)]);
var inst_73598__$1 = (state_73630[(2)]);
var inst_73599 = (inst_73598__$1 == null);
var inst_73600 = cljs.core.not.call(null,inst_73599);
var state_73630__$1 = (function (){var statearr_73635 = state_73630;
(statearr_73635[(9)] = inst_73598__$1);

return statearr_73635;
})();
if(inst_73600){
var statearr_73636_73667 = state_73630__$1;
(statearr_73636_73667[(1)] = (5));

} else {
var statearr_73637_73668 = state_73630__$1;
(statearr_73637_73668[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (15))){
var inst_73620 = (state_73630[(2)]);
var state_73630__$1 = state_73630;
var statearr_73638_73669 = state_73630__$1;
(statearr_73638_73669[(2)] = inst_73620);

(statearr_73638_73669[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (13))){
var state_73630__$1 = state_73630;
var statearr_73639_73670 = state_73630__$1;
(statearr_73639_73670[(2)] = null);

(statearr_73639_73670[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (6))){
var inst_73595 = (state_73630[(7)]);
var inst_73616 = (inst_73595 > (0));
var state_73630__$1 = state_73630;
if(cljs.core.truth_(inst_73616)){
var statearr_73640_73671 = state_73630__$1;
(statearr_73640_73671[(1)] = (12));

} else {
var statearr_73641_73672 = state_73630__$1;
(statearr_73641_73672[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (3))){
var inst_73628 = (state_73630[(2)]);
var state_73630__$1 = state_73630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73630__$1,inst_73628);
} else {
if((state_val_73631 === (12))){
var inst_73594 = (state_73630[(8)]);
var inst_73618 = cljs.core.vec.call(null,inst_73594);
var state_73630__$1 = state_73630;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73630__$1,(15),out,inst_73618);
} else {
if((state_val_73631 === (2))){
var state_73630__$1 = state_73630;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73630__$1,(4),ch);
} else {
if((state_val_73631 === (11))){
var inst_73610 = (state_73630[(2)]);
var inst_73611 = (new Array(n));
var inst_73594 = inst_73611;
var inst_73595 = (0);
var state_73630__$1 = (function (){var statearr_73642 = state_73630;
(statearr_73642[(7)] = inst_73595);

(statearr_73642[(8)] = inst_73594);

(statearr_73642[(10)] = inst_73610);

return statearr_73642;
})();
var statearr_73643_73673 = state_73630__$1;
(statearr_73643_73673[(2)] = null);

(statearr_73643_73673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (9))){
var inst_73594 = (state_73630[(8)]);
var inst_73608 = cljs.core.vec.call(null,inst_73594);
var state_73630__$1 = state_73630;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73630__$1,(11),out,inst_73608);
} else {
if((state_val_73631 === (5))){
var inst_73595 = (state_73630[(7)]);
var inst_73603 = (state_73630[(11)]);
var inst_73594 = (state_73630[(8)]);
var inst_73598 = (state_73630[(9)]);
var inst_73602 = (inst_73594[inst_73595] = inst_73598);
var inst_73603__$1 = (inst_73595 + (1));
var inst_73604 = (inst_73603__$1 < n);
var state_73630__$1 = (function (){var statearr_73644 = state_73630;
(statearr_73644[(11)] = inst_73603__$1);

(statearr_73644[(12)] = inst_73602);

return statearr_73644;
})();
if(cljs.core.truth_(inst_73604)){
var statearr_73645_73674 = state_73630__$1;
(statearr_73645_73674[(1)] = (8));

} else {
var statearr_73646_73675 = state_73630__$1;
(statearr_73646_73675[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (14))){
var inst_73623 = (state_73630[(2)]);
var inst_73624 = cljs.core.async.close_BANG_.call(null,out);
var state_73630__$1 = (function (){var statearr_73648 = state_73630;
(statearr_73648[(13)] = inst_73623);

return statearr_73648;
})();
var statearr_73649_73676 = state_73630__$1;
(statearr_73649_73676[(2)] = inst_73624);

(statearr_73649_73676[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (10))){
var inst_73614 = (state_73630[(2)]);
var state_73630__$1 = state_73630;
var statearr_73650_73677 = state_73630__$1;
(statearr_73650_73677[(2)] = inst_73614);

(statearr_73650_73677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73631 === (8))){
var inst_73603 = (state_73630[(11)]);
var inst_73594 = (state_73630[(8)]);
var tmp73647 = inst_73594;
var inst_73594__$1 = tmp73647;
var inst_73595 = inst_73603;
var state_73630__$1 = (function (){var statearr_73651 = state_73630;
(statearr_73651[(7)] = inst_73595);

(statearr_73651[(8)] = inst_73594__$1);

return statearr_73651;
})();
var statearr_73652_73678 = state_73630__$1;
(statearr_73652_73678[(2)] = null);

(statearr_73652_73678[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73664,out))
;
return ((function (switch__70820__auto__,c__70934__auto___73664,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73656[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73656[(1)] = (1));

return statearr_73656;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_73630){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73657){if((e73657 instanceof Object)){
var ex__70824__auto__ = e73657;
var statearr_73658_73679 = state_73630;
(statearr_73658_73679[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73630);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73657;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73680 = state_73630;
state_73630 = G__73680;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_73630){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_73630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73664,out))
})();
var state__70936__auto__ = (function (){var statearr_73659 = f__70935__auto__.call(null);
(statearr_73659[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73664);

return statearr_73659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73664,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args73681 = [];
var len__67408__auto___73755 = arguments.length;
var i__67409__auto___73756 = (0);
while(true){
if((i__67409__auto___73756 < len__67408__auto___73755)){
args73681.push((arguments[i__67409__auto___73756]));

var G__73757 = (i__67409__auto___73756 + (1));
i__67409__auto___73756 = G__73757;
continue;
} else {
}
break;
}

var G__73683 = args73681.length;
switch (G__73683) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args73681.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__70934__auto___73759 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__70934__auto___73759,out){
return (function (){
var f__70935__auto__ = (function (){var switch__70820__auto__ = ((function (c__70934__auto___73759,out){
return (function (state_73725){
var state_val_73726 = (state_73725[(1)]);
if((state_val_73726 === (7))){
var inst_73721 = (state_73725[(2)]);
var state_73725__$1 = state_73725;
var statearr_73727_73760 = state_73725__$1;
(statearr_73727_73760[(2)] = inst_73721);

(statearr_73727_73760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (1))){
var inst_73684 = [];
var inst_73685 = inst_73684;
var inst_73686 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_73725__$1 = (function (){var statearr_73728 = state_73725;
(statearr_73728[(7)] = inst_73686);

(statearr_73728[(8)] = inst_73685);

return statearr_73728;
})();
var statearr_73729_73761 = state_73725__$1;
(statearr_73729_73761[(2)] = null);

(statearr_73729_73761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (4))){
var inst_73689 = (state_73725[(9)]);
var inst_73689__$1 = (state_73725[(2)]);
var inst_73690 = (inst_73689__$1 == null);
var inst_73691 = cljs.core.not.call(null,inst_73690);
var state_73725__$1 = (function (){var statearr_73730 = state_73725;
(statearr_73730[(9)] = inst_73689__$1);

return statearr_73730;
})();
if(inst_73691){
var statearr_73731_73762 = state_73725__$1;
(statearr_73731_73762[(1)] = (5));

} else {
var statearr_73732_73763 = state_73725__$1;
(statearr_73732_73763[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (15))){
var inst_73715 = (state_73725[(2)]);
var state_73725__$1 = state_73725;
var statearr_73733_73764 = state_73725__$1;
(statearr_73733_73764[(2)] = inst_73715);

(statearr_73733_73764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (13))){
var state_73725__$1 = state_73725;
var statearr_73734_73765 = state_73725__$1;
(statearr_73734_73765[(2)] = null);

(statearr_73734_73765[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (6))){
var inst_73685 = (state_73725[(8)]);
var inst_73710 = inst_73685.length;
var inst_73711 = (inst_73710 > (0));
var state_73725__$1 = state_73725;
if(cljs.core.truth_(inst_73711)){
var statearr_73735_73766 = state_73725__$1;
(statearr_73735_73766[(1)] = (12));

} else {
var statearr_73736_73767 = state_73725__$1;
(statearr_73736_73767[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (3))){
var inst_73723 = (state_73725[(2)]);
var state_73725__$1 = state_73725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_73725__$1,inst_73723);
} else {
if((state_val_73726 === (12))){
var inst_73685 = (state_73725[(8)]);
var inst_73713 = cljs.core.vec.call(null,inst_73685);
var state_73725__$1 = state_73725;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73725__$1,(15),out,inst_73713);
} else {
if((state_val_73726 === (2))){
var state_73725__$1 = state_73725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_73725__$1,(4),ch);
} else {
if((state_val_73726 === (11))){
var inst_73693 = (state_73725[(10)]);
var inst_73689 = (state_73725[(9)]);
var inst_73703 = (state_73725[(2)]);
var inst_73704 = [];
var inst_73705 = inst_73704.push(inst_73689);
var inst_73685 = inst_73704;
var inst_73686 = inst_73693;
var state_73725__$1 = (function (){var statearr_73737 = state_73725;
(statearr_73737[(11)] = inst_73703);

(statearr_73737[(7)] = inst_73686);

(statearr_73737[(12)] = inst_73705);

(statearr_73737[(8)] = inst_73685);

return statearr_73737;
})();
var statearr_73738_73768 = state_73725__$1;
(statearr_73738_73768[(2)] = null);

(statearr_73738_73768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (9))){
var inst_73685 = (state_73725[(8)]);
var inst_73701 = cljs.core.vec.call(null,inst_73685);
var state_73725__$1 = state_73725;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_73725__$1,(11),out,inst_73701);
} else {
if((state_val_73726 === (5))){
var inst_73686 = (state_73725[(7)]);
var inst_73693 = (state_73725[(10)]);
var inst_73689 = (state_73725[(9)]);
var inst_73693__$1 = f.call(null,inst_73689);
var inst_73694 = cljs.core._EQ_.call(null,inst_73693__$1,inst_73686);
var inst_73695 = cljs.core.keyword_identical_QMARK_.call(null,inst_73686,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_73696 = (inst_73694) || (inst_73695);
var state_73725__$1 = (function (){var statearr_73739 = state_73725;
(statearr_73739[(10)] = inst_73693__$1);

return statearr_73739;
})();
if(cljs.core.truth_(inst_73696)){
var statearr_73740_73769 = state_73725__$1;
(statearr_73740_73769[(1)] = (8));

} else {
var statearr_73741_73770 = state_73725__$1;
(statearr_73741_73770[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (14))){
var inst_73718 = (state_73725[(2)]);
var inst_73719 = cljs.core.async.close_BANG_.call(null,out);
var state_73725__$1 = (function (){var statearr_73743 = state_73725;
(statearr_73743[(13)] = inst_73718);

return statearr_73743;
})();
var statearr_73744_73771 = state_73725__$1;
(statearr_73744_73771[(2)] = inst_73719);

(statearr_73744_73771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (10))){
var inst_73708 = (state_73725[(2)]);
var state_73725__$1 = state_73725;
var statearr_73745_73772 = state_73725__$1;
(statearr_73745_73772[(2)] = inst_73708);

(statearr_73745_73772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_73726 === (8))){
var inst_73693 = (state_73725[(10)]);
var inst_73689 = (state_73725[(9)]);
var inst_73685 = (state_73725[(8)]);
var inst_73698 = inst_73685.push(inst_73689);
var tmp73742 = inst_73685;
var inst_73685__$1 = tmp73742;
var inst_73686 = inst_73693;
var state_73725__$1 = (function (){var statearr_73746 = state_73725;
(statearr_73746[(14)] = inst_73698);

(statearr_73746[(7)] = inst_73686);

(statearr_73746[(8)] = inst_73685__$1);

return statearr_73746;
})();
var statearr_73747_73773 = state_73725__$1;
(statearr_73747_73773[(2)] = null);

(statearr_73747_73773[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__70934__auto___73759,out))
;
return ((function (switch__70820__auto__,c__70934__auto___73759,out){
return (function() {
var cljs$core$async$state_machine__70821__auto__ = null;
var cljs$core$async$state_machine__70821__auto____0 = (function (){
var statearr_73751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73751[(0)] = cljs$core$async$state_machine__70821__auto__);

(statearr_73751[(1)] = (1));

return statearr_73751;
});
var cljs$core$async$state_machine__70821__auto____1 = (function (state_73725){
while(true){
var ret_value__70822__auto__ = (function (){try{while(true){
var result__70823__auto__ = switch__70820__auto__.call(null,state_73725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__70823__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__70823__auto__;
}
break;
}
}catch (e73752){if((e73752 instanceof Object)){
var ex__70824__auto__ = e73752;
var statearr_73753_73774 = state_73725;
(statearr_73753_73774[(5)] = ex__70824__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_73725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e73752;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__70822__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__73775 = state_73725;
state_73725 = G__73775;
continue;
} else {
return ret_value__70822__auto__;
}
break;
}
});
cljs$core$async$state_machine__70821__auto__ = function(state_73725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__70821__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__70821__auto____1.call(this,state_73725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__70821__auto____0;
cljs$core$async$state_machine__70821__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__70821__auto____1;
return cljs$core$async$state_machine__70821__auto__;
})()
;})(switch__70820__auto__,c__70934__auto___73759,out))
})();
var state__70936__auto__ = (function (){var statearr_73754 = f__70935__auto__.call(null);
(statearr_73754[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__70934__auto___73759);

return statearr_73754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__70936__auto__);
});})(c__70934__auto___73759,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map