// Compiled by ClojureScript 1.9.494 {}
goog.provide('garden.stylesheet');
goog.require('cljs.core');
goog.require('garden.util');
goog.require('garden.color');
goog.require('garden.types');
/**
 * Create a rule function for the given selector. The `selector`
 *   argument must be valid selector (ie. a keyword, string, or symbol).
 *   Additional arguments may consist of extra selectors or
 *   declarations.
 * 
 *   The returned function accepts any number of arguments which represent
 *   the rule's children.
 * 
 *   Ex.
 *    (let [text-field (rule "[type="text"])]
 *     (text-field {:border ["1px" :solid "black"]}))
 *    ;; => ["[type="text"] {:boder ["1px" :solid "black"]}]
 */
garden.stylesheet.rule = (function garden$stylesheet$rule(var_args){
var args__67415__auto__ = [];
var len__67408__auto___84717 = arguments.length;
var i__67409__auto___84718 = (0);
while(true){
if((i__67409__auto___84718 < len__67408__auto___84717)){
args__67415__auto__.push((arguments[i__67409__auto___84718]));

var G__84719 = (i__67409__auto___84718 + (1));
i__67409__auto___84718 = G__84719;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic = (function (selector,more){
if(!(((selector instanceof cljs.core.Keyword)) || (typeof selector === 'string') || ((selector instanceof cljs.core.Symbol)))){
throw cljs.core.ex_info.call(null,"Selector must be either a keyword, string, or symbol.",cljs.core.PersistentArrayMap.EMPTY);
} else {
return (function() { 
var G__84720__delegate = function (children){
return cljs.core.into.call(null,cljs.core.apply.call(null,cljs.core.vector,selector,more),children);
};
var G__84720 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__84721__i = 0, G__84721__a = new Array(arguments.length -  0);
while (G__84721__i < G__84721__a.length) {G__84721__a[G__84721__i] = arguments[G__84721__i + 0]; ++G__84721__i;}
  children = new cljs.core.IndexedSeq(G__84721__a,0);
} 
return G__84720__delegate.call(this,children);};
G__84720.cljs$lang$maxFixedArity = 0;
G__84720.cljs$lang$applyTo = (function (arglist__84722){
var children = cljs.core.seq(arglist__84722);
return G__84720__delegate(children);
});
G__84720.cljs$core$IFn$_invoke$arity$variadic = G__84720__delegate;
return G__84720;
})()
;
}
});

garden.stylesheet.rule.cljs$lang$maxFixedArity = (1);

garden.stylesheet.rule.cljs$lang$applyTo = (function (seq84715){
var G__84716 = cljs.core.first.call(null,seq84715);
var seq84715__$1 = cljs.core.next.call(null,seq84715);
return garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic(G__84716,seq84715__$1);
});

garden.stylesheet.cssfn = (function garden$stylesheet$cssfn(fn_name){
return (function() { 
var G__84723__delegate = function (args){
return (new garden.types.CSSFunction(fn_name,args,null,null,null));
};
var G__84723 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__84724__i = 0, G__84724__a = new Array(arguments.length -  0);
while (G__84724__i < G__84724__a.length) {G__84724__a[G__84724__i] = arguments[G__84724__i + 0]; ++G__84724__i;}
  args = new cljs.core.IndexedSeq(G__84724__a,0);
} 
return G__84723__delegate.call(this,args);};
G__84723.cljs$lang$maxFixedArity = 0;
G__84723.cljs$lang$applyTo = (function (arglist__84725){
var args = cljs.core.seq(arglist__84725);
return G__84723__delegate(args);
});
G__84723.cljs$core$IFn$_invoke$arity$variadic = G__84723__delegate;
return G__84723;
})()
;
});
garden.stylesheet.at_rule = (function garden$stylesheet$at_rule(identifier,value){
return (new garden.types.CSSAtRule(identifier,value,null,null,null));
});
/**
 * Create a CSS @font-face rule.
 */
garden.stylesheet.at_font_face = (function garden$stylesheet$at_font_face(var_args){
var args__67415__auto__ = [];
var len__67408__auto___84727 = arguments.length;
var i__67409__auto___84728 = (0);
while(true){
if((i__67409__auto___84728 < len__67408__auto___84727)){
args__67415__auto__.push((arguments[i__67409__auto___84728]));

var G__84729 = (i__67409__auto___84728 + (1));
i__67409__auto___84728 = G__84729;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((0) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((0)),(0),null)):null);
return garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic(argseq__67416__auto__);
});

garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic = (function (font_properties){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@font-face",font_properties], null);
});

garden.stylesheet.at_font_face.cljs$lang$maxFixedArity = (0);

garden.stylesheet.at_font_face.cljs$lang$applyTo = (function (seq84726){
return garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq84726));
});

/**
 * Create a CSS @import rule.
 */
garden.stylesheet.at_import = (function garden$stylesheet$at_import(var_args){
var args84730 = [];
var len__67408__auto___84735 = arguments.length;
var i__67409__auto___84736 = (0);
while(true){
if((i__67409__auto___84736 < len__67408__auto___84735)){
args84730.push((arguments[i__67409__auto___84736]));

var G__84737 = (i__67409__auto___84736 + (1));
i__67409__auto___84736 = G__84737;
continue;
} else {
}
break;
}

var G__84734 = args84730.length;
switch (G__84734) {
case 1:
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__67431__auto__ = (new cljs.core.IndexedSeq(args84730.slice((1)),(0),null));
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67431__auto__);

}
});

garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$1 = (function (url){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),null], null));
});

garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic = (function (url,media_queries){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),media_queries], null));
});

garden.stylesheet.at_import.cljs$lang$applyTo = (function (seq84731){
var G__84732 = cljs.core.first.call(null,seq84731);
var seq84731__$1 = cljs.core.next.call(null,seq84731);
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic(G__84732,seq84731__$1);
});

garden.stylesheet.at_import.cljs$lang$maxFixedArity = (1);

/**
 * Create a CSS @media rule.
 */
garden.stylesheet.at_media = (function garden$stylesheet$at_media(var_args){
var args__67415__auto__ = [];
var len__67408__auto___84741 = arguments.length;
var i__67409__auto___84742 = (0);
while(true){
if((i__67409__auto___84742 < len__67408__auto___84741)){
args__67415__auto__.push((arguments[i__67409__auto___84742]));

var G__84743 = (i__67409__auto___84742 + (1));
i__67409__auto___84742 = G__84743;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic = (function (media_queries,rules){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"media","media",-1066138403),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),media_queries,new cljs.core.Keyword(null,"rules","rules",1198912366),rules], null));
});

garden.stylesheet.at_media.cljs$lang$maxFixedArity = (1);

garden.stylesheet.at_media.cljs$lang$applyTo = (function (seq84739){
var G__84740 = cljs.core.first.call(null,seq84739);
var seq84739__$1 = cljs.core.next.call(null,seq84739);
return garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic(G__84740,seq84739__$1);
});

/**
 * Create a CSS @keyframes rule.
 */
garden.stylesheet.at_keyframes = (function garden$stylesheet$at_keyframes(var_args){
var args__67415__auto__ = [];
var len__67408__auto___84746 = arguments.length;
var i__67409__auto___84747 = (0);
while(true){
if((i__67409__auto___84747 < len__67408__auto___84746)){
args__67415__auto__.push((arguments[i__67409__auto___84747]));

var G__84748 = (i__67409__auto___84747 + (1));
i__67409__auto___84747 = G__84748;
continue;
} else {
}
break;
}

var argseq__67416__auto__ = ((((1) < args__67415__auto__.length))?(new cljs.core.IndexedSeq(args__67415__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67416__auto__);
});

garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic = (function (identifier,frames){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"identifier","identifier",-805503498),identifier,new cljs.core.Keyword(null,"frames","frames",1765687497),frames], null));
});

garden.stylesheet.at_keyframes.cljs$lang$maxFixedArity = (1);

garden.stylesheet.at_keyframes.cljs$lang$applyTo = (function (seq84744){
var G__84745 = cljs.core.first.call(null,seq84744);
var seq84744__$1 = cljs.core.next.call(null,seq84744);
return garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic(G__84745,seq84744__$1);
});

/**
 * Create a color from RGB values.
 */
garden.stylesheet.rgb = (function garden$stylesheet$rgb(r,g,b){
return garden.color.rgb.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,g,b], null));
});
/**
 * Create a color from HSL values.
 */
garden.stylesheet.hsl = (function garden$stylesheet$hsl(h,s,l){
return garden.color.hsl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [h,s,l], null));
});

//# sourceMappingURL=stylesheet.js.map?rel=1489355964688