// Compiled by ClojureScript 1.9.494 {}
goog.provide('reagent.dom');
goog.require('cljs.core');
goog.require('cljsjs.react.dom');
goog.require('reagent.impl.util');
goog.require('reagent.impl.template');
goog.require('reagent.impl.batching');
goog.require('reagent.ratom');
goog.require('reagent.debug');
goog.require('reagent.interop');
if(typeof reagent.dom.imported !== 'undefined'){
} else {
reagent.dom.imported = null;
}
reagent.dom.module = (function reagent$dom$module(){
if(!((reagent.dom.imported == null))){
return reagent.dom.imported;
} else {
if(typeof ReactDOM !== 'undefined'){
return reagent.dom.imported = ReactDOM;
} else {
if(typeof require !== 'undefined'){
var or__66187__auto__ = reagent.dom.imported = require("react-dom");
if(cljs.core.truth_(or__66187__auto__)){
return or__66187__auto__;
} else {
throw (new Error("require('react-dom') failed"));
}
} else {
throw (new Error("js/ReactDOM is missing"));

}
}
}
});
if(typeof reagent.dom.roots !== 'undefined'){
} else {
reagent.dom.roots = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
reagent.dom.unmount_comp = (function reagent$dom$unmount_comp(container){
cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.dissoc,container);

return (reagent.dom.module.call(null)["unmountComponentAtNode"])(container);
});
reagent.dom.render_comp = (function reagent$dom$render_comp(comp,container,callback){
var _STAR_always_update_STAR_84355 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = true;

try{return (reagent.dom.module.call(null)["render"])(comp.call(null),container,((function (_STAR_always_update_STAR_84355){
return (function (){
var _STAR_always_update_STAR_84356 = reagent.impl.util._STAR_always_update_STAR_;
reagent.impl.util._STAR_always_update_STAR_ = false;

try{cljs.core.swap_BANG_.call(null,reagent.dom.roots,cljs.core.assoc,container,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [comp,container], null));

reagent.impl.batching.flush_after_render.call(null);

if(!((callback == null))){
return callback.call(null);
} else {
return null;
}
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_84356;
}});})(_STAR_always_update_STAR_84355))
);
}finally {reagent.impl.util._STAR_always_update_STAR_ = _STAR_always_update_STAR_84355;
}});
reagent.dom.re_render_component = (function reagent$dom$re_render_component(comp,container){
return reagent.dom.render_comp.call(null,comp,container,null);
});
/**
 * Render a Reagent component into the DOM. The first argument may be
 *   either a vector (using Reagent's Hiccup syntax), or a React element. The second argument should be a DOM node.
 * 
 *   Optionally takes a callback that is called when the component is in place.
 * 
 *   Returns the mounted component instance.
 */
reagent.dom.render = (function reagent$dom$render(var_args){
var args84357 = [];
var len__67408__auto___84360 = arguments.length;
var i__67409__auto___84361 = (0);
while(true){
if((i__67409__auto___84361 < len__67408__auto___84360)){
args84357.push((arguments[i__67409__auto___84361]));

var G__84362 = (i__67409__auto___84361 + (1));
i__67409__auto___84361 = G__84362;
continue;
} else {
}
break;
}

var G__84359 = args84357.length;
switch (G__84359) {
case 2:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return reagent.dom.render.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args84357.length)].join('')));

}
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$2 = (function (comp,container){
return reagent.dom.render.call(null,comp,container,null);
});

reagent.dom.render.cljs$core$IFn$_invoke$arity$3 = (function (comp,container,callback){
reagent.ratom.flush_BANG_.call(null);

var f = (function (){
return reagent.impl.template.as_element.call(null,((cljs.core.fn_QMARK_.call(null,comp))?comp.call(null):comp));
});
return reagent.dom.render_comp.call(null,f,container,callback);
});

reagent.dom.render.cljs$lang$maxFixedArity = 3;

reagent.dom.unmount_component_at_node = (function reagent$dom$unmount_component_at_node(container){
return reagent.dom.unmount_comp.call(null,container);
});
/**
 * Returns the root DOM node of a mounted component.
 */
reagent.dom.dom_node = (function reagent$dom$dom_node(this$){
return (reagent.dom.module.call(null)["findDOMNode"])(this$);
});
/**
 * Force re-rendering of all mounted Reagent components. This is
 *   probably only useful in a development environment, when you want to
 *   update components in response to some dynamic changes to code.
 * 
 *   Note that force-update-all may not update root components. This
 *   happens if a component 'foo' is mounted with `(render [foo])` (since
 *   functions are passed by value, and not by reference, in
 *   ClojureScript). To get around this you'll have to introduce a layer
 *   of indirection, for example by using `(render [#'foo])` instead.
 */
reagent.dom.force_update_all = (function reagent$dom$force_update_all(){
reagent.ratom.flush_BANG_.call(null);

var seq__84368_84372 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,reagent.dom.roots)));
var chunk__84369_84373 = null;
var count__84370_84374 = (0);
var i__84371_84375 = (0);
while(true){
if((i__84371_84375 < count__84370_84374)){
var v_84376 = cljs.core._nth.call(null,chunk__84369_84373,i__84371_84375);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_84376);

var G__84377 = seq__84368_84372;
var G__84378 = chunk__84369_84373;
var G__84379 = count__84370_84374;
var G__84380 = (i__84371_84375 + (1));
seq__84368_84372 = G__84377;
chunk__84369_84373 = G__84378;
count__84370_84374 = G__84379;
i__84371_84375 = G__84380;
continue;
} else {
var temp__6753__auto___84381 = cljs.core.seq.call(null,seq__84368_84372);
if(temp__6753__auto___84381){
var seq__84368_84382__$1 = temp__6753__auto___84381;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__84368_84382__$1)){
var c__67098__auto___84383 = cljs.core.chunk_first.call(null,seq__84368_84382__$1);
var G__84384 = cljs.core.chunk_rest.call(null,seq__84368_84382__$1);
var G__84385 = c__67098__auto___84383;
var G__84386 = cljs.core.count.call(null,c__67098__auto___84383);
var G__84387 = (0);
seq__84368_84372 = G__84384;
chunk__84369_84373 = G__84385;
count__84370_84374 = G__84386;
i__84371_84375 = G__84387;
continue;
} else {
var v_84388 = cljs.core.first.call(null,seq__84368_84382__$1);
cljs.core.apply.call(null,reagent.dom.re_render_component,v_84388);

var G__84389 = cljs.core.next.call(null,seq__84368_84382__$1);
var G__84390 = null;
var G__84391 = (0);
var G__84392 = (0);
seq__84368_84372 = G__84389;
chunk__84369_84373 = G__84390;
count__84370_84374 = G__84391;
i__84371_84375 = G__84392;
continue;
}
} else {
}
}
break;
}

return "Updated";
});

//# sourceMappingURL=dom.js.map?rel=1489355964040