// Compiled by ClojureScript 1.9.494 {}
goog.provide('garden.stylesheet');
goog.require('cljs.core');
goog.require('garden.util');
goog.require('garden.color');
goog.require('garden.types');
/**
 * Create a rule function for the given selector. The `selector`
 *   argument must be valid selector (ie. a keyword, string, or symbol).
 *   Additional arguments may consist of extra selectors or
 *   declarations.
 * 
 *   The returned function accepts any number of arguments which represent
 *   the rule's children.
 * 
 *   Ex.
 *    (let [text-field (rule "[type="text"])]
 *     (text-field {:border ["1px" :solid "black"]}))
 *    ;; => ["[type="text"] {:boder ["1px" :solid "black"]}]
 */
garden.stylesheet.rule = (function garden$stylesheet$rule(var_args){
var args__67427__auto__ = [];
var len__67420__auto___70345 = arguments.length;
var i__67421__auto___70346 = (0);
while(true){
if((i__67421__auto___70346 < len__67420__auto___70345)){
args__67427__auto__.push((arguments[i__67421__auto___70346]));

var G__70347 = (i__67421__auto___70346 + (1));
i__67421__auto___70346 = G__70347;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic = (function (selector,more){
if(!(((selector instanceof cljs.core.Keyword)) || (typeof selector === 'string') || ((selector instanceof cljs.core.Symbol)))){
throw cljs.core.ex_info.call(null,"Selector must be either a keyword, string, or symbol.",cljs.core.PersistentArrayMap.EMPTY);
} else {
return (function() { 
var G__70348__delegate = function (children){
return cljs.core.into.call(null,cljs.core.apply.call(null,cljs.core.vector,selector,more),children);
};
var G__70348 = function (var_args){
var children = null;
if (arguments.length > 0) {
var G__70349__i = 0, G__70349__a = new Array(arguments.length -  0);
while (G__70349__i < G__70349__a.length) {G__70349__a[G__70349__i] = arguments[G__70349__i + 0]; ++G__70349__i;}
  children = new cljs.core.IndexedSeq(G__70349__a,0);
} 
return G__70348__delegate.call(this,children);};
G__70348.cljs$lang$maxFixedArity = 0;
G__70348.cljs$lang$applyTo = (function (arglist__70350){
var children = cljs.core.seq(arglist__70350);
return G__70348__delegate(children);
});
G__70348.cljs$core$IFn$_invoke$arity$variadic = G__70348__delegate;
return G__70348;
})()
;
}
});

garden.stylesheet.rule.cljs$lang$maxFixedArity = (1);

garden.stylesheet.rule.cljs$lang$applyTo = (function (seq70343){
var G__70344 = cljs.core.first.call(null,seq70343);
var seq70343__$1 = cljs.core.next.call(null,seq70343);
return garden.stylesheet.rule.cljs$core$IFn$_invoke$arity$variadic(G__70344,seq70343__$1);
});

garden.stylesheet.cssfn = (function garden$stylesheet$cssfn(fn_name){
return (function() { 
var G__70351__delegate = function (args){
return (new garden.types.CSSFunction(fn_name,args,null,null,null));
};
var G__70351 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__70352__i = 0, G__70352__a = new Array(arguments.length -  0);
while (G__70352__i < G__70352__a.length) {G__70352__a[G__70352__i] = arguments[G__70352__i + 0]; ++G__70352__i;}
  args = new cljs.core.IndexedSeq(G__70352__a,0);
} 
return G__70351__delegate.call(this,args);};
G__70351.cljs$lang$maxFixedArity = 0;
G__70351.cljs$lang$applyTo = (function (arglist__70353){
var args = cljs.core.seq(arglist__70353);
return G__70351__delegate(args);
});
G__70351.cljs$core$IFn$_invoke$arity$variadic = G__70351__delegate;
return G__70351;
})()
;
});
garden.stylesheet.at_rule = (function garden$stylesheet$at_rule(identifier,value){
return (new garden.types.CSSAtRule(identifier,value,null,null,null));
});
/**
 * Create a CSS @font-face rule.
 */
garden.stylesheet.at_font_face = (function garden$stylesheet$at_font_face(var_args){
var args__67427__auto__ = [];
var len__67420__auto___70355 = arguments.length;
var i__67421__auto___70356 = (0);
while(true){
if((i__67421__auto___70356 < len__67420__auto___70355)){
args__67427__auto__.push((arguments[i__67421__auto___70356]));

var G__70357 = (i__67421__auto___70356 + (1));
i__67421__auto___70356 = G__70357;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((0) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((0)),(0),null)):null);
return garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic(argseq__67428__auto__);
});

garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic = (function (font_properties){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["@font-face",font_properties], null);
});

garden.stylesheet.at_font_face.cljs$lang$maxFixedArity = (0);

garden.stylesheet.at_font_face.cljs$lang$applyTo = (function (seq70354){
return garden.stylesheet.at_font_face.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70354));
});

/**
 * Create a CSS @import rule.
 */
garden.stylesheet.at_import = (function garden$stylesheet$at_import(var_args){
var args70358 = [];
var len__67420__auto___70363 = arguments.length;
var i__67421__auto___70364 = (0);
while(true){
if((i__67421__auto___70364 < len__67420__auto___70363)){
args70358.push((arguments[i__67421__auto___70364]));

var G__70365 = (i__67421__auto___70364 + (1));
i__67421__auto___70364 = G__70365;
continue;
} else {
}
break;
}

var G__70362 = args70358.length;
switch (G__70362) {
case 1:
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__67443__auto__ = (new cljs.core.IndexedSeq(args70358.slice((1)),(0),null));
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67443__auto__);

}
});

garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$1 = (function (url){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),null], null));
});

garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic = (function (url,media_queries){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"import","import",-1399500709),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),media_queries], null));
});

garden.stylesheet.at_import.cljs$lang$applyTo = (function (seq70359){
var G__70360 = cljs.core.first.call(null,seq70359);
var seq70359__$1 = cljs.core.next.call(null,seq70359);
return garden.stylesheet.at_import.cljs$core$IFn$_invoke$arity$variadic(G__70360,seq70359__$1);
});

garden.stylesheet.at_import.cljs$lang$maxFixedArity = (1);

/**
 * Create a CSS @media rule.
 */
garden.stylesheet.at_media = (function garden$stylesheet$at_media(var_args){
var args__67427__auto__ = [];
var len__67420__auto___70369 = arguments.length;
var i__67421__auto___70370 = (0);
while(true){
if((i__67421__auto___70370 < len__67420__auto___70369)){
args__67427__auto__.push((arguments[i__67421__auto___70370]));

var G__70371 = (i__67421__auto___70370 + (1));
i__67421__auto___70370 = G__70371;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic = (function (media_queries,rules){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"media","media",-1066138403),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"media-queries","media-queries",-1563277678),media_queries,new cljs.core.Keyword(null,"rules","rules",1198912366),rules], null));
});

garden.stylesheet.at_media.cljs$lang$maxFixedArity = (1);

garden.stylesheet.at_media.cljs$lang$applyTo = (function (seq70367){
var G__70368 = cljs.core.first.call(null,seq70367);
var seq70367__$1 = cljs.core.next.call(null,seq70367);
return garden.stylesheet.at_media.cljs$core$IFn$_invoke$arity$variadic(G__70368,seq70367__$1);
});

/**
 * Create a CSS @keyframes rule.
 */
garden.stylesheet.at_keyframes = (function garden$stylesheet$at_keyframes(var_args){
var args__67427__auto__ = [];
var len__67420__auto___70374 = arguments.length;
var i__67421__auto___70375 = (0);
while(true){
if((i__67421__auto___70375 < len__67420__auto___70374)){
args__67427__auto__.push((arguments[i__67421__auto___70375]));

var G__70376 = (i__67421__auto___70375 + (1));
i__67421__auto___70375 = G__70376;
continue;
} else {
}
break;
}

var argseq__67428__auto__ = ((((1) < args__67427__auto__.length))?(new cljs.core.IndexedSeq(args__67427__auto__.slice((1)),(0),null)):null);
return garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__67428__auto__);
});

garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic = (function (identifier,frames){
return garden.stylesheet.at_rule.call(null,new cljs.core.Keyword(null,"keyframes","keyframes",-1437976012),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"identifier","identifier",-805503498),identifier,new cljs.core.Keyword(null,"frames","frames",1765687497),frames], null));
});

garden.stylesheet.at_keyframes.cljs$lang$maxFixedArity = (1);

garden.stylesheet.at_keyframes.cljs$lang$applyTo = (function (seq70372){
var G__70373 = cljs.core.first.call(null,seq70372);
var seq70372__$1 = cljs.core.next.call(null,seq70372);
return garden.stylesheet.at_keyframes.cljs$core$IFn$_invoke$arity$variadic(G__70373,seq70372__$1);
});

/**
 * Create a color from RGB values.
 */
garden.stylesheet.rgb = (function garden$stylesheet$rgb(r,g,b){
return garden.color.rgb.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [r,g,b], null));
});
/**
 * Create a color from HSL values.
 */
garden.stylesheet.hsl = (function garden$stylesheet$hsl(h,s,l){
return garden.color.hsl.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [h,s,l], null));
});

//# sourceMappingURL=stylesheet.js.map