(ns mathdoc.main
  (:gen-class)
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [clojure.spec.test :as stest]
            [duct.core :as duct]))

(defn read-config [f]
  (duct/read-config
    (io/resource "mathdoc/core/config.edn")
    (io/resource "mathdoc/server/config.edn")
    (io/resource "mathdoc/compiler/config.edn")
    (io/resource "mathdoc/cljs/config.edn")
    (io/file f)))

(defn exec [])

(defn -main [& args]
  (stest/instrument (stest/instrumentable-syms))
  (s/check-asserts true)
  (duct/exec
   (read-config (or (first args) "config.edn"))))

;;; tests

(comment

  (read-config "config.edn")

  )
