(ns mathdoc.module.logger
  (:require [integrant.core :as ig]
            [duct.core :as duct]))

(defmethod ig/init-key
  ::inject
  [_ {:keys [ks]}]
  (fn
    [config]
    (reduce
     (fn
       [config k]
       (duct/assoc-in-default
        config
        [k :logger]
        (ig/ref :duct/logger)))
     config
     ks)))
