(ns mathdoc.process.options
  (:require [integrant.core :as ig]
            [clojure.spec :as s]))

(s/def ::content-dir string?)

(defmethod ig/init-key
  ::content-dir
  [_ v]
  {:pre [(s/assert ::content-dir v)]}
  v)

(s/def ::notes-dir string?)

(defmethod ig/init-key
  ::notes-dir
  [_ v]
  {:pre [(s/assert ::notes-dir v)]}
  v)

(s/def ::target-dir string?)

(defmethod ig/init-key
  ::target-dir
  [_ v]
  {:pre [(s/assert ::target-dir v)]}
  v)

(s/def ::include-dir string?)

(defmethod ig/init-key
  ::include-dir
  [_ v]
  {:pre [(s/assert ::include-dir v)]}
  v)

(s/def ::template string?)

(defmethod ig/init-key
  ::template
  [_ v]
  {:pre [(s/assert ::template v)]}
  v)

(s/def ::commitscript string?)

(defmethod ig/init-key
  ::commitscript
  [_ v]
  {:pre [(s/assert ::commitscript v)]}
  v)

(s/def ::append-files (s/coll-of string?))

(defmethod ig/init-key
  ::append-files
  [_ v]
  {:pre [(s/assert ::append-files v)]}
  v)

(s/def ::prepend-files (s/coll-of string?))

(defmethod ig/init-key
  ::prepend-files
  [_ v]
  {:pre [(s/assert ::prepend-files v)]}
  v)

