(ns mathdoc.process.meta
  (:refer-clojure :exclude [meta])
  (:require [clojure.string :as str]
            [medley.core :as med]
            [meta-merge.core :as meta-merge]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [duct.core :as duct]))

(defmulti emit-elem :type)

(defn map-elems [elems]
  (->> elems
       (mapv emit-elem)))

(defn str-elems [elems]
  (->> elems
       (map-elems)
       (apply str)))



;;; implementation of multi method

(defmethod emit-elem
  :MetaBool [{:keys [content]}]
  content)
(defmethod emit-elem
  :MetaString [{:keys [content]}]
  content)
(defmethod emit-elem
  :MetaInlines [{:keys [content]}]
  ;; TODO: better use another multi method here
  ;; (specific for html or latex?)
  (str-elems content))
(defmethod emit-elem
  :MetaMap [{:keys [content]}]
  (med/map-vals emit-elem content))
(defmethod emit-elem
  :MetaList [{:keys [content]}]
  (map-elems content))

;; TODO: these should be implemented somewhere else
;; (specific for html or latex?)

(defmethod emit-elem
  :Str [{:keys [content]}]
  content)
(defmethod emit-elem
  :Emph [{:keys [content]}]
  (str "<em>" (apply str (map emit-elem content)) "</em>"))
(defmethod emit-elem
  :RawInline [{:keys [content]}]
  (second content))
(defmethod emit-elem
  :Space [{:keys [content]}]
  " ")



;;; process

(defn sanitize-author [a]
  (if (vector? a)
    (str/join ", " a)
    a))

(defn process-data [m]
  (as-> m _
    (:meta _)
    (med/map-vals emit-elem _)
    (update _ :author sanitize-author)))


(defn process [{:keys [input data logger]}]
  (duct/log logger :info :process)
  (meta-merge/meta-merge data (process-data input)))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process/meta
  [_ v]
  (process v))
