(ns mathdoc.process.parse.citeproc
  (:require [clojure.java.shell :as sh]
            [clojure.spec :as s]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat
               :data (s/keys :req-un [::json]))
        :ret string?)

(s/def ::json
  string?)

;;; implementation

(defn process-data [json]
  (let [{:keys [out err exit]}
        (sh/sh "pandoc-citeproc" :in json)]
    (if (= 0 exit)
      out
      (log/error
       "pandoc-citeproc failed"
       {:out out
        :err err}))))

(defn process [{:keys [json logger]}]
  (duct/log logger :info :process)
  (process-data json))


;;; integrant

(defmethod ig/init-key
  :mathdoc.process.parse/citeproc
  [_ v]
  (process v))
