(ns mathdoc.process.parse.json
  (:require [cheshire.core :as json]
            [clojure
             [spec :as s]
             [walk :as walk]]
            [clojure.core.match :as m]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat :data
                     (s/keys :req-un [::msp/jsonstr]))
        :ret map?)

;;; implementation

(defn post-process [elements]
  (->>
   elements
   (walk/prewalk
    (fn [m]
      (m/match
       [m]
       [{:t t, :c c}] {:type (keyword t), :content c}
       [{:t t}] {:type (keyword t)}
       :else m)))))

(defn parse-json [json]
  (-> json
      (json/parse-string true)
      (post-process)))

(defn process [{:keys [jsonstr logger]}]
  (duct/log logger :info :process)
  (parse-json jsonstr))


;;; integrant

(defmethod ig/init-key
  :mathdoc.process.parse/json
  [_ v]
  (process v))
