(def MODULES
  #{:server :process :compiler :core :main :cljs :dependencies})

(def SOURCE-PATHS
  (mapv #(str "mathdoc." (name %) "/src") MODULES))

(def RESOURCE-PATHS
  (mapv #(str "mathdoc." (name %) "/resources") MODULES))

(def DEPENDENCIES
  (read-string (slurp "dependencies.edn")))

(defn select-deps
  [m keys]
  (into []
        (comp (filter (comp (set keys) first))
           (mapcat second))
        m))

(defproject org.dsteurer/mathdoc "0.1.10"
  :description "pandoc wrapper to craft mathematical documents and presentations"
  :url "http://dsteurer.org"
  :license {:name "Eclipse Public License"
            :url  "http://www.eclipse.org/legal/epl-v10.html"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies ~(select-deps DEPENDENCIES MODULES)
  :source-paths ~SOURCE-PATHS
  :resource-paths ~RESOURCE-PATHS
  :main ^:skip-aot mathdoc.main
  :profiles
  {:dev
   {:dependencies   ~(select-deps DEPENDENCIES #{:webjars :repl})
    :source-paths   ["../talks/cljs" "mathdoc.dev/src"]
    :resource-paths ["mathdoc.dev/resources"]
    :repl-options
    {:init-ns          user
     :nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}})
