(ns mathdoc.process.options
  (:require [integrant.core :as ig]
            [clojure.spec :as s]
            [mathdoc.core :as core]))

(core/derive-all
 {::fragment-path     ::core/path
  ::content-dir       ::core/path
  ::template-dir      ::core/path
  ::notes-path        ::core/path
  ::metadata-filename ::core/string})

(comment

  (ig/init-key :mathdoc.core/path "test")

  (derive ::content-dir ::core/path)

  (ig/init-key ::content-dir "test")

  (s/def ::fragment-dir string?)

  (defmethod ig/init-key
    ::fragment-dir
    [_ v]
    (s/assert ::content-dir v))

  (s/def ::content-dir string?)

  (defmethod ig/init-key
    ::content-dir
    [_ v]
    (s/assert ::content-dir v))

  (s/def ::notes-dir string?)

  (defmethod ig/init-key
    ::notes-dir
    [_ v]
    (s/assert ::notes-dir v))

  (s/def ::target-dir string?)

  (defmethod ig/init-key
    ::target-dir
    [_ v]
    (s/assert ::target-dir v))

  (s/def ::include-dir string?)

  (defmethod ig/init-key
    ::include-dir
    [_ v]
    (s/assert ::include-dir v))

  (s/def ::template string?)

  (defmethod ig/init-key
    ::template
    [_ v]
    (s/assert ::template v))

  (s/def ::commitscript string?)

  (defmethod ig/init-key
    ::commitscript
    [_ v]
    (s/assert ::commitscript v))

  (s/def ::append-files (s/coll-of string?))

  (defmethod ig/init-key
    ::append-files
    [_ v]
    (s/assert ::append-files v))

  (s/def ::prepend-files (s/coll-of string?))

  (defmethod ig/init-key
    ::prepend-files
    [_ v]
    (s/assert ::prepend-files v))

  )
