(ns mathdoc.compiler
  (:gen-class)
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [clojure.spec.test :as stest]
            [duct.core :as duct]
            [integrant.core :as ig]
            [mathdoc.core :as mathdoc]
            [mathdoc.main :as main]))

;; for safety instrument all specs
(stest/instrument (stest/instrumentable-syms))
(s/check-asserts true)

;; TODO: compiler should also process also content files and render them

(def sources
  [[:resource "mathdoc/compiler/compile.edn"]])

(defn -main [& args]
  (->>
   [:file (or (first args) "config.edn")]
   (mathdoc/read-config main/sources sources)
   (duct/prep)
   (duct/compile)))

#_(-main)

