(ns mathdoc.process.render
  (:require [integrant.core :as ig]
            [selmer.parser :as selmer]
            [clojure.java.io :as io]
            [taoensso.timbre :as log]))

(defmethod ig/init-key
  ::pandoc
  [_ {:keys [absolute-file pandoc-metadata template-path]}]
  (selmer/set-resource-path! (.toURL (io/file template-path)))
  (let [template (:pandoc-template pandoc-metadata)]
    (selmer/render-file
     template
     {:pandoc pandoc-metadata
      :body   (slurp absolute-file)}
     {:short-comment-second nil
      :tag-open \<
      :tag-close \>
      :filter-open \<
      :filter-close \>})))
