(ns mathdoc.cljs.drawmenu
  (:require
   [taoensso.timbre :as log]
   [integrant.core :as ig]
   [cljs.core.async :as a]
   [hickory.core :as h]
   [hickory.render :as hrender]
   [dommy.core :as dommy :refer-macros [sel sel1]]
   [clojure.walk :as walk]
   [mathdoc.cljs.reveal :as reveal])
  (:require-macros
   [cljs.core.async.macros :refer [alt! go go-loop]]
   [cljs.spec :as s]))

(def colors
  {:yellow  "#b58900"
   :orange  "#cb4b16"
   :red     "#dc322f"
   :magenta "#d33682"
   :violet  "#6c71c4"
   :blue    "#268bd2"
   :cyan    "#2aa198"
   :green   "#859900"})

#_(dommy/listen! (sel1 "#paintbrush-red")
                 :click #(aset js/Pen "colors" "fg" (:red colors)))

#_(dommy/listen! (sel1 "#paintbrush-yellow")
                 :click #(aset js/Pen "colors" "fg" (:yellow colors)))

(defn listen-id-color [id color]
  #_(.log js/console id color)
  (when-let [elem (sel1 (str "#" id))]
    (aset elem "style" "color" color)
    (dommy/listen!
     elem
     :click #(aset js/Pen "colors" "fg" color))))

#_(dommy/bounding-client-rect (sel1 "#paintbrush-yellow"))

(defn add-color-listeners []
  (doseq [[colorname color] colors]
    #_(.log js/console colorname color)
    (listen-id-color
     (str "paintbrush-" (name colorname))
     color)))



;; if (window.location.search.match( /nofragments/gi ))
;; { Reveal.configure({fragments: false});}


(defn maybe-hide-canvas []
  (when (-> js/window .-location .-search (.match #"nocanvas"))
    (.log js/console "hide canvas")
    (-> (sel1 "#board")
        (dommy/set-style! "display" "none"))))

(defn fix-top [slide]
  (when (dommy/has-class? slide "align-top")
    #_(print "fix-top" (.-id slide))
    (dommy/set-style!
     slide
     "top" "0px")))

#_ (-> (sel1 "#section-section-28")
       (dommy/set-style! "top" "0px"))

(defn maybe-center-slides []
  (doseq [slide (sel ".reveal section")]
    (when-not (dommy/has-class? slide "align-top")
      (dommy/add-class! slide "center"))))

#_(defn check-top-slide [ev]

  ;; doesn't work so well; better set top of slides to 0 if they have class align-top
  #_(if (dommy/has-class? (.-currentSlide ev) "align-top")
    (js/Reveal.configure #js {"center" false})
    (js/Reveal.configure #js {"center" true}))

  #_(doseq [slide ["previousSlide" "currentSlide" "nextSlide"]]
    (print "slide" slide "aget" (aget ev slide))
    (when (aget ev slide)
      (fix-top (aget ev slide))))

  #_(when (dommy/has-class? (.-currentSlide ev) "align-top")
    (dommy/set-style!
     (.-currentSlide ev)
     "top" "0px")))



#_(defn ^:export init []
  (.log js/console "drawmenu")


  (.addEventListener
   js/Reveal
   "ready"
   (juxt
    maybe-hide-canvas
    maybe-center-slides
    add-color-listeners)))

;;; integrant

(def config
  {::ready {:ready (ig/ref ::reveal/ready)}})

(defmethod ig/init-key
  ::ready
  [_ {:keys [ready]}]
  (go
    (log/info ::promise ready)
    (a/<! ready)
    (log/info ::ready :init)
    (maybe-hide-canvas)
    (maybe-center-slides)
    (add-color-listeners))
  ::ready)

(defmethod ig/resume-key
  ::ready
  [_ config _ v]
  #_(log/info ::ready :resume)
  v
  (ig/init-key ::ready config))

;;; tests

(comment

  (let [p (a/promise-chan)]
    (doseq [i (range 30)]

      (go
        (a/<! p)
        (a/<! (a/timeout (rand-int 1000)))
        (println i)))
    (a/put! p 1))

  (let [p (a/promise-chan)]
    (a/put! p 1)
    (doseq [i (range 30)]

      (go
        (a/<! p)
        (println i)))
    )

  )
