(ns mathdoc.compiler.collect
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [integrant.core :as ig]
            [mathdoc.core :as core]
            [duct.core :as duct]
            [clojure.string :as str]
            [taoensso.timbre :as log])
  (:import java.net.URI))

(comment

  (core/relative-path "test/" "test/t/test 1 test2/sds")

  )


(defn directory? [d]
  (.isDirectory (io/file d)))

(defn file-exists? [f]
  (.exists (io/file f)))

(defn ends-with [exts s]
  (some #(str/ends-with? (str s) %) exts))

(comment

  (ends-with [".blg" ".out" ".bbl" ".aux" ".log" ".toc"
              ".idx" "notes.js" "notes.html" ".ipynb"
              "/.gitignore"] (io/file "sdsd/ssd.ipynb"))

  )

(defn copy
  ([source-path target-path]
   (copy source-path target-path {}))
  ([source-path target-path {:keys [exclude-ends-with] :as opts}]
   (doseq [f (->> (io/file source-path)
                  (file-seq )
                  (remove directory?)
                  (filter file-exists?)
                  (remove (partial ends-with exclude-ends-with)))]
     (let [target-file (io/file target-path
                                (core/relative-path source-path f))]
       (io/make-parents target-file)
       (io/copy f target-file)))))

(comment

  (take 10 (file-seq (io/file "target/mathdoc/compiler/")))

  (file-seq (io/file "../talks/static/figure"))

  (take 10 (copy "target/mathdoc/compiler/resources/public" "target/mathdoc/deploy"))

  (copy "../talks/static/figure" "target/test-copy-figure/")

  )

(s/def ::sources (s/and (s/coll-of ::core/path) not-empty))
(s/def ::target-path ::core/path)
(s/def ::config (s/keys :req-un [::sources ::target-path]))

(derive ::copy :duct/compiler)

(defmethod ig/init-key
  ::copy
  [_ {:keys [sources target-path logger] :as config}]
  (s/assert ::config config)
  (doseq [s sources]
    (duct/log logger :info :source [s target-path])
    (copy s target-path config)))
