(ns mathdoc.util.latexlog
  (:require [cljs.build.api :as b]
            [clojure.java.io :as io])
  (:import javax.script.ScriptEngineManager))
(comment
  ;; Create a shared Nashorn instance and eval Babel
  (def engine
    (doto (.getEngineByName (ScriptEngineManager.) "nashorn")
      (.eval "var LatexLogParser = {}; function define (x) {LatexLogParser = x.call();}")
      (.put "logtext" (slurp "../inference/target/writeup/writeup.log"))
      (.eval (io/reader (io/resource "js/latex-log-parser.js")))
      (.eval "var logentries = LatexLogParser.parse(logtext, {})")))

  (slurp "../inference/target/writeup/writeup.log")


  (keys (.get engine "logentries"))
  (get (.get engine "logentries") "warnings")

  ;; Add a custom transform
  (defmethod closure/js-transforms :jsx [ijs opts]
    (let [code (str (gensym))]
      (.put engine code (:source ijs))
      (assoc ijs :source
             (.eval engine (str "Babel.transform("code", {presets: ['react', 'es2016']}).code")))))
  )


(comment

  (-> 216056
      (- 149574)
      (/ 12)
      (* 7)
      (+ 149574)
      (float))

  )
