(ns mathdoc.process.parse.pandoc
  (:require [clojure.spec.alpha :as s]
            [mathdoc.util.pandoc :as p]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]
            [clojure.java.io :as io]))

;;; specs

(s/fdef process
        :args (s/cat
               :data (s/keys :req-un [::msp/inputfiles
                                      ::opts
                                      ::metadata]))
        :ret string?)

(s/def ::input string?)
(s/def ::opts
  (s/coll-of ::opt))

(s/def ::metadata
  (s/coll-of (s/cat :var keyword?
                    :val (s/? string?))))

(s/def ::opt
  (s/cat :opt keyword? :val (s/? string?)))

(s/def ::config
  (s/keys :req-un [::input
                   :mathdoc.core/logger
                   ::opts
                   ::metadata]))

;;; implementation

#_(defn maybe-slurp [f]
  (when (.exists (io/file f))
    (slurp f)))

#_(defn get-pandoc [files opts metadata]
  (as-> files _
        (map maybe-slurp _)
        (apply str _)
        (p/pandoc _ opts metadata)))

#_(defn process [{:keys [inputfiles logger opts metadata]}]
  (duct/log logger :info :process)
  (get-pandoc inputfiles opts metadata))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process.parse/pandoc
  [_ {:keys [logger opts metadata input] :as config}]
  (s/assert ::config config)
  (duct/log logger :info :process)
  (p/pandoc input opts metadata))


;;; tests

#_(s/conform :pandoc/opts
             [[:to "json"] [:from "markdown"] [:smart] [:standalone]])

#_(s/conform :pandoc/metadata
             [])

#_(defn pandoc [& [m]]
    (delayed/delayed get-data m))

#_(-> reloaded.repl/system :pandoc :opts)
#_(-> reloaded.repl/system :pandoc :metadata)
#_(-> reloaded.repl/system :pandoc mathdoc.boundary.Data/get-data)

#_(-> reloaded.repl/system :pandoc :data)
