(ns mathdoc.process.transform.env
  (:require [clojure.spec.alpha :as s]
            [clojure
             [set :as set]
             [walk :as walk]]
            [mathdoc.specs.process :as msp]
            [clojure.core.match :as m]
            [meta-merge.core :as meta-merge]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat :data (s/keys :req-un [::msp/ast ::envs]))
        :ret (s/spec ::msp/ast))

(s/def ::envs (s/coll-of string?))

;;; implementation

(defn set-intersection
  "list of envs in classes"
  [envs classes]
  (-> classes
      (set)
      (set/intersection envs)
      seq))


(defn augment-attr [envs class data-map]
  (if-let [env (some->>
                class
                (set-intersection envs)
                (first))]
    {:class ["env"]
     :data-map {:data-env env}}
    (if (set-intersection #{"aside"} class)
      {:data-map {:data-divtag "aside"}}
      {})))

(defn process-data
  [envs data]
  (->
   (fn [m]
     (m/match
      [m]
      [{:type :BlockQuote
        :content
        {:elems
         [{:type :Header
           :content
           {:attr
            {:id id
             :class class
             :data-map data-map}
            :elems []}}
          & elems]}}]
      {:type :Div
       :content
       {:attr
        (meta-merge/meta-merge
         {:id id
          :class class
          :data-map data-map}
         (augment-attr envs class data-map))
        :elems elems}}
      :else m))
   (walk/prewalk data)))

(defn process [{:keys [ast logger envs]}]
  (duct/log logger :info :process)
  (process-data envs ast))


;;; integrant

(defmethod ig/init-key
  :mathdoc.process.transform/env
  [_ v]
  (process v))



;;; tests


#_(-> reloaded.repl/system :env mathdoc.boundary.Data/get-data)
