(ns mathdoc.process.transform.notes
  (:require [taoensso.timbre :as log]
            [clojure.walk :as walk]
            [clojure.spec.alpha :as s]
            [clojure.core.match :as m]
            [clojure.set :as set]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat :data (s/keys :req-un [::msp/ast]))
        :ret ::msp/ast)

;;; implementation

(defn skip
  [skip-pred f]
  (fn [v]
    (if (skip-pred v)
      v
      (f v))))

(defn header-div
  [v]
  (and (map? v)
       (= :Div (:type v))
       (-> v :content :attr :data-map :section)))

(defn wrap-div [attr elems]
  {:type :Div
   :content
   {:attr attr
    :elems elems}})

(defn get-level [m]
  (some-> m :content :level))

(defn- get-presection
  [m]
  (some-> m :content :attr :data-map :presection))

(defn- get-section
  [m]
  (some-> m :content :attr :data-map :section))

(defn- notes-header?
  [m]
  (some-> m :content :elems first #{{:type :Str, :content "NOTES:"}}))

(defn process-header-div
  [m]
  #_(log/info (some-> m :content :elems first))
  (m/match
   [m]
   [{:type :Div
      :content
      {:attr attr
       :elems [(header :guard (every-pred
                               (comp #{1 2 3 4 5} get-level)
                               notes-header?))
               & elems]}}]
   (-> m
       (assoc-in [:content :attr :data-map :data-divtag] "aside")
       (update-in [:content :attr :class] conj "notes"))
   :else m))

(defn process-ast [ast]
  (walk/postwalk
   (skip (complement header-div)
         process-header-div)
   ast))

(defn process [{:keys [ast logger]}]
  (duct/log logger :info :process)
  (process-ast ast))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process.transform/notes
  [_ v]
  (process v))
