(ns mathdoc.util.pandoc
  "pandoc wrapper"
  (:require [clojure.java.shell :as sh]))

(defn- metadata->opts
  "translate list of options of form [:key \"value\"] to list of metadata options"
  [opts]
  (->> opts
       (mapcat #(map (partial vector (first %)) (rest %)))
       (map #(str (name (first %)) ":" (second %)))
       (map #(identity [:metadata %]))))

(defn- opts->args
  "translate list of options of form [:key \"value\"] to pandoc arguments"
  [opts & {:keys [seps] :or {seps ["--" "="]}}]
  (let [opt->pandoc-arg #(->> %
                              (map name)
                              (interleave seps)
                              (apply str))]
    (map opt->pandoc-arg opts)))

(defn pandoc
  "run pandoc on content with provided options and metadata"
  [content opts metadata]
  (let [opts* (concat opts (metadata->opts metadata))
        args (opts->args opts*)
        pandoc-partial (apply partial sh/sh "pandoc" args)
        result {:exit 1 :err "test err" :out ""}
        result (pandoc-partial :in content)]
    (when-not (= 0 (:exit result))
      (throw (ex-info
              "pandoc failed"
              {:function "pandoc"
               :content-length (count content) ;; might be long; just report length
               :err (:err result)
               :opts opts
               :metadata metadata
               :args args})))
    (:out result)))
