(ns mathdoc.main
  (:gen-class)
  (:require [clojure.java.io :as io]
            [clojure.spec.alpha :as s]
            [clojure.spec.test.alpha :as stest]
            [duct.core :as duct]
            [mathdoc.core :as mathdoc]))

;; enable safety checks
(stest/instrument (stest/instrumentable-syms))
(s/check-asserts true)

(def sources
  [[:resource "mathdoc/core/config.edn"]
   [:resource "mathdoc/server/config.edn"]
   [:resource "mathdoc/cljs/config.edn"]
   [:resource "mathdoc/compiler/config.edn"]])

(defn -main [& args]
  (->> [:file (or (first args) "config.edn")]
       (mathdoc/read-config sources)
       (mathdoc/exec)))
