(ns mathdoc.process.metadata
  (:require [integrant.core :as ig]
            [clojure.java.io :as io]
            [yaml.core :as yaml]))


(def meta-regex #"(?m)(?s)^---\n(.*)^---")

(defn extract-metadata [s]
  (second (re-find meta-regex s)))

(defn maybe-slurp [f]
  (when (.exists (io/file f))
    (slurp f)))

(defn parse-yaml [s]
  (as-> s _
    (yaml/parse-string _)
    (if (vector? _) (first _) _)))

(defn path-metadata-string
  [absolute-file]
  (some->
   (io/file absolute-file)
   (.getParentFile)
   (io/file  "_metadata.yaml")
   (maybe-slurp)))

(defn path-metadata
  [absolute-file]
  (some->
   (io/file absolute-file)
   (.getParentFile)
   (io/file  "_metadata.yaml")
   (maybe-slurp)
   (parse-yaml)))

(defn file-metadata
  [absolute-file]
  (some->
   absolute-file
   (maybe-slurp)
   (extract-metadata)
   (parse-yaml)))

#_(path-metadata "../talks/content/interview/eth.md")

(defmethod ig/init-key
  ::yaml
  [_ {:keys [absolute-file]}]
  (merge
   (path-metadata absolute-file)
   (file-metadata absolute-file)
   {:path-metadata-string (path-metadata-string absolute-file)}))
