(ns mathdoc.compiler.cljs
  (:require cljs.build.api
            [clojure.spec :as s]
            [integrant.core :as ig]
            [clojure.java.io :as io]))

;;; specs

(s/def ::sources (s/coll-of string?))

(s/def ::rel-output-dir string?)
(s/def ::rel-output-to string?)
(s/def ::output-root string?)
(s/def ::asset-path string?)

(s/def ::preloads (s/coll-of symbol?))
(s/def ::main symbol?)

(s/def ::config
  (s/keys :req-un [::sources ::rel-output-dir
                   ::rel-output-to ::asset-path
                   ::preloads ::main]))

;;; implementation

(defmethod ig/init-key
  :mathdoc.compiler/cljs
  [_ {:keys [sources output-root rel-output-dir rel-output-to]
      :as   config}]
  {:pre [(s/assert ::config config)]}
  (cljs.build.api/build
   (apply cljs.build.api/inputs sources)
   (merge
    {:source-map    true
     :verbose       true
     :pretty-print  true
     :optimizations :none}
    (dissoc config
            :sources :output-root
            :rel-output-to :rel-output-dir)
    {:output-to  (str output-root "/" rel-output-to)
     :output-dir (str output-root "/" rel-output-dir)}))
  output-root)

;;; tests

(comment

  (time
   (cljs.build.api/build
    "src" #_["src" "../../talks/cljs"]
    {:output-to     "resources/mathdoc/build/cljs/public/js/compiled/main.js"
     :output-dir    "resources/mathdoc/build/cljs/public/js/compiled/out"
     :main          'mathdoc.cljs.core
     :asset-path    "/js/compiled/out"
     :source-map    true
     :verbose       true
     :pretty-print  true
     :preloads      ['devtools.preload]
     :optimizations :none}))

  )
