(ns mathdoc.process.parse.pandoc
  (:require [clojure.spec :as s]
            [mathdoc.util.pandoc :as p]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat
               :data (s/keys :req-un [::msp/inputfiles
                                      ::opts
                                      ::metadata]))
        :ret string?)

(s/def ::opts
  (s/coll-of ::opt))

(s/def ::metadata
  (s/coll-of (s/cat :var keyword?
                    :val (s/? string?))))

(s/def ::opt
  (s/cat :opt keyword? :val (s/? string?)))

;;; implementation

(defn get-pandoc [files opts metadata]
  (as-> files _
        (map slurp _)
        (apply str _)
        (p/pandoc _ opts metadata)))

(defn process [{:keys [inputfiles logger opts metadata]}]
  (duct/log logger :info :process)
  (get-pandoc inputfiles opts metadata))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process.parse/pandoc
  [_ v]
  (process v))


;;; tests

#_(s/conform :pandoc/opts
             [[:to "json"] [:from "markdown"] [:smart] [:standalone]])

#_(s/conform :pandoc/metadata
             [])

#_(defn pandoc [& [m]]
    (delayed/delayed get-data m))

#_(-> reloaded.repl/system :pandoc :opts)
#_(-> reloaded.repl/system :pandoc :metadata)
#_(-> reloaded.repl/system :pandoc mathdoc.boundary.Data/get-data)

#_(-> reloaded.repl/system :pandoc :data)
