(ns mathdoc.cljs.reveal
  (:require [cljs.core.async :as a]
            [taoensso.timbre :as log]
            [integrant.core :as ig])
  (:require-macros
   [cljs.core.async.macros :refer [alt! go go-loop]]))

(def config
  {::ready nil
   ::slidechanged nil
   ::fragmentshown nil})

(defmethod ig/init-key
  ::ready
  [_ _]
  ;; promise chan seems buggy
  #_(let [p (a/promise-chan)]
      (log/info ::ready)
      (js/Reveal.addEventListener
       "ready"
       (fn ready []
         (log/info ::ready :deliver)
         (a/put! p :ready)))
      p)
  (let [p (a/chan)]
    (log/info ::ready :init)
    (js/Reveal.addEventListener
     "ready"
     (fn ready []
       (go-loop [n 0]
         (a/>! p :ready)
         (log/info ::ready :deliver n)
         (recur (inc n)))))
    p))

;; keep promise chan on resume
(defmethod ig/resume-key
  ::ready
  [_ _ _ p]
  (log/info ::ready :resume)
  p)

(defmethod ig/init-key
  ::slidechanged
  [_ _]
  (let [listen-ch   (a/chan (a/dropping-buffer 10))
        listen-mult (a/mult listen-ch)]
    (log/info ::slidechanged :init)
    (js/Reveal.addEventListener
     "slidechanged"
     (fn slidechanged-listener [ev]
       (a/put! listen-ch ev)))

    (fn slidechanged-tap [ch]
      (a/tap listen-mult ch))))

(defmethod ig/resume-key
  ::slidechanged
  [_ _ _ f]
  (log/info ::slidechanged :resume)
  f)

(defmethod ig/init-key
  ::fragmentshown
  [_ _]
  (let [listen-ch   (a/chan (a/dropping-buffer 10))
        listen-mult (a/mult listen-ch)]
    (log/info ::fragmentshown :init)
    (js/Reveal.addEventListener
     "fragmentshown"
     (fn fragmentshown-listener [ev]
       (a/put! listen-ch ev)))

    (fn fragmentshown-tap [ch]
      (a/tap listen-mult ch))))

(defmethod ig/resume-key
  ::fragmentshown
  [_ _ _ f]
  (log/info ::fragmentshown :resume)
  f)
