(ns mathdoc.compiler.page
  (:require [clojure.java.io :as io]
            [ring.mock.request :as mock]
            [clojure.string :as str]
            [integrant.core :as ig]
            [taoensso.timbre :as log]
            [clojure.spec.alpha :as s]
            [mathdoc.core :as core]
            [duct.core :as duct])
  (:import java.net.URI))

;; TODO: use mock request to render response for compiler

#_(mock/request :get "/")



(defn directory? [d]
  (.isDirectory (io/file d)))

(defn file-exists? [f]
  (.exists (io/file f)))

#_(directory? "../talks/content")

(defn content-uris [content-path]
  (->> (io/file content-path)
       file-seq
       (filter file-exists?)
       (remove directory?)
       (map (partial core/relative-path content-path))
       (filter (some-fn #(str/ends-with? % "index.yaml") #(str/ends-with? % ".md")))
       #_(map #(str/replace % #"\.[a-z]*$" "/"))
       (map #(str "/" %))
       (map #(str/replace % #"\.md$" "/"))
       (map #(str/replace % #"index\.yaml$" ""))))

(comment

  (content-files "../talks/content")

  ((ig/init-key
   :mathdoc.endpoint.page/handler
   {:logger nil
    :content-path "../talks/content"
    :fragment-path "target/mathdoc/fragmeht/html"
    :template-path "../talks/template"})
   (mock/request :get "/interview/eth/"))

  )

(defn copy-page
  [{:keys [target-path handler]} uri]
  (let [target-file (io/file
                     (str target-path uri "index.html"))]
    (io/make-parents target-file)
    (->
     uri
     (as-> _ (mock/request :get _))
     (handler)
     (:body)
     (as-> _ (spit target-file _)))))

#_(copy-page {:handler (constantly {:body "test"})
              :target-path "target/test-copy"} "/talk/ias/")

(s/def ::config (s/keys :req-un [::content-path ::target-path ::handler]))

(s/def ::content-path ::core/path)
(s/def ::target-path ::core/path)
(s/def ::handler fn?)

;; TODO: derive from compiler, add to config, change config to copy directly into deploy dir, make sure that copy happens in the right order so that custom files replace asset files

(derive ::copy :duct/compiler)

(defmethod ig/init-key
  ::copy
  [_ {:keys [content-path target-path logger] :as config}]
  (duct/log logger :info :copy)
  (s/assert ::config config)
  (->>
   (content-uris content-path)
   (map (partial copy-page config))
   (dorun))
  target-path)

(comment

  (ig/init-key
   ::copy {:content-path "../talks/content"
           :target-path "target/test-copy"
           :handler (ig/init-key
                     :mathdoc.endpoint.page/handler
                     {:logger nil
                      :content-path "../talks/content"
                      :fragment-path "target/mathdoc/fragment/html"
                      :template-path "../talks/template"})})

  ((ig/init-key
    :mathdoc.endpoint.page/handler
    {:logger nil
     :content-path "../talks/content"
     :fragment-path "target/mathdoc/fragmeht/html"
     :template-path "../talks/template"})
   (mock/request :get "/interview/eth/"))

  )

#_(defmethod ig/resume-key ::compiler [_ _ _ v] v)

#_(derive ::compiler :mathdoc.core/resume-identity)
