(ns mathdoc.cljs.download
  (:require
   [taoensso.timbre :as log]
   [integrant.core :as ig]
   [cljs.core.async :as a]
   [hickory.core :as h]
   [hickory.render :as hrender]
   [dommy.core :as dommy :refer-macros [sel sel1]]
   [clojure.walk :as walk]
   [mathdoc.cljs.reveal :as reveal])
  (:require-macros
   [cljs.core.async.macros :refer [alt! go go-loop]]
   [cljs.spec.alpha :as s]))

(defn get-canvas-data []
  (.toDataURL (sel1 "#board")))

(defn get-location []
  (str (aget js/window "location")))

(defn post-canvas []
  (.log js/console "post canvas")
  (->
   js/jQuery
   (.ajax
    #js {:type "POST"
         :url "/__save-canvas"
         :data
         #js {:img-base64 (get-canvas-data)
              :location (get-location)}})
   (.done (fn [data]
            (js/window.prompt "Ctrl-C, Enter" data)
            #_(.log js/console "done" data))))
  #_(.log js/console "posted"))

;;; integrant

(def config
  {::listen {:ready (ig/ref ::reveal/ready)}})

(defmethod ig/init-key
  ::listen
  [_ {:keys [ready]}]
  (go
    (a/<! ready)
    (log/info ::listen-init)
    (dommy/listen!
     (sel1 "#download")
     :click post-canvas))
  ::listen)

(defmethod ig/resume-key
  ::listen
  [_ _ _ v]
  (log/info ::listen-resume)
  v)
