(ns mathdoc.module.transform
  (:require [integrant.core :as ig]
            [taoensso.timbre :as log]
            [clojure.spec.alpha :as s]))

(s/def ::pipeline
  (s/coll-of keyword?))

(s/def ::source
  keyword?)

(s/def ::sink-ks
  (s/coll-of keyword?))

(s/def ::options
  (s/keys :req-un [::pipeline ::source ::sink-ks]))

(defmethod ig/init-key
  :mathdoc.module/transform
  [_ {:keys [pipeline source sink-ks] :as options}]
  {:pre [(s/assert ::options options)]
   :post [(fn? %)]}
  (fn transform
    [config]
    {:pre [(map? config)]
     :post [(map? %)]}
    (->
     (fn transform-reduce
       [[config from] to]
       [(assoc-in config
                  [to :ast] (ig/ref from))
        to])
     (reduce
      [config source]
      pipeline)
     first
     (assoc-in sink-ks (ig/ref (last pipeline))))))
