(ns mathdoc.process.fragment
  (:require [integrant.core :as ig]
            [clojure.spec.alpha :as s]
            [clojure.java.io :as io]
            [clojure.string :as str]
            [taoensso.timbre :as log]
            [mathdoc.core :as core]))

(s/def ::config
  (s/keys :req-un [::fragment-path ::fragment ::file]))

(s/def ::fragment-path
  ::core/path)

(s/def ::fragment
  string?)

(s/def ::file
  string?)

(defmethod ig/init-key
  ::copy
  [_ {:keys [fragment-path fragment file] :as config}]
  (s/assert ::config config)
  (let [fragment-file (str
                       fragment-path
                       "/"
                       (str/replace file #"\.md$" "")
                       ".html")]
    (try
      (io/make-parents fragment-file)
      (spit fragment-file fragment)
      :success
      (catch Exception e
        (log/error "cannot write to file" fragment-file "exception" e)
        :fail))))
