(ns mathdoc.process.layout.template
  (:require [meta-merge.core :as meta-merge]
            [stencil.core :as stencil]
            [taoensso.timbre :as log]
            [clojure.spec :as s]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]))



;;; specs

(s/fdef process
        :args (s/cat
               :data (s/keys :req-un [::template
                                      ::msp/meta
                                      ::msp/root])))

(s/def ::template
  string?)



;;; implementation

(defn render [template context]
  (stencil/render-string (slurp template) context))

(defn process [{:keys [meta root template logger]
                :as context}]
  (duct/log logger :info :process)
  (render (str root "/" (or (:template meta) template))
          context))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process.layout/template
  [_ v]
  (process v))




;;; tests

#_(slurp "template/template-slides-com.html")
#_(render "template/template-slides-com.html" "test" {:title "my title"})

#_(-> reloaded.repl/system :htmlslides mathdoc.boundary.Data/get-data)

#_(-> reloaded.repl/system :htmlslides :meta mathdoc.boundary.Data/get-data)

#_(-> reloaded.repl/system :htmlslides keys)
