(ns mathdoc.process.transform.extractnotes
  (:require [taoensso.timbre :as log]
            [clojure.walk :as walk]
            [clojure.spec :as s]
            [clojure.core.match :as m]
            [clojure.set :as set]
            [integrant.core :as ig]
            [mathdoc.specs.process :as msp]
            [duct.core :as duct]
            [mathdoc.process.write.html :as write-html]
            [hiccup.core :as h]
            [clojure.java.io :as io]
            [taoensso.timbre :as log]))

;;; specs

(s/fdef process
        :args (s/cat :data (s/keys :req-un [::msp/ast]))
        :ret ::msp/ast)

;;; implementation

(defn skip
  [skip-pred f]
  (fn [v]
    (if (skip-pred v)
      v
      (f v))))

(defn header-div
  [v]
  (and (map? v)
       (= :Div (:type v))
       (-> v :content :attr :data-map :section)))

(defn wrap-div [attr elems]
  {:type :Div
   :content
   {:attr attr
    :elems elems}})

(defn get-level [m]
  (some-> m :content :level))

(defn- notes-header?
  [m]
  (some-> m :content :elems first #{{:type :Str, :content "NOTES:"}}))

(defn clean-notes-header
  [m]
  (update-in m [:content :elems] next))

(defn notes-header-div?
  [m]
  #_(log/info (some-> m :content :elems first))
  (m/match
   [m]
   [{:type :Div
     :content
     {:attr  attr
      :elems [(header :guard (every-pred
                              (comp #{1 2 3 4 5} get-level)
                              notes-header?))
              & _]}}]
   true
   :else false))

(defn process-ast [ast]
  ;; TODO: add bootstrap css
  (h/html
   [:html
    [:head
     [:meta {:charset "utf-8"}]
     [:title "notes"]
     [:link {:rel "stylesheet"
             :href "tufte-css/tufte.css"}]
     [:meta {:name "viewport"
             :content "width=device-width, initial-scale=1"}]]
    [:body
     [:article
      (->> ast
           (tree-seq coll? seq)
           (filter notes-header-div?)
           (map (fn [m] (update-in m [:content :elems] vec)))
           (map (fn [m] (update-in m [:content :elems 0] clean-notes-header)))
           (walk/postwalk
            (fn [m]
              (if (= :Header (:type m))
                (update-in m [:content :level] #(- % 2))
                m)))
           (write-html/html-elems))]]]))



(comment

  (get-in (vec (range 5)) [2])

  (tree-seq )

  )

(defn process [{:keys [ast logger file root notes-dir]}]
  (duct/log logger :info :process)
  (let [note-file (str root "/" notes-dir "/" file ".html")]
    (io/make-parents note-file)
    (spit note-file (process-ast ast))
    note-file))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process.transform/extractnotes
  [_ v]
  (process v))
