(ns mathdoc.compiler.notes
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [garden.core :as garden]
            [integrant.core :as ig]))

;;; specs

(s/def ::public string?)

;;; implementation

(defmethod ig/init-key
  ::public
  [_ v]
  {:pre [(s/assert ::public v)]}
  v)

(def notes-style
  (list
   [:#current-slide
    {:position "absolute"
     :width    "40%"
     :height   "60%"
     :top      0
     :left     0}]
   [:#upcoming-slide
    {:position "absolute"
     :width    "40%"
     :height   "40%"
     :left     0
     :top      "60%"}]
   [:#speaker-controls
    {:position  "absolute"
     :top       "0"
     :right     "0"
     :width     "60%"
     :height    "100%"
     :overflow  "auto"
     :font-size "18px"}]
   [:.speaker-controls-notes
    {:margin-bottom "1500px"}]
   [:#speaker-controls :p
    {:margin-top    "0.4em"
     :margin-bottom "0.4em"}]))

(defmethod ig/init-key
  ::css
  [_ {:keys [file root] :as config}]
  {:pre [(s/assert string? file)]}
  (io/make-parents file)
  (spit file (garden/css notes-style))
  root)
