(ns mathdoc.process.outputfile
  (:require [clojure.java.io :as io]
            [clojure.spec :as s]
            [taoensso.timbre :as log]
            [integrant.core :as ig]
            [duct.core :as duct]))

;;; specs

(s/fdef process
        :args (s/cat
               :data (s/keys
                      :req-un [::input
                               ::targetfile]))
        :ret #{:fail :success})

(s/def ::targetfile
  string?)

(s/def ::input
  string?)

;;; implementation

(defn process [{:keys [input logger targetfile]}]
  (duct/log logger :info :process)
  (try
    (io/make-parents targetfile)
    (spit targetfile input)
    :success
    (catch Exception e
      (log/error "cannot write to file" targetfile "exception" e)
      :fail)))

;;; integrant

(defmethod ig/init-key
  :mathdoc.process/outputfile
  [_ v]
  (process v))
