(ns mathdoc.process.folder
  (:require [integrant.core :as ig]
            [clojure.string :as str]))

(defmethod ig/init-key
  ::metadata
  [_ {:keys [content-dir file]}]
  (as-> (str content-dir "/" file) _
    (str/split _  #"/")
    (drop-last _)
    (str/join "/" _)
    (str _ "/_metadata.yaml")))

(comment

  (ig/init-key ::metadata {:content-dir "content"
                           :file "interview/eth"})

  )
