(ns mathdoc.process.fragment
  (:require [integrant.core :as ig]
            [clojure.spec :as s]
            [clojure.java.io :as io]
            [clojure.string :as str]))

(s/def ::config
  (s/keys :req-un [::fragment-dir ::fragment ::file]))

(s/def ::fragment-dir
  string?)

(s/def ::fragment
  string?)

(s/def ::file
  string?)

(s/def ::root
  string?)

(defmethod ig/init-key
  ::copy
  [_ {:keys [fragment-dir fragment file] :as config}]
  (s/assert ::config config)
  (let [fragment-file (str
                       fragment-dir
                       "/"
                       (str/replace file #"\.md$" "")
                       ".html")]
    (io/make-parents fragment-file)
    (spit fragment-file fragment)
    fragment-dir))
