(ns mathdoc.server.figwheel
  (:require [com.stuartsierra.component :as component]
            [figwheel-sidecar
             [repl-api :as f]
             [system :as sys]]
            [integrant.core :as ig]))

(defmethod ig/init-key
  ::public
  [_ v]
  v)

(defmethod ig/init-key
  :mathdoc.server/figwheel
  [_ {:keys [public all-builds] :as config}]
  (assert (and (string? public) (not-empty public)))
  (component/start
   (sys/figwheel-system
    (assoc config
           :all-builds (map (fn [build]
                              (-> build
                                  (assoc-in [:compiler :output-to] (str public "/js/compiled/main.js"))
                                  (assoc-in [:compiler :output-dir] (str public "/js/compiled/out"))))
                            all-builds)))))

(defmethod ig/halt-key!
  :mathdoc.server/figwheel
  [_ system]
  (component/stop system))

(defmethod ig/suspend-key!
  :mathdoc.server/figwheel
  [_ system])

(defmethod ig/resume-key
  :mathdoc.server/figwheel
  [_ _ _ v]
  v)
