/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.common.interfaces.Receivable;
import org.dstorerdb.common.streams.StringInputStream;
import org.dstorerdb.encryptor.exceptions.InvalidTextException;

public class Receiver
implements Receivable {
    private final StringInputStream inputStream;
    private final StringBuilder sbData;

    public Receiver(InputStream sockStream) {
        this.inputStream = new StringInputStream(sockStream);
        this.sbData = new StringBuilder();
    }

    private String getColorByHeader(String header) {
        switch (header) {
            case "BAD_RANGE": {
                return "\u001b[33m";
            }
            case "errlog": {
                return "\u001b[31m";
            }
            case "errparam": {
                return "\u001b[31m";
            }
            case "errord": {
                return "\u001b[31m";
            }
            case "errorreg": {
                return "\u001b[31m";
            }
            case "errorsyn": {
                return "\u001b[36m";
            }
            case "err": {
                return "\u001b[31m";
            }
            case "GET": {
                return "\u001b[37m";
            }
            case "HELP": {
                return "\u001b[37m";
            }
            case "OK": {
                return "\u001b[32m";
            }
            case "warning": {
                return "\u001b[33m";
            }
        }
        return "\u001b[0m";
    }

    private String getHeader(String msg) {
        return msg.split("-")[0];
    }

    private String getGETMsg(String originalMsg) {
        return originalMsg.replace("~~", "\n");
    }

    private String getFormattedMsg(String msg) {
        String[] splitMsg = msg.split("-");
        String header = splitMsg[0];
        String outHeader = splitMsg[1];
        String pureMsg = outHeader.substring(0, outHeader.length() - 4);
        if (header.toLowerCase().contains("get")) {
            return this.getGETMsg(pureMsg);
        }
        return pureMsg;
    }

    public String getReceivData() {
        try {
            String msg = this.inputStream.readString();
            String header = this.getHeader(msg);
            String color = this.getColorByHeader(header);
            String finalMsg = this.getFormattedMsg(msg);
            this.sbData.append(color).append(finalMsg).append("\u001b[0m");
            finalMsg = this.sbData.toString();
            this.sbData.delete(0, this.sbData.length());
            return finalMsg;
        }
        catch (IOException | InvalidTextException ex) {
            Logger.getLogger(Receiver.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

