/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.cmdintepreter.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import org.dstorerdb.cmdintepreter.cmd.BadSyntaxException;
import org.dstorerdb.cmdintepreter.cmd.Interpretable;

public class Command
implements Interpretable {
    private String order;
    private String[] options;

    public Command(String order, String ... options) {
        this.order = order;
        this.options = options;
    }

    public Command(String strCmd) throws BadSyntaxException {
        this.buildCommand(strCmd);
    }

    private void countQuotes(String strCommand) throws BadSyntaxException {
        int count = 0;
        char[] chars = strCommand.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\'') continue;
            ++count;
        }
        if (count > 0 && count % 2 != 0) {
            throw new BadSyntaxException("Sintaxis del comando invalida");
        }
    }

    private void buildCommand(String strCommand) throws BadSyntaxException {
        ArrayList<String> listOptions = new ArrayList<String>();
        String[] spaceSplit = strCommand.split(" ");
        this.order = spaceSplit[0];
        if (this.order.contains("'")) {
            throw new BadSyntaxException("La orden no puede contener comillas");
        }
        StringBuilder sbOptions = new StringBuilder();
        boolean quoteFind = false;
        for (int i = 1; i < spaceSplit.length; ++i) {
            int quoteIndex;
            String opt = spaceSplit[i];
            if (quoteFind) {
                quoteIndex = opt.indexOf("\"");
                sbOptions.append(' ');
                if (quoteIndex == -1) {
                    sbOptions.append(opt);
                    continue;
                }
                sbOptions.append(opt, 0, quoteIndex + 1);
                quoteFind = false;
                listOptions.add(sbOptions.toString());
                sbOptions.delete(0, sbOptions.length());
                if (quoteIndex >= opt.length() - 1) continue;
                listOptions.add(opt.substring(quoteIndex + 1));
                continue;
            }
            quoteIndex = opt.indexOf("\"");
            boolean bl = quoteFind = quoteIndex != -1;
            if (quoteFind) {
                sbOptions.append(opt.substring(quoteIndex));
                continue;
            }
            listOptions.add(opt);
        }
        this.options = new String[listOptions.size()];
        this.options = listOptions.toArray(this.options);
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public boolean isNumberOption(int index) {
        try {
            Long.parseLong(this.getOptionAt(index));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean hasNumberID(String option) {
        char lastC = option.charAt(option.length() - 1);
        return option.length() > 1 && (lastC == 'L' || lastC == 'I' || lastC == 'S' || lastC == 'B' || lastC == 'F' || lastC == 'D');
    }

    public int getOptionAsNumber(int index) {
        return this.isNumberOption(index) ? Integer.parseInt(this.getOptionAt(index)) : -1;
    }

    public int getOptionsCount() {
        return this.hasOptions() ? this.options.length : 0;
    }

    public String getOrder() {
        return this.order;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getOptionAt(int index) {
        return this.options[index];
    }

    public String toString() {
        StringBuilder sbCmd = new StringBuilder();
        sbCmd.append(this.order);
        int optLen = this.options != null ? this.options.length : 0;
        for (int i = 0; i < optLen; ++i) {
            sbCmd.append(' ').append(this.options[i]);
        }
        return sbCmd.toString();
    }

    public static void main(String[] args) throws BadSyntaxException {
        Command cmd = new Command("add \"hola xd\" to list");
        System.out.println("Options: " + Arrays.toString(cmd.getOptions()));
        System.out.println(cmd.toString());
    }
}

